/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xsdgen;

import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Date;

class XURL {
    private final String defaultEncoding = "ISO-8859-1";
    private String charset;
    private StringBuffer toSend;
    private PrintStream psLog;
    private StringBuffer sbLog;

    private void log(Object item) {
        if (this.psLog != null) {
            this.psLog.print(item);
        }
        if (this.sbLog != null) {
            this.sbLog.append(item);
        }
    }

    public XURL() {
        this.charset = "ISO-8859-1";
        this.psLog = null;
        this.sbLog = null;
        this.toSend = new StringBuffer("");
    }

    public XURL(String charset) {
        this.charset = charset;
        this.psLog = null;
        this.sbLog = null;
        this.toSend = new StringBuffer("");
    }

    public XURL(StringBuffer sbLog) {
        this.charset = "ISO-8859-1";
        this.psLog = null;
        this.sbLog = sbLog;
        this.toSend = new StringBuffer("");
    }

    public XURL(String charset, StringBuffer sbLog) {
        this.charset = charset;
        this.psLog = null;
        this.sbLog = sbLog;
        this.toSend = new StringBuffer("");
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void send(String name, Object value) {
        if (this.toSend.length() > 0) {
            this.toSend.append("&");
        }
        try {
            this.toSend.append(name).append("=").append(URLEncoder.encode(value.toString(), this.charset));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public String communicate(String url) {
        Date date0 = new Date();
        this.log("<xurl:communicate>" + url + "\n<xurl:send charset=" + this.charset + ">" + this.toSend);
        try {
            int c;
            URL u = new URL(url);
            URLConnection uc = u.openConnection();
            uc.setDoInput(true);
            uc.setUseCaches(false);
            uc.setRequestProperty("content-type", "application/x-www-form-urlencoded");
            uc.setRequestProperty("charset", this.charset);
            if (this.toSend.toString().length() > 0) {
                uc.setDoOutput(true);
                PrintWriter pw = new PrintWriter(uc.getOutputStream());
                pw.print(this.toSend);
                this.toSend = new StringBuffer("");
                pw.close();
            }
            StringBuffer receive = new StringBuffer("");
            String enc = uc.getContentEncoding();
            InputStreamReader isr = new InputStreamReader(uc.getInputStream(), enc != null ? enc : this.charset);
            while ((c = isr.read()) != -1) {
                receive.append((char)c);
            }
            isr.close();
            this.log("</xurl:send>\n<xurl:receive charset=" + enc + ">" + receive + "</xurl:receive>\n" + (new Date().getTime() - date0.getTime()) + " ms</xurl:communicate>");
            return receive.toString();
        }
        catch (Exception x) {
            this.log(x);
            return null;
        }
    }
}

