/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.xpath;

import com.jaxfront.core.xpath.ResetIterator;
import java.util.NoSuchElementException;

public class ResetableIterator
implements ResetIterator {
    private Object[] types;
    private int currentPos = 0;
    private int elementCount = 0;
    private Object node;

    public boolean hasNext() {
        return this.node != null;
    }

    public Object next() {
        if (this.node == null) {
            throw new NoSuchElementException();
        }
        Object ret = this.node;
        this.node = this.getNextNode();
        return ret;
    }

    public Object getCurrent() {
        if (this.types != null && this.currentPos < this.types.length) {
            return this.types[this.currentPos];
        }
        return null;
    }

    public void remove() {
        this.node = null;
    }

    public void reset() {
        this.currentPos = 0;
        this.node = this.getFirstNode();
    }

    public static void main(String[] args) {
        ResetableIterator ri = new ResetableIterator();
        for (int i = 0; i < 10; ++i) {
            ri.addChild(i + "");
        }
        while (ri.hasNext()) {
            System.out.print(ri.next());
        }
        System.out.println();
        ri.reset();
        while (ri.hasNext()) {
            System.out.print(ri.next());
        }
    }

    private Object getFirstNode() {
        if (this.types != null && this.types.length > 0) {
            return this.types[0];
        }
        return null;
    }

    private Object getNextNode() {
        ++this.currentPos;
        if (this.types != null && this.currentPos < this.types.length) {
            return this.types[this.currentPos];
        }
        return null;
    }

    public void addChild(Object aType) {
        if (this.types == null) {
            this.types = new Object[10];
            this.node = aType;
        }
        this.ensureCapacity(this.elementCount + 1);
        this.types[this.elementCount++] = aType;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.types.length;
        if (minCapacity > oldCapacity) {
            Object[] oldData = this.types;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.types = new Object[newCapacity];
            System.arraycopy(oldData, 0, this.types, 0, this.elementCount);
        }
    }
}

