/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.stringSearch;

import com.jaxfront.core.util.stringSearch.CharIntMap;
import com.jaxfront.core.util.stringSearch.MismatchSearch;

public class ShiftOrMismatches
extends MismatchSearch {
    private static final Object MISMATCH = new Object();
    private static final Object MATCH = new Object();

    public Object processBytes(byte[] pattern, int k) {
        int i;
        int b;
        Object type = MISMATCH;
        if (k << 1 > pattern.length) {
            type = MATCH;
            k = pattern.length - k;
        }
        if (pattern.length > 31 / (b = this.clog2(k + 1) + 1)) {
            throw new IllegalArgumentException();
        }
        int lim = k << (pattern.length - 1) * b;
        int ovmask = 0;
        for (i = 0; i < pattern.length; ++i) {
            ovmask = ovmask << b | 1 << b - 1;
        }
        int[] t = new int[256];
        if (type == MISMATCH) {
            lim += 1 << (pattern.length - 1) * b;
            for (i = 0; i < t.length; ++i) {
                t[i] = ovmask >> b - 1;
            }
        }
        i = 1;
        int p = 0;
        while (p < pattern.length) {
            if (type == MATCH) {
                int n = this.index(pattern[p]);
                t[n] = t[n] + i;
            } else {
                int n = this.index(pattern[p]);
                t[n] = t[n] & ~i;
            }
            ++p;
            i <<= b;
        }
        return new Object[]{t, type, new Integer(i - 1), new Integer(ovmask), new Integer(b), new Integer(lim)};
    }

    public Object processChars(char[] pattern, int k) {
        CharIntMap t;
        int i;
        int b;
        Object type = MISMATCH;
        if (k << 1 > pattern.length) {
            type = MATCH;
            k = pattern.length - k;
        }
        if (pattern.length > 31 / (b = this.clog2(k + 1) + 1)) {
            throw new IllegalArgumentException();
        }
        int lim = k << (pattern.length - 1) * b;
        int ovmask = 0;
        for (i = 0; i < pattern.length; ++i) {
            ovmask = ovmask << b | 1 << b - 1;
        }
        if (type == MATCH) {
            t = this.createCharIntMap(pattern);
        } else {
            lim += 1 << (pattern.length - 1) * b;
            t = this.createCharIntMap(pattern, ovmask >> b - 1);
        }
        i = 1;
        int p = 0;
        while (p < pattern.length) {
            if (type == MATCH) {
                t.set(pattern[p], t.get(pattern[p]) + i);
            } else {
                t.set(pattern[p], t.get(pattern[p]) & ~i);
            }
            ++p;
            i <<= b;
        }
        return new Object[]{t, type, new Integer(i - 1), new Integer(ovmask), new Integer(b), new Integer(lim)};
    }

    public int[] searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed, int k) {
        int overflow;
        int state;
        Object[] o = (Object[])processed;
        int[] t = (int[])o[0];
        Object type = o[1];
        int mask = (Integer)o[2];
        int ovmask = (Integer)o[3];
        int b = (Integer)o[4];
        int lim = (Integer)o[5];
        if (type == MATCH) {
            state = 0;
            overflow = 0;
        } else {
            state = mask & ~ovmask;
            overflow = ovmask;
        }
        for (int p = textStart; p < textEnd; ++p) {
            state = (state << b) + t[this.index(text[p])] & mask;
            overflow = (overflow << b | state & ovmask) & mask;
            state &= ~ovmask;
            if (type == MATCH) {
                if ((state | overflow) < lim) continue;
                return new int[]{p - pattern.length + 1, pattern.length - k};
            }
            if ((state | overflow) >= lim) continue;
            return new int[]{p - pattern.length + 1, state >> (pattern.length - 1) * b};
        }
        return new int[]{-1, 0};
    }

    public int[] searchChars(char[] text, int textStart, int textEnd, char[] pattern, Object processed, int k) {
        int overflow;
        int state;
        Object[] o = (Object[])processed;
        CharIntMap t = (CharIntMap)o[0];
        Object type = o[1];
        int mask = (Integer)o[2];
        int ovmask = (Integer)o[3];
        int b = (Integer)o[4];
        int lim = (Integer)o[5];
        if (type == MATCH) {
            state = 0;
            overflow = 0;
        } else {
            state = mask & ~ovmask;
            overflow = ovmask;
        }
        for (int p = textStart; p < textEnd; ++p) {
            state = (state << b) + t.get(text[p]) & mask;
            overflow = (overflow << b | state & ovmask) & mask;
            state &= ~ovmask;
            if (type == MATCH) {
                if ((state | overflow) < lim) continue;
                return new int[]{p - pattern.length + 1, pattern.length - k};
            }
            if ((state | overflow) >= lim) continue;
            return new int[]{p - pattern.length + 1, state >> (pattern.length - 1) * b};
        }
        return new int[]{-1, 0};
    }

    private int clog2(int x) {
        int i = 0;
        while (x > 1 << i) {
            ++i;
        }
        return i;
    }

    public boolean usesNative() {
        return false;
    }
}

