/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.stringSearch;

import com.jaxfront.core.util.stringSearch.CharIntMap;
import com.jaxfront.core.util.stringSearch.StringSearch;

public class BoyerMooreHorspool
extends StringSearch {
    public Object processBytes(byte[] pattern) {
        int i;
        int[] skip = new int[256];
        for (i = 0; i < skip.length; ++i) {
            skip[i] = pattern.length;
        }
        for (i = 0; i < pattern.length - 1; ++i) {
            skip[this.index((byte)pattern[i])] = pattern.length - i - 1;
        }
        return skip;
    }

    public Object processChars(char[] pattern) {
        CharIntMap skip = this.createCharIntMap(pattern, pattern.length);
        for (int i = 0; i < pattern.length - 1; ++i) {
            skip.set(pattern[i], pattern.length - i - 1);
        }
        return skip;
    }

    public int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        return useNative ? this.nativeSearchBytes(text, textStart, textEnd, pattern, processed) : this.javaSearchBytes(text, textStart, textEnd, pattern, processed);
    }

    private int javaSearchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        int[] skip = (int[])processed;
        for (int k = pattern.length - 1; k < textEnd; k += skip[this.index(text[k])]) {
            int i;
            int j = pattern.length - 1;
            for (i = k; j >= 0 && text[i] == pattern[j] && i >= textStart; --j, --i) {
            }
            if (j != -1) continue;
            return ++i;
        }
        return -1;
    }

    private native int nativeSearchBytes(byte[] var1, int var2, int var3, byte[] var4, Object var5);

    public int searchChars(char[] text, int textStart, int textEnd, char[] pattern, Object processed) {
        CharIntMap skip = (CharIntMap)processed;
        for (int k = pattern.length - 1; k < textEnd; k += skip.get(text[k])) {
            int i;
            int j = pattern.length - 1;
            for (i = k; j >= 0 && text[i] == pattern[j] && i >= textStart; --j, --i) {
            }
            if (j != -1) continue;
            return ++i;
        }
        return -1;
    }
}

