/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util.io.files;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public class Objects {
    protected Objects() {
    }

    public static final Object[] map(Map m, Object[] domain) {
        if (m == null || domain == null) {
            return null;
        }
        Object[] codomain = new Object[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            codomain[i] = m.get(domain[i]);
        }
        return codomain;
    }

    public static final List map(Map m, List domain) {
        if (m == null || domain == null) {
            return null;
        }
        return Arrays.asList(Objects.map(m, domain.toArray()));
    }

    public static final Collection map(Map m, Collection domain) {
        if (m == null || domain == null) {
            return null;
        }
        return Arrays.asList(Objects.map(m, domain.toArray()));
    }

    public static final Object[] map(Map m, Object[] domain, Object defaultValue) {
        if (m == null || domain == null) {
            return null;
        }
        Object[] codomain = new Object[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            Object key = domain[i];
            codomain[i] = m.containsKey(key) ? m.get(key) : defaultValue;
        }
        return codomain;
    }

    public static final Object[] map(Map m, Object[] domain, Object[] defaultValues) {
        if (m == null || domain == null) {
            return null;
        }
        Object[] codomain = new Object[domain.length];
        for (int i = 0; i < domain.length; ++i) {
            Object key = domain[i];
            codomain[i] = m.containsKey(key) ? m.get(key) : (i < defaultValues.length ? defaultValues[i] : null);
        }
        return codomain;
    }

    public static Map compose(Map f, Map g) {
        Map result = Objects.getMap(f.size());
        Iterator i = f.keySet().iterator();
        while (i.hasNext()) {
            Object x = i.next();
            Object y = f.get(x);
            Object z = g.get(y);
            result.put(x, z);
        }
        return result;
    }

    public static Map inverse(Map f) throws InstantiationException {
        Map result = Objects.getMap(f.size());
        Iterator i = f.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (result.containsKey(entry.getValue())) {
                throw new InstantiationException("irreversible function");
            }
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static final Map asMap(Object[] pairs) {
        return Objects.toMap(pairs);
    }

    public static final boolean isEmpty(Object data) {
        if (data == null) {
            return true;
        }
        if (data instanceof Collection) {
            return ((Collection)data).isEmpty();
        }
        if (data instanceof Map) {
            return ((Map)data).isEmpty();
        }
        if (data instanceof Object[]) {
            return ((Object[])data).length == 0;
        }
        return data.toString().length() == 0 || "null".equals(data.toString());
    }

    public static final byte[] toBytes(char[] from) {
        byte[] result = new byte[from.length];
        for (int i = 0; i < from.length; ++i) {
            result[i] = (byte)from[i];
        }
        return result;
    }

    public static final char[] toChars(byte[] from) {
        char[] result = new char[from.length];
        for (int i = 0; i < from.length; ++i) {
            result[i] = (char)(0xFF & from[i]);
        }
        return result;
    }

    public static final long crc32(byte[] data) {
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return crc32.getValue();
    }

    public static final long crc32(byte[] data, int off, int len) {
        CRC32 crc32 = new CRC32();
        crc32.update(data, off, len);
        return crc32.getValue();
    }

    public static final byte[] toBytes(long from) {
        byte[] result = new byte[8];
        for (int i = 0; i < 8; ++i) {
            result[i] = (byte)from;
            from >>= 8;
        }
        return result;
    }

    public static int indexOf(Object what, Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if ((what != null || array[i] != null) && (what == null || !what.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object what, Object[] array, int fromIndex) {
        for (int i = fromIndex; i < array.length; ++i) {
            if ((what != null || array[i] != null) && (what == null || !what.equals(array[i]))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object what, List list) {
        for (int i = 0; i < list.size(); ++i) {
            Object current = list.get(i);
            if ((what != null || current != null) && (what == null || !what.equals(current))) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(Object what, List list, int fromIndex) {
        for (int i = fromIndex; i < list.size(); ++i) {
            Object current = list.get(i);
            if ((what != null || current != null) && (what == null || !what.equals(current))) continue;
            return i;
        }
        return -1;
    }

    public static Map getMap() {
        return new HashMap();
    }

    public static Map getMap(int size) {
        return new HashMap(size * 4 / 3);
    }

    public static Set getSet(int size) {
        return new HashSet(size);
    }

    public static Map toMap(Object key, Object value) {
        Map map = Objects.getMap(1);
        map.put(key, value);
        return map;
    }

    public static Map toMap(Object key1, Object value1, Object key2, Object value2) {
        Map map = Objects.toMap(key1, value1);
        map.put(key2, value2);
        return map;
    }

    public static Map toMap(Object key1, Object value1, Object key2, Object value2, Object key3, Object value3) {
        Map map = Objects.toMap(key1, value1, key2, value2);
        map.put(key3, value3);
        return map;
    }

    public static Map toMap(Object[] pairs) {
        if (pairs == null) {
            return null;
        }
        Map map = Objects.getMap(pairs.length / 2);
        for (int i = 0; i < pairs.length; i += 2) {
            map.put(pairs[i], pairs[i + 1]);
        }
        return map;
    }

    public static Set toSet(Object[] objects) {
        if (objects == null) {
            return null;
        }
        Set set = Objects.getSet(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            set.add(objects[i]);
        }
        return set;
    }

    public static HashMap reallocate(Map map) {
        int size = map.size() * 4 / 3;
        HashMap result = new HashMap(size);
        result.putAll(map);
        return result;
    }
}

