/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.Sortable;
import java.util.Hashtable;

public class XMLSchemaPositionSorter
implements Sortable {
    private boolean _isXUIComponentSort;
    private Hashtable _ids = new Hashtable();

    public XMLSchemaPositionSorter(boolean isXUIComponentSort) {
        this._isXUIComponentSort = isXUIComponentSort;
    }

    public boolean compare(Object a, Object b) {
        if (a instanceof Type && b instanceof Type) {
            short[] compareIds;
            Type type_a = (Type)a;
            Type type_b = (Type)b;
            if (this._isXUIComponentSort) {
                String xpathA = type_a.getDirectChildValue("xpath");
                String xpathB = type_b.getDirectChildValue("xpath");
                if (xpathA != null && xpathB != null) {
                    if (xpathA.startsWith("global:") && !xpathB.startsWith("global:")) {
                        return true;
                    }
                    if (xpathB.startsWith("global:") && !xpathA.startsWith("global:")) {
                        return false;
                    }
                    if (xpathB.startsWith("global:") && xpathA.startsWith("global:")) {
                        String startXPathB;
                        int indexB;
                        String startXPathA = xpathA;
                        int indexA = startXPathA.indexOf("/");
                        if (indexA != -1) {
                            startXPathA = startXPathA.substring(0, indexA);
                        }
                        if ((indexB = (startXPathB = xpathB).indexOf("/")) != -1) {
                            startXPathB = startXPathB.substring(0, indexB);
                        }
                        if (!startXPathA.equals(startXPathB)) {
                            return xpathA.compareTo(xpathB) < 0;
                        }
                    }
                }
                type_a = (Type)type_a.getUserObject();
                type_b = (Type)type_b.getUserObject();
            }
            if (type_a == null || type_b == null) {
                return false;
            }
            short[] ids = type_a.getId();
            if (ids.length == (compareIds = type_b.getId()).length) {
                for (int i = 0; i < ids.length; ++i) {
                    if (type_a.isAttribute() && !type_b.isAttribute()) {
                        return true;
                    }
                    if (!type_a.isAttribute() && type_b.isAttribute()) {
                        return false;
                    }
                    if (ids[i] < compareIds[i]) {
                        return true;
                    }
                    if (ids[i] <= compareIds[i]) continue;
                    return false;
                }
                ListType parentList_a = type_a.getParentList();
                ListType parentList_b = type_b.getParentList();
                if ((parentList_a != null || parentList_b != null) && parentList_a == parentList_b) {
                    return this.getListIndex(parentList_a, type_a) < this.getListIndex(parentList_b, type_b);
                }
            } else {
                if (ids.length < compareIds.length) {
                    for (int i = 0; i < ids.length; ++i) {
                        if (ids[i] < compareIds[i]) {
                            return true;
                        }
                        if (ids[i] <= compareIds[i]) continue;
                        return false;
                    }
                    return true;
                }
                for (int i = 0; i < compareIds.length; ++i) {
                    if (ids[i] < compareIds[i]) {
                        return true;
                    }
                    if (ids[i] <= compareIds[i]) continue;
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private int getListIndex(ListType parentList, Type type) {
        if (type.getParent() == parentList) {
            return parentList.getList().indexOf(type);
        }
        if (type.getParent() != null) {
            return this.getListIndex(parentList, type.getParent());
        }
        return -1;
    }
}

