/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.IntrospectionMethodParameter;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.ToStringConverter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapHelper {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void removeKeyStartsWith(Map aMap, String startsWith) {
        Iterator it = aMap.entrySet().iterator();
        ArrayList toRemove = new ArrayList();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            if (!aEntry.getKey().toString().startsWith(startsWith)) continue;
            toRemove.add(aEntry.getKey());
        }
        MapHelper.removeKeysFromMap(aMap, toRemove);
    }

    public static Map copyKeyStartsWith(Map aMap, String startsWith) {
        Iterator it = aMap.entrySet().iterator();
        HashMap result = new HashMap();
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            if (!aEntry.getKey().toString().startsWith(startsWith)) continue;
            result.put(aEntry.getKey(), aEntry.getValue());
        }
        return result;
    }

    public static void removeKeysFromMap(Map aMap, String[] toRemove) {
        int ts = toRemove.length;
        for (int t = 0; t < ts; ++t) {
            aMap.remove(toRemove[t]);
        }
    }

    public static void removeKeysFromMap(Map aMap, ArrayList toRemove) {
        int ts = toRemove.size();
        for (int t = 0; t < ts; ++t) {
            aMap.remove(toRemove.get(t));
        }
    }

    public static void removeOther(Map aMap, List toKeep) {
        int ts = toKeep.size();
        Object[] entries = aMap.entrySet().toArray();
        for (int e = 0; e < entries.length; ++e) {
            Map.Entry aEntry = (Map.Entry)entries[e];
            if (toKeep.indexOf(aEntry.getKey()) != -1) continue;
            aMap.remove(aEntry.getKey());
        }
    }

    public static String toString(Map list) {
        return MapHelper.toString(list, true, true);
    }

    public static String toString(Map list, boolean withKey, boolean withValue) {
        return MapHelper.toString(list, withKey, withValue, ",");
    }

    public static String toString(Map list, boolean withKey, boolean withValue, String delim) {
        return MapHelper.toString(list, withKey, withValue, delim, null, null, null);
    }

    public static String toString(Map list, boolean withKey, boolean withValue, String delim, String prefix, String postfix, ToStringConverter converter) {
        Set aSet = list.entrySet();
        Iterator aSetIt = aSet.iterator();
        StringBuffer result = new StringBuffer();
        if (prefix != null) {
            result.append(prefix);
        }
        while (aSetIt.hasNext()) {
            Map.Entry entry = aSetIt.next();
            if (withKey) {
                result.append(entry.getKey().toString());
            }
            if (withKey && withValue) {
                result.append("=");
            }
            if (withValue) {
                if (converter != null) {
                    result.append(converter.convert(entry.getValue()));
                } else {
                    result.append(entry.getValue());
                }
            }
            if (!aSetIt.hasNext()) continue;
            result.append(delim);
        }
        if (postfix != null) {
            result.append(postfix);
        }
        return result.toString();
    }

    public static List toListForEntrySet(Map aMap) {
        int s = aMap.size();
        Vector result = new Vector(s > 0 ? s : 10);
        Iterator it = aMap.entrySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static List toListForValues(Map aMap) {
        Vector result = new Vector(aMap.size());
        Iterator it = aMap.values().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static List toListForKey(Map aMap) {
        Vector result = new Vector(aMap.size());
        Iterator it = aMap.keySet().iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static Object[] toArrayForKey(Map aMap) {
        Object[] result = new Object[aMap.size()];
        Iterator it = aMap.keySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            result[pos++] = it.next();
        }
        return result;
    }

    public static String[] toStringArrayForKey(Map aMap) {
        String[] result = new String[aMap.size()];
        Iterator it = aMap.keySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            result[pos++] = it.next().toString();
        }
        return result;
    }

    public static String[] toStringArray(Map aMap, boolean key, boolean value) {
        String[] result = new String[aMap.size()];
        Iterator it = aMap.entrySet().iterator();
        int pos = 0;
        while (it.hasNext()) {
            Map.Entry aEntry = it.next();
            if (key) {
                String string = result[pos++] = aEntry.getKey() != null ? aEntry.getKey().toString() : "";
            }
            if (!value) continue;
            result[pos++] = aEntry.getValue() != null ? aEntry.getValue().toString() : "";
        }
        return result;
    }

    public static Map invertKeyValue(Map aMap) {
        Iterator entries = aMap.entrySet().iterator();
        HashMap result = new HashMap(aMap.size());
        while (entries.hasNext()) {
            Map.Entry object = entries.next();
            result.put(object.getValue(), object.getKey());
        }
        return result;
    }

    public static Object getFirstMapEntry(Map aMap) {
        Iterator it = aMap.entrySet().iterator();
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }

    public static boolean containsAll(Map map, Object[] keys) {
        for (int k = 0; k < keys.length; ++k) {
            if (map.containsKey(keys[k])) continue;
            return false;
        }
        return true;
    }

    public static Map tupleToMap(String[] what) {
        int l = what.length / 2;
        HashMap<String, String> result = new HashMap<String, String>(l);
        for (int i = 0; i < what.length; i += 2) {
            result.put(what[i], what[i + 1]);
        }
        return result;
    }

    public static Map tupleToMap(String[] what, Map result) {
        if (what == null) {
            return result;
        }
        int l = what.length / 2;
        for (int i = 0; i < what.length; i += 2) {
            result.put(what[i], what[i + 1]);
        }
        return result;
    }

    public static Map toMap(String[] what) {
        int l = what.length;
        HashMap<String, String> result = new HashMap<String, String>(l);
        for (int i = 0; i < l; ++i) {
            result.put(what[i], what[i]);
        }
        return result;
    }

    public static Map toMap(Enumeration what) {
        HashMap result = new HashMap();
        while (what.hasMoreElements()) {
            Object object = what.nextElement();
            result.put(object, object);
        }
        return result;
    }

    public static Map toMap(List what) {
        return MapHelper.toMap(what, false);
    }

    public static Map toMap(List what, boolean emptyIfNull) {
        if (what == null && emptyIfNull) {
            return new HashMap(2);
        }
        int l = what.size();
        HashMap result = new HashMap(l);
        for (int i = 0; i < l; ++i) {
            result.put(what.get(i), what.get(i));
        }
        return result;
    }

    public static Map toMap(List what, boolean emptyIfNull, boolean posAsValue) {
        if (what == null && emptyIfNull) {
            return new HashMap(2);
        }
        int l = what.size();
        HashMap result = new HashMap(l);
        for (int i = 0; i < l; ++i) {
            result.put(what.get(i), i);
        }
        return result;
    }

    public static Map toMap(Class impl, Enumeration what) {
        Map result = (Map)IntroSpectionHelper.createObject(impl.getName(), (List)null);
        while (what.hasMoreElements()) {
            Object object = what.nextElement();
            result.put(object, object);
        }
        return result;
    }

    public static Map toMap(Class impl, List what) {
        int l = what.size();
        Map result = (Map)IntroSpectionHelper.createObject(impl.getName(), (List)null);
        for (int i = 0; i < l; ++i) {
            result.put(what.get(i), what.get(i));
        }
        return result;
    }

    public static String[] translate(String[] sqlColNames, Map colMapping) {
        ArrayList<String> res = new ArrayList<String>(sqlColNames.length);
        for (int s = 0; s < sqlColNames.length; ++s) {
            Object val;
            if (sqlColNames[s] == null || (val = colMapping.get(sqlColNames[s])) == null) continue;
            res.add(val.toString());
        }
        return ArrayUtil.toStringArray(res);
    }

    public static Map addAll(Map<String, String> items, String[] vals) {
        for (int v = 0; v < vals.length; ++v) {
            items.put(vals[v], vals[v]);
        }
        return items;
    }

    public static boolean istTrue(Map domArgs, String key, boolean defaultVal) {
        if (domArgs == null || !domArgs.containsKey(key)) {
            return defaultVal;
        }
        return StringUtil.isTrue((String)domArgs.get(key));
    }

    public synchronized Map load(InputStream inStream) throws IOException {
        int limit;
        HashMap<String, String> result = new HashMap<String, String>();
        char[] convtBuf = new char[1024];
        LineReader lr = new LineReader(inStream);
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = MapHelper.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = MapHelper.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            result.put(key, value);
        }
        return result;
    }

    public static synchronized void store(Map aMap, OutputStream out, String comments, String keyPrefix, ToStringConverter converter, String entryPrefix, String entryPostfix) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            StringUtil.writeln(awriter, new StringBuffer().append("#").append(comments).toString());
        }
        for (String key : aMap.keySet()) {
            Object valObj = aMap.get(key);
            String val = null;
            if (converter != null) {
                val = converter.convert(valObj);
            } else {
                String string = val = valObj != null ? valObj.toString() : null;
            }
            if (keyPrefix != null) {
                key = new StringBuffer().append(keyPrefix).append(key).toString();
            }
            key = MapHelper.saveConvert(key, true);
            val = MapHelper.saveConvert(val, false);
            StringUtil.writeln(awriter, new StringBuffer().append(entryPrefix != null ? entryPrefix : "").append(key).append("=").append(val).append(entryPostfix != null ? entryPostfix : "").toString());
        }
        awriter.flush();
    }

    public static String convert(Object o) {
        return o.toString();
    }

    public static void serialize(Map aMap) throws IOException {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)aMap);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        props.store(bos, "");
        System.out.println(new String(bos.toString()));
    }

    public static void deSerializeProperties() throws IOException {
        Properties props = new Properties();
        ByteArrayInputStream bis = new ByteArrayInputStream("".getBytes());
        props.load(bis);
        System.out.println(props.toString());
    }

    public static String loadConvert(String in) {
        return MapHelper.loadConvert(in.toCharArray(), 0, in.length(), new char[in.length()]);
    }

    public static String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(MapHelper.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(MapHelper.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(MapHelper.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(MapHelper.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static Object createFromString(String string) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        if (string == null) {
            return res;
        }
        List els = StringUtil.getAllBetween(string, "[", "]");
        for (int e = 0; e < els.size(); ++e) {
            String aEl = StringUtil.removeIfFirstLast((String)els.get(e), "[", "]");
            String key = StringUtil.substringBefore(aEl, "=");
            String val = StringUtil.substringAfter(aEl, "=");
            IntrospectionMethodParameter param = IntroSpectionHelper.parseParam(val);
            Object valObj = param.getParameterValue();
            res.put(key, valObj);
        }
        return res;
    }

    class LineReader {
        byte[] inBuf = new byte[8192];
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = (char)(0xFF & this.inBuf[this.inOff++]);
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream.read(this.inBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

