/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class DateCalculator {
    public static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("yyyy.mm.dd");

    public static Date getEarliestNonExcludedDate(int daysAway, Date baseDate, int[] excludedDaysOfWeek) {
        return DateCalculator.getEarliestNonExcludedDate(daysAway, baseDate, excludedDaysOfWeek, (Hashtable)null);
    }

    public static Date getEarliestNonExcludedDate(int daysAway, Date baseDate, int[] excludedDaysOfWeek, String[] excludedDateList) {
        Hashtable<Date, String> excludedDates = new Hashtable<Date, String>();
        if (excludedDateList != null) {
            for (int i = 0; i < excludedDateList.length; ++i) {
                try {
                    excludedDates.put(SimpleDateFormat.getDateInstance().parse(excludedDateList[i]), "");
                    continue;
                }
                catch (ParseException err) {
                    // empty catch block
                }
            }
        }
        return DateCalculator.getEarliestNonExcludedDate(daysAway, baseDate, excludedDaysOfWeek, excludedDates);
    }

    public static Date getEarliestNonExcludedDate(int daysAway, Date baseDate, int[] excludedDaysOfWeek, Date[] excludedDateList) {
        Hashtable<Date, String> excludedDates = new Hashtable<Date, String>();
        if (excludedDateList != null) {
            for (int i = 0; i < excludedDateList.length; ++i) {
                excludedDates.put(excludedDateList[i], "");
            }
        }
        return DateCalculator.getEarliestNonExcludedDate(daysAway, baseDate, excludedDaysOfWeek, excludedDates);
    }

    public static Date getEarliestNonExcludedDate(int daysAway, Date baseDate, int[] excludedDaysOfWeek, Hashtable excludedDates) {
        int i;
        if (daysAway < 0) {
            return null;
        }
        if (baseDate == null) {
            baseDate = new Date();
        }
        Calendar baseCopy = Calendar.getInstance();
        Calendar baseCal = Calendar.getInstance();
        baseCopy.setTime(baseDate);
        baseCal.clear();
        baseCal.set(baseCopy.get(1), baseCopy.get(2), baseCopy.get(5));
        if (excludedDaysOfWeek == null) {
            excludedDaysOfWeek = new int[]{};
        }
        if (excludedDates == null) {
            excludedDates = new Hashtable();
        }
        Hashtable<Integer, String> excludedDays = new Hashtable<Integer, String>();
        for (i = 0; i < excludedDaysOfWeek.length; ++i) {
            excludedDays.put(new Integer(excludedDaysOfWeek[i]), "");
        }
        while (DateCalculator.isExcludedDate(baseCal, excludedDays, excludedDates)) {
            baseCal.add(5, 1);
        }
        Calendar resultCal = Calendar.getInstance();
        resultCal.setTime(baseCal.getTime());
        int daysPerWeek = resultCal.getMaximum(7);
        int daysPerWeekNotExcluded = daysPerWeek - excludedDays.size();
        int wholeWeeksAway = daysAway / daysPerWeekNotExcluded;
        int remainingDaysAway = daysAway % daysPerWeekNotExcluded;
        resultCal.add(5, wholeWeeksAway * daysPerWeek);
        int nExcludedDates = 0;
        Enumeration exclDates = excludedDates.keys();
        while (exclDates.hasMoreElements()) {
            Date nextExclDate = (Date)exclDates.nextElement();
            Calendar nextExclCal = Calendar.getInstance();
            nextExclCal.setTime(nextExclDate);
            if (excludedDays.containsKey(new Integer(nextExclCal.get(7))) || !baseCal.before(nextExclCal) || resultCal.before(nextExclCal)) continue;
            ++nExcludedDates;
        }
        remainingDaysAway += nExcludedDates;
        for (i = 0; i < remainingDaysAway; ++i) {
            do {
                resultCal.add(5, 1);
            } while (DateCalculator.isExcludedDate(resultCal, excludedDays, excludedDates));
        }
        return resultCal.getTime();
    }

    public static boolean isExcludedDate(Calendar checkCal, Hashtable excludedDays, Hashtable excludedDates) {
        Calendar testCal = Calendar.getInstance();
        testCal.clear();
        testCal.set(checkCal.get(1), checkCal.get(2), checkCal.get(5));
        return excludedDays != null && excludedDays.containsKey(new Integer(checkCal.get(7))) || excludedDates != null && excludedDates.containsKey(testCal.getTime());
    }
}

