/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.tableModel.StackableTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SorterTableModel
extends AbstractTableModel
implements StackableTableModel {
    protected TableModel tableModel;
    public static final int DESCENDING = -1;
    public static final int NOT_SORTED = 0;
    public static final int ASCENDING = 1;
    public static final String STATUS = "status";
    private Class[] columnClasses;
    private static Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    private boolean _colNumSorterMode = false;
    public static final Comparator TYPE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Type && o2 instanceof Type) {
                if (((Type)o1).isSimple() && ((Type)o2).isSimple()) {
                    return ((SimpleType)o1).compareValue((SimpleType)o2);
                }
                return ((Type)o1).getXPathLocation().compareTo(((Type)o2).getXPathLocation());
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator RULE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Type && o2 instanceof Type) {
                if (((Type)o1).isSimple() && ((Type)o2).isSimple()) {
                    ((SimpleType)o1).compareValue((SimpleType)o2);
                } else if (((Type)o1).getParent("component") != null && ((Type)o2).getParent("component") != null) {
                    Type t1 = (Type)o1;
                    Type t2 = (Type)o2;
                    return ((SimpleType)t1.getParent("component").getDirectChild("xpath")).getValue().compareTo(((SimpleType)t2.getParent("component").getDirectChild("xpath")).getValue());
                }
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator RULE_STATUS_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Type && o2 instanceof Type) {
                Integer s1 = (Integer)((Type)o1).getClientProperty(SorterTableModel.STATUS);
                Integer s2 = (Integer)((Type)o2).getClientProperty(SorterTableModel.STATUS);
                if (s1 == null && s2 != null) {
                    return 1;
                }
                if (s1 != null && s2 == null) {
                    return -1;
                }
                if (s1 == null && s2 == null) {
                    return 0;
                }
                return s1.compareTo(s2);
            }
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    };
    public static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    };
    public static final Comparator NUMBER_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return Double.compare(Double.parseDouble(o1.toString()), Double.parseDouble(o2.toString()));
        }
    };
    private Row[] viewToModel;
    private int[] modelToView;
    private JTableHeader tableHeader;
    private MouseListener mouseListener;
    private TableModelListener tableModelListener;
    private Map columnComparators = new HashMap();
    private List sortingColumns = new ArrayList();

    public SorterTableModel() {
        this.mouseListener = new MouseHandler();
        this.tableModelListener = new TableModelHandler();
        this.columnClasses = new Class[0];
    }

    public SorterTableModel(TableModel tableModel) {
        this();
        this.columnClasses = new Class[tableModel.getColumnCount()];
        this.setTableModel(tableModel);
    }

    public SorterTableModel(TableModel tableModel, JTableHeader tableHeader) {
        this();
        this.columnClasses = new Class[tableModel.getColumnCount()];
        this.setTableHeader(tableHeader);
        this.setTableModel(tableModel);
    }

    private void clearSortingState() {
        this.viewToModel = null;
        this.modelToView = null;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public void setTableModel(TableModel tableModel) {
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        if (this.tableModel != null) {
            this.tableModel.addTableModelListener(this.tableModelListener);
        }
        this.clearSortingState();
        this.fireTableStructureChanged();
    }

    public JTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        if (this.tableHeader != null) {
            this.tableHeader.removeMouseListener(this.mouseListener);
            TableCellRenderer defaultRenderer = this.tableHeader.getDefaultRenderer();
            if (defaultRenderer instanceof SortableHeaderRenderer) {
                this.tableHeader.setDefaultRenderer(((SortableHeaderRenderer)defaultRenderer).tableCellRenderer);
            }
        }
        this.tableHeader = tableHeader;
        if (this.tableHeader != null) {
            this.tableHeader.addMouseListener(this.mouseListener);
            this.tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this.tableHeader.getDefaultRenderer()));
        }
    }

    public boolean isSorting() {
        return this.sortingColumns.size() != 0;
    }

    private Directive getDirective(int column) {
        for (int i = 0; i < this.sortingColumns.size(); ++i) {
            Directive directive = (Directive)this.sortingColumns.get(i);
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    public int getSortingStatus(int column) {
        return this.getDirective(column).direction;
    }

    private void sortingStatusChanged() {
        this.clearSortingState();
        this.fireTableDataChanged();
        if (this.tableHeader != null) {
            this.tableHeader.repaint();
        }
    }

    public void setSortingStatus(int column, int status) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (status != 0) {
            this.sortingColumns.add(new Directive(column, status));
        }
        this.sortingStatusChanged();
    }

    protected Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private void cancelSorting() {
        this.sortingColumns.clear();
        this.sortingStatusChanged();
    }

    public void setColumnComparator(Class type, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(type);
        } else {
            this.columnComparators.put(type, comparator);
        }
    }

    public void setColumnComparator(Integer column, Comparator comparator) {
        if (comparator == null) {
            this.columnComparators.remove(column);
        } else {
            this.columnComparators.put(column, comparator);
        }
    }

    protected Comparator getComparator(int column) {
        Class columnType = null;
        Comparator comparator = null;
        if (this.isColNumSorterMode()) {
            comparator = (Comparator)this.columnComparators.get(new Integer(column));
            if (comparator != null) {
                return comparator;
            }
        } else {
            columnType = this.getColumnClass(column);
            comparator = (Comparator)this.columnComparators.get(columnType);
            if (comparator != null) {
                return comparator;
            }
            if (columnType != null && Comparable.class.isAssignableFrom(columnType)) {
                return COMPARABLE_COMAPRATOR;
            }
        }
        return LEXICAL_COMPARATOR;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            int tableModelRowCount = this.tableModel.getRowCount();
            this.viewToModel = new Row[tableModelRowCount];
            for (int row = 0; row < tableModelRowCount; ++row) {
                this.viewToModel[row] = new Row(row);
            }
            if (this.isSorting()) {
                Arrays.sort(this.viewToModel);
            }
        }
        return this.viewToModel;
    }

    public int getViewToModel(int rowIndex) {
        int mIndex = rowIndex;
        if (rowIndex >= 0) {
            mIndex = this.modelIndex(rowIndex);
            if (this.tableModel != null && this.tableModel instanceof StackableTableModel) {
                return ((StackableTableModel)this.tableModel).getViewToModel(mIndex);
            }
        }
        return mIndex;
    }

    private int[] getModelToView() {
        if (this.modelToView == null) {
            int n = this.getViewToModel().length;
            this.modelToView = new int[n];
            for (int i = 0; i < n; ++i) {
                this.modelToView[this.modelIndex((int)i)] = i;
            }
        }
        return this.modelToView;
    }

    public int getRowCount() {
        return this.tableModel == null ? 0 : this.tableModel.getRowCount();
    }

    public int getColumnCount() {
        return this.tableModel == null ? 0 : this.tableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        Class aColClass = this.tableModel.getColumnClass(column);
        if (column < this.columnClasses.length && this.columnClasses[column] != null && this.columnClasses[column] != aColClass) {
            aColClass = this.columnClasses[column];
        }
        return aColClass;
    }

    public void setColumnClass(int column, Class columnClass) {
        this.columnClasses[column] = columnClass;
    }

    public boolean isCellEditable(int row, int column) {
        return this.tableModel.isCellEditable(this.modelIndex(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.tableModel.getValueAt(this.modelIndex(row), column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        this.tableModel.setValueAt(aValue, this.modelIndex(row), column);
    }

    private int modelIndex(int viewIndex) {
        int index = this.getViewToModel()[viewIndex].modelIndex;
        return index;
    }

    public boolean isColNumSorterMode() {
        return this._colNumSorterMode;
    }

    public void setColNumSorterMode(boolean isColNumSorterMode) {
        this._colNumSorterMode = isColNumSorterMode;
    }

    static /* synthetic */ Row[] access$802(SorterTableModel x0, Row[] x1) {
        x0.viewToModel = x1;
        return x1;
    }

    private static class Directive {
        private int column;
        private int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                int modelColumn = table.convertColumnIndexToModel(column);
                JLabel oldLabel = (JLabel)c;
                JLabel l = new JLabel(oldLabel.getText(), SorterTableModel.this.getHeaderRendererIcon(modelColumn, oldLabel.getFont().getSize()), 2);
                c = l;
            }
            return c;
        }
    }

    private static class Arrow
    implements Icon {
        private boolean descending;
        private int size;
        private int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                // empty if block
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            int column;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            if (viewColumn != -1 && (column = columnModel.getColumn(viewColumn).getModelIndex()) != -1) {
                int status = SorterTableModel.this.getSortingStatus(column);
                if (!e.isControlDown()) {
                    SorterTableModel.this.cancelSorting();
                }
                status += e.isShiftDown() ? -1 : 1;
                status = (status + 4) % 3 - 1;
                SorterTableModel.this.setSortingStatus(column, status);
            }
        }
    }

    private class TableModelHandler
    implements TableModelListener {
        private TableModelHandler() {
        }

        public void tableChanged(TableModelEvent e) {
            if (!SorterTableModel.this.isSorting()) {
                SorterTableModel.this.clearSortingState();
                SorterTableModel.this.fireTableChanged(e);
                return;
            }
            if (e.getFirstRow() == -1) {
                SorterTableModel.access$802(SorterTableModel.this, null);
                SorterTableModel.this.cancelSorting();
                SorterTableModel.this.fireTableChanged(e);
                return;
            }
            int column = e.getColumn();
            if (e.getFirstRow() == e.getLastRow() && column != -1 && SorterTableModel.this.getSortingStatus(column) == 0 && SorterTableModel.this.modelToView != null) {
                int viewIndex = SorterTableModel.this.getModelToView()[e.getFirstRow()];
                SorterTableModel.this.fireTableChanged(new TableModelEvent(SorterTableModel.this, viewIndex, viewIndex, column, e.getType()));
                return;
            }
            SorterTableModel.this.clearSortingState();
            SorterTableModel.this.fireTableDataChanged();
        }
    }

    private class Row
    implements Comparable {
        private int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int row1 = this.modelIndex;
            int row2 = ((Row)o).modelIndex;
            Iterator it = SorterTableModel.this.sortingColumns.iterator();
            while (it.hasNext()) {
                Directive directive = (Directive)it.next();
                int column = directive.column;
                Object o1 = SorterTableModel.this.tableModel.getValueAt(row1, column);
                Object o2 = SorterTableModel.this.tableModel.getValueAt(row2, column);
                int comparison = 0;
                comparison = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : SorterTableModel.this.getComparator(column).compare(o1, o2)));
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }
}

