/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.ui.tableModel;

import [Ljava.lang.Object;;
import com.jaxfront.core.ui.tableModel.StackableTableModel;
import com.jaxfront.core.util.IntroSpectionHelper;
import java.util.Comparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class FilterableTableModel
extends AbstractTableModel
implements TableModelListener,
StackableTableModel {
    private Comparator defaultComp = new DefaultComparator();
    public static final String DEFAULT_FILTER = "^#.*";
    private TableModel _delegateTableModel;
    private int[] _filterMapping;
    private int _filterMatchCount;
    private int rowCount = -1;
    private TableFilter _tableFilter;
    private int[] _rowsToFilterOut;

    public FilterableTableModel(TableModel delegateTableModel) {
        this._delegateTableModel = delegateTableModel;
        this._delegateTableModel.addTableModelListener(this);
    }

    public void addRow(Object[] rowColumns) {
        try {
            IntroSpectionHelper.callFunktion(this._delegateTableModel, "addRow", new Class[]{Object;.class}, new Object[]{rowColumns});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRowCount() {
        if (this.getCachedRowCount() == -1) {
            if (this.isFilterEnabled()) {
                if (this._rowsToFilterOut != null) {
                    this.doFilter(this._rowsToFilterOut);
                } else {
                    this.doFilter();
                }
            }
            this.setCachedRowCount(this._filterMapping != null ? this._filterMapping.length : this._delegateTableModel.getRowCount());
            return this.getCachedRowCount();
        }
        return this.getCachedRowCount();
    }

    public int getColumnCount() {
        return this._delegateTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this._delegateTableModel.getColumnName(column);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int actualRowIndex = rowIndex;
        if (this.isFilterEnabled()) {
            actualRowIndex = this._filterMapping[rowIndex];
        }
        return this._delegateTableModel.getValueAt(actualRowIndex, columnIndex);
    }

    public int getViewToModel(int rowIndex) {
        int actualRowIndex = rowIndex;
        if (rowIndex >= 0) {
            if (this.isFilterEnabled()) {
                actualRowIndex = this._filterMapping[rowIndex];
            }
            if (actualRowIndex >= 0 && this._delegateTableModel != null && this._delegateTableModel instanceof StackableTableModel) {
                actualRowIndex = ((StackableTableModel)this._delegateTableModel).getViewToModel(actualRowIndex);
            }
        }
        return actualRowIndex;
    }

    public int[] getFilterMapping() {
        return this._filterMapping;
    }

    private void setFilterMapping(int[] filterMapping) {
        this._filterMapping = filterMapping;
    }

    public TableModel getDelegateTableModel() {
        return this._delegateTableModel;
    }

    public void setDelegateTableModel(TableModel delegate) {
        this._delegateTableModel = delegate;
    }

    public void deleteRow(int selectedRow) {
        if (this._delegateTableModel != null && this._delegateTableModel instanceof DefaultTableModel) {
            ((DefaultTableModel)this._delegateTableModel).removeRow(selectedRow);
        } else {
            try {
                IntroSpectionHelper.callFunktion(this._delegateTableModel, "deleteRow", new Class[]{Integer.TYPE}, new Object[]{new Integer(selectedRow)});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void doFilter() {
        this._filterMatchCount = 0;
        int rowCount = this._delegateTableModel.getRowCount();
        int[] tmpMapping = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean found = true;
            int fCols = this._tableFilter.getCols();
            for (int j = 0; found && j < fCols; ++j) {
                ColumnFilter colFilter = this._tableFilter.getColumnFilter(j);
                found = colFilter != null ? this._tableFilter.getColumnFilter(j).match((String)this._delegateTableModel.getValueAt(i, this._tableFilter.getFilterColIndexFor(j))) : true;
            }
            if (!found) continue;
            tmpMapping[this._filterMatchCount++] = i;
            found = false;
        }
        int[] currentFilterMapping = new int[this._filterMatchCount];
        System.arraycopy(tmpMapping, 0, currentFilterMapping, 0, this._filterMatchCount);
        this.setFilterMapping(currentFilterMapping);
    }

    private void doFilter(int[] rowsToFilter) {
        this._filterMatchCount = 0;
        int rowCount = this._delegateTableModel.getRowCount();
        int[] tmpMapping = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            boolean found = false;
            for (int j = 0; j < rowsToFilter.length; ++j) {
                if (rowsToFilter[j] != i) continue;
                found = true;
                break;
            }
            if (found) continue;
            tmpMapping[this._filterMatchCount++] = i;
            found = false;
        }
        int[] currentFilterMapping = new int[this._filterMatchCount];
        System.arraycopy(tmpMapping, 0, currentFilterMapping, 0, this._filterMatchCount);
        this.setFilterMapping(currentFilterMapping);
    }

    public int getFilterMatchCount() {
        return this._filterMatchCount;
    }

    public void setFilterMatchCount(int filterMatches) {
        this.setCachedRowCount(-1);
        this._filterMatchCount = filterMatches;
    }

    public TableFilter getFilter() {
        return this._tableFilter;
    }

    public void setFilter(String[][] filters) {
        this._tableFilter = new TableFilter(filters);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
        this.fireTableDataChanged();
    }

    public void setFilter(String[] filters) {
        this._tableFilter = new TableFilter(filters);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
        this.fireTableDataChanged();
    }

    public void setFilteredRows(int[] rows) {
        this._rowsToFilterOut = rows;
        this.setCachedRowCount(-1);
        this.fireTableDataChanged();
    }

    public void resetFilters() {
        this._tableFilter.reset();
        this.setCachedRowCount(-1);
        this.fireTableDataChanged();
    }

    public int[] getFilteredRows() {
        return this._rowsToFilterOut;
    }

    public void setFilter(String[][] filters, int[] filterCols) {
        this._tableFilter = new TableFilter(filterCols, filters);
        this.setFilterColumns(filterCols);
        this._rowsToFilterOut = null;
        this.setCachedRowCount(-1);
        this.fireTableDataChanged();
    }

    boolean isFilterEnabled() {
        return this.getFilteredRows() != null || this.getFilter() != null && !"".equals(this.getFilter());
    }

    public int[] getFilterColumns() {
        return this._tableFilter.getColMapping();
    }

    public void setFilterColumns(int[] filterColumns) {
        this._rowsToFilterOut = null;
        if (this._tableFilter != null) {
            this._tableFilter.setColMapping(filterColumns);
        } else {
            this._tableFilter = new TableFilter(filterColumns);
        }
    }

    public void addTableModelListener(TableModelListener l) {
        super.addTableModelListener(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        super.removeTableModelListener(l);
    }

    public void tableChanged(TableModelEvent e) {
        this.setCachedRowCount(-1);
        this.fireTableChanged(e);
    }

    private void setCachedRowCount(int rowCount) {
        this.rowCount = rowCount;
    }

    private int getCachedRowCount() {
        return this.rowCount;
    }

    public class ColumnFilter {
        private String[] _filterValues;
        String colName;
        int logic;
        int colIndex;
        Comparator compImpl = null;

        public ColumnFilter(String[] filters) {
            this.setFilters(filters);
        }

        public void setFilters(String[] filters) {
            this._filterValues = filters;
        }

        public String[] getFilterValues() {
            return this._filterValues;
        }

        public Comparator getComparable() {
            if (this.compImpl == null) {
                return FilterableTableModel.this.defaultComp;
            }
            return this.compImpl;
        }

        public void setSortable(Comparator compImpl) {
            this.compImpl = compImpl;
        }

        public int getLogic() {
            return this.logic;
        }

        public boolean match(String value) {
            for (int i = 0; i < this._filterValues.length; ++i) {
                if (this.getComparable().compare(value, this._filterValues[i]) != 1) continue;
                return true;
            }
            return false;
        }
    }

    public class TableFilter {
        private ColumnFilter[] _colFilters;
        private int[] _cols = new int[0];

        public TableFilter(String[][] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = new int[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(filters[i]);
                this._cols[i] = i;
            }
        }

        public TableFilter(String[] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = new int[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(new String[]{filters[i]});
                this._cols[i] = i;
            }
        }

        public TableFilter(int[] cols, String[][] filters) {
            this._colFilters = new ColumnFilter[filters.length];
            this._cols = cols;
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(filters[i]);
            }
        }

        public TableFilter(int[] cols) {
            this._cols = cols;
        }

        public TableFilter(int cols) {
            this._colFilters = new ColumnFilter[cols];
            this._cols = new int[cols];
            for (int i = 0; i < cols; ++i) {
                ColumnFilter colF;
                this._colFilters[i] = colF = new ColumnFilter(new String[]{FilterableTableModel.DEFAULT_FILTER});
                this._cols[i] = i;
            }
        }

        public ColumnFilter getColumnFilter(int index) {
            if (this._colFilters == null) {
                return null;
            }
            return this._colFilters[index];
        }

        public ColumnFilter getColumnFilter(String colName) {
            for (int i = 0; i < this._colFilters.length; ++i) {
                if (this._colFilters[i].colName != colName) continue;
                return this._colFilters[i];
            }
            return null;
        }

        public int getCols() {
            return this._cols.length;
        }

        public int[] getColMapping() {
            return this._cols;
        }

        public void setColMapping(int[] cols) {
            this._cols = cols;
        }

        public int getFilterColIndexFor(int col) {
            return this._cols[col];
        }

        public void reset() {
            this._colFilters = null;
        }

        public void setFilters(String[] filters) {
            for (int i = 0; i < filters.length; ++i) {
                ColumnFilter colF = this._colFilters[i];
                colF.setFilters(new String[]{filters[i]});
            }
        }
    }

    public class DefaultComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            boolean matches = arg0.toString().matches(arg1.toString());
            return matches ? 1 : 0;
        }
    }
}

