/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.type;

import com.jaxfront.core.dom.DOMBuilder;
import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontUserEvent;
import com.jaxfront.core.error.ValidationError;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.KeyRefException;
import com.jaxfront.core.schema.SchemaNode;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.schema.XMLSchema;
import com.jaxfront.core.schema.impl.XMLSchemaImpl;
import com.jaxfront.core.type.AbstractCompositeType;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.DerivationNameResolver;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.xui.BehaviourDefinition;
import com.jaxfront.core.xui.XUIDefinition;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractListType
extends AbstractType
implements ListType {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Type _editingType;
    private List _list;
    private List _noTargetXUIDefinitions;
    private int[] _sortIndexes;

    public AbstractListType(SchemaNode schemaElement, Type editingType) {
        super(schemaElement);
        this.setEditingType(editingType);
        this._editingType.setParent(this);
    }

    public Type add(Type type) {
        return this.add(type, null, true);
    }

    private Type add(Type type, boolean check) {
        return this.add(type, null, check);
    }

    private Type add(Type type, Type beforeType, boolean check) {
        if (beforeType == null) {
            return this.add(type, -1, check);
        }
        return this.add(type, this.getList().indexOf(beforeType), check);
    }

    public List sort(int direction) {
        Vector toSort;
        boolean wasBlocked;
        block5: {
            this.getDOM().setRuleEngineBlocked(true);
            wasBlocked = this.getDOM().getUndoManager().isBlocked();
            this.getDOM().getUndoManager().blockInput(true);
            toSort = new Vector(this.size());
            ArrayUtil.addToVector(toSort, this.toArray());
            FastQSort qSort = new FastQSort();
            try {
                qSort.sort(toSort, StringUtil.getNaturalTypeTreeLabelComparator(), direction);
            }
            catch (Exception e) {
                if (!LogRegistry.getInstance().logWarnings()) break block5;
                LogRegistry.getInstance().warn(this.getClass(), "sort failed:" + e.getMessage());
            }
        }
        if (toSort != null) {
            this.getList().clear();
            for (int i = 0; i < toSort.size(); ++i) {
                this.getList().add(toSort.get(i));
            }
        }
        if (!wasBlocked) {
            this.getDOM().getUndoManager().blockInput(false);
            this.getDOM().setRuleEngineBlocked(false);
        }
        this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_SORTED(this, null));
        return toSort;
    }

    private Type add(Type type, int index, boolean check) {
        return this.add(null, type, index, check);
    }

    private boolean isUserCreated(Object source) {
        return source == null || source != FastQSort.class;
    }

    public Type add(Object source, Type type, int index, boolean check) {
        block16: {
            JAXFrontUndoManager undoManager = this.getDOM().getUndoManager();
            boolean wasUndoCompoundState = undoManager.isInCompoundEditState();
            boolean isBinding = this.getDOM().isBinding();
            try {
                if (!isBinding) {
                    undoManager.startCompoundEdit();
                }
                if (check) {
                    this.checkCardinality(1);
                }
                type.setParent(this);
                if (type.isRecursive() && !type.hasRecursionBeenBuilt()) {
                    try {
                        ((CompositeType)type).completeRecursion();
                    }
                    catch (CloneNotSupportedException e) {
                        // empty catch block
                    }
                }
                if (index == -1 || index > this.size()) {
                    index = this.size();
                    this.getList().add(type);
                } else {
                    this.getList().add(index, type);
                    this.markAsDirtyXPath();
                }
                if (this.isUserCreated(source) && !isBinding && !this.getDOM().isPasteMode()) {
                    this.notifyKeyRefChildsForCreation(type);
                    this.autoCreateEntries();
                }
                if (this.getDOM().isXUIInitialized()) {
                    boolean ruleEngineBlocked = this.getDOM().isRuleEngineBlocked();
                    this.getDOM().setRuleEngineBlocked(true);
                    this.maintainXUIDefinitions(type);
                    this.reinitVars(index, type);
                    this.getDOM().setRuleEngineBlocked(ruleEngineBlocked);
                }
                if (!isBinding) {
                    if (!this.getDOM().getController().isBlockDirtyChange()) {
                        this.setHasChanged(true);
                    }
                    this.getDOM().getUndoManager().addListChangeEditEvent(null, this, type, index, (short)2);
                    type.getDOM().fireDOMChanged(DOMChangeEvent.DOM_ADD_NODE(type));
                }
                if (!this.getDOM().isEditable()) {
                    this.getDOM().markNotEditableTypes(type, false, false);
                }
                if (!wasUndoCompoundState && !isBinding) {
                    undoManager.stopCompoundEdit();
                }
            }
            catch (ValidationException ex) {
                type = null;
                if (this.shouldFireCardinalityException()) {
                    this.getDOM().getController().getErrorController().addError(new ValidationError(ex, (Type)this));
                }
                if (wasUndoCompoundState || isBinding) break block16;
                undoManager.abortCompoundEdit();
            }
        }
        return type;
    }

    public Type addNewChild() {
        return this.addNewChild(null);
    }

    public Type addNewChild(int index) {
        return this.addNewChild(null, index);
    }

    public Type addNewChild(Type templateType) {
        return this.addNewChild(templateType, -1);
    }

    public Type addNewChild(Type templateType, Type beforeType) {
        return this.addNewChild(templateType, this.getList().indexOf(beforeType));
    }

    private Type copyType(Type templateType) {
        Type copy = null;
        boolean wasBinding = this._DOM.isBinding();
        try {
            if (templateType != null) {
                this._DOM.setIsBinding(true);
                copy = templateType.deepClone(this._DOM, true, true);
                if (!wasBinding) {
                    this._DOM.setIsBinding(false);
                }
            } else {
                List derivedTypes;
                Type editingType = this.getEditingType();
                if (this.getEditingType().isAbstract() && (derivedTypes = this.getEditingType().getDerivedTypes()).size() > 0) {
                    editingType = (Type)derivedTypes.get(0);
                }
                this._DOM.setIsBinding(true);
                copy = editingType.deepClone(this._DOM, false, false);
                if (!wasBinding) {
                    this._DOM.setIsBinding(false);
                }
            }
        }
        catch (CloneNotSupportedException e) {
            LogRegistry.getInstance().error(this.getClass(), e);
            copy = null;
        }
        copy.setParent(this);
        return copy;
    }

    public boolean hasAbstractContent() {
        return this.getEditingType().isAbstract();
    }

    public Type addNewChild(Object source, Type templateType, int targetIndex) {
        Type copy = this.copyType(templateType);
        return this.add(source, copy, targetIndex, true);
    }

    public Type addNewChild(Type templateType, int targetIndex) {
        return this.addNewChild(null, templateType, targetIndex);
    }

    public void addNoTargetXUIDefinition(Type xuiType) {
        if (this._noTargetXUIDefinitions == null) {
            this._noTargetXUIDefinitions = new Vector(4);
        }
        this.getNoTargetXUIDefinitions().add(xuiType);
    }

    public void bind(Object trigger, Type type) {
        this._hasParentListBeenResolved = false;
        this._parentList = null;
        if (trigger == JAXFrontUserEvent.class && this.getStyle().isSelectionOnly()) {
            return;
        }
        if (type.isList()) {
            this._serializable = ((AbstractType)type)._serializable;
        }
        List childrenToBind = ((ListType)type).getDirectChildren();
        if (this.size() == childrenToBind.size()) {
            for (int i = 0; i < this.size(); ++i) {
                ((Type)this.getList().get(i)).bind(trigger, (Type)childrenToBind.get(i));
            }
        } else if (this.size() > childrenToBind.size()) {
            int counter = 0;
            for (counter = 0; counter < childrenToBind.size(); ++counter) {
                ((Type)this.getList().get(counter)).bind(trigger, (Type)childrenToBind.get(counter));
            }
            int c = counter;
            while (counter < this.size()) {
                try {
                    this.removeChild((Type)this.getList().get(counter), false);
                }
                catch (ListModificationException e) {
                    // empty catch block
                }
                ++c;
            }
        } else {
            int counter = 0;
            for (counter = 0; counter < this.size(); ++counter) {
                ((Type)this.getList().get(counter)).bind(trigger, (Type)childrenToBind.get(counter));
            }
            for (int nextCounter = counter; nextCounter < childrenToBind.size(); ++nextCounter) {
                Type newType = this.addNewChild((Type)childrenToBind.get(nextCounter));
                this.setDOMRecursive(newType);
            }
        }
        if (this.getStyle().isUsingPlugIn()) {
            this.informPlugin(this);
        }
        this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_FINISHED_BINDING(this));
    }

    private void setDOMRecursive(Type type) {
        type.setDOM(this.getDOM());
        List childs = null;
        if (type.isComposite()) {
            childs = ((CompositeType)type).getComposites();
        } else if (type.isList()) {
            childs = ((ListType)type).getList();
        }
        if (childs != null) {
            for (int i = 0; i < childs.size(); ++i) {
                this.setDOMRecursive((Type)childs.get(i));
            }
        }
    }

    public void bind(Document DOM, Element instanceElement) {
        boolean bindOnylAvailable = JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isBindingOnlyAvailable();
        if (this.getDOM().isXUIDOMInstance()) {
            bindOnylAvailable = false;
        }
        this.bind(DOM, instanceElement, bindOnylAvailable);
    }

    public void bind(Document DOM, Element instanceElement, boolean bindOnlyAvailable) {
        this.bind(DOM, instanceElement, bindOnlyAvailable, false);
    }

    public void removeFromEnd(int count) {
        int from = this.getDirectChildrenSize() - 1;
        int to = from - count;
        to = to < 0 ? 0 : to;
        for (int i = from; i > to; --i) {
            try {
                this.removeChild((Type)this.getList().get(i), false);
                continue;
            }
            catch (ListModificationException e) {
                // empty catch block
            }
        }
    }

    public void bind(Document DOM, Element instanceElement, boolean bindOnlyAvailable, boolean removeChilds) {
        super.bind(DOM, instanceElement, bindOnlyAvailable);
        if (this.getEditingType() != null && this.getEditingType().getDOM() == null && this._DOM != null) {
            this.getEditingType().bind(this._DOM, null, bindOnlyAvailable);
        }
        if (instanceElement != null && instanceElement.getParentNode() != null) {
            Element instanceParent = instanceElement.getParentNode().getNodeType() == 9 || this.isAbstract() || this.isAnonymous() ? instanceElement : (Element)instanceElement.getParentNode();
            List instanceChildren = this.getInstanceChildren(instanceParent);
            List removedOriginals = null;
            List childInstances = instanceChildren;
            if (removeChilds && this.size() > 0) {
                removedOriginals = this.removeAll(true, false);
            } else {
                int typeChildsCount = this.getDirectChildrenSize();
                int cDiff = typeChildsCount - childInstances.size();
                if (cDiff > 0) {
                    this.removeFromEnd(cDiff);
                }
            }
            for (int i = 0; i < childInstances.size(); ++i) {
                try {
                    boolean dataBound = false;
                    boolean reusedType = false;
                    Type newType = null;
                    if (i < this.getDirectChildrenSize()) {
                        newType = (Type)this.getList().get(i);
                        reusedType = newType != null;
                    }
                    Element element = (Element)childInstances.get(i);
                    if (this.isAbstract()) {
                        Type originalDerrivate;
                        DerivationNameResolver derivationNameResolver;
                        String derrivationName = element.getAttribute("xsi:type");
                        if ((derrivationName == null || derrivationName.length() == 0) && (derivationNameResolver = (DerivationNameResolver)this.getDOM().getClientProperty("DOM-DerivationNameResolver")) != null) {
                            derrivationName = derivationNameResolver.getName(this, element);
                        }
                        if ((originalDerrivate = DOMHelper.getDerivedType(this.getEditingType(), derrivationName, false)) != null) {
                            if (newType == null) {
                                newType = originalDerrivate.deepClone(this.getDOM(), true, false);
                            }
                        } else if (LogRegistry.getInstance().logWarnings()) {
                            LogRegistry.getInstance().warn(this.getClass(), "No derivate found for: " + this.getEditingType().getName() + " with name: " + derrivationName);
                        }
                    } else if (this.isAnonymous() && this.getEditingType().isChoice()) {
                        Object[] choiceNames;
                        int choiceNameIndex;
                        String choiceName = element.getLocalName();
                        if (choiceName == null) {
                            choiceName = element.getNodeName();
                        }
                        String choiceNS = element.getNamespaceURI();
                        if (this.getEditingType().isChoice() && (choiceNameIndex = ArrayUtil.contains(choiceNames = ((CompositeType)this.getEditingType().getTemplate()).getRelevantChoiceNames(), choiceName)) != -1) {
                            ((CompositeType)this.getEditingType().getTemplate()).createChoiceType(choiceName);
                        }
                        if (this.getEditingType().getTemplate().getDirectChild(choiceName, choiceNS) != null) {
                            Type choiceType;
                            if (newType == null) {
                                newType = this.getEditingType().deepClone(null, false, false);
                            }
                            if ((choiceType = newType.getDirectChild(choiceName, choiceNS)) == null) {
                                choiceType = ((AbstractCompositeType)newType).createChoiceType(choiceName);
                            }
                            if (newType != null) {
                                newType.setChoosenType(choiceType);
                            }
                            choiceType.bind(DOM, element, bindOnlyAvailable);
                            dataBound = true;
                        }
                    } else if (!bindOnlyAvailable || this.getDOM().isXUIDOMInstance() || this.getDOM().isPDFXUIDOM()) {
                        if (newType == null) {
                            newType = this.getEditingType().deepClone(null, false, false);
                        }
                    } else if (newType == null) {
                        newType = this.getEditingType().deepClone(null, false, false, false, null, element);
                    }
                    if (newType == null) continue;
                    newType.setParent(this);
                    newType.setDOM(this._DOM);
                    if (!reusedType) {
                        if (!this._DOM.isBinding()) {
                            this.add(newType);
                        } else {
                            this.getList().add(newType);
                        }
                    }
                    if (dataBound) continue;
                    newType.bind(this._DOM, element, bindOnlyAvailable);
                    dataBound = true;
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    LogRegistry.getInstance().error(this.getClass(), e);
                }
            }
            if (this._list != null) {
                ((Vector)this._list).trimToSize();
            }
            if (this.getXUIDefinition() != null && TypeVisualizerFactory.getInstance() != null && this.getStyle().isUsingPlugIn()) {
                this.informPlugin(this);
            }
        } else if (this.size() > 0) {
            this.deleteAll(true, false);
        }
    }

    public void checkCardinality(int changes) throws ValidationException {
        if (this.violateCardinality(changes)) {
            throw ValidationException.createCardinalityException(this);
        }
    }

    public boolean violateCardinality(int changes) {
        boolean violate = false;
        int maxOccurs = this.getMaxOccurs();
        if (maxOccurs == -1) {
            maxOccurs = Integer.MAX_VALUE;
        }
        if (changes == 1) {
            if (this.size() + changes > maxOccurs) {
                violate = true;
            }
        } else if (changes == -1) {
            if (this.size() + changes < this.getMinOccurs()) {
                violate = true;
            }
        } else if (changes == 0) {
            if (this.size() > maxOccurs) {
                violate = true;
            }
            if (this.size() < this.getMinOccurs()) {
                violate = true;
            }
        }
        return violate;
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData) throws CloneNotSupportedException {
        return this.deepClone(dom, cloneChoices, includingData, false, null, null);
    }

    public Object delete(Type type) throws ListModificationException {
        return this.delete(type, false);
    }

    public Object delete(Type type, boolean isTemporary) throws ListModificationException {
        return this.delete(type, isTemporary, true);
    }

    public Object delete(Type type, boolean isTemporary, boolean check) throws ListModificationException {
        int index = this.getList().indexOf(type);
        return this.delete(index, isTemporary, check);
    }

    private Object delete(int index, boolean isTemporary, boolean check) throws ListModificationException {
        return this.delete(null, index, isTemporary, check);
    }

    public Object delete(Object source, int index, boolean isTemporary, boolean check) throws ListModificationException {
        Object deleted;
        block17: {
            if (this.getDOM().isXUIInitialized()) {
                this.reinitVars(index, null);
            }
            deleted = null;
            if (index >= 0 && index < this.size()) {
                try {
                    Type type;
                    block16: {
                        if (check) {
                            this.checkCardinality(-1);
                        }
                        type = (Type)this.get(index);
                        if (check && type.isKey()) {
                            try {
                                ((AbstractType)type).isKeyRemovable();
                            }
                            catch (KeyRefException e) {
                                if (isTemporary) break block16;
                                throw new ListModificationException(1, type, (ListType)this, e);
                            }
                        }
                    }
                    if (!this.getDOM().isPasteMode()) {
                        try {
                            this.notifyKeyRefChildsForDeletion(type, check);
                            this.notifyChildsForDeletion(ArrayUtil.createListContaining(type), check);
                        }
                        catch (KeyRefException e) {
                            throw new ListModificationException(1, type, (ListType)this, e);
                        }
                    }
                    if (!isTemporary && !this.getDOM().isBinding()) {
                        this.getDOM().getUndoManager().addListChangeEditEvent(null, this, type, index, (short)1);
                    }
                    deleted = this.getList().remove(index);
                    this.markDirtyXPath(index);
                    if (!this.getDOM().isBinding()) {
                        if (!this.getDOM().getController().isBlockDirtyChange()) {
                            this.setHasChanged(true);
                        }
                        if (!this.isDerivedFromGlobalEditingType((AbstractType)type)) {
                            type.setRenderable(false);
                        }
                        this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_REMOVE_NODE(type, index), isTemporary);
                        type.getDOM().getController().removeRule(type, true);
                        type.getDOM().removeFormulaExpressions(type);
                    }
                    type.release();
                }
                catch (ValidationException ex) {
                    if (this.shouldFireCardinalityException()) {
                        this.getDOM().getController().getErrorController().addError(new ValidationError(ex, (Type)this));
                    }
                    break block17;
                }
            }
            LogRegistry.getInstance().error(this.getClass(), "try to remove a not existing element (-1 index) from:" + this.getXPathLocation());
        }
        return deleted;
    }

    private String getKeyRefIDTypeName() {
        Type keyRefIDType = null;
        if (this.getEditingType() != null && this.getEditingType().getDirectChildren() != null && this.getEditingType().getDirectChildren().listIterator().hasNext()) {
            ListIterator iterator = this.getEditingType().getDirectChildren().listIterator();
            while (iterator.hasNext()) {
                Type tempChild = (Type)iterator.next();
                if (tempChild == null || !tempChild.isKey()) continue;
                keyRefIDType = tempChild;
                break;
            }
        }
        if (keyRefIDType != null) {
            return keyRefIDType.getName();
        }
        return null;
    }

    private Type getListItemIDType() {
        String listItemIDPath;
        Type listItemIDType = null;
        if (this.getStyle().getTableInfo() != null && (listItemIDPath = this.getStyle().getTableInfo().getListItemIDPath()) != null && listItemIDPath.length() > 0) {
            listItemIDType = TypePathExecuter.getInstance().getTypeForXPath(this.getEditingType(), listItemIDPath);
        }
        return listItemIDType;
    }

    private void deleteAll(boolean isTemporary, boolean check) {
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            Type child = (Type)this.getList().get(i);
            try {
                this.delete(child, isTemporary, check);
                continue;
            }
            catch (ListModificationException e) {
                // empty catch block
            }
        }
        if (this.getStyle().getTableInfo() != null) {
            this.getStyle().getTableInfo().clearLineInfos();
        }
    }

    public Type getDirectChild(String name) {
        return this.getEditingType().getDirectChild(name);
    }

    public Type getDirectChild(String name, String namespace) {
        return this.getEditingType().getDirectChild(name, namespace);
    }

    public List getDirectChildren() {
        return this.getList();
    }

    public int getDirectChildrenSize() {
        if (this._list == null) {
            return 0;
        }
        return this.getList().size();
    }

    public List getDirectChildren(String name) {
        Iterator iterator = this.getList().iterator();
        Vector<Type> found = new Vector<Type>();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (!type.getName().equals(name)) continue;
            found.add(type);
        }
        return found;
    }

    public Type getEditingType() {
        return this._editingType;
    }

    private List getInstanceChildren(Element instanceElement) {
        List children = null;
        children = this.isAnonymous() ? DOMHelper.getChildren(this.getDOM().getSchema(), instanceElement) : DOMHelper.getChildren(this.getDOM().getSchema(), instanceElement, this);
        return children;
    }

    public List getList() {
        if (this._list == null) {
            this._list = new Vector(5);
        }
        return this._list;
    }

    public int getMaxOccurs() {
        return this.getSchemaElement().getMaxOccurs();
    }

    public int getMinOccurs() {
        return this.getSchemaElement().getMinOccurs();
    }

    public List getNoTargetXUIDefinitions() {
        return this._noTargetXUIDefinitions;
    }

    private int getPosition(String nodeName, List names) {
        for (int i = 0; i < names.size(); ++i) {
            List subNames = (List)names.get(i);
            if (!subNames.contains(nodeName)) continue;
            return i;
        }
        return -1;
    }

    private List getUnnamedChildGroups(Element instanceElement) {
        Vector children = new Vector();
        if (this.getEditingType().isComposite()) {
            CompositeType composite = (CompositeType)this.getEditingType();
            List names = this.getChildNames(composite);
            List instanceChildren = DOMHelper.getChildren(null, instanceElement);
            int counter = 0;
            for (int i = 0; i < instanceChildren.size(); ++i) {
                Node node = (Node)instanceChildren.get(i);
                int position = this.getPosition(node.getNodeName(), names);
                Vector<Node> groupNodes = null;
                if (position >= 0) {
                    List relevantNames = (List)names.get(position);
                    groupNodes = new Vector<Node>();
                    if (relevantNames.size() > 1) {
                        boolean isOk = true;
                        for (int j = i; j < instanceChildren.size() && isOk; ++j) {
                            i = j;
                            Node testableNode = (Node)instanceChildren.get(j);
                            if (testableNode.getNodeType() == 3) continue;
                            if (relevantNames.indexOf(testableNode.getNodeName()) > -1) {
                                groupNodes.add(testableNode);
                                continue;
                            }
                            isOk = false;
                        }
                    } else {
                        groupNodes.add(node);
                    }
                }
                if (groupNodes != null && groupNodes.size() > 0) {
                    children.addAll(groupNodes);
                }
                ++counter;
            }
        }
        return children;
    }

    private void initializeXUIDefinitions(Type originalType, Type newType, boolean isStart, List rulesToInitialize) {
        block4: {
            List subTypes;
            block3: {
                newType.setTemplate(originalType);
                this.checkXUIDefinition(originalType, newType, rulesToInitialize);
                if (!originalType.isList()) break block3;
                ListType newLType = (ListType)newType;
                Type origEditingType = ((ListType)originalType).getEditingType();
                this.initializeXUIDefinitions(origEditingType, newLType.getEditingType(), false, rulesToInitialize);
                if (newLType.size() <= 0) break block4;
                Iterator listEntries = newLType.getList().iterator();
                while (listEntries.hasNext()) {
                    Type newSubType = (Type)listEntries.next();
                    this.initializeXUIDefinitions(origEditingType, newSubType, false, rulesToInitialize);
                }
                break block4;
            }
            if (originalType.isComposite() && (subTypes = ((CompositeType)originalType).getComposites()) != null) {
                Iterator origIterator = subTypes.iterator();
                while (origIterator.hasNext()) {
                    Type origSubType = (Type)origIterator.next();
                    Type newSubType = newType.getDirectChild(origSubType.getName());
                    if (newSubType == null) continue;
                    this.initializeXUIDefinitions(origSubType, newSubType, false, rulesToInitialize);
                }
            }
        }
    }

    public void checkXUIDefinition(Type originalType, Type newType, List rulesToInitialize) {
        XUIDefinition originalXUIDef = originalType.getXUIDefinition();
        XUIDefinition newXUIDef = newType.getXUIDefinition(false);
        if (originalXUIDef != null && originalXUIDef.hasBeenInitializedFromFile()) {
            if (newXUIDef == null || !newXUIDef.hasBeenInitializedFromFile()) {
                newXUIDef = new XUIDefinition(newType, null);
                newXUIDef.reinitialize(originalXUIDef);
                newType.setUIDefinition(newXUIDef);
                newType.setSerializable(newXUIDef.getStyle().getSerializable());
            } else if (newXUIDef.hasBeenInitializedFromFile() && !newType.isEditingType() && !newType.isDerivedFromEditingType() && newXUIDef.getBehaviour() != null) {
                rulesToInitialize.add(newXUIDef.getBehaviour());
            }
        }
    }

    public boolean isList() {
        return true;
    }

    public void maintainXUIDefinitions(Type type) {
        this.getDOM().maintainNoTargetXPathDefinitions(this.getNoTargetXUIDefinitions());
        Type parentEditingClone = null;
        if (this._template != null) {
            parentEditingClone = this._template.isList() ? ((ListType)this._template).getEditingType() : this._template;
        }
        if (parentEditingClone == null) {
            parentEditingClone = this.getEditingType();
        }
        Vector rulesToInitialize = new Vector();
        this.initializeXUIDefinitions(parentEditingClone, type, true, rulesToInitialize);
        if (rulesToInitialize.size() > 0) {
            Iterator it = rulesToInitialize.iterator();
            while (it.hasNext()) {
                ((BehaviourDefinition)it.next()).applyInitializationRules();
            }
        }
    }

    private void reinitVars(int index, Type type) {
        if (type != null && index == -1) {
            index = this.getList().indexOf(type);
        }
        if (index != -1 && index != this.size() - 1) {
            for (int i = index; i < this.size(); ++i) {
                Type child = (Type)this.getList().get(i);
                this.removeVarsFor(child);
            }
        }
        this.getDOM().reinitVars();
    }

    private void removeVarsFor(Type type) {
        List children = type.getDirectChildren();
        if (type.isSimple() && ((AbstractType)type).getVarName() != null && type.getClientProperty("VAR_NAME_XPATH") != null) {
            this.getDOM().getNoTargetVars().put(((AbstractType)type).getVarName(), (String)type.getClientProperty("VAR_NAME_XPATH"));
            ((AbstractType)type).setVarName(null);
        }
        Iterator typeIterator = children.iterator();
        while (typeIterator.hasNext()) {
            this.removeVarsFor((Type)typeIterator.next());
        }
    }

    public void move(int from, int to) {
    }

    public void release() {
        if (this._editingType != null && this.getDOM() != null && this.getDOM().isReleased() && !this.getDOM().isRunningInXUIEditor() && !this.getDOM().isXUIDOMInstance()) {
            AbstractType aEdType = (AbstractType)this._editingType;
            if (!aEdType.isReleased() && aEdType.isGlobalEdType()) {
                --this._globalEdTypeRefCount;
                if (!this._editingType.getSchemaElement().getSchema().keepInMemory() && aEdType.getEdTypeUUID() != null && aEdType.getGlobalEdTypeRefCount() <= 0) {
                    Object removed = ((XMLSchemaImpl)this._editingType.getSchemaElement().getSchema()).getEditingTypeCache().remove(aEdType.getEdTypeUUID());
                    this._editingType.release();
                }
            } else {
                this._editingType.release();
            }
        }
        if (!this.isDerivedFromGlobalEditingType(this)) {
            Iterator iterator;
            if (this._list != null) {
                iterator = this._list.iterator();
                while (iterator.hasNext()) {
                    ((Type)iterator.next()).release();
                }
                this._list = null;
            }
            if (this._noTargetXUIDefinitions != null) {
                iterator = this._noTargetXUIDefinitions.iterator();
                if (!JAXFrontProperties.getInstance(this.getDOM().getAppContext()).isUsingXUICache()) {
                    while (iterator.hasNext()) {
                        Type aXuiType = (Type)iterator.next();
                        if (this.getDOM().isRunningInXUIEditor() || aXuiType.getDOM() == DOMBuilder.getInstance().getXUISchemaDOM(this.getDOM().getAppContext()).getXUIDocument()) continue;
                        aXuiType.release();
                    }
                }
                this._noTargetXUIDefinitions = null;
            }
            super.release();
        }
    }

    public void removeAll() {
        this.deleteAll(false, false);
    }

    public List removeAll(boolean isTemporary, boolean check) {
        List listChilds = DOMHelper.getAllListChilds(this, true);
        for (int lc = listChilds.size() - 1; lc >= 0; --lc) {
            ((ListType)listChilds.get(lc)).removeAll(isTemporary, check);
        }
        int size = this.size();
        for (int i = size - 1; i >= 0; --i) {
            Type child = (Type)this.getList().get(i);
            try {
                this.delete(child, isTemporary, check);
                listChilds.add(child);
                continue;
            }
            catch (ListModificationException e) {
                // empty catch block
            }
        }
        return listChilds;
    }

    public boolean removeChild(Type child) throws ListModificationException {
        return this.delete(child) != null;
    }

    public Object removeChild(int index) throws ListModificationException {
        if (index == -1) {
            return this.removeLastChild(false);
        }
        return this.delete(index, false, true);
    }

    private void removeChild(Type child, boolean check) throws ListModificationException {
        this.delete(child, false, check);
    }

    public Object removeLastChild(boolean isTemporary) throws ListModificationException {
        return this.delete(this.size() - 1, isTemporary, true);
    }

    public void removeNoTargetXUIDefinition(Type xuiType) {
        if (this._noTargetXUIDefinitions != null) {
            this.getNoTargetXUIDefinitions().remove(xuiType);
        }
    }

    public void serialize(StringBuffer sb, int indent, boolean writeName, boolean recursive, boolean serializeEmptyContent) {
        super.serialize(sb, indent, writeName, recursive, serializeEmptyContent);
        if (this.size() > 0 && this.isSerializable() && recursive) {
            Iterator children = this.getList().iterator();
            while (children.hasNext()) {
                Type child = (Type)children.next();
                child.serialize(sb, indent, writeName, recursive, serializeEmptyContent);
            }
        }
    }

    public void swap(int from, int to) {
        if (this.getList() != null) {
            Vector currentList = (Vector)this.getList();
            Type sourceType = (Type)currentList.get(from);
            Type destinationType = (Type)currentList.get(to);
            currentList.remove(from);
            currentList.add(to, sourceType);
            int startIndex = from;
            if (to < from) {
                startIndex = to;
            }
            this.markDirtyXPath(startIndex);
            sourceType.markAsDirtyXPath();
            destinationType.markAsDirtyXPath();
            this.getDOM().getUndoManager().addListItemMovedEvent(null, this, from, to);
            this.getParentList().getDOM().fireDOMChanged(DOMChangeEvent.DOM_SWAP_NODE(this, from, to));
        }
    }

    public String getDisplayValue() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        boolean wasEmpty = false;
        String value = null;
        int dSize = this.getDirectChildrenSize();
        if (dSize > 0) {
            List list = this.getDirectChildren();
            for (int i = 0; i < dSize; ++i) {
                Type simpleGroup = (Type)list.get(i);
                value = simpleGroup.getDisplayValue();
                boolean bl = wasEmpty = value == null || value.equals("");
                if (first) {
                    first = false;
                } else if (!wasEmpty) {
                    buf.append(", ");
                }
                buf.append(wasEmpty ? "" : value);
            }
        }
        return buf.toString();
    }

    public Type getChild(String name) {
        return this.getEditingType().getChild(name);
    }

    public Type getChild(String name, String namespace) {
        return this.getEditingType().getChild(name, namespace);
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void setList(List list) {
        this._list = list;
    }

    public int[] getSortIndexes() {
        return this._sortIndexes;
    }

    public void setSortIndexes(int[] sortIndexes) {
        this._sortIndexes = sortIndexes;
    }

    public boolean isChoice() {
        return false;
    }

    private void markDirtyXPath(int startIndex) {
        if (startIndex < this.size()) {
            Iterator iterator = this.getList().iterator();
            while (iterator.hasNext()) {
                ((Type)iterator.next()).markAsDirtyXPath();
            }
        }
    }

    public void markAsDirtyXPath() {
        this.setDirtyXPath(true);
        Iterator iterator = this.getList().iterator();
        while (iterator.hasNext()) {
            ((Type)iterator.next()).markAsDirtyXPath();
        }
    }

    public boolean hasEmptyContent(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        boolean isEmpty = true;
        if (this.checkForEmptyContent() && this.size() > 0) {
            isEmpty = false;
        }
        return isEmpty;
    }

    public boolean hasEmptyContentChilds(boolean checkSerializeDefaults, boolean checkDefaultValue) {
        boolean isEmpty = true;
        if (this.checkForEmptyContent() && this.size() > 0) {
            Iterator listItemIterator = this.getList().iterator();
            while (listItemIterator.hasNext()) {
                if (((AbstractType)listItemIterator.next()).hasEmptyContent(checkSerializeDefaults, checkDefaultValue)) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public Type copyChild(Integer typeToCopyindex) {
        Type copy = null;
        List childs = this.getList();
        if (childs != null && typeToCopyindex != null) {
            int index = typeToCopyindex;
            if (childs != null && childs.size() > index) {
                Type childToCopy = (Type)childs.get(index);
                this.copyType(childToCopy);
            }
        }
        return copy;
    }

    public void copyAndPasteChild(Type typeToCopy, Integer targetIndex) {
        if (targetIndex == null) {
            targetIndex = new Integer(this.size() - 1);
        }
        this.addNewChild(typeToCopy, targetIndex);
    }

    public void copyAndPasteChild(Integer typeToCopyIndex, Integer targetIndex) {
        if (typeToCopyIndex != null) {
            int index = typeToCopyIndex;
            Type typeToCopy = (Type)this.getList().get(index);
            this.copyAndPasteChild(typeToCopy, targetIndex);
        }
    }

    public void copyAndPasteChild(Type typeToCopy) {
        int targetIndex = this.size() - 1;
        this.copyAndPasteChild(typeToCopy, new Integer(targetIndex));
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractListType clone = (AbstractListType)super.clone();
        clone._list = null;
        return clone;
    }

    public void maintainEditingTypeParent(Type editingType, Type parent) {
        editingType.setParent(parent);
        editingType.setDOM(parent.getDOM());
        List children = editingType.getDirectChildren();
        for (int i = 0; i < children.size(); ++i) {
            this.maintainEditingTypeParent((Type)children.get(i), editingType);
        }
        if (editingType.isList()) {
            this.maintainEditingTypeParent(((ListType)editingType).getEditingType(), editingType);
        }
    }

    public Type deepClone(Document dom, boolean cloneChoices, boolean includingData, boolean includeEditingType, SchemaNode schemaNode, Element element) throws CloneNotSupportedException {
        if (dom != null) {
            this.setDOM(dom);
        }
        AbstractListType copy = (AbstractListType)this.clone();
        Type edType = null;
        edType = this.resolveEditingType(dom, cloneChoices, includingData, schemaNode);
        copy.setEditingType(edType);
        copy._editingType.setParent(copy);
        if (this._list != null) {
            copy._list = new Vector(this.size());
            if (includingData) {
                List childs = this.getList();
                Type item = null;
                Type itemCopy = null;
                for (int c = 0; c < childs.size(); ++c) {
                    item = (Type)childs.get(c);
                    itemCopy = item.deepClone(dom, cloneChoices, includingData);
                    itemCopy.setParent(copy);
                    copy.add(itemCopy);
                }
            }
        }
        return copy;
    }

    private Type resolveEditingType(Document dom, boolean cloneChoices, boolean includingData, SchemaNode schemaNode) throws CloneNotSupportedException {
        Type edType = null;
        Type curEdType = this.getEditingType();
        if (JAXFrontProperties.getInstance().useEditingTypeCache()) {
            if (this.getDOM() != null) {
                edType = (Type)this.getDOM().getEditingTypeCache().get(((AbstractType)curEdType).getAbsoluteXPathLocation());
            } else {
                XMLSchema schema = curEdType.getSchemaElement().getSchema();
                edType = (Type)((XMLSchemaImpl)schema).getEditingTypeCache().get(((AbstractType)curEdType).getAbsoluteXPathLocation());
                if (!schema.isXUISchema()) {
                    ((AbstractType)curEdType).setGlobalEdType(true);
                    ++this._globalEdTypeRefCount;
                }
            }
            if (edType == null) {
                edType = curEdType.deepClone(dom, cloneChoices, includingData, true, schemaNode, null);
                if (this.getDOM() != null) {
                    this.getDOM().putEditingTypeCache(edType);
                } else {
                    ((XMLSchemaImpl)curEdType.getSchemaElement().getSchema()).putEditingTypeCache(curEdType);
                }
            }
        } else {
            edType = curEdType.deepClone(dom, cloneChoices, includingData, true, schemaNode, null);
        }
        return edType;
    }

    public void setEditingType(Type editingType) {
        this._editingType = editingType;
    }

    public void autoCreateEntries() {
        int requestedSize = 0;
        boolean autoCreate = this.getDOM().getGlobalDefinition().isAutoCreateMaxOccurListItems();
        boolean checkMinOccurs = true;
        if (this.hasUIDefinition()) {
            if (this.getStyle().getTableInfo() != null) {
                autoCreate = this.getStyle().getTableInfo().isAutoCreateMaxOccurListItems();
            } else if (this.getStyle().getListInfo() != null) {
                autoCreate = this.getStyle().getListInfo().isAutoCreateMaxOccurListItems();
            }
        }
        if (autoCreate && (requestedSize = this.getSchemaElement().getMaxOccurs()) >= 0) {
            checkMinOccurs = false;
        }
        if (checkMinOccurs) {
            autoCreate = this.getDOM().getGlobalDefinition().isAutoCreateMinOccurListItems();
            if (this.hasUIDefinition()) {
                if (this.getStyle().getTableInfo() != null) {
                    autoCreate = this.getStyle().getTableInfo().isAutoCreateMinOccurListItems();
                } else if (this.getStyle().getListInfo() != null) {
                    autoCreate = this.getStyle().getListInfo().isAutoCreateMinOccurListItems();
                }
            }
            if (autoCreate) {
                requestedSize = this.getSchemaElement().getMinOccurs();
            }
        }
        if (autoCreate && this.size() < requestedSize) {
            while (requestedSize - this.size() > 0) {
                Type newType = this.addNewChild();
                if (newType == null) continue;
                this.getDOM().checkAutoCreateListItems(newType);
            }
        }
    }

    protected boolean shouldFireCardinalityException() {
        return true;
    }

    public int size() {
        if (this._list == null) {
            return 0;
        }
        return this.getList().size();
    }

    public void clear() {
        this.removeAll();
    }

    public Object[] toArray() {
        if (this._list == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        return this.getList().toArray();
    }

    public Object get(int index) {
        if (this._list == null) {
            return null;
        }
        return this.getList().get(index);
    }

    public Object remove(int index) {
        try {
            return this.removeChild(index);
        }
        catch (ListModificationException e) {
            return null;
        }
    }

    public void add(int index, Object element) {
        this.addNewChild((Type)element, index);
    }

    public int indexOf(Object o) {
        return this.getList().indexOf(o);
    }

    public boolean isListItemRemoveable(Type listEntry) throws ListModificationException {
        try {
            this.checkCardinality(-1);
        }
        catch (ValidationException e1) {
            throw new ListModificationException(1, listEntry, (ListType)this, e1);
        }
        try {
            this.checkKeysForDeletion(listEntry);
        }
        catch (KeyRefException e) {
            throw new ListModificationException(1, listEntry, (ListType)this, e);
        }
        return true;
    }

    public int lastIndexOf(Object o) {
        return this.getList().lastIndexOf(o);
    }

    public boolean add(Object o) {
        return this.addNewChild((Type)o) != null;
    }

    public boolean contains(Object o) {
        if (this._list == null) {
            return false;
        }
        return this.getList().contains(o);
    }

    public boolean remove(Object o) {
        try {
            return this.removeChild((Type)o);
        }
        catch (ListModificationException e) {
            return false;
        }
    }

    public boolean addAll(int index, Collection c) {
        Iterator all = c.iterator();
        int startAt = 0;
        while (all.hasNext()) {
            Type element = (Type)all.next();
            if (startAt >= index) {
                this.addNewChild(element);
            }
            ++startAt;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator all = c.iterator();
        while (all.hasNext()) {
            Type element = (Type)all.next();
            this.addNewChild(element);
        }
        return true;
    }

    public boolean containsAll(Collection c) {
        return this.getList().containsAll(c);
    }

    public boolean removeAll(Collection c) {
        Iterator all = c.iterator();
        while (all.hasNext()) {
            Type element = (Type)all.next();
            try {
                this.removeChild(element);
            }
            catch (ListModificationException e) {
                return false;
            }
        }
        return true;
    }

    public boolean retainAll(Collection c) {
        Iterator all = c.iterator();
        while (all.hasNext()) {
            Type element = (Type)all.next();
            if (this.getList().contains(element)) continue;
            try {
                this.removeChild(element);
            }
            catch (ListModificationException e) {
                return false;
            }
        }
        return true;
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.getList().subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.getList().listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.getList().listIterator(index);
    }

    public Object set(int index, Object element) {
        return this.addNewChild((Type)element, index);
    }

    public Object[] toArray(Object[] a) {
        return this.getList().toArray(a);
    }

    public boolean hasChanged() {
        if (this._hasChanged) {
            return true;
        }
        return super.hasChanged();
    }
}

