/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.rule;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.AbstractCondition;
import com.jaxfront.core.rule.Condition;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.Message;
import com.jaxfront.core.type.Type;
import java.io.Serializable;

public class ConditionExpression
extends AbstractCondition
implements Serializable,
Cloneable {
    private FormulaExpression _formulaExpression;
    private boolean _useEventSourceAsBase = false;
    private Class _userConditionClass;
    private Condition _userCondition;

    public static ConditionExpression NO_CONDITION() {
        ConditionExpression noCondition = new ConditionExpression();
        noCondition._showError = false;
        noCondition._useToggle = false;
        return noCondition;
    }

    private ConditionExpression() {
    }

    public ConditionExpression(int id, Document DOM, Type source, Type xuiCondition) {
        this._source = source;
        if (xuiCondition != null) {
            this.initialize(id, xuiCondition);
        }
    }

    public boolean doesConcern(Type sourceType, boolean inclTargets) {
        if (this.isUsingUserClass()) {
            return this.getUserCondition().doesConcern(sourceType);
        }
        return this._formulaExpression != null && this._formulaExpression.doesConcern(sourceType, inclTargets);
    }

    private Condition getUserCondition() {
        if (this._userCondition == null) {
            try {
                this._userCondition = (Condition)this._userConditionClass.newInstance();
                this._userCondition.setSourceType(this._source);
            }
            catch (Exception ex) {
                LogRegistry.getInstance().warn(this.getClass(), "unable to instantiate user condition (" + this._userConditionClass.getName() + ")");
            }
        }
        return this._userCondition;
    }

    private void initialize(int id, Type xuiCondition) {
        Type message;
        if (xuiCondition.getDirectChildValue("showError") != null) {
            this._showError = new Boolean(xuiCondition.getDirectChildValue("showError"));
        }
        if (xuiCondition.getDirectChildValue("useInverse") != null) {
            this._useToggle = new Boolean(xuiCondition.getDirectChildValue("useInverse"));
        }
        if (xuiCondition.getDirectChildValue("className") != null) {
            this._userConditionClass = ConditionExpression.initUserClass(this.getSource().getDOM().getCustomClassloader(), xuiCondition.getDirectChildValue("className"));
        }
        String formula = xuiCondition.getDirectChildValue("formulaExpression");
        this._useEventSourceAsBase = Boolean.valueOf(xuiCondition.getDirectChildValue("useEventSourceAsBase"));
        if (formula != null) {
            this._formulaExpression = new FormulaExpression(this.getSource(), formula, false, false);
        }
        if ((message = xuiCondition.getDirectChild("message")) != null) {
            this._message = new Message(id, this.getSource(), message.getDirectChildValue("classification"), new Boolean(message.getDirectChildValue("needsUserAcceptance")), this._formulaExpression);
        }
    }

    public static Class initUserClass(ClassLoader classloader, String className) {
        block4: {
            try {
                Class<?> userClass = classloader.loadClass(className);
                if (userClass != null && Condition.class.isAssignableFrom(userClass)) {
                    return userClass;
                }
                if (LogRegistry.getInstance().logWarnings()) {
                    LogRegistry.getInstance().warn(ConditionExpression.class, className + " is not a valid Condition --> must implement Condition Interface");
                }
            }
            catch (Throwable ex) {
                if (!LogRegistry.getInstance().logWarnings()) break block4;
                LogRegistry.getInstance().warn(ConditionExpression.class, className + " is not a valid Condition --> must implement Condition Interface");
            }
        }
        return null;
    }

    public boolean isTrue(Type source, Object event) throws FormulaException {
        boolean formulaCheck = true;
        if (this._formulaExpression != null) {
            formulaCheck = this._formulaExpression.getExpression() == null || this._formulaExpression.getExpression().length() == 0 ? true : this._formulaExpression.isTrue(source, event, this._useEventSourceAsBase, true);
        }
        if (this.isUsingUserClass()) {
            formulaCheck = this._useEventSourceAsBase ? this.getUserCondition().isTrue(source) : this.getUserCondition().isTrue(this.getSource());
        }
        return formulaCheck;
    }

    public boolean isUsingUserClass() {
        return this._userConditionClass != null;
    }

    public void release() {
        if (this._formulaExpression != null) {
            this._formulaExpression.release();
        }
        this._formulaExpression = null;
        if (this._message != null) {
            this._message.release();
        }
        this._userConditionClass = null;
        this._source = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getMessage().getText());
        return sb.toString();
    }

    public Object clone(Type newSourceType) {
        ConditionExpression clone = null;
        try {
            clone = (ConditionExpression)super.clone();
            clone._source = newSourceType;
            if (this._formulaExpression != null) {
                clone._formulaExpression = new FormulaExpression(newSourceType, this._formulaExpression.getExpression(), false, false);
            }
            if (this._message != null) {
                clone._message = (Message)this._message.clone(newSourceType);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public FormulaExpression getFormulaExpression() {
        return this._formulaExpression;
    }
}

