/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypePathExecuter;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Comparative;
import org.nfunk.jep.type.NULL;

public abstract class SuperTypeNode
extends JaxfrontMathCommand {
    public static final Double isTrue = Comparative._true;
    public static final Double isFalse = Comparative._false;

    public SuperTypeNode() {
        this.numberOfParameters = -1;
    }

    String removeEscapedChars(String path) {
        return path.replace('\'', '\"');
    }

    void addToResultBag(MathEvaluator.MathCommunicator communicator, Object aType) {
        if (communicator.getResultBag() != null) {
            communicator.getResultBag().add(aType);
        }
    }

    void addToResultBag(MathEvaluator.MathCommunicator communicator, Collection collection) {
        if (communicator.getResultBag() != null) {
            communicator.getResultBag().addAll(collection);
        }
    }

    void dispatch(MathEvaluator.MathCommunicator communicator, Stack stack, Object o1, Object o2) throws ParseException {
        if (o1 == NULL._null || o2 == NULL._null) {
            stack.push(NULL._null);
        } else if (o1 instanceof String && o2 instanceof String) {
            this.evaluate(communicator, stack, (String)o1, (String)o2);
        } else if (o1 instanceof String && o2 instanceof Double) {
            this.evaluate(communicator, stack, (String)o1, (Double)o2);
        } else if (o1 instanceof String && o2 instanceof Boolean) {
            this.evaluate(communicator, stack, (String)o1, (Boolean)o2);
        } else if (o1 instanceof String && o2 instanceof Type) {
            this.evaluate(communicator, stack, (String)o1, (Type)o2, communicator.getIncludeOnlySerializable());
        } else if (o1 instanceof Type && o2 instanceof String) {
            this.evaluate(communicator, stack, (String)o2, (Type)o1, communicator.getIncludeOnlySerializable());
        } else {
            throw new ParseException("Wrong parameter type in node function o1 (" + o1 + ") o2 (" + o2 + ")");
        }
    }

    void dispatch(MathEvaluator.MathCommunicator communicator, Stack stack, Object o1, Object o2, Object o3) throws ParseException {
        if (o1 == NULL._null || o2 == NULL._null || o3 == NULL._null) {
            stack.push(NULL._null);
        } else if (o1 instanceof String && o2 instanceof Type && o3 instanceof Double) {
            this.evaluate(communicator, stack, (String)o1, (Type)o2, (Double)o3);
        } else {
            throw new ParseException("Wrong parameter type in node function o1 (" + o1 + ") o2 (" + o2 + ") o3 (" + o3 + ")");
        }
    }

    void dispatch(MathEvaluator.MathCommunicator communicator, Stack stack, Object o1) throws ParseException {
        if (o1 == NULL._null) {
            stack.push(NULL._null);
        } else if (o1 instanceof String) {
            this.evaluate(communicator, stack, (String)o1);
        } else if (o1 instanceof Type) {
            this.evaluate(communicator, stack, (Type)o1);
        } else if (o1 instanceof List) {
            this.evaluate(communicator, stack, (List)o1);
        } else {
            throw new ParseException("Wrong parameter type in node function o1 (" + o1 + ")");
        }
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath, Type baseType, Double includeOnlySerializable) {
        List resultList = TypePathExecuter.getInstance().processXPath(baseType, xPath.trim(), communicator.isEditingTypeIncluded(), communicator.isListTypeIncluded(), false, includeOnlySerializable > 0.0);
        if (communicator.isExtractFirstOnly()) {
            if (resultList.size() > 0) {
                Object aResult = resultList.get(0);
                this.addAResult(communicator, stack, (Type)aResult);
            } else {
                stack.push(NULL._null);
            }
        } else {
            ArrayResult results = new ArrayResult();
            for (int j = 0; j < resultList.size(); ++j) {
                Object aResult = resultList.get(j);
                this.addAResult(communicator, results, (Type)aResult);
            }
            stack.push(results);
        }
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath, String expression, Type baseType, Double onlySerializable) throws ParseException {
        expression = this.removeEscapedChars(expression);
        List resultList = TypePathExecuter.getInstance().processXPath(baseType, xPath.trim(), communicator.isEditingTypeIncluded(), communicator.isListTypeIncluded(), false, onlySerializable > 0.0);
        ArrayResult result = new ArrayResult();
        if (communicator.isExtractFirstOnly()) {
            if (resultList.size() > 0) {
                Object aResult = resultList.get(0);
                this.addAResult(communicator, result, (Type)aResult);
            } else {
                stack.push(NULL._null);
            }
        } else {
            for (int i = 0; i < resultList.size(); ++i) {
                Type aResult = (Type)resultList.get(i);
                if (aResult == NULL._null || !aResult.isSimple()) continue;
                this.addToResultBag(communicator, aResult);
                SimpleType resultType = (SimpleType)aResult;
                String buildedExpression = "";
                buildedExpression = !resultType.isNumber() ? "\"" + resultType.getValue() + "\"" : resultType.getValue();
                buildedExpression = buildedExpression + expression;
                if (!MathEvaluator.getInstance().evaluateBoolean(aResult, buildedExpression)) continue;
                this.addAObjectResult(communicator, result, resultList.get(i));
            }
        }
        stack.push(result);
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath, Double includeSerializable) {
        this.evaluate(communicator, stack, xPath, communicator.getRootType(), includeSerializable);
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath, Boolean includeSerializable) {
        Double includeTemp = isFalse;
        if (includeSerializable != null && includeSerializable.booleanValue()) {
            includeTemp = isTrue;
        }
        this.evaluate(communicator, stack, xPath, communicator.getRootType(), includeTemp);
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, Type aType) {
        this.addAResult(communicator, stack, aType);
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath) {
        this.evaluate(communicator, stack, xPath, communicator.getRootType(), communicator.getIncludeOnlySerializable());
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, List arrayResult) {
        ArrayResult result = new ArrayResult();
        for (int i = 0; i < arrayResult.size(); ++i) {
            Type aResult = (Type)arrayResult.get(i);
            if (!aResult.isSimple()) continue;
            Object valueObject = ((SimpleType)aResult).getMathValueTyped();
            if (valueObject == null) {
                result.add(NULL._null);
                continue;
            }
            result.add(valueObject);
        }
        stack.push(result);
    }

    void evaluate(MathEvaluator.MathCommunicator communicator, Stack stack, String xPath, String expression) throws ParseException {
        this.evaluate(communicator, stack, xPath, expression, communicator.getRootType(), communicator.getIncludeOnlySerializable());
    }

    private void add(MathEvaluator.MathCommunicator communicator, List resultList, Object o) {
        if (communicator.isAddEmptyElementsToResult()) {
            resultList.add(o);
        } else if (o != NULL._null) {
            resultList.add(o);
        }
    }

    private void addAResult(MathEvaluator.MathCommunicator communicator, List resultList, Type resultType) {
        this.addToResultBag(communicator, resultType);
        if (communicator.isExtractValues()) {
            if (resultType.isSimple()) {
                this.add(communicator, resultList, ((SimpleType)resultType).getMathValueTyped());
            } else {
                this.add(communicator, resultList, resultType.getDisplayValue());
            }
        } else {
            this.add(communicator, resultList, resultType);
        }
    }

    private void addAObjectResult(MathEvaluator.MathCommunicator communicator, List resultList, Object aResult) {
        if (communicator.isExtractValues()) {
            if (aResult instanceof Type) {
                this.addAResult(communicator, resultList, (Type)aResult);
            } else {
                this.add(communicator, resultList, aResult);
            }
        } else {
            this.add(communicator, resultList, aResult);
        }
    }

    void resolveNodes(MathEvaluator.MathCommunicator communicator, Stack inStack, Stack outStack) throws ParseException {
        this.resolveNodes(communicator, inStack, outStack, false, true);
    }

    void resolveNodes(MathEvaluator.MathCommunicator communicator, Stack inStack, Stack outStack, boolean extractValues) throws ParseException {
        this.resolveNodes(communicator, inStack, outStack, extractValues, true);
    }

    void resolveNodes(MathEvaluator.MathCommunicator communicator, Stack inStack, Stack outStack, boolean extractValues, boolean addEmptyElementsToResult) throws ParseException {
        this.resolveNodes(communicator, inStack, outStack, extractValues, addEmptyElementsToResult, false);
    }

    void resolveNodes(MathEvaluator.MathCommunicator communicator, Stack inStack, Stack outStack, boolean extractValues, boolean addEmptyElementsToResult, boolean extractFirstOnly) throws ParseException {
        communicator.setExtractValues(extractValues);
        communicator.setExtractFirstOnly(extractFirstOnly);
        communicator.setAddEmptyElementsToResult(addEmptyElementsToResult);
        if (this.curNumberOfParameters == 1) {
            this.dispatch(communicator, outStack, inStack.pop());
        } else if (this.curNumberOfParameters == 2) {
            Object param1 = inStack.pop();
            Object param2 = inStack.pop();
            this.dispatch(communicator, outStack, param2, param1);
        } else if (this.curNumberOfParameters == 3) {
            Object param1 = inStack.pop();
            Object param2 = inStack.pop();
            Object param3 = inStack.pop();
            this.dispatch(communicator, outStack, param3, param2, param1);
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter type");
        }
    }

    public void release() {
    }
}

