/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.rule.MathEvaluator;
import java.io.Serializable;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.NULL;

public class LongCast
extends PostfixMathCommand {
    public LongCast() {
        this.numberOfParameters = -1;
    }

    private Long convert(String param) {
        return new Long(new Double(param).longValue());
    }

    private Long convert(Boolean param) {
        if (param.booleanValue()) {
            return new Long(1L);
        }
        return new Long(0L);
    }

    private Long convert(Number param) {
        return new Long(((Double)param).longValue());
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Serializable result = null;
        if (this.curNumberOfParameters == 1) {
            Object newParam = stack.pop();
            try {
                if (newParam instanceof String) {
                    result = this.convert((String)newParam);
                }
                if (newParam instanceof Number) {
                    result = this.convert((Number)newParam);
                }
                if (newParam instanceof Boolean) {
                    result = this.convert((Boolean)newParam);
                }
                if (newParam instanceof List) {
                    List paramArray = (List)newParam;
                    ArrayResult resultArray = new ArrayResult(paramArray.size());
                    for (int i = 0; i < paramArray.size(); ++i) {
                        Object aArrayValue = paramArray.get(i);
                        if (aArrayValue instanceof String) {
                            resultArray.add(this.convert((String)newParam));
                            continue;
                        }
                        if (paramArray.get(i) instanceof Number) {
                            resultArray.add(this.convert((Number)newParam));
                            continue;
                        }
                        if (newParam instanceof Boolean) {
                            resultArray.add(this.convert((Boolean)newParam));
                            continue;
                        }
                        resultArray.add(NULL._null);
                    }
                    result = resultArray;
                }
                throw new ParseException(this.getClass() + " Invalid parameter type:" + newParam);
            }
            catch (NumberFormatException e) {
                throw new ParseException(this.getClass() + " NumberFormatException can't parse:" + newParam);
            }
        } else {
            throw new ParseException(this.getClass() + " Invalid parameter count");
        }
        stack.push(result);
    }
}

