/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.jep;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.jep.JaxfrontMathCommand;
import com.jaxfront.core.jep.SuperTypeNode;
import com.jaxfront.core.rule.MathEvaluator;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.StringUtil;
import java.util.List;
import java.util.Stack;
import org.nfunk.jep.ParseException;

public class ActAs
extends JaxfrontMathCommand {
    public ActAs() {
        this.numberOfParameters = -1;
    }

    public void run(MathEvaluator.MathCommunicator communicator, Stack stack) throws ParseException {
        this.checkStack(stack);
        Object xpath = null;
        Object value = null;
        Document dom = communicator.getDoc();
        switch (this.curNumberOfParameters) {
            case 1: {
                value = stack.pop();
                List propHolders = communicator.getTargetTypes();
                if (propHolders == null || propHolders.size() == 0) {
                    this.setActAs(communicator.getRootType(), value);
                } else {
                    this.setActAs(dom, propHolders, value);
                }
                stack.push(SuperTypeNode.isTrue);
                break;
            }
            case 2: {
                value = stack.pop();
                xpath = stack.pop();
                if (xpath instanceof Type) {
                    this.setActAs(xpath, value);
                } else if (xpath instanceof List) {
                    this.setActAs(dom, (List)xpath, (Object)value);
                } else if (xpath instanceof String) {
                    this.setActAs(dom, communicator.getDoc().getTypes(xpath), value);
                }
                stack.push(SuperTypeNode.isTrue);
            }
        }
    }

    private void setActAs(Type aType, Object value) {
        if (aType != null && value != null && aType.isSimple()) {
            if (value instanceof Number) {
                ((SimpleType)aType).actAs(null, ((Number)value).shortValue());
            } else {
                ((SimpleType)aType).actAs(null, StringUtil.getShort(value.toString(), (short)2));
            }
        }
    }

    private void setActAs(Document dom, String xpath, Object value) {
        if (value != null) {
            this.setActAs(dom, dom.getTypes(xpath), value);
        }
    }

    private void setActAs(Document dom, List propHolders, Object value) {
        if (value != null) {
            for (int p = 0; p < propHolders.size(); ++p) {
                if (propHolders.get(p) instanceof String) {
                    this.setActAs(dom, (String)propHolders.get(p), (Object)((String)value));
                    continue;
                }
                this.setActAs((Type)propHolders.get(p), value);
            }
        }
    }
}

