/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.error;

import com.jaxfront.core.error.AbstractError;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.ArrayUtil;
import com.jaxfront.core.util.GUIComponentNLS;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class ValidationError
extends AbstractError {
    private ValidationException _exception;

    public ValidationError(ValidationException ex, Type source) {
        super(source, source);
        this._exception = ex;
    }

    public String getMessageClassificationForIcon() {
        String messageClassification = this.getException().getClassification();
        if (messageClassification == null) {
            messageClassification = "warning";
        }
        return messageClassification;
    }

    public String getClassification() {
        if (this._classification == null) {
            this._classification = this.getException().getClassification();
            if (this._classification == null) {
                this._classification = "warning";
            }
        }
        return this._classification;
    }

    public boolean isCardinalityError() {
        return this.getException().isCardinalityException();
    }

    public ValidationException getException() {
        return this._exception;
    }

    public boolean isMandatoryError() {
        return this.getException().isMandatoryException();
    }

    public boolean isNeedingUserAcceptance() {
        return this._exception.isNeedingUserAcceptance();
    }

    public String getMessageText() {
        String errorMessage = this.getException().getMessage();
        if (this.isXSDError()) {
            errorMessage = this.convertParserMessage(errorMessage, (DatatypeException)this.getException().getCause());
        }
        return errorMessage;
    }

    public boolean isXSDError() {
        return this.getErrorHolder() != null && this.getErrorHolder().getStyle().getValidationErrorMessage() == null && this.getException().getCause() instanceof DatatypeException;
    }

    private String convertParserMessage(String defaultErrorMessage, DatatypeException cause) {
        String errorMessage = null;
        if (cause instanceof InvalidDatatypeValueException && this.getErrorHolder().isSimple() && (((SimpleType)this.getErrorHolder()).isNumber() || ((SimpleType)this.getErrorHolder()).isDate() || ((SimpleType)this.getErrorHolder()).isDateTime() || ((SimpleType)this.getErrorHolder()).isTime())) {
            String dataType = "number";
            if (((SimpleType)this.getErrorHolder()).isDate()) {
                dataType = "date";
            } else if (((SimpleType)this.getErrorHolder()).isDateTime()) {
                dataType = "dateTime";
            } else if (((SimpleType)this.getErrorHolder()).isTime()) {
                dataType = "time";
            }
            errorMessage = GUIComponentNLS.getInstance().getNLSText(this.getErrorHolder().getDOM(), "cvc-datatype-valid_" + dataType, defaultErrorMessage, ArrayUtil.toStringArray(cause.getArgs()));
        }
        if (errorMessage == null) {
            errorMessage = GUIComponentNLS.getInstance().getNLSText(this.getErrorHolder().getDOM(), cause.getKey(), defaultErrorMessage, ArrayUtil.toStringArray(cause.getArgs()));
        }
        return errorMessage;
    }

    public boolean isShowingDialog() {
        return this.getException().isShowingDialog();
    }

    public int getErrorType() {
        return 1;
    }

    public void release() {
        super.release();
        this._exception = null;
    }
}

