/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.dom;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import java.util.EventObject;

public class DOMChangeEvent
extends EventObject {
    private long stype;
    private int _movedFrom = -1;
    private int _movedTo = -1;
    private int _index = -1;
    private int _genericType = -1;
    private String _changedName;
    private String _oldValue;
    private String _newValue;
    private boolean _isTemporary;
    public static final String NULL_EVENT = "NULL_EVENT";
    private static DOMChangeEvent NULL_EVENT_IMPL = null;
    public static final long NONE = 0L;
    public static final long DOM_SAVED = 1L;
    public static final long DOM_REMOVE_NODE = 2L;
    public static final long DOM_IS_ABOUT_TO_SAVE = 4L;
    public static final long DOM_IS_ABOUT_TO_VALIDATE = 8L;
    public static final long DOM_VISUALIZER_INITIALIZED = 16L;
    public static final long DOM_SORTED = 32L;
    public static final long DOM_CANCELLED = 64L;
    public static final long DOM_TREE_CHANGED = 128L;
    public static final long DOM_CHANGE_NODE = 256L;
    public static final long DOM_MOVE_NODE = 512L;
    public static final long DOM_SWAP_NODE = 1024L;
    public static final long DOM_FINISHED_BINDING = 2048L;
    public static final long DOM_ADD_NODE = 4096L;
    public static final long DOM_PERSISTENT = 8192L;
    public static final long DOM_ABOUT_TO_PERSIST = 16384L;
    public static final long DOM_INITIALIZED = 32768L;
    public static final long DOM_LIST_ITEM_SELECT = 65536L;
    public static final long DOM_LIST_ITEM_DESELECT = 131072L;
    public static final long DOM_VISUALIZER_ONCREATE = 262144L;
    public static final long DOM_COPY_CONTENT = 524288L;
    public static final long DOM_PASTE_CONTENT = 0x100000L;
    public static final long DOM_DELETED = 0x200000L;
    public static final long DOM_FINGERPRINT_CHANGED = 0x400000L;
    public static final long DOM_GO_NEXT = 0x800000L;
    public static final long DOM_ABOUT_GO_NEXT = 0x1000000L;
    public static final long DOM_PAGE_SELECTED = 0x2000000L;
    public static final long DOM_ABOUT_REMOVE_NODE = 0x4000000L;
    public static final long DOM_COMMIT = 0x8000000L;
    public static final long DOM_GENERIC = 0x10000000L;
    public static final long DOM_GO_PREVIOUS = 0x20000000L;
    public static final long DOM_ABOUT_GO_PREVIOUS = 0x40000000L;
    public static final long DOM_IS_ABOUT_TO_SERIALIZE = Integer.MIN_VALUE;
    public static final long DOM_SERIALIZED = 0x100000000L;
    public static final long DOM_VALIDATED = 0x200000000L;
    private int[] _indexes;
    private String _genericName;

    private DOMChangeEvent(Object source) {
        super(source);
    }

    private DOMChangeEvent(Object source, int[] indexes) {
        super(source);
        this.stype = 32L;
        this._indexes = indexes;
    }

    private DOMChangeEvent(long type, Object source) {
        super(source);
        this.stype = type;
    }

    private DOMChangeEvent(long type, Object source, String changedName, String oldValue, String newValue) {
        super(source);
        this.stype = type;
        this._changedName = changedName;
        this._oldValue = oldValue;
        this._newValue = newValue;
    }

    private DOMChangeEvent(long type, Object source, int index) {
        super(source);
        this.stype = type;
        this._index = index;
    }

    private DOMChangeEvent(long type, Object source, String genericName, int genericType) {
        super(source);
        this.stype = type;
        this._genericName = genericName;
        this._genericType = genericType;
    }

    private DOMChangeEvent(long type, Object source, int movedFrom, int movedTo) {
        super(source);
        this.stype = type;
        this._movedFrom = movedFrom;
        this._movedTo = movedTo;
    }

    public static DOMChangeEvent DOM_ADD_NODE(Type newType) {
        return DOMChangeEvent.DOM_ADD_NODE(newType, -1);
    }

    public static DOMChangeEvent DOM_SORTED(ListType listType, int[] indexes) {
        return new DOMChangeEvent(listType, indexes);
    }

    public static DOMChangeEvent NULL_EVENT() {
        if (NULL_EVENT_IMPL == null) {
            NULL_EVENT_IMPL = new DOMChangeEvent(0L, NULL_EVENT);
        }
        return NULL_EVENT_IMPL;
    }

    public static DOMChangeEvent DOM_ADD_NODE(Type newType, int index) {
        return new DOMChangeEvent(4096L, newType, index);
    }

    public static DOMChangeEvent DOM_GENERIC(Object source, String changeName, int type) {
        return new DOMChangeEvent(0x10000000L, source, changeName, type);
    }

    public static DOMChangeEvent DOM_CANCELLED(Object source) {
        return new DOMChangeEvent(64L, source);
    }

    public static DOMChangeEvent DOM_COMMIT(Object source) {
        return new DOMChangeEvent(0x8000000L, source);
    }

    public static DOMChangeEvent DOM_GO_NEXT(Object source) {
        return new DOMChangeEvent(0x800000L, source);
    }

    public static DOMChangeEvent DOM_ABOUT_GO_NEXT(Object source) {
        return new DOMChangeEvent(0x1000000L, source);
    }

    public static DOMChangeEvent DOM_GO_PREVIOUS(Object source) {
        return new DOMChangeEvent(0x20000000L, source);
    }

    public static DOMChangeEvent DOM_ABOUT_GO_PREVIOUS(Object source) {
        return new DOMChangeEvent(0x40000000L, source);
    }

    public static DOMChangeEvent DOM_COPY_CONTENT(Object source) {
        return new DOMChangeEvent(524288L, source);
    }

    public static DOMChangeEvent DOM_PASTE_CONTENT(Object source) {
        return new DOMChangeEvent(0x100000L, source);
    }

    public static DOMChangeEvent DOM_CHANGE_NODE(Type type) {
        return new DOMChangeEvent(256L, type);
    }

    public static DOMChangeEvent DOM_INITIALIZED(Document dom) {
        return new DOMChangeEvent(32768L, dom.getRootType());
    }

    public static DOMChangeEvent DOM_ITEM_SELECTED(Type selectedType) {
        return new DOMChangeEvent(65536L, selectedType);
    }

    public static DOMChangeEvent DOM_ITEM_DESELECTED(Type deselectedType) {
        return new DOMChangeEvent(131072L, deselectedType);
    }

    public static DOMChangeEvent DOM_FINISHED_BINDING(Type type) {
        return new DOMChangeEvent(2048L, type);
    }

    public static DOMChangeEvent DOM_VISUALIZER_INITIALIZED(Object source) {
        return new DOMChangeEvent(16L, source);
    }

    public static DOMChangeEvent DOM_VISUALIZER_ONCREATE(Object source) {
        return new DOMChangeEvent(262144L, source);
    }

    public static DOMChangeEvent DOM_TREE_CHANGED(Object source) {
        return new DOMChangeEvent(128L, source);
    }

    public static DOMChangeEvent DOM_IS_ABOUT_TO_SAVE(Object source) {
        return new DOMChangeEvent(4L, source);
    }

    public static DOMChangeEvent DOM_IS_ABOUT_TO_SERIALIZE(Object source) {
        return new DOMChangeEvent(Integer.MIN_VALUE, source);
    }

    public static DOMChangeEvent DOM_SERIALIZED(Object source) {
        return new DOMChangeEvent(0x100000000L, source);
    }

    public static DOMChangeEvent DOM_IS_ABOUT_TO_VALIDATE(Object source) {
        return new DOMChangeEvent(8L, source);
    }

    public static DOMChangeEvent DOM_VALIDATED(Object source) {
        return new DOMChangeEvent(0x200000000L, source);
    }

    public static DOMChangeEvent DOM_REMOVE_NODE(Type type) {
        return DOMChangeEvent.DOM_REMOVE_NODE(type, -1);
    }

    public static DOMChangeEvent DOM_REMOVE_NODE(Type type, int index) {
        return new DOMChangeEvent(2L, type, index);
    }

    public static DOMChangeEvent DOM_ABOUT_REMOVE_NODE(Type type, int index) {
        return new DOMChangeEvent(0x4000000L, type, index);
    }

    public static DOMChangeEvent DOM_PAGE_SELECTED(Type type, int index) {
        return new DOMChangeEvent(0x2000000L, type, index);
    }

    public static DOMChangeEvent DOM_SAVED(Type source) {
        return new DOMChangeEvent(1L, source);
    }

    public static DOMChangeEvent DOM_SAVED(Document source) {
        return new DOMChangeEvent(1L, source.getRootType());
    }

    public static DOMChangeEvent DOM_PERSISTENT(Type source) {
        return new DOMChangeEvent(8192L, source);
    }

    public static DOMChangeEvent DOM_IS_ABOUT_TO_PERSIST(Type source) {
        return new DOMChangeEvent(16384L, source);
    }

    public static DOMChangeEvent DOM_PERSISTENT(Document source) {
        return new DOMChangeEvent(8192L, source.getRootType());
    }

    public static DOMChangeEvent DOM_DELETED(Document source) {
        return new DOMChangeEvent(0x200000L, source.getRootType());
    }

    public static DOMChangeEvent DOM_FINGERPRINT_CHANGED(Document source, String name, String oldValue, String newValue) {
        return new DOMChangeEvent(0x400000L, source.getRootType(), name, oldValue, newValue);
    }

    public static DOMChangeEvent DOM_SWAP_NODE(Object source, int movedFrom, int movedTo) {
        return new DOMChangeEvent(1024L, source, movedFrom, movedTo);
    }

    public int getIndex() {
        return this._index;
    }

    public int[] getIndexes() {
        return this._indexes;
    }

    public long getType() {
        return this.stype;
    }

    public long getGenericType() {
        return this._genericType;
    }

    public String getGenericName() {
        return this._genericName;
    }

    public boolean isAboutToSave() {
        return this.stype == 4L;
    }

    public boolean isAboutToRemoveNode() {
        return this.stype == 0x4000000L;
    }

    public boolean isFinishedBinding() {
        return this.stype == 2048L;
    }

    public boolean isFingerprintChanged() {
        return this.stype == 0x400000L;
    }

    public boolean isAboutToValidate() {
        return this.stype == 8L;
    }

    public boolean isAddingNode() {
        return this.stype == 4096L;
    }

    public boolean isCancelled() {
        return this.stype == 64L;
    }

    public boolean isCommit() {
        return this.stype == 0x8000000L;
    }

    public boolean isPersistent() {
        return this.stype == 8192L;
    }

    public boolean isDeleted() {
        return this.stype == 0x200000L;
    }

    public boolean isAboutToPersist() {
        return this.stype == 16384L;
    }

    public boolean isChangingNode() {
        return this.stype == 256L;
    }

    public boolean isGeneric() {
        return this.stype == 0x10000000L;
    }

    public boolean isInitialized() {
        return this.stype == 16L;
    }

    public boolean isOnCreate() {
        return this.stype == 262144L;
    }

    public boolean isGoNext() {
        return this.stype == 0x800000L;
    }

    public boolean isPageSelected() {
        return this.stype == 0x2000000L;
    }

    public boolean isAboutToGoNext() {
        return this.stype == 0x1000000L;
    }

    public boolean isGoPrevious() {
        return this.stype == 0x20000000L;
    }

    public boolean isAboutToGoPrevious() {
        return this.stype == 0x40000000L;
    }

    public boolean isCopyContent() {
        return this.stype == 524288L;
    }

    public boolean isPasteContent() {
        return this.stype == 0x100000L;
    }

    public boolean isMovingNode() {
        return this.stype == 512L;
    }

    public boolean isSorted() {
        return this.stype == 32L;
    }

    public boolean isListItemSelected() {
        return this.stype == 65536L;
    }

    public boolean isListItemDeselected() {
        return this.stype == 131072L;
    }

    public boolean isTreeChange() {
        return this.stype == 128L;
    }

    public boolean isRemovingNode() {
        return this.stype == 2L;
    }

    public boolean isSaved() {
        return this.stype == 1L;
    }

    public boolean isNullEvent() {
        return this.stype == 0L || this == NULL_EVENT_IMPL;
    }

    public boolean isSwappingNode() {
        return this.stype == 1024L;
    }

    public boolean isTemporary() {
        return this._isTemporary;
    }

    public void setIsTemporary(boolean temporary) {
        this._isTemporary = temporary;
    }

    public int getMovedFromIndex() {
        return this._movedFrom;
    }

    public int getMovedToIndex() {
        return this._movedTo;
    }

    public String getOldValue() {
        return this._oldValue;
    }

    public String getChangeName() {
        return this._changedName;
    }

    public String getNewValue() {
        return this._newValue;
    }

    public String toString() {
        String source = "null";
        if (this.getSource() instanceof Type) {
            source = ((Type)this.getSource()).getXPathLocation();
        } else if (this.getSource() instanceof Document) {
            source = "document: " + ((Document)this.getSource()).getRootType().getXPathLocation();
        }
        return this.getClass() + " [eventMask=" + this.getType() + ", source=" + source + "]";
    }

    public boolean isForceEvent() {
        return this.isAboutToPersist() || this.isAboutToSave() || this.isAboutToValidate() || this.isPersistent() || this.isSaved();
    }
}

