/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.clipboard;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.IntroSpectionHelper;
import com.jaxfront.core.util.StringUtil;
import com.jaxfront.core.util.URLHelper;
import java.io.Externalizable;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringReader;
import java.net.URL;
import org.w3c.dom.Document;

public class CopyTypeWrapper
implements Externalizable {
    private Class _clonedClass = null;
    private String _qName = null;
    private String _schemaTypeQName = null;
    private String _schemaName = null;
    private String _schemaRefName = null;
    private String _xpathLocation = null;
    private String _serializedTypeContent;
    private String _userObjectXPathLocation;
    private String _nlsSourceXPathLocation;
    private boolean _isListType;
    private boolean _isChoiceType;
    private boolean _isAdd;
    private boolean _stringOnlyMode;

    public CopyTypeWrapper() {
    }

    public CopyTypeWrapper(Type cloneType, String xml) {
        this._clonedClass = cloneType.getClass();
        this._qName = cloneType.getName();
        this._schemaTypeQName = cloneType.getSchemaElement().getSchemaType().getQName();
        this._schemaRefName = cloneType.getSchemaElement().getRefName();
        this._xpathLocation = cloneType.getXPathLocation();
        this._userObjectXPathLocation = cloneType.getXPathLocation();
        Type compParent = cloneType.getParent("component");
        if (compParent != null) {
            this._nlsSourceXPathLocation = compParent.getDirectChildValue("xpath");
        }
        if (xml != null) {
            this.setIsAdd(true);
        }
        this._serializedTypeContent = xml == null ? cloneType.serialize(true).toString() : xml;
        this._isListType = cloneType.isList();
        this._isChoiceType = cloneType.isChoice();
        URL xsdURL = cloneType.getDOM().getFingerPrint().getXSDURL();
        if (xsdURL != null && xsdURL.toExternalForm().toUpperCase().startsWith("FILE:")) {
            this._schemaName = URLHelper.getFileName(xsdURL);
        }
    }

    public CopyTypeWrapper(String content) throws Exception {
        String line = null;
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        try {
            this._clonedClass = Class.forName(CopyTypeWrapper.getValue(reader.readLine()));
            this._qName = CopyTypeWrapper.getValue(reader.readLine());
            this._schemaTypeQName = CopyTypeWrapper.getValue(reader.readLine());
            this._schemaRefName = CopyTypeWrapper.getValue(reader.readLine());
            this._xpathLocation = CopyTypeWrapper.getValue(reader.readLine());
            this._userObjectXPathLocation = CopyTypeWrapper.getValue(reader.readLine());
            this._nlsSourceXPathLocation = CopyTypeWrapper.getValue(reader.readLine());
            this._isListType = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
            this._isChoiceType = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
            this._isAdd = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
            String xmlContent = reader.readLine();
            if (xmlContent != null) {
                StringBuffer xml = new StringBuffer(CopyTypeWrapper.getValue(xmlContent));
                while ((line = reader.readLine()) != null) {
                    xml.append(line);
                    xml.append(StringUtil.newLine);
                }
                this._serializedTypeContent = xml.toString();
            }
        }
        catch (Exception e) {
            try {
                Document doc = DOMHelper.createDocument(content, null);
                this._serializedTypeContent = content;
                this._qName = doc.getDocumentElement().getLocalName();
                this._stringOnlyMode = true;
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
    }

    public String getXpathLocation() {
        return this._xpathLocation;
    }

    public String getXPathLocation() {
        return this._xpathLocation;
    }

    public Object getClonedClass() {
        return this._clonedClass;
    }

    public Object getSchemaTypeQName() {
        return this._schemaTypeQName;
    }

    public Object getSchemaRefName() {
        return this._schemaRefName;
    }

    public Object getQName() {
        return this._qName;
    }

    public boolean isStringOnlyMode() {
        return this._stringOnlyMode;
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public String getUserObjectXPathLocation() {
        return this._userObjectXPathLocation;
    }

    public String getNLSSourceXPathLocation() {
        return this._nlsSourceXPathLocation;
    }

    public String getSerializedTypeContent() {
        return this._serializedTypeContent;
    }

    public boolean isListType() {
        return this._isListType;
    }

    public boolean isChoiceType() {
        return this._isChoiceType;
    }

    public boolean isAdding() {
        return this.isAdd();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String line = null;
        String content = new String(IntroSpectionHelper.read(in));
        LineNumberReader reader = new LineNumberReader(new StringReader(content));
        this._clonedClass = Class.forName(CopyTypeWrapper.getValue(reader.readLine()));
        this._qName = CopyTypeWrapper.getValue(reader.readLine());
        this._schemaTypeQName = CopyTypeWrapper.getValue(reader.readLine());
        this._schemaRefName = CopyTypeWrapper.getValue(reader.readLine());
        this._xpathLocation = CopyTypeWrapper.getValue(reader.readLine());
        this._userObjectXPathLocation = CopyTypeWrapper.getValue(reader.readLine());
        this._nlsSourceXPathLocation = CopyTypeWrapper.getValue(reader.readLine());
        this._isListType = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
        this._isChoiceType = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
        this._isAdd = Boolean.valueOf(CopyTypeWrapper.getValue(reader.readLine()));
        StringBuffer xml = new StringBuffer(CopyTypeWrapper.getValue(reader.readLine()));
        while ((line = reader.readLine()) != null) {
            xml.append(line);
        }
        this._serializedTypeContent = xml.toString();
    }

    private static String getValue(String line) {
        if (line == null) {
            return null;
        }
        String value = line.substring(line.indexOf("=") + 1);
        return value.trim();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBytes(this.toString());
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("clonedClass=" + (this._clonedClass != null ? this._clonedClass.getName() : "null") + StringUtil.newLine);
        out.append("qName=" + this._qName + StringUtil.newLine);
        out.append("schemaTypeQName=" + this._schemaTypeQName + StringUtil.newLine);
        out.append("schemaRefName=" + this._schemaRefName + StringUtil.newLine);
        out.append("xpathLocation=" + this._xpathLocation + StringUtil.newLine);
        out.append("userObjectXPathLocation=" + this._userObjectXPathLocation + StringUtil.newLine);
        out.append("nlsSourceXPathLocation=" + this._nlsSourceXPathLocation + StringUtil.newLine);
        out.append("isListType=" + this._isListType + StringUtil.newLine);
        out.append("isChoiceType=" + this._isChoiceType + StringUtil.newLine);
        out.append("isAdd=" + this._isAdd + StringUtil.newLine);
        out.append("xml=" + this._serializedTypeContent + StringUtil.newLine);
        return out.toString();
    }

    public void setIsAdd(boolean _isAdd) {
        this._isAdd = _isAdd;
    }

    public boolean isAdd() {
        return this._isAdd;
    }
}

