/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.core.access;

import com.jaxfront.core.access.IUser;
import com.jaxfront.core.access.modifier.UIPersistencySearchSerialModifier;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.SerializationModifier;
import com.jaxfront.core.schema.ValidationException;

public class UIPersistencyHelper {
    public static final SerializationModifier _searchModifier = new UIPersistencySearchSerialModifier(new String[]{"pageSize", "sortOrder", "showAsColumn", "value", "columnSequence", "id", "helper"}, new String[]{"rowActions", "pageActions", "formatter", "vars"});

    public static String getSplitterPos(IUser user, String key) {
        String pos = "230";
        String uiPersistency = user.getUiPersistencyEntryString("WORKBENCH", "NAVIGATION", null, key);
        if (uiPersistency != null && !"-1".equals(uiPersistency)) {
            pos = uiPersistency;
        }
        return pos;
    }

    public static boolean getSplitterInitClosed(IUser user, String key, boolean defaultSetting) {
        boolean isClosed = defaultSetting;
        String uiSetting = user.getUiPersistencyEntryString("WORKBENCH", "NAVIGATION", null, key);
        if (uiSetting != null) {
            isClosed = "-1".equals(uiSetting);
        }
        return isClosed;
    }

    public static void persistGUISettings(Document document, String target, boolean isSearch) {
        try {
            String content = null;
            if (isSearch) {
                DOMHelper.forceSerializationWholeTree(document.getType("/XMLDBMapping/searchPanel/mainPanel/helper[list]"), false, true);
                DOMHelper.forceSerializationWholeTree(document.getType("/XMLDBMapping/helperFields"), false, true);
                content = UIPersistencyHelper.serializeDOM(document, _searchModifier);
            } else {
                content = UIPersistencyHelper.serializeDOM(document, null);
            }
            document.getUser().putUiPersistency("WORKBENCH", null, target, "LAST_XML", content, null);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    public static void persistGUISettings(Document document, String category, String context, String target, String key, String content) {
        try {
            document.getUser().putUiPersistency(category, context, target, key, content, null);
        }
        catch (Exception e) {
            e.toString();
        }
    }

    public static String serializeDOM(Document document, SerializationModifier modifier) throws ValidationException {
        SerializationModifier oldMod = document.getSerializationModifier();
        document.setSerializationModifier(modifier);
        String content = document.serializeInternal(false, true).toString();
        document.setSerializationModifier(oldMod);
        return content;
    }
}

