/*
 * Decompiled with CFR 0.152.
 */
package net.java.swingfx.waitwithstyle.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.java.swingfx.waitwithstyle.CancelableAdaptee;
import net.java.swingfx.waitwithstyle.CancelableProgressPanel;
import net.java.swingfx.waitwithstyle.PerformanceCancelableProgressPanel;

public class Main {
    private static final Dimension SIZE = new Dimension(600, 600);

    public static void main(String[] args) {
        MyPanel panel = new MyPanel();
        JFrame f = new JFrame("Cancelable Progress Demo");
        f.setDefaultCloseOperation(3);
        f.setSize(SIZE);
        Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = scrSize.width / 2 - Main.SIZE.width / 2;
        int y = scrSize.height / 2 - Main.SIZE.height / 2;
        f.setLocation(x, y);
        f.getContentPane().add(panel);
        f.getRootPane().setDefaultButton(panel.getGoButton());
        f.setVisible(true);
    }

    private static class MyPanel
    extends JPanel
    implements ActionListener {
        private JCheckBox useFastGraphicsCheckBox = new JCheckBox("Best Performance");
        private JTextField urlTextField;
        private JButton goButton;
        private JEditorPane htmlPane;
        private JTextField delayTextField;

        public MyPanel() {
            super(new BorderLayout());
            this.useFastGraphicsCheckBox.setToolTipText("When selected the PerformanceInfiniteProgressPanel is used instead of InfiniteProgressPanel.  It's not perfect yet - mousing over cancel draws two cancel buttons.");
            this.urlTextField = new JTextField("http://www.google.com/              ");
            this.goButton = new JButton("Go");
            this.goButton.addActionListener(this);
            this.htmlPane = new JEditorPane();
            this.htmlPane.setEditable(false);
            this.delayTextField = new JTextField("10000");
            this.delayTextField.setToolTipText("Set how long a delay is made before the page is loaded.  (Note: Unfortunately, actual page loading is on the EDT)");
            ((AbstractDocument)this.delayTextField.getDocument()).setDocumentFilter(new DocumentFilter(){

                @Override
                public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                    if (string != null && string.length() > 0) {
                        try {
                            Integer.parseInt(string);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                    }
                    super.insertString(fb, offset, string, attr);
                }
            });
            JPanel topPanel = new JPanel();
            topPanel.add(this.goButton);
            topPanel.add(this.urlTextField);
            JPanel bottomPanel = new JPanel();
            bottomPanel.add(this.useFastGraphicsCheckBox);
            bottomPanel.add(new JLabel("Total Delay:"));
            bottomPanel.add(this.delayTextField);
            this.add((Component)topPanel, "North");
            this.add((Component)new JScrollPane(this.htmlPane), "Center");
            this.add((Component)bottomPanel, "South");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String sym = this.urlTextField.getText();
            JComponent veil = null;
            if (this.useFastGraphicsCheckBox.isSelected()) {
                veil = new PerformanceCancelableProgressPanel();
                veil.setText("Starting Lookup of " + sym);
            } else {
                veil = new CancelableProgressPanel("Starting Lookup of " + this.urlTextField.getText());
            }
            JRootPane rootPane = this.getRootPane();
            Component oldGlassPane = rootPane.getGlassPane();
            LookupWorkerRunnable runnable = new LookupWorkerRunnable(sym, (CancelableAdaptee)((Object)veil), rootPane, oldGlassPane);
            rootPane.setGlassPane(veil.getComponent());
            rootPane.revalidate();
            JComponent veil1 = veil;
            SwingUtilities.invokeLater(new Runnable((CancelableAdaptee)((Object)veil1)){
                private final /* synthetic */ CancelableAdaptee val$veil1;
                {
                    this.val$veil1 = cancelableAdaptee;
                }

                @Override
                public void run() {
                    this.val$veil1.start();
                }
            });
            veil.setText("Waking up the page loader...");
            Thread backgroundWorker = new Thread(runnable);
            backgroundWorker.start();
        }

        public JButton getGoButton() {
            return this.goButton;
        }

        class LookupWorkerRunnable
        implements Runnable,
        ActionListener {
            private String request;
            private CancelableAdaptee veil;
            private JRootPane rootPane;
            private Component oldGlassPane;
            private boolean canceled;
            private boolean beyondCancelation;

            LookupWorkerRunnable(String request, CancelableAdaptee veil, JRootPane rootPane, Component oldGlassPane) {
                this.request = request;
                this.veil = veil;
                this.rootPane = rootPane;
                this.oldGlassPane = oldGlassPane;
                veil.addCancelListener(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(Integer.parseInt(MyPanel.this.delayTextField.getText()) / 4);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LookupWorkerRunnable.this.veil.setText("Yawn! Are you sure you want to load " + LookupWorkerRunnable.this.request.trim() + "?");
                        }
                    });
                    Thread.sleep(Integer.parseInt(MyPanel.this.delayTextField.getText()) / 4);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LookupWorkerRunnable.this.veil.setText("Alright, alright, I'll do it in a bit!");
                        }
                    });
                    Thread.sleep(Integer.parseInt(MyPanel.this.delayTextField.getText()) / 4);
                    LookupWorkerRunnable lookupWorkerRunnable = this;
                    synchronized (lookupWorkerRunnable) {
                        if (!this.canceled) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        LookupWorkerRunnable.this.tearDown();
                                        MyPanel.this.htmlPane.setPage(LookupWorkerRunnable.this.request);
                                    }
                                    catch (IOException e) {
                                        LookupWorkerRunnable.this.showException(e);
                                    }
                                }
                            });
                            this.beyondCancelation = true;
                        }
                    }
                }
                catch (Throwable t) {
                    this.tearDown();
                    this.showException(t);
                }
            }

            private void showException(Throwable t) {
                JOptionPane.showMessageDialog(this.rootPane, "Exception:" + t);
            }

            private void tearDown() {
                this.veil.stop();
                this.rootPane.setGlassPane(this.oldGlassPane);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                LookupWorkerRunnable lookupWorkerRunnable = this;
                synchronized (lookupWorkerRunnable) {
                    if (!this.beyondCancelation) {
                        this.canceled = true;
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                JOptionPane.showMessageDialog(LookupWorkerRunnable.this.rootPane, "Sorry, you were just a bit late in cancelling the page, fetching the page already.");
                            }
                        });
                    }
                }
                this.tearDown();
            }
        }
    }
}

