/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;

public class Simplify {
    public static <PropT> Graph<PropT> simplify(Graph<PropT> g) {
        boolean simplified;
        do {
            simplified = false;
            for (Node<PropT> n0 : g.getNodes()) {
                for (Node<PropT> n1 : g.getNodes()) {
                    if (n1.getId() <= n0.getId() || n1.getBooleanAttribute("accepting") != n0.getBooleanAttribute("accepting") || !Simplify.equivalentCheck(n0, n1) || !Simplify.equivalentCheck(n1, n0)) continue;
                    for (Edge<PropT> e : n1.getIncomingEdges()) {
                        new Edge<PropT>(e.getSource(), n0, e.getGuard(), e.getAction(), e.getAttributes());
                    }
                    n1.remove();
                    simplified = true;
                }
            }
        } while (simplified);
        return g;
    }

    private static <PropT> boolean equivalentCheck(Node<PropT> n0, Node<PropT> n1) {
        boolean equivalent = true;
        block0: for (Edge<PropT> e0 : n0.getOutgoingEdges()) {
            if (!equivalent) {
                return false;
            }
            equivalent = false;
            for (Edge<PropT> e1 : n1.getOutgoingEdges()) {
                if (e0.getNext() != e1.getNext() && (e0.getNext() != n0 && e0.getNext() != n1 || e1.getNext() != n0 && e1.getNext() != n1) || !e0.getGuard().equals(e1.getGuard()) || !e0.getAction().equals(e1.getAction())) continue;
                equivalent = true;
                continue block0;
            }
        }
        return equivalent;
    }
}

