/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.xjlib.appkit.swing;

import java.awt.Frame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.antlr.xjlib.foundation.XJSystem;

public class XJLookAndFeel {
    public static String applyLookAndFeel(String name) {
        Frame[] frame;
        String className = XJLookAndFeel.getLookAndFeelClassName(name);
        if (className == null) {
            System.err.println("No LAF class name for name '" + name + "', using default LAF.");
            className = XJLookAndFeel.getLookAndFeelClassName(null);
        }
        try {
            UIManager.setLookAndFeel(className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Frame aFrame : frame = Frame.getFrames()) {
            SwingUtilities.updateComponentTreeUI(aFrame);
            aFrame.pack();
        }
        return XJLookAndFeel.getLookAndFeelName(className);
    }

    public static String getLookAndFeelClassName(String name) {
        UIManager.LookAndFeelInfo[] info;
        if (name == null) {
            if (XJSystem.isLinux()) {
                return UIManager.getCrossPlatformLookAndFeelClassName();
            }
            return UIManager.getSystemLookAndFeelClassName();
        }
        for (UIManager.LookAndFeelInfo anInfo : info = UIManager.getInstalledLookAndFeels()) {
            if (!anInfo.getName().equalsIgnoreCase(name)) continue;
            return anInfo.getClassName();
        }
        return null;
    }

    public static String getLookAndFeelName(String className) {
        UIManager.LookAndFeelInfo[] info;
        for (UIManager.LookAndFeelInfo anInfo : info = UIManager.getInstalledLookAndFeels()) {
            if (!anInfo.getClassName().equalsIgnoreCase(className)) continue;
            return anInfo.getName();
        }
        return null;
    }

    public static String getDefaultLookAndFeelName() {
        UIManager.LookAndFeelInfo[] info;
        String name = UIManager.getSystemLookAndFeelClassName();
        for (UIManager.LookAndFeelInfo anInfo : info = UIManager.getInstalledLookAndFeels()) {
            if (!anInfo.getClassName().equalsIgnoreCase(name)) continue;
            return anInfo.getName();
        }
        return name;
    }
}

