/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization.graphics.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.antlr.works.components.GrammarWindow;
import org.antlr.works.grammar.element.ElementRule;
import org.antlr.works.menu.ContextualMenuFactory;
import org.antlr.works.stats.StatisticsAW;
import org.antlr.works.utils.IconManager;
import org.antlr.works.utils.Toolbar;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.graph.GGraphAbstract;
import org.antlr.works.visualization.graphics.graph.GGraphGroup;
import org.antlr.works.visualization.graphics.panel.GView;
import org.antlr.works.visualization.skin.nfa.NFASkin;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.appkit.swing.XJRollOverButton;
import org.antlr.xjlib.appkit.swing.XJRollOverButtonToggle;
import org.antlr.xjlib.foundation.notification.XJNotificationCenter;
import org.antlr.xjlib.foundation.notification.XJNotificationObserver;

public class GPanel
implements XJNotificationObserver {
    protected Container container;
    protected Box pathButtonSelectionBox;
    protected Toolbar controlPanel;
    protected JTextField errorLabel;
    protected GContext context;
    protected GView view;
    protected JScrollPane viewScrollPane;
    protected ElementRule rule;
    protected GrammarWindow editor;

    public GPanel(GrammarWindow editor, GContext context) {
        this.editor = editor;
        this.context = context;
        this.container = new JPanel(new BorderLayout());
        this.createNormalPanel();
        XJNotificationCenter.defaultCenter().addObserver(this, "NOTIF_CURRENT_PATH_DID_CHANGE");
    }

    public void close() {
        this.editor = null;
        this.context = null;
        XJNotificationCenter.defaultCenter().removeObserver(this);
    }

    public void setGraphs(List graphs) {
        this.view.setGraphs(graphs);
        this.view.refresh();
        this.updateCurrentAlternative();
    }

    public void setRule(ElementRule rule) {
        if (this.view != null) {
            this.view.setEnable(false);
        }
        this.rule = rule;
        this.createPanel();
        this.view.setEnable(true);
    }

    public void setPlaceholder(String placeholder) {
        this.view.setPlaceholder(placeholder);
    }

    public void update() {
        this.updateCurrentError();
    }

    public Container getContainer() {
        return this.container;
    }

    public GGraphAbstract getCurrentGraph() {
        return this.view.getCurrentGraph();
    }

    public BufferedImage getImageOfView() {
        return this.view.getImage();
    }

    public void createPanel() {
        if (this.rule == null) {
            return;
        }
        if (this.rule.hasErrors()) {
            this.createErrorPanel();
        } else {
            this.createNormalPanel();
        }
    }

    private void createNormalPanel() {
        this.container.removeAll();
        this.container.add((Component)this.createVisualizationPane(), "Center");
        this.container.add((Component)this.createControlPane(), "South");
        this.container.validate();
    }

    private void createErrorPanel() {
        this.container.removeAll();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createErrorPane(), "North");
        panel.add((Component)this.createVisualizationPane(), "Center");
        this.container.add((Component)panel, "Center");
        this.container.add((Component)this.createControlPane(), "South");
        this.container.validate();
    }

    private Container createVisualizationPane() {
        this.view = new CustomGView(this, this.context);
        this.viewScrollPane = new JScrollPane(this.view);
        this.viewScrollPane.setWheelScrollingEnabled(true);
        return this.viewScrollPane;
    }

    private Container createErrorPane() {
        this.controlPanel = Toolbar.createHorizontalToolbar();
        if (this.rule.errors.size() > 1) {
            this.controlPanel.addElement(this.createPrevErrorButton());
            this.controlPanel.addElement(this.createNextErrorButton());
            this.controlPanel.addGroupSeparator();
        }
        this.controlPanel.addElement(new JLabel(IconManager.shared().getIconWarning()));
        this.errorLabel = new JTextField();
        this.controlPanel.addElement(this.errorLabel);
        this.errorLabel.setBorder(null);
        this.errorLabel.setEditable(false);
        this.errorLabel.setBackground(this.getContainer().getBackground());
        this.controlPanel.add(Box.createHorizontalGlue());
        this.pathButtonSelectionBox = new Box(0);
        this.controlPanel.addElement(this.pathButtonSelectionBox);
        this.controlPanel.addGroupSeparator();
        this.controlPanel.addElement(this.createShowCrossLinksButton());
        return this.controlPanel;
    }

    private JButton createPrevErrorButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconBackward());
        button.setFocusable(false);
        button.setToolTipText("Show Previous Error");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (GPanel.this.view.setPrevGraph()) {
                    GPanel.this.view.refresh();
                    GPanel.this.createPathSelectionButtons();
                    GPanel.this.updateCurrentError();
                }
            }
        });
        return button;
    }

    private JButton createNextErrorButton() {
        XJRollOverButton button = XJRollOverButton.createMediumButton(IconManager.shared().getIconForward());
        button.setFocusable(false);
        button.setToolTipText("Show Next Error");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                if (GPanel.this.view.setNextGraph()) {
                    GPanel.this.view.refresh();
                    GPanel.this.createPathSelectionButtons();
                    GPanel.this.updateCurrentError();
                }
            }
        });
        return button;
    }

    private void updateCurrentAlternative() {
        if (this.view.getCurrentGraph() instanceof GGraphGroup && this.pathButtonSelectionBox != null && this.pathButtonSelectionBox.getComponentCount() == 0) {
            this.createPathSelectionButtons();
        }
    }

    private void updateCurrentError() {
        if (this.rule == null || !this.rule.hasErrors()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int count = this.view.getGraphs().size();
        int index = this.view.getCurrentGraphIndex();
        if (count > 1) {
            sb.append("(");
            sb.append(index + 1);
            sb.append("/");
            sb.append(count);
            sb.append(") ");
        }
        sb.append(this.rule.getErrorMessageString(index));
        this.errorLabel.setText(sb.toString());
        this.controlPanel.revalidate();
    }

    private void createPathSelectionButtons() {
        this.pathButtonSelectionBox.removeAll();
        if (!(this.view.getCurrentGraph() instanceof GGraphGroup)) {
            return;
        }
        GGraphGroup gg = (GGraphGroup)this.view.getCurrentGraph();
        int count = gg.getPathGroup().getNumberOfPaths();
        if (count <= 1) {
            this.pathButtonSelectionBox.add(new JLabel("Alternative:"));
        } else {
            this.pathButtonSelectionBox.add(new JLabel("Alternatives:"));
        }
        for (int i = 0; i < count; ++i) {
            this.pathButtonSelectionBox.add(this.createPathSelectionButton(i));
        }
    }

    private JCheckBox createPathSelectionButton(int pathIndex) {
        JCheckBox button = new JCheckBox(String.valueOf(pathIndex + 1));
        button.setName(String.valueOf(pathIndex));
        button.setFocusable(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JCheckBox button = (JCheckBox)event.getSource();
                GGraphGroup gg = (GGraphGroup)GPanel.this.view.getCurrentGraph();
                gg.getPathGroup().setPathVisible(Integer.parseInt(button.getName()), button.isSelected());
                gg.getPathGroup().makeSureCurrentPathIsVisible();
                GPanel.this.view.cacheRerender();
                GPanel.this.view.repaint();
            }
        });
        GGraphGroup gg = (GGraphGroup)this.view.getCurrentGraph();
        button.setSelected(gg.getPathGroup().isPathVisible(pathIndex));
        return button;
    }

    private JToggleButton createShowCrossLinksButton() {
        XJRollOverButtonToggle button = XJRollOverButtonToggle.createMediumButton(IconManager.shared().getIconShowLinks());
        button.setSelected(true);
        button.setFocusable(false);
        button.setToolTipText("Show links between rules");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                for (Object o : GPanel.this.view.getGraphs()) {
                    GGraphGroup gg = (GGraphGroup)o;
                    gg.getPathGroup().toggleShowRuleLinks();
                }
                GPanel.this.view.cacheRerender();
                GPanel.this.view.repaint();
            }
        });
        return button;
    }

    private Container createControlPane() {
        Toolbar box = Toolbar.createHorizontalToolbar();
        box.addElement(new JLabel("Zoom"));
        box.addElement(this.createFactorSlider());
        box.addElement(new JLabel("Show:"));
        box.addElement(this.createShowNFAButton());
        box.addElement(this.createShowRuleNameButton());
        return box;
    }

    private JSlider createFactorSlider() {
        JSlider slider = new JSlider();
        slider.setFocusable(false);
        slider.setMinimum(1);
        slider.setMaximum(800);
        slider.setValue((int)(this.context.getFactor() * 40.0f));
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent event) {
                JSlider slider = (JSlider)event.getSource();
                GPanel.this.context.setFactor((float)slider.getValue() / 40.0f);
                GPanel.this.view.refreshSizeChanged(slider.getValueIsAdjusting());
            }
        });
        return slider;
    }

    private JCheckBox createShowNFAButton() {
        JCheckBox button = new JCheckBox("NFA");
        button.setFocusable(false);
        button.setSelected(this.context.skin instanceof NFASkin);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                StatisticsAW.shared().recordEvent(135);
                JCheckBox button = (JCheckBox)event.getSource();
                if (button.isSelected()) {
                    GPanel.this.context.setSkin(new NFASkin());
                } else {
                    GPanel.this.context.setSkin(new SDSkin());
                }
                GPanel.this.view.refresh();
            }
        });
        return button;
    }

    private JCheckBox createShowRuleNameButton() {
        final JCheckBox button = new JCheckBox("Rule Name");
        button.setFocusable(false);
        button.setSelected(this.context.isShowRuleName());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                GPanel.this.context.setShowRuleName(button.isSelected());
                GPanel.this.view.refresh();
            }
        });
        return button;
    }

    public void notificationFire(Object source, String name) {
        if (name.equals("NOTIF_CURRENT_PATH_DID_CHANGE")) {
            this.updateCurrentAlternative();
        }
    }

    protected class CustomGView
    extends GView {
        public CustomGView(GPanel panel, GContext context) {
            super(panel, context);
        }

        public JPopupMenu getContextualMenu() {
            ContextualMenuFactory factory = GPanel.this.editor.createContextualMenuFactory();
            factory.addItem(111);
            factory.addItem(110);
            return factory.menu;
        }
    }
}

