/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.visualization;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.antlr.works.ate.syntax.misc.ATEToken;
import org.antlr.works.grammar.engine.GrammarEngine;
import org.antlr.works.grammar.syntax.GrammarSyntaxEngine;
import org.antlr.works.prefs.AWPrefs;
import org.antlr.works.visualization.graphics.GContext;
import org.antlr.works.visualization.graphics.GContextProvider;
import org.antlr.works.visualization.graphics.GEngineGraphics;
import org.antlr.works.visualization.graphics.GEnginePS;
import org.antlr.works.visualization.graphics.GFactory;
import org.antlr.works.visualization.graphics.graph.GGraph;
import org.antlr.works.visualization.serializable.SEncoder;
import org.antlr.works.visualization.skin.syntaxdiagram.SDSkin;
import org.antlr.xjlib.foundation.XJUtils;

public class SDGenerator
implements GContextProvider {
    public GrammarEngine engine;
    public GContext context;

    public SDGenerator(GrammarEngine engine) {
        this.engine = engine;
        this.context = new GContext();
        this.context.setSkin(new SDSkin());
        this.context.setProvider(this);
    }

    public void serializeRule(String name, SEncoder encoder) throws Exception {
        GGraph graph = this.createGraph(name);
        encoder.write(graph);
    }

    public void renderRuleToEPSFile(String ruleName, String file) throws Exception {
        GGraph graph = this.createGraph(ruleName);
        GEnginePS engine = new GEnginePS();
        this.context.setEngine(engine);
        graph.draw();
        XJUtils.writeStringToFile(engine.getPSText(), file);
    }

    public void renderRuleToBitmapFile(String ruleName, String imageFormat, String file) throws Exception {
        GGraph graph = this.createGraph(ruleName);
        int width = (int)(graph.getWidth() + 1.0f);
        int height = (int)(graph.getHeight() + 1.0f);
        BufferedImage image = new BufferedImage(width, height, 5);
        Graphics2D g2d = (Graphics2D)image.getGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.context.setEngine(new GEngineGraphics());
        this.context.setGraphics2D(g2d);
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        graph.draw();
        g2d.dispose();
        ImageIO.write((RenderedImage)image, imageFormat, new File(file));
    }

    private GGraph createGraph(String ruleName) throws Exception {
        GGraph graph = new GFactory().buildGraphsForRule(this.engine.getANTLRGrammarEngine(), ruleName);
        graph.setContext(this.context);
        graph.render(0.0f, 0.0f);
        return graph;
    }

    public Color contextGetColorForLabel(String label) {
        if (label.charAt(0) == '\'' || label.charAt(0) == '\"') {
            return AWPrefs.getSyntaxColor("PREF_SYNTAX_STRING");
        }
        if (ATEToken.isLexerName(label)) {
            return GrammarSyntaxEngine.COLOR_LEXER;
        }
        return GrammarSyntaxEngine.COLOR_PARSER;
    }
}

