/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.utils;

import java.awt.Component;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.JComboBox;
import org.antlr.xjlib.foundation.XJSystem;

public class Utils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String stringFromFile(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            int x = fis.available();
            if (x > 0) {
                byte[] b = new byte[x];
                for (int c = 0; c < x; c += fis.read(b, c, x - c)) {
                }
                String string = new String(b);
                return string;
            }
            String string = "";
            return string;
        }
        finally {
            fis.close();
        }
    }

    public static String toString(String[] object) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < object.length; ++i) {
            sb.append(object[i]);
            if (i >= object.length - 1) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String trimString(String s) {
        int b;
        int a;
        for (a = 0; a < s.length() && s.charAt(a) == ' ' || s.charAt(a) == '\n' || s.charAt(a) == '\t'; ++a) {
        }
        for (b = s.length() - 1; b > 0 && s.charAt(b) == ' ' || s.charAt(b) == '\n' || s.charAt(b) == '\t'; --b) {
        }
        if (a == s.length() || b == 0) {
            return "";
        }
        return s.substring(a, b + 1);
    }

    public static boolean isComponentChildOf(Component child, Component parent) {
        if (child == null) {
            return false;
        }
        if (child == parent) {
            return true;
        }
        return Utils.isComponentChildOf(child.getParent(), parent);
    }

    public static String quotePath(String path) {
        if (path == null || path.length() == 0 || XJSystem.isMacOS()) {
            return path;
        }
        if ((path = Utils.unquotePath(path)).indexOf(32) != -1) {
            path = "\"" + path + "\"";
        }
        return path;
    }

    public static String unquotePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        if (path.charAt(0) == '\"') {
            path = path.substring(1);
        }
        if (path.charAt(path.length() - 1) == '\"') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static void fillComboWithEOL(JComboBox combo) {
        combo.removeAllItems();
        combo.addItem("Unix (LF)");
        combo.addItem("Mac (CR)");
        combo.addItem("Windows (CRLF)");
    }

    public static String convertRawTextWithEOL(String rawText, JComboBox eolCombo) {
        return rawText.replaceAll("\n", Utils.getEOL(eolCombo));
    }

    private static String getEOL(JComboBox eolCombo) {
        switch (eolCombo.getSelectedIndex()) {
            case 0: {
                return "\n";
            }
            case 1: {
                return "\r";
            }
            case 2: {
                return "\r\n";
            }
        }
        return "\n";
    }

    public static String[] concat(String[] a, String[] b) {
        String[] n = new String[a.length + b.length];
        System.arraycopy(a, 0, n, 0, a.length);
        System.arraycopy(b, 0, n, a.length, b.length);
        return n;
    }
}

