/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.dialog;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import org.antlr.Tool;
import org.antlr.works.utils.IconManager;
import org.antlr.xjlib.appkit.app.XJApplication;
import org.antlr.xjlib.appkit.frame.XJPanel;

public class DialogAbout
extends XJPanel {
    public InfoTableModel tableModel = new InfoTableModel();
    private JButton appIconButton;
    private JLabel descriptionLabel;
    private JLabel titleLabel;
    private JLabel versionLabel;
    private JLabel copyrightLabel;
    private JTabbedPane tabbedPane1;
    private JPanel panel2;
    private JTextArea acknowledgeTextArea;
    private JPanel panel1;
    private JScrollPane scrollPane1;
    private JTable infoTable;

    public DialogAbout() {
        this.initComponents();
        this.appIconButton.setIcon(IconManager.shared().getIconApplication());
        this.copyrightLabel.setText("Copyright (c) 2005-2010 Jean Bovet & Terence Parr");
        this.versionLabel.setText("Version " + XJApplication.getAppVersionLong());
        this.infoTable.setModel(this.tableModel);
        this.infoTable.getParent().setBackground(Color.white);
        this.tableModel.addInfo("ANTLRWorks", XJApplication.getAppVersionShort());
        this.tableModel.addInfo("ANTLR", new Tool().VERSION);
        this.tableModel.addInfo("StringTemplate", "3.2.1");
        this.tableModel.addInfo("Java", System.getProperty("java.version") + " (" + System.getProperty("java.vendor") + ")");
        this.tableModel.fireTableDataChanged();
        this.resetAcknowledge();
        this.addAcknowledge("Contributions by RP Talusan <rp_talusan@yahoo.com>");
        this.addAcknowledge("ANTLR and StringTemplate are (c) 1989-2010 Terence Parr");
        this.addAcknowledge("gUnit is (c) 2008-2009 Leon Jen-Yuan Su");
        this.addAcknowledge("Application & Mac OS X document icons are (c) Simon Bovet");
        this.addAcknowledge("Portion of the GUI uses JGoodies, (c) 2002-2004 Karsten Lentzsch");
        this.addAcknowledge("Portion of the GUI was created using JFormDesigner, (c) 2004-2005 Karl Tauber");
        this.addAcknowledge("B-spline algorithm is (c) Leen Ammeraal <http://home.wxs.nl/~ammeraal/grjava.html>");
        this.addAcknowledge("BrowserLauncher is (c) 2001 Eric Albert <ejalbert@cs.stanford.edu>");
        this.setResizable(false);
        this.setSize(800, 500);
        this.center();
    }

    public void resetAcknowledge() {
        this.acknowledgeTextArea.setText("");
        this.acknowledgeTextArea.setBackground(null);
    }

    public void addAcknowledge(String ack) {
        this.acknowledgeTextArea.setText(this.acknowledgeTextArea.getText() + "\n" + ack);
    }

    public boolean isAuxiliaryWindow() {
        return true;
    }

    private void initComponents() {
        this.appIconButton = new JButton();
        this.descriptionLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.versionLabel = new JLabel();
        this.copyrightLabel = new JLabel();
        this.tabbedPane1 = new JTabbedPane();
        this.panel2 = new JPanel();
        this.acknowledgeTextArea = new JTextArea();
        this.panel1 = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.infoTable = new JTable();
        CellConstraints cc = new CellConstraints();
        this.setResizable(false);
        this.setTitle("About");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.BOTTOM, Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec("top:max(default;15dlu)"), FormFactory.LINE_GAP_ROWSPEC, new RowSpec("bottom:max(default;10dlu)"), FormFactory.LINE_GAP_ROWSPEC, new RowSpec("top:max(default;10dlu)"), FormFactory.LINE_GAP_ROWSPEC, new RowSpec("fill:max(default;60dlu):grow"), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.appIconButton.setIcon(null);
        this.appIconButton.setBorderPainted(false);
        this.appIconButton.setContentAreaFilled(false);
        this.appIconButton.setDefaultCapable(false);
        this.appIconButton.setEnabled(true);
        this.appIconButton.setFocusable(false);
        this.appIconButton.setFocusPainted(false);
        this.appIconButton.setPreferredSize(new Dimension(124, 144));
        this.appIconButton.setMaximumSize(new Dimension(136, 144));
        this.appIconButton.setMinimumSize(new Dimension(136, 144));
        contentPane.add((Component)this.appIconButton, cc.xywh(3, 3, 1, 8));
        this.descriptionLabel.setText("A graphical development environment for developing and debugging ANTLR v3 grammars");
        this.descriptionLabel.setHorizontalAlignment(2);
        this.descriptionLabel.setHorizontalTextPosition(2);
        this.descriptionLabel.setVerticalTextPosition(1);
        this.descriptionLabel.setVerticalAlignment(1);
        contentPane.add((Component)this.descriptionLabel, cc.xywh(5, 7, 1, 2));
        this.titleLabel.setText("ANTLRWorks");
        this.titleLabel.setFont(new Font("Lucida Grande", 1, 36));
        contentPane.add((Component)this.titleLabel, cc.xy(5, 3));
        this.versionLabel.setText("Version 1.0 early access 1");
        contentPane.add((Component)this.versionLabel, cc.xy(5, 5));
        this.copyrightLabel.setText("Copyright (c) 2005 Jean Bovet & Terence Parr");
        contentPane.add((Component)this.copyrightLabel, cc.xy(5, 9));
        this.panel2.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.DEFAULT, 0.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.acknowledgeTextArea.setText("ANTLR and StringTemplate are (c) 1989-2005 Terence Parr\nXJLibrary is (c) 2004-2005 Jean Bovet\nPortion of the GUI uses JGoodies, (c) 2002-2004 Karsten Lentzsch\nPortion of the GUI was created using JFormDesigner, (c) 2004-2005 Karl Tauber\nBrowserLauncher is (c) 2001 Eric Albert <ejalbert@cs.stanford.edu>\nApplication icon is (c) Matthew McClintock <matthew@mc.clintock.com>\n");
        this.acknowledgeTextArea.setEditable(false);
        this.acknowledgeTextArea.setBackground(SystemColor.window);
        this.panel2.add((Component)this.acknowledgeTextArea, cc.xy(3, 3));
        this.tabbedPane1.addTab("Acknowledgment", this.panel2);
        this.panel1.setLayout(new FormLayout(new ColumnSpec[]{new ColumnSpec(Sizes.dluX(10)), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(Sizes.dluX(10))}, new RowSpec[]{new RowSpec(Sizes.dluY(10)), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(RowSpec.FILL, Sizes.dluY(10), 1.0), FormFactory.LINE_GAP_ROWSPEC, new RowSpec(Sizes.dluY(10))}));
        this.infoTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Name", "Version"}){
            boolean[] columnEditable;
            {
                this.columnEditable = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.columnEditable[columnIndex];
            }
        });
        this.infoTable.setShowVerticalLines(true);
        this.scrollPane1.setViewportView(this.infoTable);
        this.panel1.add((Component)this.scrollPane1, cc.xy(3, 3));
        this.tabbedPane1.addTab("Information", this.panel1);
        contentPane.add((Component)this.tabbedPane1, cc.xywh(3, 11, 3, 1));
        this.pack();
    }

    public class InfoTableModel
    extends DefaultTableModel {
        public List<Object[]> info = new ArrayList<Object[]>();

        public Object getValueAt(int row, int column) {
            return this.info.get(row)[column];
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public int getRowCount() {
            if (this.info == null) {
                return 0;
            }
            return this.info.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                return "Name";
            }
            return "Version";
        }

        public void addInfo(String name, String version) {
            this.info.add(new Object[]{name, version});
        }
    }
}

