/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.works.debugger.events;

public class DBEvent {
    public static final int NO_EVENT = -1;
    public static final Integer negOne = -1;
    public static final Integer[] ints = new Integer[28];
    public static final int ALL = 0;
    public static final int NONE = 1;
    public static final int COMMENCE = 2;
    public static final int TERMINATE = 3;
    public static final int LOCATION = 4;
    public static final int CONSUME_TOKEN = 5;
    public static final int CONSUME_HIDDEN_TOKEN = 6;
    public static final int LT = 7;
    public static final int ENTER_RULE = 8;
    public static final int EXIT_RULE = 9;
    public static final int ENTER_SUBRULE = 10;
    public static final int EXIT_SUBRULE = 11;
    public static final int ENTER_DECISION = 12;
    public static final int EXIT_DECISION = 13;
    public static final int ENTER_ALT = 14;
    public static final int MARK = 15;
    public static final int REWIND = 16;
    public static final int BEGIN_BACKTRACK = 17;
    public static final int END_BACKTRACK = 18;
    public static final int BEGIN_RESYNC = 19;
    public static final int END_RESYNC = 20;
    public static final int NIL_NODE = 21;
    public static final int CREATE_NODE = 22;
    public static final int BECOME_ROOT = 23;
    public static final int ADD_CHILD = 24;
    public static final int SET_TOKEN_BOUNDARIES = 25;
    public static final int RECOGNITION_EXCEPTION = 26;
    public static final int ERROR_NODE = 27;
    private int eventType;
    private String grammarName;

    public DBEvent(int eventType) {
        this.eventType = eventType;
    }

    public static String getEventName(int type) {
        switch (type) {
            case -1: {
                return "-";
            }
            case 5: {
                return "Consume";
            }
            case 6: {
                return "Consume hidden";
            }
            case 8: {
                return "Enter rule";
            }
            case 9: {
                return "Exit rule";
            }
            case 10: {
                return "Enter subrule";
            }
            case 11: {
                return "Exit subrule";
            }
            case 12: {
                return "Enter decision";
            }
            case 13: {
                return "Exit decision";
            }
            case 14: {
                return "Enter alternative";
            }
            case 4: {
                return "Location";
            }
            case 7: {
                return "LT";
            }
            case 15: {
                return "Mark";
            }
            case 16: {
                return "Rewind";
            }
            case 17: {
                return "Begin backtrack";
            }
            case 18: {
                return "End backtrack";
            }
            case 26: {
                return "Recognition exception";
            }
            case 19: {
                return "Begin resync";
            }
            case 20: {
                return "End resync";
            }
            case 21: {
                return "Nil node";
            }
            case 27: {
                return "Error node";
            }
            case 22: {
                return "Create node";
            }
            case 23: {
                return "Become root";
            }
            case 24: {
                return "Add child";
            }
            case 25: {
                return "Set token boundaries";
            }
            case 2: {
                return "Commence";
            }
            case 3: {
                return "Terminate";
            }
            case 0: {
                return "All";
            }
        }
        return "?";
    }

    public static Integer convertToInteger(int eventType) {
        Integer retInt = eventType < ints.length ? ints[eventType] : (eventType == -1 ? negOne : Integer.valueOf(eventType));
        return retInt;
    }

    public int getEventType() {
        return this.eventType;
    }

    public void setEventType(int eventType) {
        this.eventType = eventType;
    }

    public String getGrammarName() {
        return this.grammarName;
    }

    public void setGrammarName(String grammarName) {
        this.grammarName = grammarName;
    }

    public String toString() {
        switch (this.getEventType()) {
            case 19: {
                return "Begin resync";
            }
            case 20: {
                return "End resync";
            }
            case 2: {
                return "Commence";
            }
            case 3: {
                return "Terminate";
            }
        }
        return super.toString();
    }

    static {
        int maxI = ints.length;
        for (int i = 0; i < maxI; ++i) {
            DBEvent.ints[i] = i;
        }
    }
}

