/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.wrapper;

import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.wrapper.JAXJWrapper;
import java.awt.AWTEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;

public class JAXJCheckBox
extends JCheckBox
implements JAXJWrapper {
    long _eventFilter = Integer.MAX_VALUE;
    boolean _filteringEnabled = false;
    private int _focusOrder = -1;

    protected void processEvent(AWTEvent e) {
        if (this.isEventEnabled(e.getID())) {
            super.processEvent(e);
        }
    }

    public JAXJCheckBox() {
        this.setFont(FontFactory.getCheckboxFontDefinition().createFont());
    }

    public JAXJCheckBox(Icon icon) {
        super(icon);
        this.setFont(FontFactory.getCheckboxFontDefinition().createFont());
    }

    public JAXJCheckBox(Icon icon, boolean selected) {
        super(icon, selected);
        this.setFont(FontFactory.getCheckboxFontDefinition().createFont());
    }

    public JAXJCheckBox(String text) {
        super(text);
        this.setFont(FontFactory.getCheckboxFontDefinition().createFont());
    }

    public JAXJCheckBox(Action a) {
        super(a);
        this.setFont(FontFactory.getCheckboxFontDefinition().createFont());
    }

    public JAXJCheckBox(String text, boolean selected) {
        this(text, null, selected);
    }

    public JAXJCheckBox(String text, Icon icon) {
        this(text, icon, false);
    }

    public JAXJCheckBox(String text, Icon icon, boolean selected) {
        super(text, icon, selected);
        this.setFont(FontFactory.getLabelFontDefinition().createFont());
    }

    public void setEditable(boolean editable) {
        boolean bl = this._filteringEnabled = !editable;
        if (!editable) {
            this.setEventFilters(24L);
        }
    }

    public final void setEventFilters(long eventFilter) {
        this._eventFilter &= eventFilter ^ 0xFFFFFFFFFFFFFFFFL;
    }

    boolean isEventEnabled(int type) {
        return !this._filteringEnabled || (this._eventFilter & (long)type) == 0L;
    }

    public int getFocusIndex() {
        return this._focusOrder;
    }

    public void setFocusIndex(int index) {
        this._focusOrder = index;
    }
}

