/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.FlipOrientationTableModel;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.swing.ui.tools.TableSorter;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.ContextView;
import com.jaxfront.swing.ui.visualizers.KeyRefRelationView;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class SimpleTypeCellEditor
implements TableCellEditor,
FocusListener {
    private Visualizer _visualizer;
    private JComponent _editorComponent;
    protected transient Vector listeners = new Vector();
    protected transient ChangeEvent changeEvent = null;

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addElement(l);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    protected void fireEditingCanceled() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.elementAt(i)).editingCanceled(ce);
        }
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        if (this.listeners != null) {
            Vector listenerClone = (Vector)this.listeners.clone();
            for (int i = listenerClone.size() - 1; i >= 0; --i) {
                ((CellEditorListener)listenerClone.elementAt(i)).editingStopped(ce);
            }
        }
    }

    public Object getCellEditorValue() {
        if (this._visualizer != null && this._visualizer.getModel() != null) {
            if (this._visualizer instanceof AbstractSimpleTypeView) {
                return ((AbstractSimpleTypeView)this._visualizer).getText();
            }
            if (this._visualizer instanceof SimpleTypeVisualizer) {
                return ((SimpleTypeVisualizer)this._visualizer).getText();
            }
            return "";
        }
        return "";
    }

    private Visualizer getEditorComponent(Type type) {
        return TypeVisualizerFactory.getInstance().getVisualizer(type, (Type)type.getParentList());
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this._editorComponent != null) {
            this._editorComponent.removeFocusListener(this);
        }
        SimpleType type = null;
        if (value instanceof SimpleType) {
            type = (SimpleType)value;
            if (type != null && type.isKey()) {
                KeyRefRelationView view = new KeyRefRelationView((Type)type);
                view.setBackground(table.getSelectionBackground());
                view.setForeground(table.getSelectionForeground());
                view.getEditorField().addFocusListener(this);
                this._visualizer = view;
                this._editorComponent = view.getEditorField();
                return (Component)this._visualizer;
            }
        } else if (value instanceof ListType && !(value instanceof SimpleTypeList)) {
            ListType listType = (ListType)value;
            ListType keyList = listType.getParent().getParentList();
            if (keyList != null && keyList.isKey()) {
                Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer((Type)listType, false);
                if (visualizer == null) {
                    visualizer = new ContextView();
                    visualizer.setModel((Type)listType);
                    TypeVisualizerFactory.getInstance().cacheVisualizer((Type)listType, visualizer);
                }
                visualizer.populateView();
                ((JComponent)visualizer).setBackground(table.getSelectionBackground());
                ((JComponent)visualizer).setForeground(table.getSelectionForeground());
                return (JComponent)visualizer;
            }
        } else {
            FlipOrientationTableModel model = (FlipOrientationTableModel)((TableSorter)table.getModel()).getModel();
            int modelIndex = table.convertColumnIndexToModel(column);
            type = model.getSimpleTypeAt(row, modelIndex);
        }
        if (!type.isSimple() && type.getTypeClassification() != 128) {
            String content = "";
            if (value instanceof String) {
                content = (String)value;
            }
            JTextField field = new JTextField(content);
            field.setEnabled(false);
            return field;
        }
        this._visualizer = this.getEditorComponent((Type)type);
        JComponent editorComponent = (JComponent)this._visualizer;
        if (this._visualizer != null && this._visualizer instanceof AbstractSimpleTypeView) {
            editorComponent = type.isSimple() && !type.isColor() && !type.isDate() && !type.getStyle().isUsingPlugIn() ? ((SimpleTypeVisualizer)this._visualizer).getEditorField() : ((AbstractSimpleTypeView)this._visualizer).getEditorComponent();
            editorComponent.setVisible(true);
        }
        if (type.isChoice() && type.getXUIDefinition().getStyle().isChoiceAsComboBox() || type.isKeyRef()) {
            // empty if block
        }
        this._editorComponent = editorComponent;
        this._editorComponent.addFocusListener(this);
        return this._editorComponent;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
        if (!this._visualizer.getImplementation().isViewReleased()) {
            this.stopCellEditing();
        }
    }
}

