/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.CodeTables;
import com.jaxfront.core.jep.ArrayResult;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.swing.ui.tools.AutoCompletion;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.CodeSetValueComboBoxEditor;
import com.jaxfront.swing.ui.visualizers.MultiColumnComboBoxRenderer;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import java.awt.event.ItemEvent;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;

public class CodeSetMultiColumComboBox
extends AbstractSimpleTypeView {
    protected JComponent createEditorComponent() {
        JAXJComboBox editor = new JAXJComboBox();
        AutoCompletion.enable(editor);
        editor.addItemListener(this);
        editor.addFocusListener(this);
        this.setFirstFocusableComponent(editor);
        editor.setAutoscrolls(true);
        this.setChoices(((SimpleType)this.getModel()).getEnumeration());
        ArrayResult arrayResult = new ArrayResult();
        ArrayResult emptyEntry = new ArrayResult();
        emptyEntry.add((Object)" ");
        emptyEntry.add((Object)" ");
        arrayResult.add((Object)emptyEntry);
        String codeSetName = this.getStyle().getCodeSetName();
        String[][] codeSetItems = this.getModel().getSchemaElement().getSchema().getCodeTables().getCodeItems(this.getModel(), codeSetName);
        ArrayResult oneItem = null;
        for (int i = 0; i < codeSetItems.length; ++i) {
            oneItem = new ArrayResult();
            oneItem.add((Object)("(" + codeSetItems[i][0] + ")"));
            oneItem.add((Object)codeSetItems[i][1]);
            arrayResult.add((Object)oneItem);
        }
        MultiColumnComboBoxRenderer renderer = new MultiColumnComboBoxRenderer(arrayResult, new String[]{"20", "80"});
        renderer.setDefaultPrefix(this.getDOM().getGlobalDefinition().getDefaultValuePreFix());
        renderer.setDefaultPostfix(this.getDOM().getGlobalDefinition().getDefaultValuePostFix());
        editor.setRenderer(renderer);
        return editor;
    }

    public String getText() {
        String codeSetID;
        String currentValue = (String)((JAXJComboBox)this._editorComponent).getSelectedItem();
        if (currentValue == null) {
            return "";
        }
        if (currentValue.equals("none")) {
            return "";
        }
        String codeset = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getCodeSetName();
        if (codeset != null && !currentValue.equals("") && (codeSetID = this.getDOM().getSchema().getCodeTables().getId(this.getModel(), codeset, currentValue, this.getDOM().getLanguage())) != null) {
            currentValue = codeSetID;
        }
        return currentValue;
    }

    public void populateView() {
        this.setChoices(((SimpleType)this.getModel()).getEnumeration());
        String value = ((SimpleType)this.getModel()).getValue();
        String defaultValue = ((SimpleType)this.getModel()).getDefaultValue();
        if (value != null) {
            String codeValue;
            String codeset;
            if (!this.getStyle().isUsingCodeSet() || (codeset = ((SimpleType)this.getModel()).getXUIDefinition().getStyle().getCodeSetName()) == null || value == null || (codeValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, value, this.getDOM().getLanguage())) == null || !CodeTables.isValueInvalid((String)(value = codeValue), (String)this.getDOM().getLanguage())) {
                // empty if block
            }
            ((JAXJComboBox)this._editorComponent).setSelectedItem(value);
        } else if (((JAXJComboBox)this._editorComponent).getItemCount() > 0) {
            ((JAXJComboBox)this._editorComponent).setSelectedIndex(0);
        }
    }

    private void setChoices(String[] choices) {
        if (this._editorComponent != null) {
            String codeset = this.getStyle().getCodeSetName();
            if (codeset != null) {
                String currentValue = this.getDOM().getSchema().getCodeTables().getText(this.getModel(), codeset, ((SimpleType)this.getModel()).getValue(), this.getDOM().getLanguage());
                if (CodeTables.isValueInvalid((String)currentValue, (String)this.getDOM().getLanguage())) {
                    ((JAXJComboBox)this._editorComponent).setEditor(new CodeSetValueComboBoxEditor());
                    ((JAXJComboBox)this._editorComponent).setEditable(true, false);
                }
                Vector<String> tempChoices = new Vector<String>();
                for (int i = 0; i < choices.length; ++i) {
                    if (!this.getStyle().isEnumerationAllowingInvalidCodes() && CodeTables.isValueInvalid((String)choices[i], (String)this.getDOM().getLanguage())) continue;
                    tempChoices.add(choices[i]);
                }
                choices = tempChoices.toArray(new String[tempChoices.size()]);
            }
            ((JAXJComboBox)this._editorComponent).setModel(new DefaultComboBoxModel<String>(choices));
        }
    }

    public void populateModel() {
        String currentValue;
        String modelValue = ((SimpleType)this.getModel()).getValue();
        if (modelValue == null) {
            modelValue = "";
        }
        if ((currentValue = this.getText()) != null && !modelValue.equals(currentValue)) {
            ((SimpleType)this.getModel()).setValue((Object)this, currentValue, false);
        }
    }

    public void itemStateChanged(ItemEvent e) {
        JAXJComboBox comboBox;
        super.itemStateChanged(e);
        if (e.getStateChange() == 1 && (comboBox = (JAXJComboBox)this._editorComponent).isPopupVisible() && e.getItem() != null) {
            this.populateModel();
        }
    }
}

