/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.dom.JAXFrontPropertyChangeEvent;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaException;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.rule.Rule;
import com.jaxfront.core.type.AbstractType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.SimpleTypeList;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.type.TypeController;
import com.jaxfront.core.ui.ChoiceName;
import com.jaxfront.core.ui.ComplexVisualizer;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.TreeModel;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.xui.GlobalDefinition;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.swing.ui.beans.MultiLineLabel;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.NavigationTree;
import com.jaxfront.swing.ui.layout.PercentLayout;
import com.jaxfront.swing.ui.layout.TabActionIcon;
import com.jaxfront.swing.ui.tools.BorderActionSet;
import com.jaxfront.swing.ui.tools.FocusHelper;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.FormLayoutBuilder;
import com.jaxfront.swing.ui.tools.FunctionalPanel;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.HRefMouseAdapter;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.visualizers.AbstractCompositeView;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.ComplexGroupListView;
import com.jaxfront.swing.ui.visualizers.SimpleGroupListView;
import com.jaxfront.swing.ui.wrapper.JAXJCheckBox;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public abstract class AbstractView
extends JPanel
implements PropertyChangeListener,
Visualizer,
ComplexVisualizer,
ItemListener,
FocusListener {
    public static final String PROPERTY_USER_CHANGED_SERIALIZE = "userChangedSerialize";
    public static final int HEADER_HEIGHT_OFFSET = 5;
    public static final String FILL = "fill:default:grow";
    public static final String FILL_NO_GROW = "fill:default:none";
    protected static final double DEFAULT_COMPONENT_HEIGHT = new Double(new JTextField().getPreferredSize().getHeight());
    protected Type _model;
    protected Type _context;
    protected JPanel _visualizerPanel;
    protected JPanel _labelPanel;
    protected JPanel _editorComponentPanel;
    protected JComponent _label;
    protected JComponent _editorComponent;
    protected Component _firstFocusableComponent;
    protected MultiLineLabel _hintTextLabel;
    protected JComponent _hintTextComponent;
    protected Border _originalBorder;
    protected List _buttons;
    private boolean _uiReleased = false;
    protected JPanel _captionTableLayoutPanel;
    protected FunctionalPanel _borderPanel;
    protected HeaderPanel _headerPanel;
    protected Color _defaultBackgroundColor;
    protected HeaderPanel _separatorPanel;
    protected JAXJCheckBox _optionalCheckBox;
    protected boolean _editable;
    private boolean _hasBeenBuilt;
    private boolean _isShowingHintLabel;
    private boolean _allowTreeNodeHighlighting = true;
    private int _rowIndexInParentTableLayout = -1;
    private FormLayout _parentTableLayout;
    private JComponent _parentTablePanel;
    protected JComponent _tableLabel;
    protected BorderActionSet _changeSerActionSet;
    protected BorderActionSet _changeHeaderSerActionSet;
    private Dimension _preferredSize = null;
    private AbstractAction _serializeTrueAction = null;
    private AbstractAction _serializeFalseAction = null;

    public AbstractView() {
    }

    public AbstractView(Type context) {
        this._context = context;
    }

    public AbstractView(LayoutManager layout) {
        super(layout);
        this.build();
    }

    public void postInitialization() {
        Vector notAppliedRules;
        if (this.getDOM() != null && (notAppliedRules = (Vector)this.getDOM().getNotFiredInitializationRules().get(this.getModel())) != null) {
            for (int i = 0; i < notAppliedRules.size(); ++i) {
                Rule aRule = (Rule)notAppliedRules.get(i);
                if (LogRegistry.getInstance().logInfos()) {
                    LogRegistry.getInstance().info(this.getClass(), "fireing late initialization rule" + aRule.toString());
                }
                aRule.apply(this.getModel(), null);
            }
            this.getDOM().getNotFiredInitializationRules().remove(this.getModel());
        }
    }

    public void addTreeNode(boolean shouldBeSerialized) {
        if (this.getModel() != null) {
            this.getModel().addTreeNode(shouldBeSerialized);
        }
    }

    public void removeTreeNode(boolean shouldBeSerialized) {
        if (this.getModel() != null) {
            this.getModel().removeTreeNode(shouldBeSerialized);
        }
    }

    public void addNewChild() {
        if (this.getModel() != null && this.getModel().isList()) {
            ((ListType)this.getModel()).addNewChild(null);
        }
    }

    private void build() {
        this.defaultBuild();
    }

    protected HeaderPanel createHeader(Type type, int height) {
        return GUITools.createHeader(type, type.getStyle().getLabelText(), height, null);
    }

    protected JComponent createLabel() {
        String labelText = this.getLabelText();
        this._label = this.createLabel(labelText, this.isLabelMulti(), this.isLabelUnderlined());
        String href = this.getStyle().getLeafLabelHRef();
        if (this.getModel().isSimple() && href != null) {
            this._label.addMouseListener(new HRefMouseAdapter(this._label, href));
        }
        String labelIconName = this.getStyle().getLabelIcon();
        ImageIcon imageIcon = JAXFrontProperties.getImageIcon((URL)this.getDOM().getFingerPrint().getXUIURL(), (String)labelIconName);
        if (this._label != null && imageIcon != null) {
            JPanel labelIconHolderPanel = null;
            JLabel imageLabel = new JLabel(imageIcon);
            imageLabel.setFocusable(false);
            if (this.getStyle().isLabelIconPositionTop()) {
                FormLayout iconHolderLayout = new FormLayout("f:d:g", "p,p");
                labelIconHolderPanel = new JPanel(iconHolderLayout);
                labelIconHolderPanel.setName("labelIconHolderPanel");
                labelIconHolderPanel.setFocusable(false);
                labelIconHolderPanel.add((Component)imageLabel, "1,1,L,C");
                labelIconHolderPanel.add((Component)this._label, "1,2");
            } else if (this.getStyle().isLabelIconPositionBottom()) {
                FormLayout iconHolderLayout = new FormLayout("f:d:g", "p,p");
                labelIconHolderPanel = new JPanel(iconHolderLayout);
                labelIconHolderPanel.setName("labelIconHolderPanel");
                labelIconHolderPanel.setFocusable(false);
                labelIconHolderPanel.add((Component)this._label, "1,1");
                labelIconHolderPanel.add((Component)imageLabel, "1,2,L,C");
            } else if (this.getStyle().isLabelIconPositionLeft()) {
                String indentColSpec = "p,4px,f:d:g";
                String indentRowSpec = "p";
                FormLayout iconIndentLayout = new FormLayout(indentColSpec, indentRowSpec);
                labelIconHolderPanel = new JPanel(iconIndentLayout);
                labelIconHolderPanel.setName("labelIconHolderPanel");
                labelIconHolderPanel.setFocusable(false);
                labelIconHolderPanel.add((Component)imageLabel, "1,1");
                labelIconHolderPanel.add((Component)this._label, "3,1");
            } else if (this.getStyle().isLabelIconPositionRight()) {
                FormLayout iconHolderLayout = new FormLayout("p,4px,p", "p");
                labelIconHolderPanel = new JPanel(iconHolderLayout);
                labelIconHolderPanel.setName("labelIconHolderPanel");
                labelIconHolderPanel.setFocusable(false);
                labelIconHolderPanel.add((Component)this._label, "1,1");
                labelIconHolderPanel.add((Component)imageLabel, "3,1,L,C");
            }
            this._label = labelIconHolderPanel;
        }
        return this._label;
    }

    public static TabActionIcon createTabActionIcon(int index, Type model, Action tabAction, Action tabInverseAction) {
        boolean isEditable = model.getStyle().isHierarchyEnabled(model);
        tabAction.putValue("tabIndex", new Integer(index));
        tabAction.setEnabled(isEditable);
        if (tabInverseAction != null) {
            tabInverseAction.setEnabled(isEditable);
        }
        TabActionIcon icon = new TabActionIcon(tabAction, tabInverseAction);
        return icon;
    }

    protected JComponent createLabel(String text, boolean useMultiLine, boolean underlined) {
        if (text != null) {
            String labelToolTip;
            if (useMultiLine || underlined) {
                MultiLineLabel multiLineLabel = new MultiLineLabel(text, underlined);
                if (underlined && !useMultiLine) {
                    multiLineLabel.setWrapStyleWord(false);
                    multiLineLabel.setLineWrap(false);
                    multiLineLabel.setRows(1);
                }
                JScrollPane helperPane = new JScrollPane();
                helperPane.setFocusable(false);
                helperPane.getViewport().setFocusable(false);
                helperPane.getViewport().add(multiLineLabel);
                helperPane.setBorder(null);
                this._label = helperPane;
            } else {
                this._label = new JLabel(text);
                this._label.setFocusable(false);
            }
            Container panel = null;
            if (this.getDOM().useOptionalCheckBox() && !this.getModel().isRequired() && this.getModel().getParent() != null && this.getModel().getParent().hasUndefinedChildren()) {
                String columnSpec = "2px,15px,2px,fill:default:grow";
                String rowSpec = "pref";
                panel = new JPanel(new FormLayout(columnSpec, rowSpec));
                panel.setName("optionalCheckBoxPanel");
                panel.setFocusable(false);
                this._optionalCheckBox = new JAXJCheckBox();
                this._optionalCheckBox.setSelected(true);
                this._optionalCheckBox.addItemListener(this);
                panel.add((Component)this._optionalCheckBox, "2, 1");
            }
            if ((labelToolTip = this.getStyle().getLabelToolTip()) == null && this.getDOM().getGlobalDefinition().isUsingAnnotationHelpInTooltip()) {
                labelToolTip = DOMHelper.getAnnotation((Type)this.getModel());
            }
            if (labelToolTip != null) {
                this._label.setToolTipText(labelToolTip);
            }
            if (panel != null) {
                panel.add((Component)this._label, "4, 1, L, F");
                this._label = panel;
            }
        }
        return this._label;
    }

    private JButton createButton(String buttonName, String actionClassString, String commandName) {
        return this.createButton(buttonName, actionClassString, commandName, null);
    }

    private JButton createButton(String buttonName, String actionClassString, String commandName, String ruleId) {
        JButton userButton = FormLayoutBuilder.createButton(this.getModel(), buttonName, actionClassString, commandName, ruleId);
        this.getButtons().add(userButton);
        return userButton;
    }

    protected abstract void defaultBuild();

    private ActionListener getAction(Class actionClass) {
        return this.getAction(actionClass, null);
    }

    private ActionListener getAction(Class actionClass, String commandName) {
        return FormLayoutBuilder.getAction(this.getModel(), actionClass, commandName);
    }

    public static JAXJComboBox getChoiceComboBox(JAXJComboBox comboBox, ActionListener listener, Type type, Type choosenType) {
        if (type.isComposite()) {
            return AbstractView.getComboBox(comboBox, listener, type, ChoiceName.get((CompositeType)((CompositeType)type)), choosenType);
        }
        return AbstractView.getComboBox(comboBox, listener, type, ChoiceName.get((Type)type), choosenType);
    }

    private static JAXJComboBox getComboBox(JAXJComboBox comboBox, ActionListener listener, Type type, ChoiceName[] choiceNames, Type choosenType) {
        Integer selectedIndex = null;
        if (choosenType != null) {
            for (int i = 0; i < choiceNames.length; ++i) {
                if (!choiceNames[i].getTypeName().equals(choosenType.getName())) continue;
                selectedIndex = new Integer(i);
                break;
            }
        }
        if (selectedIndex == null) {
            selectedIndex = new Integer(-1);
        }
        comboBox.setModel(new DefaultComboBoxModel<ChoiceName>(choiceNames));
        if (selectedIndex != null && choiceNames.length > 0) {
            comboBox.setSelectedIndex(selectedIndex);
        }
        if (listener != null) {
            comboBox.addActionListener(listener);
        }
        return comboBox;
    }

    static JAXJComboBox getDerrivedTypesComboBox(ActionListener actionListener, Type type, Type choosenType) {
        JAXJComboBox comboBox = new JAXJComboBox();
        ChoiceName[] choiceNames = null;
        if (type.isAbstract()) {
            choiceNames = ChoiceName.getAbstract((Type)type);
        } else if (type.isChoice()) {
            choiceNames = ChoiceName.get((CompositeType)((CompositeType)type));
        }
        AbstractView.getComboBox(comboBox, actionListener, type, choiceNames, choosenType);
        return comboBox;
    }

    public Document getDOM() {
        if (this._model != null) {
            return this._model.getDOM();
        }
        return null;
    }

    public JComponent getEditorComponent() {
        return this._editorComponent;
    }

    public void setEditorComponent(JComponent editorComponent) {
        this._editorComponent = editorComponent;
    }

    public JComponent getLabel() {
        return this._label;
    }

    public JPanel getVisualizerPanel() {
        return this._visualizerPanel;
    }

    protected AbstractEditorPanel getEditor() {
        if (this.getDOM() != null) {
            return (AbstractEditorPanel)this.getDOM().getEditor();
        }
        return null;
    }

    public String getLabelText() {
        if (this.getModel() != null) {
            Type type = this.getModel();
            if (type.isList()) {
                type = ((ListType)type).getEditingType();
            }
            if (type != null) {
                if (type.isComposite()) {
                    if (type.isChoice()) {
                        return type.getStyle().getChoiceLabel();
                    }
                    return type.getStyle().getCaptionTitleLabel();
                }
                return type.getStyle().getLabelText();
            }
        }
        return null;
    }

    public Type getModel() {
        return this._model;
    }

    private JPanel initCaptionPanel() {
        float captionIndent = this.getStyle().getCaptionIndentValue();
        String columnSpec = (int)captionIndent + "," + "f:p:g";
        String rowSpec = "p";
        FormLayout captionTableLayout = new FormLayout(columnSpec, rowSpec);
        this._captionTableLayoutPanel = new JPanel(captionTableLayout);
        this._captionTableLayoutPanel.setName("captionTableLayoutPanel");
        this._captionTableLayoutPanel.setFocusable(false);
        return this._captionTableLayoutPanel;
    }

    protected JPanel getCaptionTableLayoutPanel() {
        if (this._captionTableLayoutPanel == null) {
            return this.initCaptionPanel();
        }
        return this._captionTableLayoutPanel;
    }

    private JPanel initLabelPanel() {
        float labelIndent = this.getStyle().getLabelIndent();
        float labelColumnWidth = this.getLabelColumnWidth();
        if (labelColumnWidth >= 1.0f) {
            String columnSpec = (int)labelIndent + "," + "f:p:g";
            String rowSpec = "p";
            FormLayout labelTableLayout = new FormLayout(columnSpec, rowSpec);
            this._labelPanel = new JPanel(labelTableLayout);
            this._labelPanel.setName("labelPanel");
        } else {
            this._labelPanel = new JPanel(new BorderLayout());
            this._labelPanel.setName("labelPanel");
            if (labelIndent > 0.0f) {
                FormLayout indentLayout = new FormLayout(labelIndent + "px", "p");
                JPanel indentPanel = new JPanel(indentLayout);
                indentPanel.setName("indentPanel");
                indentPanel.setFocusable(false);
                this._labelPanel.add((Component)indentPanel, "West");
            }
        }
        this._labelPanel.setFocusable(false);
        return this._labelPanel;
    }

    public JPanel getLabelPanel() {
        if (this._labelPanel == null) {
            return this.initLabelPanel();
        }
        return this._labelPanel;
    }

    public JPanel getLabelPanel(JComponent label) {
        if (label != null) {
            if (this.isLabelColumnWidthAsPixel()) {
                this.getLabelPanel().add((Component)label, "2, 1");
            } else {
                this.getLabelPanel().add((Component)label, "Center");
            }
            label.setFont(FontFactory.getLabelFontDefinition().createFont());
        }
        return this.getLabelPanel();
    }

    public float getComponentSize() {
        return this.getStyle().getComponentSize();
    }

    private JPanel initEditorComponentPanel() {
        float columnWidth;
        float componentIndent = this.getStyle().getComponentIndent();
        float componentSize = this.getComponentSize();
        if (componentSize == -3.0f) {
            componentSize = 15.0f;
        }
        if ((columnWidth = this.getComponentColumnWidth()) >= 1.0f || componentSize > 0.0f) {
            String columnSpec = null;
            String rowSpec = "pref";
            columnSpec = componentSize == -1.0f ? (int)componentIndent + ",f:" + (int)(columnWidth - componentIndent) + "px:g" : ((componentSize = this.applySize(componentSize)) == -1.0f ? (int)componentIndent + "," + 100 + "px:g" : (int)componentIndent + "," + (int)componentSize);
            FormLayout componentTableLayout = new FormLayout(columnSpec, rowSpec);
            this._editorComponentPanel = new JPanel(componentTableLayout);
            this._editorComponentPanel.setName("editorComponentPanel");
        } else {
            this._editorComponentPanel = new JPanel(new BorderLayout());
            this._editorComponentPanel.setName("editorComponentPanel");
            if (componentIndent > 0.0f) {
                String index = "";
                index = componentIndent > 1.0f ? componentIndent + "px" : "f:0px:g(" + String.valueOf(componentIndent) + ")";
                FormLayout indentLayout = new FormLayout(index, "p");
                JPanel indentPanel = new JPanel(indentLayout);
                indentPanel.setName("indentPanel");
                indentPanel.setFocusable(false);
                this._editorComponentPanel.add((Component)indentPanel, "West");
            }
        }
        this._editorComponentPanel.setFocusable(false);
        return this._editorComponentPanel;
    }

    public float applySize(float size) {
        Font defaultFont = (Font)UIManager.getDefaults().get("TextField.font");
        return TextTools.getWidthInPixel((int)((int)size), (Font)defaultFont);
    }

    public JPanel getEditorComponentPanel() {
        if (this._editorComponentPanel == null) {
            return this.initEditorComponentPanel();
        }
        return this._editorComponentPanel;
    }

    protected JPanel getEditorComponentPanel(JComponent editorComponent) {
        if (editorComponent != null) {
            int componentWidth = (int)this.getStyle().getComponentSize();
            if (componentWidth == -3) {
                componentWidth = 15;
            }
            if (this.isComponentColumnWidthAsPixel() || componentWidth > 0) {
                this.getEditorComponentPanel().add((Component)editorComponent, "2, 1");
            } else {
                this.getEditorComponentPanel().add((Component)editorComponent, "Center");
            }
            if (this instanceof AbstractSimpleTypeView) {
                ((AbstractSimpleTypeView)this).getEditorField().setFont(FontFactory.getTextFieldFontDefinition().createFont());
            } else {
                editorComponent.setFont(FontFactory.getTextFieldFontDefinition().createFont());
            }
        }
        return this.getEditorComponentPanel();
    }

    public void setUserSerializable(boolean serialize) {
        this.getModel().setSerializable(serialize);
    }

    protected JPanel initBorderPanel(Visualizer visualizer, JComponent component) {
        StyleDefinition style = this.getStyle();
        GlobalDefinition globalDef = this.getDOM().getGlobalDefinition();
        String captionTitleLabel = style.getCaptionTitleLabel();
        String toolTipText = style.getCaptionTitleToolTip();
        if (toolTipText == null && globalDef.isUsingAnnotationHelpInTooltip()) {
            toolTipText = DOMHelper.getAnnotation((Type)this.getModel());
        }
        float captionIndent = style.getCaptionIndentValue();
        if (this._borderPanel == null && component != null) {
            if (captionIndent > 0.0f && (visualizer instanceof ComplexGroupListView || visualizer instanceof SimpleGroupListView)) {
                String colSpecs = captionIndent + ",f:0:g";
                String rowSpecs = "pref";
                FormLayout indentLayout = new FormLayout(colSpecs, rowSpecs);
                JPanel borderIndentPanel = new JPanel(indentLayout);
                borderIndentPanel.setName("borderIndentPanel");
                this._borderPanel = new FunctionalPanel(visualizer, component);
                this._borderPanel.setName("borderPanel");
                this._borderPanel.setOptional(globalDef.isShowingOptionalBorderControl());
                this._borderPanel.setBorderTitle(captionTitleLabel);
                this._borderPanel.setBorderTitleCaptionIndent(0.0f);
                borderIndentPanel.add((Component)this._borderPanel, "2,1");
                return borderIndentPanel;
            }
            this._borderPanel = new FunctionalPanel(visualizer, component);
            this._borderPanel.setOptional(globalDef.isShowingOptionalBorderControl());
            this._borderPanel.setBorderTitle(captionTitleLabel);
            if (this.getModel().isRecursive()) {
                this._borderPanel.setBorder(null);
            }
            if (this.getStyle().useUserModifiedSerialization()) {
                this.handleCaptionSerialization();
            } else if (this._borderPanel != null && this.getStyle().isInitiallyCollapsed()) {
                this._borderPanel.collapseInitially();
            }
            if (toolTipText != null) {
                this._borderPanel.setBorderTitleToolTip(toolTipText);
            }
        }
        return this._borderPanel;
    }

    protected void handleCaptionSerialization() {
        boolean expand;
        boolean isEditable = this.getStyle().isHierarchyEnabled(this.getModel());
        AbstractAction enableSerAction = this.getUserSerializationEnableAction();
        AbstractAction disableSerAction = this.getUserSerializeDisabledAction();
        enableSerAction.setEnabled(isEditable);
        disableSerAction.setEnabled(isEditable);
        GlobalDefinition globDef = this.getDOM().getGlobalDefinition();
        boolean wasSerialEmptContent = globDef.isSerializingEmptyContent();
        globDef.setSerializingEmptyContent(false);
        boolean elemHasContent = !((AbstractType)this.getModel()).hasEmptyContent(false, true);
        globDef.setSerializingEmptyContent(wasSerialEmptContent);
        boolean serCollapsed = this.getStyle().isUserModifiedSerializationCollapsed();
        boolean bl = expand = !serCollapsed || elemHasContent;
        if (expand) {
            if (this._borderPanel != null) {
                this._changeSerActionSet = this._borderPanel.getFunctionalBorder().addBorderAction(disableSerAction, enableSerAction, 0);
                this._borderPanel.getExpandCollapseBorderActionSet().setEnabled(true);
                this._borderPanel.expandInitially();
                this._borderPanel.getFunctionalBorder().toggleActionSet(this._changeSerActionSet, false);
            }
            if (this._headerPanel != null) {
                this._changeHeaderSerActionSet = this._headerPanel.getFunctionalGrapics().addBorderAction(disableSerAction, enableSerAction, 0);
                this._headerPanel.getFunctionalGrapics().toggleActionSet(this._changeSerActionSet, false);
            }
            this.setUserSerializable(true);
            this.getStyle().setApplicationRequired(true);
            TypeController.handleDynamicRequiredState((Type)this.getModel(), (boolean)false);
        } else {
            if (this._borderPanel != null) {
                this._changeSerActionSet = this._borderPanel.getFunctionalBorder().addBorderAction(enableSerAction, disableSerAction, 0);
                this._borderPanel.getExpandCollapseBorderActionSet().setEnabled(false);
                this._borderPanel.collapseInitially();
            }
            if (this._headerPanel != null) {
                this._changeHeaderSerActionSet = this._headerPanel.getFunctionalGrapics().addBorderAction(enableSerAction, disableSerAction, 0);
            }
            this.setUserSerializable(false);
            this.getStyle().setApplicationRequired(false);
        }
    }

    public boolean isRunningInDialog() {
        if (this.getModel().getParentList() != null) {
            return this.getModel().getParentList().getStyle().isDialogMode();
        }
        return false;
    }

    public abstract void markError();

    public abstract void populateModel();

    public abstract void populateView();

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.getModel() && evt.getPropertyName() != null && evt.getPropertyName().startsWith("propertyChange")) {
            boolean performPopulateView = true;
            if (evt instanceof JAXFrontPropertyChangeEvent && ((JAXFrontPropertyChangeEvent)evt).getViewSource() == this) {
                performPopulateView = false;
            }
            if (performPopulateView) {
                this.populateView();
                if (this.getEditor() != null) {
                    this.getEditor().repaint();
                }
            }
        }
    }

    public void release() {
        if (!this._uiReleased && this._model != null) {
            this._uiReleased = true;
            if (this.getDOM() != null) {
                this._model.getPropertyChangeSupport().removePropertyChangeListener(this);
            }
        }
        this._model = null;
        this._originalBorder = null;
        this._captionTableLayoutPanel = null;
        this._labelPanel = null;
        this._editorComponentPanel = null;
        this._headerPanel = null;
        this._borderPanel = null;
        this._label = null;
        this._changeSerActionSet = null;
        this._changeHeaderSerActionSet = null;
        this._optionalCheckBox = null;
        this._buttons = null;
    }

    public void removeLabel() {
    }

    public void removeMessage() {
        if (this.getModel() != null) {
            this.getModel().removeMessage();
        }
    }

    public void setSerializable(boolean isSerializable) {
        if (this.getModel() != null) {
            this.getModel().setSerializable(isSerializable);
        }
    }

    public abstract void resetError();

    public abstract void setLabelColor(Color var1);

    public void setLabelText(String text) {
    }

    public void setModel(Type type) {
        this._model = type;
        if (this._model != null) {
            if (!this._hasBeenBuilt) {
                this._model.getPropertyChangeSupport().addPropertyChangeListener(this);
                this.build();
            }
            if (this.getStyle().isEditorComponentVisible()) {
                this.populateView();
            }
            this._hasBeenBuilt = true;
        }
    }

    public void setTreeIcon(String gifName) {
        if (this.getModel() != null) {
            this.getModel().setTreeIcon(gifName);
        }
    }

    public void setTableLableComponent(JComponent tableLabel) {
        this._tableLabel = tableLabel;
    }

    public JComponent getTableLabelComponent() {
        return this._tableLabel;
    }

    public abstract void setRequired(boolean var1);

    public void setApplicationRequired(boolean aBoolean) {
        this.getModel().setApplicationRequired(aBoolean);
    }

    public void setVisible(boolean visible) {
        ListVisualizer view;
        super.setVisible(visible);
        this.getModel().setVisible(visible);
        if (this._tableLabel != null) {
            this._tableLabel.setVisible(visible);
        }
        if (this._editorComponent != null) {
            this._editorComponent.setVisible(visible);
        }
        if (!this.getModel().isSimple() && this.getModel().getParent() != null && this.getModel().getParent().isComposite() && this.getStyle().isRepresentedAsTab() && !this.getStyle().isSelfViewHolder()) {
            Visualizer view2 = TypeVisualizerFactory.getInstance().getVisualizer(this.getModel().getParent(), false);
            if (view2 != null && view2.getImplementation() instanceof AbstractCompositeView) {
                AbstractCompositeView compositeView = (AbstractCompositeView)view2.getImplementation();
                if (visible) {
                    compositeView.addTab(this.getModel());
                } else {
                    compositeView.removeTab(this.getModel());
                }
            }
        } else if (!this.getModel().isSimple() && this.getModel().getParent() != null && this.getModel().getParent().isList() && this.getModel().getParent().getStyle().isUsingTabList() && (view = (ListVisualizer)TypeVisualizerFactory.getInstance().getVisualizer(this.getModel().getParent(), false)) != null) {
            if (visible) {
                view.addTab(this.getModel());
            } else {
                view.removeTab(this.getModel());
            }
        }
    }

    public void setVisibleAndSerializable(boolean visible, boolean serialize) {
        this.setVisible(visible);
        this.getModel().setSerializable(serialize);
    }

    public void showLabel(boolean show) {
        this.getLabelPanel().setVisible(show);
    }

    public void showMessage(String message, String classification, boolean showDialog, boolean needsUserAcceptance) {
        this.getModel().showMessage(message, classification, showDialog, needsUserAcceptance);
    }

    private void updateHint(String text, Color color, boolean isBold) {
        if (text != null) {
            this.getHintTextLabel().setText(text);
            if (color != null) {
                this.getHintTextLabel().setDisabledTextColor(color);
            }
            if (isBold) {
                this.getHintTextLabel().setFont(FontFactory.getHintFontDefinition().updateFontDefinition(null, 1, -1).createFont());
            } else {
                this.getHintTextLabel().setFont(FontFactory.getHintFontDefinition().createFont());
            }
        }
    }

    private AbstractAction getUserSerializationEnableAction() {
        if (this._serializeTrueAction == null) {
            this._serializeTrueAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    AbstractView.this.doUserSerialization(true);
                }
            };
            this._serializeTrueAction.putValue("SmallIcon", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/serializeNew.gif"));
            this._serializeTrueAction.putValue("Name", "changeUserSerialization");
            this._serializeTrueAction.putValue("ShortDescription", GUIComponentNLS.getInstance().getNLSText("serialize_Element", "serialize Element"));
        }
        return this._serializeTrueAction;
    }

    public void doUserSerialization(boolean userSerialize) {
        boolean wasSerializable = this.getModel().isSerializable();
        this.setUserSerializable(userSerialize);
        this.getStyle().setApplicationRequired(userSerialize);
        if (userSerialize) {
            ((AbstractType)this.getModel()).notifyKeyRefChildsForCreation(this.getModel());
            this.getModel().putClientProperty(PROPERTY_USER_CHANGED_SERIALIZE, (Object)"true");
            TypeController.handleDynamicRequiredState((Type)this.getModel(), (boolean)false);
        } else {
            this.getModel().removeClientProperty(PROPERTY_USER_CHANGED_SERIALIZE);
            this._borderPanel.getExpandCollapseBorderActionSet().setEnabled(false);
        }
        this.getDOM().getUndoManager().addChangeSerializationUndoableEditEvent((Object)this.getModel(), this.getModel(), userSerialize, wasSerializable);
        if (this._borderPanel != null) {
            if (userSerialize) {
                this._borderPanel.expandInitially();
                this._borderPanel.getExpandCollapseBorderActionSet().setEnabled(true);
            } else {
                this._borderPanel.collapseInitially();
            }
        }
        if (this._headerPanel != null) {
            this.setEditable(userSerialize);
        }
    }

    private AbstractAction getUserSerializeDisabledAction() {
        if (this._serializeFalseAction == null) {
            this._serializeFalseAction = new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    AbstractView.this.doUserSerialization(false);
                }
            };
            this._serializeFalseAction.putValue("SmallIcon", JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/serializeDelete.gif"));
            this._serializeFalseAction.putValue("Name", "changeUserSerialization");
        }
        return this._serializeFalseAction;
    }

    public void showHint(String text, boolean isFormula, Color color, boolean isBold) {
        if (!(text == null || this.isShowingHintLabel() && text.equals(this._hintTextLabel.getText()))) {
            if (isFormula) {
                try {
                    FormulaExpression newFormEx = new FormulaExpression(this.getModel(), text);
                    text = newFormEx.evaluate();
                }
                catch (FormulaException ex) {
                    LogRegistry.getInstance().error(this.getClass(), "Formula Expression for action 'showHint' is invalid: " + text);
                }
            }
            this.updateHint(text, color, isBold);
            this.getHintTextLabel().setVisible(true);
            this.setIsShowingHintLabel(true);
        }
    }

    private boolean isShowingHintLabel() {
        return this._isShowingHintLabel;
    }

    private void setIsShowingHintLabel(boolean isShowingHintLabel) {
        this._isShowingHintLabel = isShowingHintLabel;
    }

    public void removeHint() {
        if (this.isShowingHintLabel()) {
            this.getHintTextLabel().setVisible(false);
            this.setIsShowingHintLabel(false);
        }
    }

    public void uiAction(String name, Object value) {
    }

    public void setCodeSetValues(String url, String codeSetName, String[] values, String defaultSelection) {
    }

    public void setValues(String[] values, String classResolverName) {
    }

    protected float getLabelColumnWidth() {
        return this.getStyle().getLabelColumnWidth();
    }

    protected boolean isLabelColumnWidthAsPixel() {
        return this.getLabelColumnWidth() >= 1.0f;
    }

    protected boolean isComponentColumnWidthAsPixel() {
        return this.getComponentColumnWidth() >= 1.0f;
    }

    protected float getComponentColumnWidth() {
        return this.getStyle().getComponentColumnWidth();
    }

    protected JComponent getCaptionPanel(JComponent contentPanel) {
        float captionIndent;
        JPanel captionPanel = null;
        GlobalDefinition globalDef = this.getDOM().getGlobalDefinition();
        Type model = this.getModel();
        StyleDefinition style = model.getStyle();
        String captionType = null;
        if (!(!style.hasCaption() || (captionType = style.getCaptionType()) == null || globalDef.isGlobalCaptionHideUnnamed() && model.isAnonymous())) {
            Font headerFont;
            String parentChildViewStetting;
            if (captionType == null || "border".equals(captionType)) {
                String columnSpec = "f:p:g";
                String rowSpec = "pref,0px";
                FormLayout borderHelperTL = new FormLayout(columnSpec, rowSpec);
                JPanel borderHelperPanel = new JPanel(borderHelperTL);
                borderHelperPanel.setName("borderHelperPanel");
                if (globalDef.hasBorderTopSpace() || globalDef.hasInnerBorderBottomSpace()) {
                    int borderTopSpace = globalDef.getTopSpaceBorder();
                    int borderBottomSpace = globalDef.getInnerBottomSpaceBorder();
                    String columnSpecification = FILL;
                    String rowSpecification = borderTopSpace + "px" + "," + "pref" + "," + borderBottomSpace + "px";
                    FormLayout borderTL = new FormLayout(columnSpecification, rowSpecification);
                    JPanel borderPanel = new JPanel(borderTL);
                    borderPanel.setName("borderPanel");
                    borderPanel.add((Component)contentPanel, "1,2");
                    contentPanel = borderPanel;
                }
                if ((captionPanel = this.initBorderPanel(this, contentPanel)) != null) {
                    if (globalDef.hasOuterBorderBottomSpace()) {
                        int borderBottomSpace = globalDef.getOuterBottomSpaceBorder();
                        String columnSpecific = FILL;
                        String rowSpecific = "pref," + borderBottomSpace + "px";
                        FormLayout borderTL = new FormLayout(columnSpecific, rowSpecific);
                        JPanel borderPanel = new JPanel(borderTL);
                        borderPanel.setName("borderPanel");
                        borderPanel.add((Component)captionPanel, "1,1");
                        captionPanel = borderPanel;
                    }
                    borderHelperPanel.add((Component)captionPanel, "1,1");
                }
                return borderHelperPanel;
            }
            captionIndent = style.getCaptionIndentValue();
            int topSpace = 0;
            int bottomSpace = 0;
            String string = parentChildViewStetting = model.getParent() != null ? model.getParent().getStyle().getChildrenView() : null;
            if ("header".equals(captionType)) {
                headerFont = FontFactory.getHeaderFontDefinition().createFont();
                this._headerPanel = this.createHeader(model, headerFont.getSize() + 5);
                this._headerPanel.setFont(headerFont);
                if (globalDef.hasHeaderTopSpace() || globalDef.hasHeaderBottomSpace()) {
                    topSpace = globalDef.getTopSpaceHeader();
                    bottomSpace = globalDef.getBottomSpaceHeader();
                }
            } else if (parentChildViewStetting != null && parentChildViewStetting.equals("separator_classic")) {
                headerFont = FontFactory.getHeaderFontClassicDefinition().createFont();
                this._headerPanel = GUITools.createSeparatorClassic(model, style.getLabelText(), headerFont.getSize() + 5);
                this._headerPanel.setFont(headerFont);
                if (globalDef.hasClassicSepTopSpace() || globalDef.hasClassicSepBottomSpace()) {
                    topSpace = globalDef.getTopSpaceClassicSeparator();
                    bottomSpace = globalDef.getBottomSpaceClassicSeparator();
                }
            } else if (parentChildViewStetting != null && parentChildViewStetting.equals("separator_modern")) {
                headerFont = FontFactory.getHeaderFontModernDefinition().createFont();
                this._headerPanel = GUITools.createSeparatorModern(model, style.getLabelText(), headerFont.getSize() + 5);
                this._headerPanel.setFont(headerFont);
                if (globalDef.hasModernSepTopSpace() || globalDef.hasModernSepBottomSpace()) {
                    topSpace = globalDef.getTopSpaceModernSeparator();
                    bottomSpace = globalDef.getBottomSpaceModernSeparator();
                }
            } else if ("separator_classic".equals(captionType) || "classic".equals(captionType)) {
                headerFont = FontFactory.getHeaderFontClassicDefinition().createFont();
                this._headerPanel = GUITools.createSeparatorClassic(model, style.getLabelText(), headerFont.getSize() + 5);
                this._headerPanel.setFont(headerFont);
                if (globalDef.hasClassicSepTopSpace() || globalDef.hasClassicSepBottomSpace()) {
                    topSpace = globalDef.getTopSpaceClassicSeparator();
                    bottomSpace = globalDef.getBottomSpaceClassicSeparator();
                }
            } else if ("separator_modern".equals(captionType) || "modern".equals(captionType)) {
                headerFont = FontFactory.getHeaderFontModernDefinition().createFont();
                this._headerPanel = GUITools.createSeparatorModern(model, style.getLabelText(), headerFont.getSize() + 5);
                this._headerPanel.setFont(headerFont);
                if (globalDef.hasModernSepTopSpace() || globalDef.hasModernSepBottomSpace()) {
                    topSpace = globalDef.getTopSpaceModernSeparator();
                    bottomSpace = globalDef.getBottomSpaceModernSeparator();
                }
            }
            if (topSpace > 0 || bottomSpace > 0) {
                String columnSpec = FILL;
                String rowSpec = topSpace + "px," + "pref," + bottomSpace + "px";
                FormLayout spacingTL = new FormLayout(columnSpec, rowSpec);
                JPanel spacePanel = new JPanel(spacingTL);
                spacePanel.setName("spacePanel");
                spacePanel.add((Component)contentPanel, "1,2");
                contentPanel = spacePanel;
            }
            JPanel innerCaptionTablePanel = new JPanel(new BorderLayout());
            innerCaptionTablePanel.setName("innerCaptionTablePanel");
            if (this._headerPanel != null) {
                String captionTitleLabel = style.getCaptionTitleLabel();
                String toolTipText = style.getCaptionTitleToolTip();
                if (captionTitleLabel != null) {
                    this._headerPanel.setHeaderTitle(captionTitleLabel);
                }
                if (toolTipText != null) {
                    this._headerPanel.setToolTipText(toolTipText);
                }
                JPanel currentHeaderPanel = null;
                if (captionIndent > 0.0f) {
                    String columnSpec = (int)captionIndent + "px," + FILL;
                    String rowSpec = "pref";
                    FormLayout headerTableLayout = new FormLayout(columnSpec, rowSpec);
                    JPanel headerTablePanel = new JPanel(headerTableLayout);
                    this._headerPanel.setName("headerPanel");
                    headerTablePanel.add((Component)this._headerPanel, "2,1");
                    currentHeaderPanel = headerTablePanel;
                } else {
                    currentHeaderPanel = this._headerPanel;
                }
                if (currentHeaderPanel != null) {
                    innerCaptionTablePanel.add((Component)currentHeaderPanel, "North");
                }
                if (contentPanel != null) {
                    innerCaptionTablePanel.add((Component)contentPanel, "Center");
                }
                captionPanel = innerCaptionTablePanel;
            }
            if (this.getStyle().useUserModifiedSerialization()) {
                this.handleCaptionSerialization();
            }
        }
        if (style.hasHeaderImageURL()) {
            captionIndent = style.getCaptionIndentValue();
            String columnSpec = (int)captionIndent + "px," + "fill:300px:grow";
            String rowSpec = "pref";
            FormLayout headerImageTL = new FormLayout(columnSpec, rowSpec);
            JPanel headerImagePanel = new JPanel(headerImageTL);
            if (!model.isRepresentedAsTreeNode() || !style.isSelfViewHolder()) {
                String headerImageURL = style.getHeaderImageURL();
                ImageIcon image = JAXFrontProperties.getImageIcon((URL)this.getDOM().getFingerPrint().getXUIURL(), (String)headerImageURL);
                JLabel imageLabel = new JLabel(image);
                imageLabel.setHorizontalAlignment(2);
                imageLabel.setBorder(null);
                headerImagePanel.add((Component)imageLabel, "2,1,L,C");
            }
            String columnSpecific = FILL;
            String rowSpecific = "pref,pref";
            FormLayout fullPanelTL = new FormLayout(columnSpecific, rowSpecific);
            JPanel fullPanel = new JPanel(fullPanelTL);
            fullPanel.setName("fullPanel");
            if (captionPanel != null) {
                fullPanel.add((Component)headerImagePanel, "1,1");
                fullPanel.add((Component)captionPanel, "1,2");
            } else {
                fullPanel.add((Component)headerImagePanel, "1,1");
                fullPanel.add((Component)contentPanel, "1,2");
            }
            return fullPanel;
        }
        if (captionPanel != null) {
            return captionPanel;
        }
        return contentPanel;
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this._optionalCheckBox) {
            this.setEnabled(this._optionalCheckBox.isSelected(), false);
            this.getModel().setSerializable(this._optionalCheckBox.isSelected());
        }
    }

    public void setEnabled(boolean enabled) {
        if (this._optionalCheckBox != null) {
            if (this._optionalCheckBox.isSelected()) {
                this.setEnabled(enabled, true);
            } else {
                this._optionalCheckBox.setEnabled(enabled);
            }
        } else {
            this.setEnabled(enabled, false);
        }
    }

    public void setEnabled(boolean enabled, boolean setOptionalToo) {
        super.setEnabled(enabled);
        if (this._editorComponent != null) {
            this._editorComponent.setEnabled(enabled);
        }
        if (this._label != null) {
            this._label.setEnabled(enabled);
        }
        if (this._optionalCheckBox != null && setOptionalToo) {
            this._optionalCheckBox.setEnabled(enabled);
        }
    }

    protected double getDefaultComponentHeight() {
        return DEFAULT_COMPONENT_HEIGHT;
    }

    protected String getStringDefaultComponentHeight() {
        return (int)DEFAULT_COMPONENT_HEIGHT + "px";
    }

    public Color getDefaultBackgroundColor() {
        if (this._defaultBackgroundColor == null) {
            this._defaultBackgroundColor = new JPanel().getBackground();
        }
        return this._defaultBackgroundColor;
    }

    public abstract void setChoosenKeyContextValue(String var1, String var2);

    public Type getSelectedType() {
        return null;
    }

    protected void setRowIndexInParentTableLayout(int index) {
        this._rowIndexInParentTableLayout = index;
    }

    protected int getRowIndexInParentTableLayout() {
        return this._rowIndexInParentTableLayout;
    }

    protected void setParentTableLayout(FormLayout tl) {
        this._parentTableLayout = tl;
    }

    protected FormLayout getParentTableLayout() {
        return this._parentTableLayout;
    }

    protected void setParentTablePanel(JComponent parentTablePanel) {
        this._parentTablePanel = parentTablePanel;
    }

    protected JComponent getParentTablePanel() {
        return this._parentTablePanel;
    }

    protected void highlightTreeEntry(Type type) {
        if (this._allowTreeNodeHighlighting && this.getEditor() != null && this.getEditor().getNavigationTree() != null) {
            TreeModel treeModel = (TreeModel)this.getEditor().getNavigationTree().getModel();
            TreeNode treeNode = null;
            if (treeModel != null) {
                if (this.getContext() != null) {
                    treeNode = treeModel.getNode(this.getContext());
                } else if (type != null) {
                    treeNode = treeModel.getNode(type.getRepresentedTreeNodeParent());
                }
                if (treeNode != null) {
                    this.getEditor().highlightNode(treeNode);
                }
            }
        }
    }

    private JScrollPane getFirstScrollPane(JComponent component) {
        if (component != null && component.getComponentCount() > 0) {
            for (int a = 0; a < component.getComponentCount(); ++a) {
                Component object = component.getComponents()[a];
                if (object != null && object instanceof JComponent) {
                    JScrollPane sp;
                    JComponent comp = (JComponent)object;
                    if (comp instanceof JScrollPane) {
                        if (((JScrollPane)comp).getViewport() != null && ((JScrollPane)comp).getViewport().getComponent(0) != null && ((JScrollPane)comp).getViewport().getComponent(0).getClass().getName().equals("javax.swing.plaf.basic.BasicComboPopup$2")) {
                            sp = this.getFirstScrollPane(comp);
                            if (sp == null) continue;
                            return sp;
                        }
                        return (JScrollPane)comp;
                    }
                    sp = this.getFirstScrollPane(comp);
                    if (sp == null) continue;
                    return sp;
                }
                return null;
            }
        }
        return null;
    }

    public void scrollToView(JComponent view) {
        if (view != null && !this.isShowing() && view.isVisible() && this.getEditor() != null && this.getEditor().getScrollPane() != null) {
            try {
                JScrollPane scrollPane = null;
                Window window = SwingUtilities.getWindowAncestor(view);
                if (window != null && window instanceof JDialog) {
                    JRootPane rootPane = ((JDialog)window).getRootPane();
                    scrollPane = this.getFirstScrollPane(rootPane);
                } else {
                    scrollPane = this.getEditor().getScrollPane();
                }
                if (scrollPane != null) {
                    boolean scrollingNeeded = false;
                    boolean horizScrollBarShowing = false;
                    boolean verticScrollBarShowing = false;
                    if (scrollPane.getHorizontalScrollBar() != null) {
                        horizScrollBarShowing = scrollPane.getHorizontalScrollBar().isShowing();
                    }
                    if (scrollPane.getVerticalScrollBar() != null) {
                        verticScrollBarShowing = scrollPane.getVerticalScrollBar().isShowing();
                    }
                    double absScrollPaneYPos = scrollPane.getLocationOnScreen().getY();
                    double absScrollPaneXPos = scrollPane.getLocationOnScreen().getX();
                    double currentYPos = scrollPane.getViewport().getViewPosition().getY();
                    double currentXPos = scrollPane.getViewport().getViewPosition().getX();
                    double viewPortHeight = scrollPane.getViewport().getHeight();
                    double viewPortWidth = scrollPane.getViewport().getWidth();
                    double absComponentYPos = view.getLocationOnScreen().getY();
                    double absComponentXPos = view.getLocationOnScreen().getX();
                    double componentHeight = view.getHeight();
                    double componentWidth = view.getWidth();
                    double visibleAreaHeight = absScrollPaneYPos + viewPortHeight;
                    double visibleAreaWidth = absScrollPaneXPos + viewPortWidth;
                    if (verticScrollBarShowing && absComponentYPos + (double)view.getFont().getSize() + 4.0 > visibleAreaHeight) {
                        currentYPos = absComponentYPos + currentYPos - absScrollPaneYPos - (viewPortHeight - componentHeight - 2.0);
                        scrollingNeeded = true;
                    } else if (verticScrollBarShowing && absScrollPaneYPos > absComponentYPos) {
                        currentYPos = absComponentYPos + currentYPos - absScrollPaneYPos - 2.0;
                        scrollingNeeded = true;
                    }
                    if (horizScrollBarShowing && absComponentXPos + componentWidth > visibleAreaWidth || absScrollPaneXPos > absComponentXPos) {
                        currentXPos = absComponentXPos + currentXPos - absScrollPaneXPos - 10.0;
                        scrollingNeeded = true;
                    }
                    if (scrollingNeeded) {
                        scrollPane.getViewport().setViewPosition(new Point((int)currentXPos, (int)currentYPos));
                    }
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    public Component getFirstFocusableComponent() {
        return this._firstFocusableComponent;
    }

    public void setFirstFocusableComponent(Component component) {
        this._firstFocusableComponent = component;
    }

    public MultiLineLabel getHintTextLabel() {
        if (this._hintTextLabel == null) {
            this._hintTextLabel = this.createHintTextLabel();
        }
        return this._hintTextLabel;
    }

    protected void checkHelp() {
        if (this.getModel() != null && this.getEditor() != null) {
            this.checkHelp(this.getModel());
        }
    }

    protected void checkHelp(Type type) {
        String helpText = type.getStyle().getHelpText();
        if (helpText != null) {
            this.getEditor().fireHelpEvent(type, helpText);
        } else if (type.getParent() != null) {
            this.checkHelp(type.getParent());
        } else {
            this.getEditor().fireHelpEvent(type, "");
        }
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        if (this._optionalCheckBox != null) {
            this._optionalCheckBox.setEditable(editable);
        }
    }

    public void jumpTo() {
        FocusHelper.focus(this.getModel(), this.getContext());
    }

    public ColumnSpec[] getColumnSpecLabelAndComponent() {
        float labelWidth = this.getLabelColumnWidth();
        float componentWidth = this.getComponentColumnWidth();
        String labelColumnWidth = "";
        String componentColumnWidth = "";
        labelColumnWidth = (double)labelWidth < 1.0 && (double)labelWidth > 0.0 ? "f:0px:g(" + labelWidth + ")" : "f:" + labelWidth + "px";
        componentColumnWidth = (double)componentWidth < 1.0 && (double)componentWidth > 0.0 ? "f:0px:g(" + componentWidth + ")" : "f:" + componentWidth + "px";
        ColumnSpec[] columnSpec = new ColumnSpec[]{new ColumnSpec(labelColumnWidth), new ColumnSpec(componentColumnWidth)};
        return columnSpec;
    }

    public ColumnSpec[] getPercentageColumnSpecComponent() {
        String componentColumnWidth = "0:g(" + this.getComponentColumnWidth() + ")";
        ColumnSpec[] columnSpec = new ColumnSpec[]{new ColumnSpec(componentColumnWidth)};
        return columnSpec;
    }

    public RowSpec[] getRowSpecDefaultComponentHeight() {
        RowSpec[] rowSpec = new RowSpec[]{new RowSpec("pref")};
        return rowSpec;
    }

    public RowSpec getRowSpec(String layout) {
        RowSpec rowSpec = new RowSpec(layout);
        return rowSpec;
    }

    public RowSpec[] getRowSpecArray(String layout) {
        RowSpec[] rowSpec = new RowSpec[]{new RowSpec(layout)};
        return rowSpec;
    }

    public FunctionalPanel getBorderPanel() {
        return this._borderPanel;
    }

    public void focusFirstComponent(boolean allowTreeNodeHighlighting) {
        this._allowTreeNodeHighlighting = allowTreeNodeHighlighting;
        if (this.getModel() == null) {
            return;
        }
        Type parent = (Type)this.getModel().getClientProperty("VIEW_HOLDER_TYPE");
        if (parent == null) {
            parent = this.getModel().getParent();
        }
        if (this.getFirstFocusableComponent() != null) {
            if (!this.getFirstFocusableComponent().hasFocus()) {
                this.focusComponent(this);
                Rectangle visRect = this.getVisibleRect();
                Rectangle ffRect = this.getFirstFocusableComponent().getBounds();
                ffRect.height = visRect.height < ffRect.height ? visRect.height - ffRect.x : ffRect.height;
                ffRect.width = visRect.width < ffRect.width ? visRect.width - ffRect.y : ffRect.width;
            }
        } else if (parent != null && parent.isChoice() && parent.getChoosenType() == this.getModel()) {
            AbstractView view = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(parent, this._context);
            view.focusFirstComponent(allowTreeNodeHighlighting);
        } else {
            this.transferFocus();
        }
    }

    public void focusComponent(AbstractView view) {
        Component focusableComponent = view.getFirstFocusableComponent();
        if (focusableComponent != null) {
            AbstractView viewToFocus;
            if (focusableComponent.isFocusable()) {
                focusableComponent.requestFocus();
                if (!focusableComponent.isEnabled()) {
                    focusableComponent.transferFocus();
                }
            } else if (view.getModel().getParent() != null && !view.getModel().getParent().isRoot() && (viewToFocus = (AbstractView)TypeVisualizerFactory.getInstance().getVisualizer(view.getModel().getParent(), this._context, false)) != null) {
                this.focusComponent(viewToFocus);
            }
        }
    }

    protected boolean allowTreeNodeHighlighting() {
        return this._allowTreeNodeHighlighting;
    }

    protected void setAllowTreeNodeHighlighting(boolean allowTreeNodeHighlighting) {
        this._allowTreeNodeHighlighting = allowTreeNodeHighlighting;
    }

    public void focusGained(FocusEvent e) {
        if (this.getDOM() != null && !e.isTemporary() && this.getDOM().getGlobalDefinition().isEditable()) {
            JComponent view = (JComponent)e.getSource();
            this.checkHelp();
            if (view != null) {
                Type type;
                this.scrollToView(view);
                if (e.getOppositeComponent() != null && !(e.getOppositeComponent() instanceof NavigationTree) && (type = this.getModel()) != null && type.isChoice() && type.getChoosenType() != null) {
                    Type type2 = type.getChoosenType();
                }
            }
        }
    }

    public void focusLost(FocusEvent e) {
    }

    protected JComponent createIndentedComponent(JComponent component) {
        GlobalDefinition global = this.getDOM().getGlobalDefinition();
        int topIndent = global.getGlobalTopIndent();
        int bottomIndent = global.getGlobalBottomIndent();
        int leftIndent = global.getGlobalLeftIndent();
        int rightIndent = global.getGlobalRightIndent();
        return GUITools.createIndentedComponent(component, topIndent, bottomIndent, leftIndent, rightIndent);
    }

    protected void createLabel(String labelText) {
        this.createLabel(labelText, false, false);
    }

    protected boolean isLabelMulti() {
        return this.getStyle().isLabelMulti();
    }

    protected boolean isLabelUnderlined() {
        return this.getStyle().isLabelUnderlined();
    }

    protected JPanel createVisualizerPanel(JComponent labelPanel, JComponent editorPanel) {
        boolean isLabelVisible = this.getStyle().isLabelVisible();
        boolean isComponentVisible = this.getStyle().isEditorComponentVisible();
        boolean isBooleanCheckBox = this.getModel().isSimple() && ((SimpleType)this.getModel()).isBoolean() && this.getStyle().isBooleanViewCheckBox();
        this._visualizerPanel = null;
        if (this.isComponentColumnWidthAsPixel() || this.isLabelColumnWidthAsPixel() || isBooleanCheckBox) {
            FormLayout labelComponentHolderTableLayout;
            if (this.isLabelMulti()) {
                labelComponentHolderTableLayout = new FormLayout(this.getColumnSpecLabelAndComponent(), this.getRowSpecArray("pref"));
                this._visualizerPanel = new JPanel(labelComponentHolderTableLayout);
                this._visualizerPanel.setName("visualizerPanel");
                if (isLabelVisible && labelPanel != null) {
                    this._visualizerPanel.add((Component)labelPanel, "1,1,F,C");
                }
                if (isComponentVisible && labelPanel != null) {
                    if (isBooleanCheckBox) {
                        this._visualizerPanel.add((Component)editorPanel, "2,1,R,B");
                    } else {
                        this._visualizerPanel.add((Component)editorPanel, "2,1");
                    }
                }
            } else {
                labelComponentHolderTableLayout = new FormLayout(this.getColumnSpecLabelAndComponent(), this.getRowSpecDefaultComponentHeight());
                this._visualizerPanel = new JPanel(labelComponentHolderTableLayout);
                this._visualizerPanel.setName("visualizerPanel");
                if (isLabelVisible && labelPanel != null) {
                    this._visualizerPanel.add((Component)labelPanel, "1,1");
                }
                if (isComponentVisible && editorPanel != null) {
                    if (isBooleanCheckBox) {
                        this._visualizerPanel.add((Component)editorPanel, "2,1,L,C");
                    } else {
                        this._visualizerPanel.add((Component)editorPanel, "2,1");
                    }
                }
            }
        } else {
            PercentLayout percentLayout = new PercentLayout(1);
            int labelWidthPercent = (int)(this.getLabelColumnWidth() * 100.0f);
            int componentWidthPercent = (int)(this.getComponentColumnWidth() * 100.0f);
            if (editorPanel == null || isLabelVisible && !isComponentVisible) {
                labelWidthPercent = 100;
                componentWidthPercent = 0;
            } else if (labelPanel == null || !isLabelVisible && isComponentVisible) {
                componentWidthPercent = 100;
                labelWidthPercent = 0;
            }
            PercentLayout.Constraints labelConstraint = new PercentLayout.Constraints(labelWidthPercent, 1);
            PercentLayout.Constraints componentConstraint = new PercentLayout.Constraints(componentWidthPercent, 1);
            this._visualizerPanel = new JPanel(percentLayout);
            this._visualizerPanel.setName("visualizerPanel");
            if (labelPanel != null && isLabelVisible) {
                this._visualizerPanel.add((Component)labelPanel, labelConstraint);
            }
            if (editorPanel != null && isComponentVisible) {
                if (this.getModel().isChoice() && editorPanel instanceof JAXJComboBox) {
                    JPanel wrappedPanel = this.getEditorComponentPanel(editorPanel);
                    this._visualizerPanel.add((Component)wrappedPanel, componentConstraint);
                } else {
                    this._visualizerPanel.add((Component)editorPanel, componentConstraint);
                }
            }
        }
        if (this.getDOM().getGlobalDefinition().hasComponentTopSpace() || this.getDOM().getGlobalDefinition().hasComponentBottomSpace()) {
            int topSpace = this.getDOM().getGlobalDefinition().getTopSpaceComponent();
            int bottomSpace = this.getDOM().getGlobalDefinition().getBottomSpaceComponent();
            String rowSpec = topSpace + "px," + "pref," + bottomSpace + "px";
            FormLayout spaceHolderTL = new FormLayout(FILL, rowSpec);
            JPanel spaceHolder = new JPanel(spaceHolderTL);
            spaceHolder.setName("spaceHolder");
            spaceHolder.setFocusable(false);
            spaceHolder.add((Component)this.getVisualizerPanel(), "1,2");
            this._visualizerPanel = spaceHolder;
        }
        return this._visualizerPanel;
    }

    protected void addButtonKeyListener(JButton jbutton) {
        final JButton button = jbutton;
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyKeyListener
        extends KeyAdapter {
            MyKeyListener() {
            }

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    button.doClick();
                }
            }
        }
        jbutton.addKeyListener(new MyKeyListener());
    }

    protected boolean hasBeenBuilt() {
        return this._hasBeenBuilt;
    }

    public Visualizer getImplementation() {
        return this;
    }

    private List getButtons() {
        if (this._buttons == null) {
            this._buttons = new Vector(5);
        }
        return this._buttons;
    }

    public Type getContext() {
        return this._context;
    }

    public void setContext(Type type) {
        this._context = type;
    }

    private MultiLineLabel createHintTextLabel() {
        MultiLineLabel hintLabel = new MultiLineLabel("", false);
        boolean isSimpleTypeView = false;
        JComponent parentPanel = null;
        if (this.getModel().isSimple() || this.getModel() instanceof SimpleTypeList) {
            isSimpleTypeView = true;
            parentPanel = this.getParentTablePanel() != null && this.getParentTablePanel().getLayout() instanceof PercentLayout ? this.getEditorComponentPanel() : this.getParentTablePanel();
        } else {
            parentPanel = this.getParentTablePanel();
        }
        if (parentPanel != null) {
            if (isSimpleTypeView) {
                if (parentPanel.getLayout() instanceof FormLayout) {
                    FormLayout parentTableLayout = (FormLayout)parentPanel.getLayout();
                    if (parentTableLayout.getRowCount() == 1) {
                        parentTableLayout.insertRow(1, this.getRowSpec("pref"));
                        parentPanel.add((Component)hintLabel, "2,2");
                    }
                } else {
                    parentPanel.add((Component)hintLabel, "South");
                }
            } else if (parentPanel.getLayout() instanceof FormLayout) {
                FormLayout parentTableLayout = (FormLayout)parentPanel.getLayout();
                parentTableLayout.insertRow(1, this.getRowSpec("pref"));
                int captionIndent = (int)this.getStyle().getCaptionIndentValue();
                if (captionIndent > 0 && !this.getModel().isList()) {
                    FormLayout indentFormLayout = new FormLayout(captionIndent + "," + FILL, "p");
                    this._hintTextComponent = new JPanel(indentFormLayout);
                    this._hintTextComponent.setName("hintTextComponent");
                    this._hintTextComponent.add((Component)hintLabel, "2,1");
                }
                if (this.getModel().isList()) {
                    if (this.getStyle().isCaptionTypeBorder()) {
                        parentPanel.add((Component)hintLabel, "1,1");
                    } else {
                        parentPanel.add((Component)hintLabel, "2,1");
                    }
                } else if (this._hintTextComponent != null) {
                    parentPanel.add((Component)this._hintTextComponent, "1,1");
                } else {
                    parentPanel.add((Component)hintLabel, "1,1");
                }
            } else {
                parentPanel.add((Component)hintLabel, "North");
            }
            parentPanel.updateUI();
        }
        return hintLabel;
    }

    public StyleDefinition getStyle() {
        return this.getModel().getXUIDefinition().getStyle();
    }

    public boolean isViewReleased() {
        return this._uiReleased;
    }

    public void setOwnPreferredSize(Dimension dim) {
        this._preferredSize = dim;
    }

    public Dimension getPreferredSize() {
        if (this._preferredSize != null) {
            return this._preferredSize;
        }
        return super.getPreferredSize();
    }

    public int getRendererType() {
        return 1;
    }
}

