/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.visualizers;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.ActionDefinition;
import com.jaxfront.core.rule.JavaAction;
import com.jaxfront.core.type.AbstractListType;
import com.jaxfront.core.type.CompositeType;
import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.ChoiceName;
import com.jaxfront.core.ui.FlipOrientationTableModel;
import com.jaxfront.core.ui.ListVisualizer;
import com.jaxfront.core.ui.RecursionVisualizer;
import com.jaxfront.core.ui.TabbableView;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.ui.tableModel.JAXDataTable;
import com.jaxfront.core.util.EventUtil;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.FormLayoutInfo;
import com.jaxfront.core.xui.ListInfo;
import com.jaxfront.core.xui.StyleDefinition;
import com.jaxfront.core.xui.TableCell;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.swing.helpers.UserMessage;
import com.jaxfront.swing.ui.beans.RowHeadedTable;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.AbstractPopUpMenu;
import com.jaxfront.swing.ui.editor.DefaultPopUpMenu;
import com.jaxfront.swing.ui.layout.ActionTabPlaf;
import com.jaxfront.swing.ui.layout.ListLayout;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jaxfront.swing.ui.tools.FormLayoutBuilder;
import com.jaxfront.swing.ui.tools.FunctionalPanel;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.tools.PopUpListener;
import com.jaxfront.swing.ui.tools.TableSorter;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeTable;
import com.jaxfront.swing.ui.visualizers.AbstractListTypeTableModel;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import com.jaxfront.swing.ui.visualizers.KeyRefRelationView;
import com.jaxfront.swing.ui.visualizers.ListActionEvent;
import com.jaxfront.swing.ui.visualizers.ListActionListenerWrapper;
import com.jaxfront.swing.ui.visualizers.ListViewAction;
import com.jaxfront.swing.ui.wrapper.DefaultTypeListModel;
import com.jaxfront.swing.ui.wrapper.JAXJButton;
import com.jaxfront.swing.ui.wrapper.JAXJComboBox;
import com.jaxfront.swing.ui.wrapper.JAXJDialog;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import com.jaxfront.swing.ui.wrapper.JAXJTabbedPane;
import com.jaxfront.swing.ui.wrapper.JAXJTable;
import com.jaxfront.swing.ui.wrapper.SimpleJList;
import com.jaxfront.swing.ui.wrapper.SimpleJListCellRenderer;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class AbstractListTypeView
extends AbstractView
implements TabbableView,
DOMChangeListener,
ActionListener,
ListSelectionListener,
AncestorListener,
MouseListener,
ListVisualizer,
ChangeListener,
PopupMenuListener,
WindowListener,
ComponentListener {
    private boolean _isAdding;
    protected JWindow _popUpWindow;
    protected JAXJComboBox _comboBox;
    protected JComponent _visualizer;
    private JPopupMenu _popUpMenu;
    private PopUpListener _popUpListener;
    protected JAXJButton _addButton;
    protected JAXJButton _editButton;
    protected JAXJButton _deleteButton;
    protected JAXJButton _copyButton;
    protected JAXJButton _moveUpButton;
    protected JAXJButton _moveDownButton;
    private JAXJTabbedPane _tabbedPane;
    protected Action _addAction;
    protected Action _editAction;
    protected Action _deleteAction;
    protected Action _copyAction;
    protected Action _moveUpAction;
    protected Action _moveDownAction;
    protected Action _copyContentAction;
    protected Action _pasteContentAction;
    public static final String ADD_ACTION_NAME = "add";
    public static final String EDIT_ACTION_NAME = "edit";
    public static final String DELETE_ACTION_NAME = "delete";
    public static final String COPY_ACTION_NAME = "copy";
    public static final String COPY_CONTENT_ACTION_NAME = "copyContent";
    public static final String PASTE_CONTENT_ACTION_NAME = "pasteContent";
    public static final String MOVE_UP_ACTION_NAME = "moveUp";
    public static final String MOVE_DOWN_ACTION_NAME = "moveDown";
    protected JPanel _buttonPanel;
    protected JPanel _upperButtonPanel;
    protected JPanel _lowerButtonPanel;
    protected JAXJDialog _editDialog;
    protected JPanel _editButtonPanel;
    protected Type _editingType;
    protected Type _originalType;
    protected JAXJSplitPane _splitPane;
    protected JAXJSplitPane _southOrientationSplitPane;
    protected SimpleJList _simpleListPanel;
    private Vector _buttonListeners = null;
    private Vector _userActions = null;
    private boolean _doAtVisualizationDone = false;
    protected AbstractListTypeTableModel _tableModel;
    protected FunctionalPanel _contentPanel;
    protected TitledBorder border;
    protected Vector _currentSelection;
    protected int _lastSelection = 0;
    protected boolean _selected = false;
    protected RowHeadedTable _list;
    protected JComponent _errorContainer;
    private JComponent _editingTypePane;
    protected Point _dialogLocation;
    protected Dimension _dialogSize;
    private JPanel _userButtonPanel;

    public AbstractListTypeView(Type type) {
        this.setModel(type);
        this._currentSelection = new Vector();
    }

    public AbstractListTypeView(Type type, Type context) {
        super(context);
        this.setModel(type);
        this._currentSelection = new Vector(1);
    }

    private void applyDefaultSelection() {
        StyleDefinition deStyle;
        Type type = this.getModel();
        if (type.getXUIDefinition(false) != null && type.getStyle().getTableInfo() != null && type.getDirectChildren().size() > 0 && !(deStyle = type.getStyle()).isListTableVisible()) {
            boolean isUserAction = ((AbstractEditorPanel)type.getDOM().getEditor()).isHighLightMode();
            if (!deStyle.getTableInfo().getStartupSelection().equals("none")) {
                if (deStyle.getTableInfo().getStartupSelection().equals("first")) {
                    this.selectType((Type)type.getDirectChildren().get(0), isUserAction);
                } else if (deStyle.getTableInfo().getStartupSelection().equals("last")) {
                    this.selectType((Type)type.getDirectChildren().get(type.getDirectChildren().size() - 1), isUserAction);
                }
            }
        }
    }

    public void postInitialization() {
        super.postInitialization();
        this.applyDefaultSelection();
        if (this.getModel().getXUIDefinition(false) != null && this.getStyle().isUsingTabList()) {
            List childs = this.getModel().getDirectChildren();
            int i = childs.size();
            while (--i >= 0) {
                Type aChild = (Type)childs.get(i);
                if (aChild.getXUIDefinition(false) == null || aChild.getStyle().isVisible()) continue;
                this.removeTab(aChild);
            }
        }
        this.handleButtonEnabling();
    }

    public void applyAutoColWidth() {
        if (this._list != null && this._list.getDataTable() != null) {
            if (this.getStyle().getListInfo() == null) {
                this._list.getDataTable().pack(0, false, true, false);
            } else if (this.getStyle().getListInfo().getDefaultWidth() == -1) {
                this._list.getDataTable().pack(0, this.getStyle().getListInfo().isAltColFitMethod(), true, false, this.getStyle().getListInfo().getDefaultWidth());
            }
        }
    }

    private boolean needsDoAtVisualization() {
        return this._list != null && this._list.getDataTable() != null && (this.getStyle().getListInfo() == null || this.getStyle().getListInfo().getDefaultWidth() == -1);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._comboBox) {
            this.getPopUpDerrivedTypesWindow().setVisible(false);
            ChoiceName choiceName = (ChoiceName)this._comboBox.getSelectedItem();
            if (choiceName != null) {
                Object type = null;
                try {
                    Type newType = null;
                    if (this.getListModel().getEditingType().isAbstract()) {
                        type = DOMHelper.getDerivedType((Type)((ListType)this.getModel()).getEditingType(), (String)choiceName.getTypeName(), (boolean)false);
                        if (type != null) {
                            newType = type.deepClone(this.getDOM(), false, false);
                            ((ListType)this.getModel()).add(newType);
                        }
                    } else {
                        newType = ((ListType)this.getModel()).addNewChild(this.getSelectedIndex(false));
                        type = newType.getChild(choiceName.getTypeName());
                        if (type == null) {
                            type = ((CompositeType)newType).createChoiceType(choiceName.getTypeName());
                        }
                        newType.setChoosenType((Type)type);
                    }
                    if (newType != null) {
                        this.doInternalAddAction(newType, false);
                    }
                }
                catch (CloneNotSupportedException ex) {
                    LogRegistry.getInstance().warn(this.getModel().getClass(), "not able to create deepClone from " + type.getClass());
                }
            }
        }
        if (this.getUserActions() != null) {
            Vector uAs = this.getUserActions();
            for (int u = 0; u < uAs.size(); ++u) {
                ((ListViewAction)uAs.get(u)).actionPerformed(e);
            }
        }
    }

    public void ancestorAdded(AncestorEvent event) {
    }

    public void ancestorMoved(AncestorEvent event) {
        this.getPopUpDerrivedTypesWindow().setVisible(false);
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        if (this._popUpWindow != null) {
            this.getPopUpDerrivedTypesWindow().setVisible(false);
        }
    }

    public void ancestorRemoved(AncestorEvent event) {
        if (this._popUpWindow != null) {
            this.getPopUpDerrivedTypesWindow().setVisible(false);
        }
    }

    private void cancelDialogChanges() {
        if (this._editDialog != null) {
            if (this._editingType != null) {
                if (this._isAdding) {
                    try {
                        TypeVisualizerFactory.getInstance().removeVisualizerStructure(this._editingType, true);
                        ((ListType)this.getModel()).delete(this._editingType);
                    }
                    catch (ListModificationException e) {
                        LogRegistry.getInstance().warn(this.getClass(), e.getLocalizedMessage());
                    }
                } else {
                    this._editingType.bind(this._originalType);
                    this._editingType.getDOM().fireDOMChanged(DOMChangeEvent.DOM_CANCELLED((Object)this._editingType));
                    ((JComponent)this.getDOM().getEditor()).repaint();
                }
            }
            this._editDialog.setVisible(false);
            this._editDialog.dispose();
            this.getDOM().getController().blockDirtyChange(false);
        }
        this._isAdding = false;
    }

    private void commitDialogChanges() {
        if (this._editDialog != null) {
            List list = ((ListType)this.getModel()).getList();
            int index = list.indexOf(this.getSelectedType());
            if (this._editingType != null) {
                this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_CHANGE_NODE((Type)this._editingType), false);
                this._editingType = null;
                this._originalType = null;
            }
            this._editDialog.setVisible(false);
            this._editDialog.dispose();
            if (index > -1) {
                Type selectedType = (Type)list.get(index);
                this.selectType(selectedType);
            }
            if (!this.getDOM().getController().hasChanged() && this.getDOM().getController().changeWhileBlocking()) {
                this.getDOM().getController().blockDirtyChange(false);
                this.getDOM().getController().fireDirtyChange();
            } else {
                this.getDOM().getController().blockDirtyChange(false);
            }
        }
    }

    private int getSelectedIndex(boolean holdCTRL) {
        int selectedIndex = -1;
        if (this._simpleListPanel != null) {
            selectedIndex = this._simpleListPanel.getFirstSelectedIndex();
            if (!holdCTRL && selectedIndex != -1) {
                ++selectedIndex;
            }
        } else if (this.getStyle().isUsingTabList()) {
            selectedIndex = this.getTabbedPane().getSelectedIndex();
            if (!holdCTRL && selectedIndex != -1) {
                ++selectedIndex;
            }
        } else {
            selectedIndex = ((List)this.getModel()).indexOf(this.getSelectedType());
            if (!holdCTRL && selectedIndex != -1) {
                ++selectedIndex;
            }
        }
        return selectedIndex;
    }

    public Type doAddAction(boolean holdCTRL) {
        Type newType = null;
        if (this.getModel().isAbstract() || this.getDOM().getGlobalDefinition().isUsingQuickChooserForChoiceListEntries() && ((ListType)this.getModel()).getEditingType().isChoice()) {
            this.popUpDerrivedTypes();
        } else {
            newType = ((ListType)this.getModel()).addNewChild(this.getSelectedIndex(holdCTRL));
            this.doInternalAddAction(newType, holdCTRL);
        }
        return newType;
    }

    private Type doInternalAddAction(Type newType, boolean holdCTRL) {
        if (newType != null && this.isDialogEditMode()) {
            this.highlightTreeEntry(this.getSelectedType());
            if (!newType.isRepresentedAsTreeNode() || !newType.getStyle().isSelfViewHolder()) {
                JDialog dialog = this.getEditDialog(newType, null, true);
                dialog.setVisible(true);
                dialog.toFront();
            }
        }
        this.refresh();
        if (newType != null && !newType.isReleased()) {
            Visualizer recVisualizer;
            this.selectType(newType);
            if (newType.isRecursive() && (recVisualizer = TypeVisualizerFactory.getInstance().getVisualizer(newType, this._context)) != null && recVisualizer.getImplementation() instanceof RecursionVisualizer) {
                ((RecursionVisualizer)recVisualizer.getImplementation()).createRecursion();
            }
        }
        this.handleButtonEnabling();
        return newType;
    }

    public void refresh() {
        if (this.getEditor() != null && this.getEditor().getWindow() != null && this._list != null) {
            this._list.refresh();
        }
    }

    public List doDeleteAction() {
        return this.delete(this.getSelectedTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List delete(Vector typesToDelete) {
        Vector<Type> deletedTypes = null;
        if (((ListType)this.getModel()).getList() != null && ((ListType)this.getModel()).getList().size() > 0 && typesToDelete != null && typesToDelete.size() > 0 && this.getDOM().getGlobalDefinition().isEditable()) {
            boolean showDeletionMesssage = true;
            boolean deleteListItem = true;
            ListInfo listInfo = this.getStyle().getListInfo();
            showDeletionMesssage = listInfo == null || listInfo.isUsingDeletionConfirmation();
            if (showDeletionMesssage) {
                deleteListItem = Dialog.showListDeletionDialog(this.getModel(), null);
            }
            if (deleteListItem) {
                this.selectType(null);
                this.showModel(null);
                deletedTypes = new Vector<Type>();
                ListType listType = (ListType)this.getModel();
                this.stopCellEditing();
                int indexToDisplay = -1;
                boolean wasCompoundEdit = this.getDOM().getUndoManager().isInCompoundEditState();
                this.getDOM().getUndoManager().startCompoundEdit();
                try {
                    for (int i = 0; i < typesToDelete.size(); ++i) {
                        try {
                            Type removeType = (Type)typesToDelete.get(i);
                            if (removeType.getClientProperty("lockedExistingListItem") != null) continue;
                            ((ListType)this.getModel()).isListItemRemoveable(removeType);
                            deletedTypes.add(removeType);
                            indexToDisplay = listType.getList().indexOf(removeType);
                            TypeVisualizerFactory.getInstance().removeVisualizerStructure(removeType, true);
                            removeType.remove();
                            continue;
                        }
                        catch (ListModificationException e) {
                            KeyRefRelationView.handleDeleteError((Exception)((Object)e), this.getDOM());
                        }
                    }
                }
                finally {
                    if (!wasCompoundEdit && this.getDOM() != null) {
                        this.getDOM().getUndoManager().stopCompoundEdit();
                    }
                }
                if (deletedTypes.size() > 0) {
                    if (this._currentSelection != null) {
                        this._currentSelection.clear();
                    }
                    if (listType.getList().size() > 0) {
                        if (indexToDisplay > 0 && indexToDisplay >= listType.getList().size()) {
                            indexToDisplay = listType.getList().size() - 1;
                        }
                        if (indexToDisplay >= 0 && indexToDisplay < listType.getList().size()) {
                            Type lastType = (Type)listType.getList().get(indexToDisplay);
                            this.selectType(lastType);
                            this.handleButtonEnabling();
                        }
                    } else {
                        this.selectType(null);
                        this.showModel(null);
                        this.handleButtonEnabling();
                    }
                    if (this.getDOM().getEditor().getWindow() != null) {
                        this.getDOM().getEditor().getWindow().repaint();
                    }
                }
            }
        }
        return deletedTypes;
    }

    public List doCopyAction() {
        Vector selection = this.getSelectedTypes();
        Type addedType = null;
        for (int i = 0; i < selection.size(); ++i) {
            Type selectedType = (Type)selection.get(i);
            addedType = ((ListType)this.getModel()).addNewChild(selectedType, ((List)this.getModel()).indexOf(selectedType) + 1);
        }
        if (this.getEditor() != null && this.getEditor().getWindow() != null) {
            this.getEditor().getWindow().repaint();
            if (this._list != null) {
                this._list.refresh();
            }
        }
        if (addedType != null) {
            this.selectType(addedType);
        }
        this.handleButtonEnabling();
        return selection;
    }

    public int[] getFromTo(Type toMoveType, boolean up) {
        int from = -1;
        int to = -1;
        ListType listType = (ListType)this.getModel();
        int listSize = listType.size();
        if (this._list == null || toMoveType != null) {
            from = listType.indexOf((Object)toMoveType);
            to = up ? ((to = from - 1) < 0 ? listSize - 1 : to) : ((to = from + 1) >= listSize ? 0 : to);
        } else {
            JAXJTable dTable = this._list.getDataTable();
            int selectedIndex = dTable.getSelectedRow();
            if (selectedIndex >= 0 && selectedIndex < listSize) {
                if (dTable.isEditing()) {
                    dTable.getCellEditor().stopCellEditing();
                }
                to = up ? ((to = selectedIndex - 1) < 0 ? listSize - 1 : to) : ((to = selectedIndex + 1) >= listSize ? (to = 0) : to);
                from = ((TableSorter)dTable.getModel()).getOriginalRowIndex(selectedIndex);
                to = ((TableSorter)dTable.getModel()).getOriginalRowIndex(to);
            }
        }
        return new int[]{from, to};
    }

    public int[] doMoveUpAction(Type toMoveType) {
        int[] fromTo = this.getFromTo(toMoveType, true);
        int from = fromTo[0];
        int to = fromTo[1];
        ListType listType = (ListType)this.getModel();
        int listSize = listType.size();
        if (from >= 0 && to >= 0 && from < listSize && to < listSize) {
            JAXJTable dTable;
            this.getEditor().setHighLightMode(this.getListModel().getEditingType().getStyle().isSelfViewHolder());
            listType.swap(from, to);
            JAXJTable jAXJTable = dTable = this._list != null ? this._list.getDataTable() : null;
            if (dTable != null) {
                dTable.getSelectionModel().setSelectionInterval(to, to);
            }
            this.getEditor().setHighLightMode(false);
        }
        return new int[]{from, to};
    }

    public int[] doMoveDownAction(Type toMoveType) {
        int[] fromTo = this.getFromTo(toMoveType, false);
        int from = fromTo[0];
        int to = fromTo[1];
        ListType listType = (ListType)this.getModel();
        int listSize = listType.size();
        if (from >= 0 && to >= 0 && from < listSize && to < listSize) {
            JAXJTable dTable;
            this.getEditor().setHighLightMode(this.getListModel().getEditingType().getStyle().isSelfViewHolder());
            listType.swap(from, to);
            JAXJTable jAXJTable = dTable = this._list != null ? this._list.getDataTable() : null;
            if (dTable != null) {
                dTable.getSelectionModel().setSelectionInterval(to, to);
            }
            this.getEditor().setHighLightMode(false);
        }
        return new int[]{from, to};
    }

    protected Action getAddAction() {
        if (this._addAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_add", "Add${ALT+A}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._addAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/new_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    Type addedType = AbstractListTypeView.this.doAddAction((e.getModifiers() & 2) != 0);
                    AbstractListTypeView.this.fireButtonListeners(1, new ListActionEvent((Object)this, 1, AbstractListTypeView.ADD_ACTION_NAME, addedType));
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._addAction, (String)accelDef[1]);
            }
        }
        return this._addAction;
    }

    protected Action getDeleteAction() {
        if (this._deleteAction == null) {
            this._deleteAction = this.createDeleteAction();
        }
        return this._deleteAction;
    }

    private AbstractAction createDeleteAction() {
        String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_delete", "Delete${ALT+D}");
        String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
        AbstractAction deleteAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/delete_16x16.gif")){

            public void actionPerformed(ActionEvent e) {
                Type tabType;
                Integer tabPos;
                if (AbstractListTypeView.this.getTabbedPane() != null && (tabPos = (Integer)AbstractListTypeView.this._deleteAction.getValue("selectedIndex")) != null && tabPos >= 0 && (tabType = AbstractListTypeView.this.getTabbedPane().getTabTypeAt(tabPos)) != null) {
                    AbstractListTypeView.this.selectType(tabType);
                }
                AbstractListTypeView.this.fireButtonListeners(2, new ListActionEvent((Object)this, 2, AbstractListTypeView.DELETE_ACTION_NAME, AbstractListTypeView.this.doDeleteAction()));
            }
        };
        if (accelDef[1] != null) {
            EventUtil.createKeyStrokes((Action)deleteAction, (String)accelDef[1]);
        }
        return deleteAction;
    }

    protected Action getCopyAction() {
        if (this._copyAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_copy", "Copy${ALT+C}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._copyAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    AbstractListTypeView.this.fireButtonListeners(3, new ListActionEvent((Object)this, 3, AbstractListTypeView.COPY_ACTION_NAME, AbstractListTypeView.this.doCopyAction()));
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._copyAction, (String)accelDef[1]);
            }
        }
        return this._copyAction;
    }

    protected Action getCopyContentAction() {
        if (this._copyContentAction == null) {
            this._copyContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_copy_content", "copy content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/copy_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    Vector userSelection = AbstractListTypeView.this.getSelectedTypes();
                    if (userSelection != null && userSelection.size() > 0) {
                        if (userSelection.size() == 1) {
                            AbstractListTypeView.this.getDOM().getClipBoard().copy((Type)userSelection.get(0));
                        } else {
                            AbstractListTypeView.this.getDOM().getClipBoard().copy(AbstractListTypeView.this.getModel(), AbstractListTypeView.this.createCopyStringFromSelection(AbstractListTypeView.this.getSelectedTypes()));
                        }
                    } else {
                        UserMessage.showInfoMessage(GUIComponentNLS.getInstance().getNLSText("usermessages_info", "Info !"), GUIComponentNLS.getInstance().getNLSText("usermessages_nothing_selected", "Nothing selected !"));
                    }
                }
            };
        }
        return this._copyContentAction;
    }

    private String createCopyStringFromSelection(List selection) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < selection.size(); ++i) {
            buff.append(((Type)selection.get(i)).serialize());
        }
        return buff.toString();
    }

    protected Action getPasteContentAction() {
        if (this._pasteContentAction == null) {
            this._pasteContentAction = new AbstractAction(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_paste_content", "paste content"), JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/pasteContent_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    if (AbstractListTypeView.this.getDOM().getClipBoard().getCopyTypeWrapper() != null) {
                        if (AbstractListTypeView.this.getStyle().isUsingTabList()) {
                            Type originType = AbstractListTypeView.this.getTabbedPane().getSelectedTabType();
                            AbstractListTypeView.this.getDOM().getClipBoard().paste(originType, false);
                            AbstractListTypeView.this.getDOM().validateKeyRefIntegrity(true);
                        } else if (AbstractListTypeView.this._list.getSelectionModel().getLeadSelectionIndex() >= 0) {
                            List list = AbstractListTypeView.this._list.getModel().getListType().getList();
                            int start = AbstractListTypeView.this._list.getSelectionModel().getAnchorSelectionIndex();
                            int end = AbstractListTypeView.this._list.getSelectionModel().getLeadSelectionIndex();
                            for (int i = start; i <= end; ++i) {
                                Type originType = (Type)list.get(i);
                                if (originType != null) {
                                    if (AbstractListTypeView.this.getDOM().getClipBoard().getCopyTypeWrapper().isAdding()) {
                                        AbstractListTypeView.this.getDOM().getClipBoard().paste(AbstractListTypeView.this.getModel(), null, false, false);
                                    } else {
                                        AbstractListTypeView.this.getDOM().getClipBoard().paste(originType, null, false, false);
                                    }
                                    AbstractListTypeView.this.getDOM().validateKeyRefIntegrity(true);
                                    AbstractListTypeView.this.populateView();
                                    continue;
                                }
                                UserMessage.showInfoMessage(GUIComponentNLS.getInstance().getNLSText("usermessages_info", "Info !"), GUIComponentNLS.getInstance().getNLSText("usermessages_nothing_selected", "Nothing selected !"));
                            }
                        }
                    }
                }
            };
        }
        return this._pasteContentAction;
    }

    private Action registerSelectAllAction() {
        AbstractAction selectAll = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (AbstractListTypeView.this._list != null && AbstractListTypeView.this._list.getDataTable() != null) {
                    AbstractListTypeView.this._list.getDataTable().selectAll();
                }
                AbstractListTypeView.this.handleButtonEnabling();
            }
        };
        EventUtil.addKeyboardBinding((JComponent)this._list, (Action)selectAll, (String)"CTRL+A", (int)2);
        return selectAll;
    }

    private Action getEditAction() {
        if (this._editAction == null && this.hasEditButton()) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_edit", "Edit${ALT+E}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._editAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/edit_16x16.gif")){

                public void actionPerformed(ActionEvent e) {
                    AbstractListTypeView.this.fireButtonListeners(0, new ListActionEvent((Object)this, 0, AbstractListTypeView.EDIT_ACTION_NAME, AbstractListTypeView.this.editObject()));
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._editAction, (String)accelDef[1]);
            }
        }
        return this._editAction;
    }

    public Action getMoveUpAction() {
        if (this._moveUpAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_up", "Up${ALT+U}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._moveUpAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowUp_9x6.gif")){

                public void actionPerformed(ActionEvent e) {
                    Type toMoveType = AbstractListTypeView.this.getTypeFromEvent(e);
                    AbstractListTypeView.this.handleButtonEnabling();
                    AbstractListTypeView.this.fireButtonListeners(4, new ListActionEvent((Object)this, 4, AbstractListTypeView.MOVE_UP_ACTION_NAME, AbstractListTypeView.this.doMoveUpAction(toMoveType)));
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._moveUpAction, (String)accelDef[1]);
            }
        }
        return this._moveUpAction;
    }

    private Type getTypeFromEvent(ActionEvent e) {
        JMenuItem me;
        Type evType = null;
        if (e.getSource() instanceof JMenuItem && (me = (JMenuItem)e.getSource()).getParent() instanceof AbstractPopUpMenu) {
            AbstractPopUpMenu menu = (AbstractPopUpMenu)me.getParent();
            evType = menu.getType();
        }
        return evType;
    }

    public Action getMoveDownAction() {
        if (this._moveDownAction == null) {
            String buttonText = GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_list_down", "Down${ALT+W}");
            String[] accelDef = EventUtil.parseAccelDefinitions((String)buttonText);
            this._moveDownAction = new AbstractAction(accelDef[0], JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/arrowDown_9x6.gif")){

                public void actionPerformed(ActionEvent e) {
                    Type toMoveType = AbstractListTypeView.this.getTypeFromEvent(e);
                    AbstractListTypeView.this.handleButtonEnabling();
                    AbstractListTypeView.this.fireButtonListeners(5, new ListActionEvent((Object)this, 5, AbstractListTypeView.MOVE_DOWN_ACTION_NAME, AbstractListTypeView.this.doMoveDownAction(toMoveType)));
                }
            };
            if (accelDef[1] != null) {
                EventUtil.createKeyStrokes((Action)this._moveDownAction, (String)accelDef[1]);
            }
        }
        return this._moveDownAction;
    }

    protected JAXJButton createButton(Action action) {
        JAXJButton returnButton = new JAXJButton(action);
        returnButton.putClientProperty("holderType", this.getModel());
        returnButton.setHorizontalAlignment(2);
        class MyKeyListener
        extends KeyAdapter {
            MyKeyListener() {
            }

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    Type addedType = AbstractListTypeView.this.doAddAction(false);
                    AbstractListTypeView.this.fireButtonListeners(1, new ListActionEvent((Object)this, 1, AbstractListTypeView.ADD_ACTION_NAME, addedType));
                } else if (evt.getKeyCode() == 38) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                } else if (evt.getKeyCode() == 40) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            }
        }
        returnButton.addKeyListener(new MyKeyListener());
        return returnButton;
    }

    private TableInfo getTableInfo() {
        if (this.getModel() != null) {
            return this.getStyle().getTableInfo();
        }
        return null;
    }

    public JPanel getUpperButtonPanel() {
        return this._upperButtonPanel;
    }

    public JPanel getLowerButtonPanel() {
        return this._lowerButtonPanel;
    }

    protected JPanel createButtonPanel(int orientation) {
        this._buttonPanel = new JPanel();
        this._buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        this._buttonPanel.setName("buttonPanel");
        this._addButton = this.createButton(this.getAddAction());
        this._addButton.setFilterAccelerators(true);
        this._deleteButton = this.createButton(this.getDeleteAction());
        this._deleteButton.setFilterAccelerators(true);
        this._copyButton = this.createButton(this.getCopyAction());
        this._copyButton.setFilterAccelerators(true);
        this._buttonPanel.setFocusable(false);
        this._buttonPanel.setLayout(new BorderLayout());
        ListLayout listLayout = new ListLayout();
        listLayout.setOrientation(orientation);
        this._upperButtonPanel = new JPanel();
        this._upperButtonPanel.setName("upperButtonsPanel");
        this._upperButtonPanel.setFocusable(false);
        this._upperButtonPanel.setLayout(listLayout);
        ListInfo info = this.getStyle().getListInfo();
        if (info != null) {
            if (info.isShowingButtons()) {
                if (info.isShowingNewButton()) {
                    this._upperButtonPanel.add(this._addButton);
                }
                if (info.isShowingCopyButton()) {
                    this._upperButtonPanel.add(this._copyButton);
                }
                if (info.isShowingDeleteButton()) {
                    this._upperButtonPanel.add(this._deleteButton);
                }
            }
        } else {
            this._upperButtonPanel.add(this._addButton);
            this._upperButtonPanel.add(this._copyButton);
            this._upperButtonPanel.add(this._deleteButton);
        }
        ListLayout listLayoutSouth = new ListLayout();
        listLayoutSouth.setOrientation(orientation);
        this._lowerButtonPanel = new JPanel();
        this._lowerButtonPanel.setName("lowerButtonsPanel");
        this._lowerButtonPanel.setFocusable(false);
        this._lowerButtonPanel.setLayout(listLayoutSouth);
        this._buttonPanel.add((Component)this._upperButtonPanel, "North");
        this._buttonPanel.add((Component)this._lowerButtonPanel, "South");
        if (this.getTableInfo() != null && this.getTableInfo().isDialogEditMode()) {
            this._editButton = this.createButton(this.getEditAction());
            if (this.getTableInfo() != null && this.getTableInfo().isShowingEditButton()) {
                this._upperButtonPanel.add(this._editButton);
            }
        }
        if (info != null && info.allowReOrdering()) {
            this._moveUpButton = this.createButton(this.getMoveUpAction());
            this._moveDownButton = this.createButton(this.getMoveDownAction());
            this._moveUpButton.setFilterAccelerators(true);
            this._moveDownButton.setFilterAccelerators(true);
            this._lowerButtonPanel.add(new JLabel(" "));
            this._lowerButtonPanel.add(this._moveUpButton);
            this._lowerButtonPanel.add(this._moveDownButton);
        }
        return this._buttonPanel;
    }

    protected JPanel createUserButtonPanel(int orientation) {
        this._userButtonPanel = new JPanel();
        this._userButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        ListLayout listLayoutSouth = new ListLayout();
        listLayoutSouth.setOrientation(orientation);
        this._userButtonPanel.setName("userButtonsPanel");
        this._userButtonPanel.setFocusable(false);
        this._userButtonPanel.setLayout(listLayoutSouth);
        Vector uActions = this.getUserActions();
        for (int u = 0; uActions != null && u < uActions.size(); ++u) {
            this._userButtonPanel.add(new JButton((Action)uActions.get(u)));
        }
        return this._userButtonPanel;
    }

    public Vector getUserActions() {
        return this._userActions;
    }

    protected JPanel createSerialChildPanel() {
        JPanel listPanel = new JPanel(new ListLayout());
        listPanel.setName("listPanel");
        FormLayoutInfo layoutInfo = (FormLayoutInfo)this.getStyle().getLayoutManager("editingType");
        if (layoutInfo != null) {
            Iterator iterator = this.getModel().getDirectChildren().iterator();
            while (iterator.hasNext()) {
                Type child = (Type)iterator.next();
                JComponent comp = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(child, this._context);
                JPanel childsPanel = this.initPanel(layoutInfo, comp);
                listPanel.add(childsPanel);
            }
        }
        return listPanel;
    }

    protected JComponent createDefaultSerialLayoutPanel() {
        JPanel defaultSerialPanel = new JPanel(new BorderLayout());
        ListInfo header = this.getStyle().getListInfo();
        defaultSerialPanel.setName("defaultSerialPanel");
        DefaultTypeListModel model = new DefaultTypeListModel((ListType)this.getModel());
        this._simpleListPanel = new SimpleJList(model, this.canModifyList());
        if (this._simpleListPanel != null && this.canModifyList()) {
            this._simpleListPanel.addPropertyChangeListener(this);
        }
        this._simpleListPanel.setSelectionEnabled(this.canModifyList() && !header.isSelectionOnly());
        this._simpleListPanel.setName("listPanel");
        this._simpleListPanel.setCellRenderer(new TypeRenderer());
        this._errorContainer = this._simpleListPanel;
        this.setEditingTypePane(this._simpleListPanel);
        JPanel controlAreaP = new JPanel(new FlowLayout(2));
        JPanel buttonHolderPanel = new JPanel(new ListLayout());
        JPanel buttonPanel = null;
        JPanel userButtonPanel = null;
        if (header == null || header.isShowingButtons() && !header.isSelectionOnly()) {
            buttonPanel = this.createButtonPanel(0);
            buttonPanel.setFocusable(false);
            buttonHolderPanel.add(buttonPanel);
        }
        if (this.getUserActions() != null) {
            userButtonPanel = this.createUserButtonPanel(0);
            buttonHolderPanel.add(userButtonPanel);
            userButtonPanel.setFocusable(false);
        }
        if (userButtonPanel != null || buttonPanel != null) {
            controlAreaP.add(buttonHolderPanel);
        }
        defaultSerialPanel.add((Component)controlAreaP, "North");
        defaultSerialPanel.add((Component)this.getEditingTypePane(), "Center");
        return defaultSerialPanel;
    }

    public boolean canModifyList() {
        ListInfo listInfo = this.getStyle().getListInfo();
        if (listInfo != null) {
            return listInfo.canModifyList();
        }
        return false;
    }

    protected JComponent createDefaultTabLayoutPanel() {
        this.getDOM().addDOMChangeListener((DOMChangeListener)this);
        JPanel defaultTabLayoutPanel = new JPanel(new BorderLayout());
        int childSize = this.getModel().getDirectChildren().size();
        if (childSize == 0) {
            ((ListType)this.getModel()).addNewChild();
        }
        List childs = this.getModel().getDirectChildren();
        for (int i = 0; i < childs.size(); ++i) {
            Type child = (Type)childs.get(i);
            this.addTab(child);
        }
        if (this.getTabbedPane().getTabCount() > 0) {
            this.getTabbedPane().setSelectedIndex(0);
        }
        this.getTabbedPane().setPopUpMenu(this.createDefaultPopUpMenu());
        defaultTabLayoutPanel.add((Component)this.getTabbedPane(), "Center");
        return defaultTabLayoutPanel;
    }

    protected JPanel initPanel(FormLayoutInfo layoutInfo, JComponent editingVisualizer) {
        List cols = layoutInfo.getColumns();
        double[] col = new double[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            col[i] = (Double)cols.get(i);
        }
        List rows = layoutInfo.getRows();
        double[] row = new double[rows.size()];
        for (int i = 0; i < rows.size(); ++i) {
            row[i] = (Double)rows.get(i);
        }
        String columnSpec = null;
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < col.length; ++i) {
            if (col[i] < 1.0) {
                buffer.append("0:g(");
                buffer.append(col[i]);
                buffer.append(")");
            } else {
                buffer.append((int)col[i] + "px");
            }
            if (i == col.length - 1) continue;
            buffer.append(",");
        }
        if (buffer.length() > 0) {
            columnSpec = buffer.toString();
        }
        String rowSpec = null;
        StringBuffer rowBuffer = new StringBuffer();
        for (int j = 0; j < row.length; ++j) {
            double value = row[j];
            if (value < 0.0) {
                rowBuffer.append("pref");
            } else {
                rowBuffer.append((int)value + "px");
            }
            if (j == row.length - 1) continue;
            rowBuffer.append(",");
        }
        if (rowBuffer.length() > 0) {
            rowSpec = rowBuffer.toString();
        }
        FormLayout tableLayout = new FormLayout(columnSpec, rowSpec);
        JPanel panel = new JPanel(tableLayout);
        panel.setName("tableLayoutPanel");
        List cellList = layoutInfo.getCells();
        for (int i = 0; i < cellList.size(); ++i) {
            FormLayoutBuilder.addTableCell(this, this.getModel(), this._context, (TableCell)cellList.get(i), panel, editingVisualizer);
        }
        panel.updateUI();
        return panel;
    }

    protected void defaultBuild() {
        boolean isEditable;
        this.setLayout(new BorderLayout());
        this.setName("mainVisualizerPanel");
        List uActions = this.getStyle().getUserListActions();
        if (uActions != null) {
            this._userActions = new Vector(uActions.size());
            for (int u = 0; u < uActions.size(); ++u) {
                ListViewAction lAction = (ListViewAction)JavaAction.createActionObject((ActionDefinition)((ActionDefinition)uActions.get(u)), (ClassLoader)this.getDOM().getCustomClassloader());
                if (lAction == null) continue;
                lAction.setListType(this.getListModel());
                this.getUserActions().add(lAction);
            }
        }
        JComponent editorComponent = this.createEditorComponent();
        StyleDefinition style = this.getStyle();
        float indent = style.getCaptionIndentValue();
        String columnSpec = "" + indent + "px," + "fill:default:grow";
        JPanel componentHolderPanel = new JPanel(new FormLayout(columnSpec, "f:p:g"));
        componentHolderPanel.setName("componentHolderPanel");
        componentHolderPanel.add((Component)editorComponent, "2,1");
        this.setParentTablePanel(componentHolderPanel);
        JComponent listHolderPanel = null;
        if (style.hasCaption()) {
            if (style.isCaptionTypeBorder()) {
                listHolderPanel = this.getCaptionPanel(editorComponent);
                this.setParentTablePanel(editorComponent);
            } else {
                listHolderPanel = this.getCaptionPanel(componentHolderPanel);
            }
        } else {
            listHolderPanel = componentHolderPanel;
        }
        if (listHolderPanel != null) {
            this.add((Component)listHolderPanel, "Center");
        }
        if (!(isEditable = style.isEditable())) {
            this.setEditable(isEditable);
        }
        this.setFirstFocusableComponent(this);
        this.addFocusListener(this);
    }

    private JPopupMenu getPopUpMenu() {
        if (this._popUpMenu == null) {
            this._popUpMenu = new JPopupMenu("------");
            this._popUpMenu.addPopupMenuListener(this);
        }
        return this._popUpMenu;
    }

    private JPopupMenu createDefaultPopUpMenu() {
        this._popUpMenu = this.getPopUpMenu();
        this._popUpMenu.add(new JMenuItem(this.getAddAction()));
        this._popUpMenu.add(new JMenuItem(this.getCopyAction()));
        this._popUpMenu.add(new JMenuItem(this.getDeleteAction()));
        if (this._editAction != null) {
            this._popUpMenu.addSeparator();
            this._popUpMenu.add(new JMenuItem(this._editAction));
        }
        this._popUpMenu.addSeparator();
        this._popUpMenu.add(new JMenuItem(this.getCopyContentAction()));
        this._popUpMenu.add(new JMenuItem(this.getPasteContentAction()));
        this._popUpMenu.addPopupMenuListener(this);
        return this._popUpMenu;
    }

    private JPopupMenu createUserPopUpMenu() {
        if (this.getUserActions() != null) {
            if (this._popUpMenu != null) {
                this.getPopUpMenu().addSeparator();
            }
            for (int us = 0; us < this.getUserActions().size(); ++us) {
                this.getPopUpMenu().add(new JMenuItem((Action)this.getUserActions().get(us)));
            }
        }
        return this._popUpMenu;
    }

    public PopUpListener getPopUpListener() {
        JPopupMenu menu = null;
        if (this._popUpListener == null) {
            if (this.getModel().getStyle().isEditable() && (this.getModel().getStyle().getTableInfo() == null || !this.getModel().getStyle().getTableInfo().isSelectionOnly())) {
                menu = this.createDefaultPopUpMenu();
            }
            if (this.getUserActions() != null) {
                menu = this.createUserPopUpMenu();
            }
            if (menu != null) {
                this._popUpListener = new PopUpListener(menu);
            }
        }
        return this._popUpListener;
    }

    private Type editObject() {
        Type selectedType = null;
        if (this._currentSelection != null && this._currentSelection.size() > 0 && this._currentSelection.get(0) != null) {
            selectedType = (Type)this._currentSelection.get(0);
            this.highlightTreeEntry(selectedType);
            this._editButton.requestFocus();
            JDialog editDialog = this.getEditDialog(selectedType, null);
            this.getDOM().getController().blockDirtyChange(true);
            editDialog.setVisible(true);
        }
        return selectedType;
    }

    public JDialog getEditDialog(Type selectedType, Type context) {
        return this.getEditDialog(selectedType, context, false);
    }

    private boolean hasEditButton() {
        return this.getStyle().isDialogMode();
    }

    private JAXJDialog getEditDialog() {
        if (this._editDialog == null) {
            Window parentWindow = this.getEditor().getWindow();
            if (parentWindow == null) {
                parentWindow = SwingUtilities.getWindowAncestor(this);
            }
            this._editDialog = GUITools.createDialogFor(parentWindow, true, this.getModel().getName());
            this._editDialog.addWindowListener(new WindowListener(){

                public void windowActivated(WindowEvent e) {
                }

                public void windowClosed(WindowEvent e) {
                }

                public void windowClosing(WindowEvent e) {
                    AbstractListTypeView.this.cancelDialogChanges();
                }

                public void windowDeactivated(WindowEvent e) {
                }

                public void windowDeiconified(WindowEvent e) {
                }

                public void windowIconified(WindowEvent e) {
                }

                public void windowOpened(WindowEvent e) {
                }
            });
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            this._editDialog.getRootPane().registerKeyboardAction(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractListTypeView.this.cancelDialogChanges();
                }
            }, stroke, 2);
            this.getEditDialog().getContentPane().add((Component)this.getEditButtonPanel(), "South");
            String title = this.getStyle().getDialogLabel();
            this.getEditDialog().setTitle(title);
        }
        return this._editDialog;
    }

    private JPanel getEditButtonPanel() {
        if (this._editButtonPanel == null) {
            this._editButtonPanel = new JPanel(new BorderLayout());
            this._editButtonPanel.setName("editButtonPanel");
            JAXJButton okButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_ok", "Ok"));
            JAXJButton cancelButton = new JAXJButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_cancel", "Cancel"));
            this.addButtonKeyListener(okButton);
            this.addButtonKeyListener(cancelButton);
            okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractListTypeView.this.commitDialogChanges();
                }
            });
            cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AbstractListTypeView.this.cancelDialogChanges();
                }
            });
            String okButtonAlignment = this.getStyle().getTableInfo().getOkButtonAlignment();
            String cancelButtonAlignment = this.getStyle().getTableInfo().getCancelButtonAlignment();
            if (okButtonAlignment.equalsIgnoreCase(cancelButtonAlignment)) {
                JPanel buttonBoxPanel = new JPanel();
                buttonBoxPanel.setName("buttonBoxPanel");
                buttonBoxPanel.setLayout(new BoxLayout(buttonBoxPanel, 0));
                if (this.getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                    buttonBoxPanel.add(okButton);
                    buttonBoxPanel.add(cancelButton);
                } else {
                    buttonBoxPanel.add(cancelButton);
                    buttonBoxPanel.add(okButton);
                }
                if (okButtonAlignment.equalsIgnoreCase("left")) {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "West");
                } else if (okButtonAlignment.equalsIgnoreCase("right")) {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "East");
                } else {
                    this._editButtonPanel.add((Component)buttonBoxPanel, "Center");
                }
            } else if (this.getStyle().getTableInfo().getOkButtonSeqPos() == 0) {
                if (okButtonAlignment.equalsIgnoreCase("left") && (cancelButtonAlignment.equalsIgnoreCase("right") || cancelButtonAlignment.equalsIgnoreCase("none"))) {
                    this._editButtonPanel.add((Component)okButton, "West");
                    this._editButtonPanel.add((Component)cancelButton, "East");
                }
            } else if (okButtonAlignment.equalsIgnoreCase("right") && (cancelButtonAlignment.equalsIgnoreCase("left") || cancelButtonAlignment.equalsIgnoreCase("none"))) {
                this._editButtonPanel.add((Component)okButton, "East");
                this._editButtonPanel.add((Component)cancelButton, "West");
            }
            if (cancelButtonAlignment.equals("none")) {
                cancelButton.setVisible(false);
            }
        }
        return this._editButtonPanel;
    }

    public JDialog getEditDialog(Type selectedType, Type context, boolean isAdding) {
        JAXJDialog editDialog = this.getEditDialog();
        this._isAdding = isAdding;
        this._editingType = selectedType;
        this.keepOriginalElement(selectedType);
        if (context == null) {
            context = this._context;
        }
        JComponent visualizer = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(selectedType, context);
        this.getEditDialog().getContentPane().removeAll();
        JScrollPane scroller = new JScrollPane(this.createIndentedComponent(visualizer));
        editDialog.getContentPane().add((Component)scroller, "Center");
        editDialog.getContentPane().add((Component)this.getEditButtonPanel(), "South");
        GUITools.applyDialogGUIPersistency(this.getModel(), editDialog, visualizer, this.getModel().getName());
        GUITools.applySWTSwingModalDialog(editDialog);
        return editDialog;
    }

    private JWindow getPopUpDerrivedTypesWindow() {
        if (this._popUpWindow == null) {
            ListType listType = (ListType)this.getModel();
            Type type = listType.getEditingType();
            type.setDOM(listType.getDOM());
            this._comboBox = AbstractListTypeView.getDerrivedTypesComboBox(this, type, null);
            this._addButton.addAncestorListener(this);
            this._popUpWindow = new JWindow(this.getEditor().getWindow());
            this.getEditor().getWindow().addWindowListener(this);
            this._popUpWindow.getContentPane().setLayout(new ListLayout());
            this._popUpWindow.getContentPane().add(this._comboBox);
            this._comboBox.addFocusListener(this);
        }
        try {
            int xLocation = (int)this._addButton.getLocationOnScreen().getX();
            int yLocation = (int)this._addButton.getLocationOnScreen().getY();
            xLocation = xLocation - (int)this._comboBox.getPreferredSize().getWidth() + this._addButton.getWidth();
            this._popUpWindow.setBounds(xLocation, yLocation += this._addButton.getHeight(), (int)this._comboBox.getPreferredSize().getWidth(), (int)this._comboBox.getPreferredSize().getHeight());
        }
        catch (IllegalComponentStateException illegalComponentStateException) {
            // empty catch block
        }
        return this._popUpWindow;
    }

    public Type getSelectedType() {
        Type selected = null;
        if (this._simpleListPanel != null) {
            Vector selection = this._simpleListPanel.getSelectedItems();
            if (selection.size() > 0) {
                selected = (Type)selection.get(0);
            }
        } else if (this.getStyle().isUsingTabList()) {
            if (this.getTabbedPane().getSelectedTabType() != null) {
                selected = this.getTabbedPane().getSelectedTabType();
            }
        } else if (this._currentSelection != null && this._currentSelection.size() > 0) {
            selected = (Type)this._currentSelection.get(0);
        }
        return selected;
    }

    public Type getSelectedTabType() {
        if (this.getStyle().isUsingTabList() && this.getTabbedPane().getSelectedTabType() != null) {
            return this.getTabbedPane().getSelectedTabType();
        }
        return null;
    }

    public void handleButtonEnabling() {
        if (this.getDataTable() != null) {
            ListSelectionModel selectionModel = this.getDataTable().getSelectionModel();
            if (selectionModel != null) {
                int selection = selectionModel.getLeadSelectionIndex();
                this.handleButtonEnabling(selection);
            }
        } else if (this._tabbedPane != null) {
            this.handleButtonEnabling(this._tabbedPane.getSelectedIndex());
        } else {
            this.handleButtonEnabling(-1);
        }
    }

    protected void handleButtonEnabling(int selected) {
        ListType lm = (ListType)this.getModel();
        boolean isSingleItemSelected = this.getSelectedTypes().size() == 1;
        boolean canAdd = !lm.violateCardinality(1);
        boolean canCopy = canAdd && selected >= 0;
        boolean canEdit = selected >= 0;
        boolean canDelete = !lm.violateCardinality(-1) && selected >= 0 && lm.getDirectChildren().size() > 0;
        boolean canMoveUp = false;
        boolean canMoveDown = false;
        Type selectedType = this.getSelectedType();
        boolean canPasteContent = this.getDOM().getClipBoard().canPaste(selectedType);
        ListInfo info = this.getStyle().getListInfo();
        if (lm.getDirectChildren().size() <= 1) {
            canMoveUp = false;
            canMoveDown = false;
        } else {
            canMoveUp = isSingleItemSelected;
            canMoveDown = isSingleItemSelected;
        }
        if (info != null) {
            if (info.isShowingButtons() && !info.isSelectionOnly()) {
                canAdd = canAdd && info.isShowingNewButton();
                canDelete = canDelete && info.isShowingDeleteButton();
                canCopy = canCopy && info.isShowingCopyButton();
            } else {
                canMoveDown = false;
                canMoveUp = false;
                canDelete = false;
                canEdit = false;
                canCopy = false;
                canAdd = false;
            }
        }
        if (this.getStyle().isSelectionOnly()) {
            canMoveDown = false;
            canMoveUp = false;
            canDelete = false;
            canEdit = false;
            canCopy = false;
            canAdd = false;
        }
        if (!isSingleItemSelected) {
            canMoveDown = false;
            canMoveUp = false;
            canEdit = false;
        }
        if (this.getSelectedTypes().size() <= 0) {
            canDelete = false;
            canEdit = false;
            canCopy = false;
        }
        this.getAddAction().setEnabled(canAdd);
        if (this._addButton != null) {
            this._addButton.setEnabled(canAdd);
        }
        this.getDeleteAction().setEnabled(canDelete);
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(canDelete);
        }
        this.getCopyAction().setEnabled(canCopy);
        if (this._copyButton != null) {
            this._copyButton.setEnabled(canCopy);
        }
        if (this._editAction != null) {
            this.getEditAction().setEnabled(canEdit);
            if (this._editButton != null) {
                this._editButton.setEnabled(canEdit);
            }
        }
        if (this._moveUpAction != null) {
            this._moveUpAction.setEnabled(canMoveUp);
        }
        if (this._moveDownAction != null) {
            this._moveDownAction.setEnabled(canMoveDown);
        }
        if (this._moveUpButton != null) {
            this._moveUpButton.setEnabled(canMoveUp);
        }
        if (this._moveDownButton != null) {
            this._moveDownButton.setEnabled(canMoveDown);
        }
        if (this._pasteContentAction != null) {
            this._pasteContentAction.setEnabled(canPasteContent);
        }
    }

    public Vector getSelectedTypes() {
        Vector selection = new Vector();
        if (this._simpleListPanel != null) {
            return this._simpleListPanel.getSelectedItems();
        }
        if (this.getStyle().isUsingTabList()) {
            if (this.getTabbedPane().getSelectedTabType() != null) {
                selection = new Vector();
                selection.add(this.getTabbedPane().getSelectedTabType());
            }
        } else if (this._currentSelection != null && this._currentSelection.size() > 0) {
            selection = (Vector)this._currentSelection.clone();
        }
        return selection;
    }

    protected void initTable() {
        int listStartSize;
        ListType listType = (ListType)this.getModel();
        FlipOrientationTableModel model = null;
        try {
            String className = listType.getStyle().getTableModelClass();
            Class[] paramClass = new Class[]{AbstractListType.class};
            Object[] params = new Object[]{listType};
            model = (FlipOrientationTableModel)Class.forName(className).getConstructor(paramClass).newInstance(params);
        }
        catch (Exception e) {
            LogRegistry.getInstance().warn(this.getClass(), "Model could not be created, reason = " + e.getMessage());
            model = new FlipOrientationTableModel(listType);
        }
        if (this.getStyle().isDialogMode()) {
            this._dialogLocation = model.getTableInfo().getDialogLocation();
            this._dialogSize = model.getTableInfo().getDialogSize();
        }
        if ((listStartSize = model.getTableInfo().getTableSize()) == -1 && (listStartSize = this.getListModel().size()) > 100) {
            listStartSize = 100;
        }
        this._list = new RowHeadedTable(model, this, listStartSize);
        int listHeight = this.calculateListHeight(this._list);
        if (listHeight >= 0) {
            this._list.getViewport().setPreferredSize(new Dimension(this._list.getWidth(), listHeight));
        }
        this._list.setFocusable(false);
        if (this.needsDoAtVisualization()) {
            this.addComponentListener(this);
        }
        this._errorContainer = this._list;
    }

    public boolean isDialogEditMode() {
        return this.getStyle().hasHeader() && this.getStyle().getTableInfo().isDialogEditMode();
    }

    private void keepOriginalElement(Type selectedType) {
        try {
            selectedType.getDOM().setIsBinding(true);
            this._originalType = selectedType.deepClone(null, true, true);
            selectedType.getDOM().setIsBinding(false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public void markError() {
        Border border = BorderFactory.createEtchedBorder(this.getDOM().getErrorMarkingColor(), Color.lightGray);
        if (this._errorContainer != null) {
            this._originalBorder = this._errorContainer.getBorder();
            this._errorContainer.setBorder(border);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (this._list != null && e.getSource() == this._list.getDataTable() && !e.isConsumed() && e.getClickCount() == 2 && this.getStyle().isDialogMode()) {
            this.editObject();
            e.consume();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
        if (this._list != null && this._list.getDataTable() != null && this._list.getDataTable() instanceof AbstractListTypeTable) {
            this._list.getDataTable().getDefaultEditor(SimpleType.class);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void populateModel() {
    }

    public void populateView() {
        Iterator composites = ((ListType)this.getModel()).getList().iterator();
        while (composites.hasNext()) {
            Vector possibleTargetVis = TypeVisualizerFactory.getInstance().getAllVisualizers((Type)composites.next());
            for (int pt = 0; pt < possibleTargetVis.size(); ++pt) {
                Visualizer visualizer = (Visualizer)possibleTargetVis.get(pt);
                if (visualizer == null) continue;
                visualizer.populateView();
            }
        }
        if (this._list != null) {
            this._list.refresh();
        }
        this.handleButtonEnabling();
    }

    private void popUpDerrivedTypes() {
        if (this._comboBox != null) {
            this._comboBox.setSelectedIndex(-1);
        }
        this.getPopUpDerrivedTypesWindow().setVisible(true);
    }

    public void removeButtonPanel() {
        if (this._buttonPanel != null) {
            Container container = this._buttonPanel.getParent();
            if (container.getLayout() instanceof FormLayout && ((FormLayout)container.getLayout()).getColumnCount() > 1) {
                ((FormLayout)container.getLayout()).removeColumn(2);
            }
            container.remove(this._buttonPanel);
            this._buttonPanel = null;
            this.updateUI();
        }
    }

    public void resetError() {
        if (this._errorContainer != null) {
            this._errorContainer.setBorder(this._originalBorder);
        }
    }

    public void setBorder(Border border) {
        if (this._contentPanel != null) {
            this._contentPanel.setBorder(border);
        }
    }

    public void showModel(Type model) {
        this.showModel(model, false);
    }

    private void showModel(Type model, boolean isUserAction) {
        boolean updateUI = false;
        boolean wasHighlight = this.getEditor().isHighLightMode();
        if (isUserAction) {
            this.getEditor().setHighLightMode(true);
        }
        if (this.getEditingTypePane() != null) {
            if (model == null) {
                this.getEditingTypePane().removeAll();
            }
            if (this.getEditingTypePane().getComponentCount() == 0 || model == null) {
                updateUI = true;
            }
            if (model != null) {
                FormLayoutInfo layoutInfo;
                this._visualizer = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(model, this._context);
                if (!(this._visualizer == null || this.getStyle().hasHeader() && this.getStyle().getTableInfo().isDialogEditMode() || !this.getStyle().isTableLayout() || (layoutInfo = (FormLayoutInfo)this.getStyle().getLayoutManager("editingType")) == null)) {
                    JPanel tempPanel = this.initPanel(layoutInfo, this._visualizer);
                    this._visualizer = tempPanel;
                }
            } else {
                this._visualizer = null;
            }
            if (!this.getStyle().isUsingSerialList()) {
                this.getEditingTypePane().removeAll();
                if (this._visualizer != null) {
                    this.getEditingTypePane().add((Component)this._visualizer, "Center");
                }
            }
            this.getEditingTypePane().validate();
            this.updateUI();
            if (updateUI && this.getSplitPane() != null) {
                String tablePosition = this.getStyle().getTablePosition();
                if (tablePosition.equals("south")) {
                    boolean isSelfViewHolder = this.getStyle().isSelfViewHolder();
                    if (this._visualizer == null) {
                        this.getSplitPane().setDividerLocation(0);
                        if (isSelfViewHolder) {
                            this._southOrientationSplitPane.setDividerLocation((int)this.getSplitPane().getBottomComponent().getPreferredSize().getHeight());
                        }
                    } else {
                        this.getSplitPane().setDividerLocation((int)this._visualizer.getPreferredSize().getHeight());
                        if (isSelfViewHolder) {
                            this._southOrientationSplitPane.setDividerLocation((int)this.getSplitPane().getBottomComponent().getPreferredSize().getHeight() + this.getSplitPane().getDividerLocation() + this._southOrientationSplitPane.getDividerSize());
                        }
                    }
                } else if (tablePosition.equals("north") && this._list.isFlipped()) {
                    this.getSplitPane().setDividerLocation((int)((JComponent)this.getSplitPane().getTopComponent()).getPreferredSize().getHeight());
                }
                this.getSplitPane().updateUI();
                this.getSplitPane().setBorder(null);
            }
        }
        if (!wasHighlight) {
            this.getEditor().setHighLightMode(false);
        }
    }

    public void setEnabled(boolean enabled) {
        if (this._visualizer != null) {
            this._visualizer.setEnabled(enabled);
        }
        if (this._addButton != null) {
            this._addButton.setEnabled(enabled);
        }
        if (this._editButton != null) {
            this._editButton.setEnabled(enabled);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setEnabled(enabled);
        }
        if (this._copyButton != null) {
            this._copyButton.setEnabled(enabled);
        }
        if (this._moveDownButton != null) {
            this._moveDownButton.setEnabled(enabled);
        }
        if (this._editDialog != null) {
            this._editDialog.setEnabled(enabled);
        }
        this.handleButtonEnabling();
        if (this._list != null) {
            this._list.setEnabled(enabled);
        }
        if (this.getEditingTypePane() != null) {
            this.getEditingTypePane().setEnabled(enabled);
        }
        if (this._borderPanel != null && this._borderPanel.getBorder() != null) {
            this._borderPanel.setEnabled(enabled);
        }
        if (this.getStyle().isUsingSerialList()) {
            Iterator iterator = this.getModel().getDirectChildren().iterator();
            while (iterator.hasNext()) {
                Type child = (Type)iterator.next();
                JComponent comp = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(child, this._context);
                comp.setEnabled(enabled);
            }
        }
    }

    public void setEditable(boolean editable) {
        if (this._addButton != null) {
            this._addButton.setEditable(editable);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setEditable(editable);
        }
        if (this._copyButton != null) {
            this._copyButton.setEditable(editable);
        }
        if (this._comboBox != null) {
            this._comboBox.setEditable(editable, false);
        }
        if (this._moveUpButton != null) {
            this._moveUpButton.setEditable(editable);
        }
        if (this._moveDownButton != null) {
            this._moveDownButton.setEditable(editable);
        }
        Iterator iterator = this.getModel().getDirectChildren().iterator();
        while (iterator.hasNext()) {
            Type child = (Type)iterator.next();
            Vector possibleTargetVis = TypeVisualizerFactory.getInstance().getAllVisualizers(child);
            for (int pt = 0; pt < possibleTargetVis.size(); ++pt) {
                Visualizer view = (Visualizer)possibleTargetVis.get(pt);
                if (view == null) continue;
                view.setEditable(editable);
            }
        }
    }

    public void setLabelColor(Color color) {
    }

    public void setRequired(boolean aBoolean) {
    }

    public void setApplicationRequired(boolean aBoolean) {
    }

    public void showLabel(boolean show) {
        if (show) {
            this.setBorder(this.border);
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void releaseButton(JAXJButton button) {
        if (button != null) {
            button.removeFocusListener(this);
        }
    }

    public void release() {
        if (this._popUpWindow != null) {
            this._popUpWindow.removeWindowListener(this);
            this._comboBox.removeFocusListener(this);
            this._popUpWindow = null;
            this._comboBox = null;
            this._addButton.removeAncestorListener(this);
        }
        if (this._visualizer != null && this._visualizer instanceof Visualizer) {
            ((Visualizer)this._visualizer).release();
            this._visualizer = null;
        }
        if (this._tabbedPane != null) {
            this._tabbedPane.removeChangeListener(this);
            this._tabbedPane = null;
        }
        if (this._simpleListPanel != null) {
            this._simpleListPanel.removePropertyChangeListener(this);
        }
        if (this._buttonListeners != null) {
            this._buttonListeners = null;
        }
        this.releaseButton(this._addButton);
        this.releaseButton(this._editButton);
        this.releaseButton(this._deleteButton);
        this.releaseButton(this._copyButton);
        this.releaseButton(this._moveUpButton);
        this.releaseButton(this._moveDownButton);
        this._addButton = null;
        this._editButton = null;
        this._deleteButton = null;
        this._copyButton = null;
        this._borderPanel = null;
        this._buttonPanel = null;
        if (this._editDialog != null) {
            this._editDialog.dispose();
            this._editDialog = null;
        }
        this._editButtonPanel = null;
        this._editingType = null;
        if (this._originalType != null) {
            this._originalType = null;
        }
        this._tableModel = null;
        this._contentPanel = null;
        this.border = null;
        this._currentSelection = null;
        if (this._list != null) {
            this._list.release();
            this._list = null;
        }
        this.setEditingTypePane(null);
        this._dialogLocation = null;
        this._dialogSize = null;
        super.release();
    }

    protected JComponent createEditorComponent() {
        StyleDefinition style = this.getStyle();
        if (style.isUsingTableList()) {
            return this.createDefaultTableLayoutPanel();
        }
        if (style.isUsingSerialList()) {
            return this.createDefaultSerialLayoutPanel();
        }
        if (style.isUsingTabList()) {
            return this.createDefaultTabLayoutPanel();
        }
        if (style.isListTableVisible()) {
            this.setEditingTypePane(new JPanel(new BorderLayout()));
            this.getEditingTypePane().setName("editingTypePane");
            this.getEditingTypePane().setBorder(null);
            this.getEditingTypePane().setFocusable(false);
            return this.getEditingTypePane();
        }
        return this.createDefaultTableLayoutPanel();
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }

    public void showTab(Type selectedType, Object component) {
        Component swingComponent = (Component)component;
        if (component instanceof Visualizer) {
            Type aTabType = ((Visualizer)swingComponent).getModel();
            this.selectTab(aTabType);
        } else {
            int tabIndex = this.getTabbedPane().indexOfComponent(swingComponent);
            if (tabIndex >= 0) {
                this.getTabbedPane().setSelectedIndex(tabIndex);
            }
        }
    }

    public void showUpDownButtons(boolean showUpDownButtons) {
        if (this._moveDownButton != null) {
            this._moveDownButton.setVisible(showUpDownButtons);
        }
        if (this._moveUpButton != null) {
            this._moveUpButton.setVisible(showUpDownButtons);
        }
    }

    public void selectType(Type model) {
        this.selectType(model, true);
    }

    public void selectType(Type model, boolean isUserAction) {
        if (this._list != null && model != null) {
            if (this.getStyle().isUsingTableList()) {
                ListType listModel = (ListType)this.getModel();
                int typeIndex = listModel.getList().indexOf(model);
                int rowIndex = ((TableSorter)this._list.getDataTable().getModel()).getOriginalRowIndexPos(typeIndex);
                if (!isUserAction) {
                    this._list.getSelectionModel().removeListSelectionListener(this);
                    this._list.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                    this.valueChanged(false, (DefaultListSelectionModel)this._list.getSelectionModel());
                    this._list.getSelectionModel().addListSelectionListener(this);
                } else {
                    this._list.getSelectionModel().setSelectionInterval(rowIndex, rowIndex);
                }
                this._list.scrollToSelection(rowIndex);
            } else if (this.getStyle().isUsingTabList()) {
                this.setAllowTreeNodeHighlighting(!isUserAction);
                this.selectTab(model);
                this.setAllowTreeNodeHighlighting(true);
            }
        }
        if (this._list == null) {
            if (this.getStyle().isUsingTabList()) {
                this.setAllowTreeNodeHighlighting(!isUserAction);
                this.selectTab(model);
                this.setAllowTreeNodeHighlighting(true);
            } else {
                this._selected = true;
                this.displayModel(true, model, isUserAction);
            }
        }
    }

    protected JComponent createDefaultTableLayoutPanel() {
        JPanel defaultTableLayoutPanel = null;
        JPanel listHolderPanel = null;
        JPanel buttonPanel = null;
        JPanel userButtonPanel = null;
        JPanel buttonHolderPanel = new JPanel(new ListLayout());
        TableInfo header = this.getStyle().getTableInfo();
        if (header == null || header.isShowingButtons()) {
            buttonPanel = this.createButtonPanel(1);
            buttonPanel.setFocusable(false);
        }
        if (this.getUserActions() != null) {
            userButtonPanel = this.createUserButtonPanel(1);
            userButtonPanel.setFocusable(false);
        }
        listHolderPanel = new JPanel(new BorderLayout());
        listHolderPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        listHolderPanel.setName("listHolderPanel");
        listHolderPanel.setFocusable(false);
        this.initTable();
        if (this._list != null) {
            listHolderPanel.add((Component)this._list, "Center");
        }
        if (buttonPanel != null) {
            buttonHolderPanel.add(buttonPanel);
            this._list.setMinimumSize(new Dimension((int)this._list.getMinimumSize().getWidth(), (int)buttonPanel.getPreferredSize().getHeight()));
        }
        if (userButtonPanel != null) {
            buttonHolderPanel.add(userButtonPanel);
            this._list.setMinimumSize(new Dimension((int)this._list.getMinimumSize().getWidth(), (int)userButtonPanel.getPreferredSize().getHeight()));
        }
        if (userButtonPanel != null || buttonPanel != null) {
            listHolderPanel.add((Component)buttonHolderPanel, "East");
        }
        if (this.isDialogEditMode()) {
            defaultTableLayoutPanel = this.getStyle().isSelfViewHolder() ? this.getSelfViwHolPanel(listHolderPanel, buttonPanel) : listHolderPanel;
        } else if (this.getStyle().getListInfo() == null || !this.getStyle().getListInfo().hideEditorPanel()) {
            this.createEditingTypePane();
            defaultTableLayoutPanel = this.createSplitPanelForTable(listHolderPanel);
        } else {
            defaultTableLayoutPanel = listHolderPanel;
        }
        if (this._list != null && header != null && (header.isSelectionOnly() || !header.isShowingButtons())) {
            this._list.getDataTable().getTableHeader().setReorderingAllowed(false);
        }
        this.registerSelectAllAction();
        return defaultTableLayoutPanel;
    }

    private JPanel getSelfViwHolPanel(JPanel listHolderPanel, JPanel buttonPanel) {
        int buttonPanelHeight;
        int listHeight = (int)this._list.getPreferredSize().getHeight() + 32;
        if (buttonPanel != null && (buttonPanelHeight = (int)buttonPanel.getPreferredSize().getHeight()) > listHeight) {
            listHeight = buttonPanelHeight;
        }
        FormLayout formLayout = new FormLayout("f:p:g", "" + listHeight);
        JPanel topViewHolderPanel = new JPanel(formLayout);
        topViewHolderPanel.add((Component)listHolderPanel, "1,1,f,t");
        return topViewHolderPanel;
    }

    private void createEditingTypePane() {
        this.setEditingTypePane(new JPanel(new BorderLayout()));
        this.getEditingTypePane().setName("editingTypePane");
        this.getEditingTypePane().setBorder(null);
        this.getEditingTypePane().setFocusable(false);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            DefaultListSelectionModel m = (DefaultListSelectionModel)e.getSource();
            try {
                if (m.getMaxSelectionIndex() == -1) {
                    this.showModel(null);
                    this.valueChanged(true, m);
                } else {
                    this.valueChanged(true, m);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.getUserActions() != null) {
            Vector uAs = this.getUserActions();
            for (int u = 0; u < uAs.size(); ++u) {
                ((ListViewAction)uAs.get(u)).valueChanged(e);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        super.itemStateChanged(e);
        if (this.getUserActions() != null) {
            Vector uAs = this.getUserActions();
            for (int u = 0; u < uAs.size(); ++u) {
                ((ListViewAction)uAs.get(u)).itemStateChanged(e);
            }
        }
    }

    public void setDialogSize(int width, int height) {
        this._dialogSize = new Dimension(width, height);
        this.getTableInfo().setDialogSize(width, height);
        if (this._editDialog != null) {
            this._editDialog.setSize(this._dialogSize);
        }
    }

    public void setDialogLcation(int x, int y) {
        this._dialogLocation = new Point(x, y);
        this.getTableInfo().setDialogLocation(x, y);
        if (this._editDialog != null) {
            this._editDialog.setLocation(this._dialogLocation);
        }
    }

    private void valueChanged(boolean isUserAction, DefaultListSelectionModel selectionModel) {
        int anchor;
        ListType listModel = (ListType)this.getModel();
        boolean showModel = true;
        if (this.getEditingTypePane() != null) {
            if (!this.getStyle().isPanelMode()) {
                this.getEditingTypePane().setVisible(false);
                showModel = false;
            } else {
                this.getEditingTypePane().setVisible(true);
            }
        }
        this._currentSelection.clear();
        int leadSelectionIndex = selectionModel.getLeadSelectionIndex();
        this._lastSelection = anchor = selectionModel.getAnchorSelectionIndex();
        if (leadSelectionIndex < anchor) {
            int z = leadSelectionIndex;
            leadSelectionIndex = anchor;
            anchor = z;
        }
        this._selected = false;
        int rowIndex = 0;
        for (int i = 0; i <= selectionModel.getMaxSelectionIndex(); ++i) {
            if (!selectionModel.isSelectedIndex(i)) continue;
            this._selected = true;
            rowIndex = ((TableSorter)this._list.getDataTable().getModel()).getOriginalRowIndex(i);
            Type selectedType = (Type)listModel.getList().get(rowIndex);
            this._currentSelection.addElement(selectedType);
        }
        if (this._list != null && this._lastSelection < listModel.getList().size() && this._lastSelection >= 0) {
            rowIndex = ((TableSorter)this._list.getDataTable().getModel()).getOriginalRowIndex(this._lastSelection);
            Type selectedModel = (Type)listModel.getList().get(rowIndex);
            if (selectedModel != null && selectedModel.getClientProperty("listItem-disabled") == null) {
                this.displayModel(showModel, selectedModel, isUserAction);
                this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_ITEM_SELECTED((Type)selectedModel));
            }
        }
        this.handleButtonEnabling();
    }

    private void displayModel(boolean showModel, Type selectedModel, boolean isUserAction) {
        ListType listModel = (ListType)this.getModel();
        if (this._selected && listModel.getStyle().isPanelMode()) {
            if (showModel) {
                this.showModel(selectedModel, isUserAction);
            }
            try {
                if (this.getDOM().getEditor() != null && this.getDOM().getEditor().getWindow() != null) {
                    this.getDOM().getEditor().getWindow().validate();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (selectedModel != null && selectedModel.getDOM().getGlobalDefinition().isShowingTree() && selectedModel.getStyle().isRepresentedAsTreeNode() && this.getDOM() != null && this.getDOM().getEditor() != null) {
            ((AbstractEditorPanel)this.getDOM().getEditor()).selectNode(selectedModel, isUserAction);
        }
    }

    protected JPanel createSplitPanelForTable(JComponent childComponents) {
        JPanel splitPanePanel = new JPanel(new BorderLayout());
        String tablePosition = this.getStyle().getTablePosition();
        int alignment = tablePosition.equals("north") || tablePosition.equals("south") ? 0 : 1;
        this._splitPane = new JAXJSplitPane(alignment);
        this._splitPane.setBorder(null);
        childComponents.setBorder(null);
        JComponent editingTypePane = this.getEditingTypePane();
        double dividerLocation = 0.5;
        boolean isSelfViewHolder = this.getStyle().isSelfViewHolder();
        if (tablePosition.equals("north")) {
            this._splitPane.setTopComponent(childComponents);
            this._splitPane.setBottomComponent(editingTypePane);
            if (!isSelfViewHolder) {
                this._splitPane.setEnabled(false);
            }
        } else if (tablePosition.equals("south")) {
            this._splitPane.setTopComponent(editingTypePane);
            JComponent table = childComponents;
            this._splitPane.setEnabled(false);
            this._splitPane.setBottomComponent(table);
            this._splitPane.setDividerLocation(0);
            this.getSplitPane().setDividerSize(0);
            ((JComponent)this.getSplitPane().getBottomComponent()).setBorder(BorderFactory.createLineBorder(new JPanel().getBackground()));
            if (isSelfViewHolder) {
                this._southOrientationSplitPane = new JAXJSplitPane(0);
                this._southOrientationSplitPane.setBorder(null);
                this._southOrientationSplitPane.setTopComponent(this._splitPane);
                this._southOrientationSplitPane.setBottomComponent(new JLabel(""));
                splitPanePanel.setName("splitPanePanel");
                splitPanePanel.add((Component)this._southOrientationSplitPane, "Center");
                splitPanePanel.setBorder(null);
                this._list.getViewport().setPreferredSize(new Dimension(this._list.getWidth(), this.calculateListHeight(this._list)));
                return splitPanePanel;
            }
        } else if (tablePosition.equals("west")) {
            this._splitPane.setLeftComponent(childComponents);
            this._splitPane.setRightComponent(editingTypePane);
            this._splitPane.setDividerLocation(dividerLocation);
        } else if (tablePosition.equals("east")) {
            this._splitPane.setLeftComponent(editingTypePane);
            this._splitPane.setRightComponent(childComponents);
            this._splitPane.setDividerLocation(dividerLocation);
        }
        splitPanePanel.setName("splitPanePanel");
        splitPanePanel.add((Component)this._splitPane, "Center");
        splitPanePanel.setBorder(null);
        int calculatedListHeight = this.calculateListHeight(this._list);
        this._list.getViewport().setPreferredSize(new Dimension(this._list.getWidth(), calculatedListHeight));
        this._splitPane.setDividerLocation(calculatedListHeight);
        return splitPanePanel;
    }

    private int calculateListHeight(RowHeadedTable listTable) {
        int dRows = listTable.getNoOfDisplayableRows();
        if (dRows >= 0) {
            int headerHeight = listTable.getDataTable().getTableHeader().getPreferredSize().height;
            int dispRows = listTable.getNoOfDisplayableRows() + 1;
            if (this.getStyle().getListInfo() != null && this.getStyle().getListInfo().allowReOrdering()) {
                ++dispRows;
            }
            return listTable.getDataTable().getRowHeight() * dispRows + headerHeight + 3;
        }
        return dRows;
    }

    public JAXDataTable getDataTable() {
        if (this._list != null) {
            return this._list.getDataTable();
        }
        return null;
    }

    protected void setEditingTypePane(JComponent editingTypePane) {
        this._editingTypePane = editingTypePane;
    }

    protected JComponent getEditingTypePane() {
        return this._editingTypePane;
    }

    protected JSplitPane getSplitPane() {
        return this._splitPane;
    }

    public void removeTab(Type type) {
        int tabIndex = this.getTabIndex(type);
        this.getTabbedPane().removeTabAt(tabIndex);
    }

    public void addTab(Type type) {
        if (type != null) {
            this.addTab(type, this.getTabIndex(type));
        }
    }

    public void addTab(Type type, int index) {
        if (type != null) {
            JComponent comp = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer(type, this._context);
            if (!this.getTabbedPane().containsTabForType(type)) {
                comp.setBorder(null);
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)comp, "Center");
                panel.putClientProperty("TAB_TYPE", type);
                this.getTabbedPane().insertTab(type.getStyle().getCaptionTitleLabel(), null, panel, null, index);
                this.selectTab(type);
            }
        }
    }

    private int getTabIndex(Type type) {
        return this.getModel().getDirectChildren().indexOf(type);
    }

    private Type getTabType(int index) {
        return (Type)this.getModel().getDirectChildren().get(index);
    }

    public void selectTab(Type type) {
        int index = -1;
        index = this.getTabIndex(type);
        if (index > -1 && index < this.getTabbedPane().getTabCount()) {
            this.getTabbedPane().setSelectedIndex(index);
        }
    }

    protected JAXJTabbedPane getTabbedPane() {
        if (this._tabbedPane == null) {
            this._tabbedPane = new JAXJTabbedPane();
            this._tabbedPane.setUI(new ActionTabPlaf(new Action[]{this.getAddAction(), this.getDeleteAction()}, 2, 8));
            this._tabbedPane.addChangeListener(this);
        }
        return this._tabbedPane;
    }

    public Visualizer getSelectedTabVisualizer() {
        Component component;
        if (this._tabbedPane != null && (component = this.getTabbedPane().getSelectedComponent()) instanceof JComponent) {
            JComponent jcomponent = (JComponent)component;
            return (Visualizer)jcomponent.getComponent(0);
        }
        return null;
    }

    public void stateChanged(ChangeEvent e) {
        int index = this.getTabbedPane().getSelectedIndex();
        if (index > -1 && this.hasBeenBuilt()) {
            Type selectedType = this.getTabType(index);
            this.highlightTreeEntry(selectedType);
        }
        this.handleButtonEnabling(index);
    }

    public void domChanged(DOMChangeEvent event) {
        if (this.getModel() != null && this.getStyle().isUsingTabList() && (event.isAddingNode() || event.isRemovingNode())) {
            Type type = (Type)event.getSource();
            if (event.isRemovingNode()) {
                int index;
                if (this.getModel() == type.getParent() && (index = event.getIndex()) != -1) {
                    this.getTabbedPane().removeTabAt(index);
                }
            } else if (event.isAddingNode() && this.getModel() == type.getParent()) {
                int index = event.getIndex();
                if (index < 0) {
                    this.addTab(type);
                } else {
                    this.addTab(type, index);
                }
            }
        }
    }

    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        if (this._popUpMenu != null && this._tabbedPane != null && e.getSource() == this._popUpMenu) {
            this.handleButtonEnabling(this.getTabbedPane().getSelectedIndex());
        }
    }

    public void setVisible(boolean visible) {
        if (this._editButton != null) {
            this._editButton.setVisible(visible);
        }
        if (this._addButton != null) {
            this._addButton.setVisible(visible);
        }
        if (this._deleteButton != null) {
            this._deleteButton.setVisible(visible);
        }
        if (this._copyButton != null) {
            this._copyButton.setVisible(visible);
        }
        if (this._moveUpButton != null) {
            this._moveUpButton.setVisible(visible);
        }
        if (this._moveDownButton != null) {
            this._moveDownButton.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public void setDeleteActionEnabled(boolean enabled) {
        this.getDeleteAction().setEnabled(enabled);
    }

    public void setAddActionEnabled(boolean enabled) {
        this.getAddAction().setEnabled(enabled);
    }

    public void setCopyActionEnabled(boolean enabled) {
        this.getCopyAction().setEnabled(enabled);
    }

    public void setCopyContentActionEnabled(boolean enabled) {
        this.getCopyContentAction().setEnabled(enabled);
    }

    public void setEditActionEnabled(boolean enabled) {
        this.getEditAction().setEnabled(enabled);
    }

    public void setMoveUpActionEnabled(boolean enabled) {
        this.getMoveUpAction().setEnabled(enabled);
    }

    public void setMoveDownActionEnabled(boolean enabled) {
        this.getMoveDownAction().setEnabled(enabled);
    }

    public void setPasteContentActionEnabled(boolean enabled) {
        this.getPasteContentAction().setEnabled(enabled);
    }

    public void resetView() {
        if (this.getSelectedType() == null && this.getEditingTypePane() != null) {
            this.getEditingTypePane().removeAll();
        }
        if (this._currentSelection != null) {
            this._currentSelection.clear();
        }
        if (this._comboBox != null) {
            int size = this._comboBox.getModel().getSize();
            if (size > 0) {
                this._comboBox.setSelectedIndex(0);
            } else {
                this._comboBox.setSelectedIndex(-1);
            }
        }
        if (this._list != null) {
            this._list.refresh();
        }
        if (this._tabbedPane != null) {
            this._tabbedPane.removeAll();
            List childs = this.getModel().getDirectChildren();
            for (int i = 0; i < childs.size(); ++i) {
                Type child = (Type)childs.get(i);
                this.addTab(child);
            }
        }
        this.showModel(null);
        this.applyDefaultSelection();
    }

    public List getButtonListeners(boolean build) {
        if (build && this._buttonListeners == null) {
            this._buttonListeners = new Vector(6);
        }
        return this._buttonListeners;
    }

    public void fireButtonListeners(int actionType, ActionEvent ae) {
        List listeners = this.getButtonListeners(false);
        if (listeners != null) {
            for (int l = 0; l < listeners.size(); ++l) {
                ListActionListenerWrapper al = (ListActionListenerWrapper)listeners.get(l);
                if (al.getActionType() != actionType) continue;
                al.actionPerformed(ae);
            }
        }
        if (this.getUserActions() != null) {
            Vector uAs = this.getUserActions();
            for (int u = 0; u < uAs.size(); ++u) {
                ((ListViewAction)uAs.get(u)).actionPerformed(actionType, ae);
            }
        }
    }

    public boolean addEditListener(ActionListener listener) {
        if (this._editButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(0, listener));
            return true;
        }
        return false;
    }

    public boolean addAddListener(ActionListener listener) {
        if (this._addButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(1, listener));
            return true;
        }
        return false;
    }

    public boolean addDeleteListener(ActionListener listener) {
        if (this._deleteButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(2, listener));
            return true;
        }
        return false;
    }

    public boolean addCopyListener(ActionListener listener) {
        if (this._copyButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(3, listener));
            return true;
        }
        return false;
    }

    public boolean addMoveUpListener(ActionListener listener) {
        if (this._moveUpButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(4, listener));
            return true;
        }
        return false;
    }

    public boolean addMoveDownListener(ActionListener listener) {
        if (this._moveDownButton != null) {
            this.getButtonListeners(true).add(new ListActionListenerWrapper(5, listener));
            return true;
        }
        return false;
    }

    public void removeAddListener(ActionListener listener) {
        if (this._addButton != null) {
            this.getButtonListeners(true).remove(listener);
        }
    }

    public void removeDeleteListener(ActionListener listener) {
        if (this._deleteButton != null) {
            this.getButtonListeners(true).remove(listener);
        }
    }

    public void removeCopyListener(ActionListener listener) {
        if (this._copyButton != null) {
            this.getButtonListeners(true).remove(listener);
        }
    }

    public void removeMoveUpListener(ActionListener listener) {
        if (this._moveUpButton != null) {
            this.getButtonListeners(true).remove(listener);
        }
    }

    public void removeMoveDownListener(ActionListener listener) {
        if (this._moveDownButton != null) {
            this.getButtonListeners(true).remove(listener);
        }
    }

    public void stopCellEditing() {
        if (this._list != null && this._list.getDataTable() != null && this._list.getDataTable().getCellEditor() != null) {
            this._list.getDataTable().getCellEditor().stopCellEditing();
        }
    }

    public ListType getListModel() {
        return (ListType)this.getModel();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this._simpleListPanel != null && evt.getPropertyName().equals("listSelectionChanged")) {
            List selection = (List)evt.getNewValue();
            if (selection.size() > 0) {
                int selIndex = this.getListModel().indexOf(selection.get(0));
                this.handleButtonEnabling(selIndex);
                this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_ITEM_SELECTED((Type)((Type)this.getListModel().get(selIndex))));
            } else {
                List oldValList = (List)evt.getOldValue();
                if (oldValList.size() > 0) {
                    this.getDOM().fireDOMChanged(DOMChangeEvent.DOM_ITEM_DESELECTED((Type)((Type)oldValList.get(0))));
                }
                this.handleButtonEnabling(-1);
            }
        } else {
            super.propertyChange(evt);
        }
    }

    public void windowClosed(WindowEvent e) {
        if (this._popUpWindow != null) {
            this._popUpWindow.setVisible(false);
            this._popUpWindow.dispose();
            this._popUpWindow = null;
            this._comboBox = null;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.windowClosed(e);
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
        this.doAtFirstVisualization();
    }

    public void componentResized(ComponentEvent e) {
        this.doAtFirstVisualization();
    }

    public void componentShown(ComponentEvent e) {
        this.doAtFirstVisualization();
    }

    private void doAtFirstVisualization() {
        if (!this._doAtVisualizationDone) {
            this._doAtVisualizationDone = true;
            this.applyAutoColWidth();
        }
    }

    public void initForTreeMenu(DefaultPopUpMenu defaultPopUpMenu) {
        ListInfo info = this.getStyle().getListInfo();
        if (info != null && info.allowReOrdering()) {
            defaultPopUpMenu.add(this.getMoveUpAction());
            defaultPopUpMenu.add(this.getMoveDownAction());
        }
    }

    class TypeRenderer
    implements SimpleJListCellRenderer {
        TypeRenderer() {
        }

        public Component getListCellComponent(SimpleJList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return (Component)TypeVisualizerFactory.getInstance().getVisualizer((Type)value);
        }
    }
}

