/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.DOMChangeEvent;
import com.jaxfront.core.dom.DOMChangeListener;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.FlipOrientationTableModel;
import com.jaxfront.core.util.sort.FastQSort;
import com.jaxfront.core.util.sort.TableColumnComparator;
import com.jaxfront.swing.ui.tools.SortingHeader;
import com.jaxfront.swing.ui.tools.TableMap;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableSorter
extends TableMap
implements DOMChangeListener {
    int[] indexes;
    int lastSortingColumn;
    Vector sortingColumns = new Vector();
    boolean _isAscending = true;
    int compares;
    private ListType _listType;
    private MouseAdapter _listMouseListener;
    private JTable _table;

    public TableSorter(FlipOrientationTableModel model, JTable table) {
        this.setModel(model);
        this._table = table;
        this._listType = model.getListType();
        this.initializeIndexes();
        this._listType.getDOM().addDOMChangeListener((DOMChangeListener)this);
    }

    public void setModel(FlipOrientationTableModel model) {
        super.setModel(model);
    }

    public void initializeIndexes() {
        int lineCount = this.model.getRowCount();
        if (this.isFlipped()) {
            lineCount = this.model.getColumnCount();
        }
        this.indexes = new int[lineCount];
        for (int row = 0; row < lineCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void checkModel() {
        int lineCount = this.model.getRowCount();
        if (this.isFlipped()) {
            lineCount = this.model.getColumnCount();
        }
        if (this.indexes.length != lineCount) {
            if (LogRegistry.getInstance().logWarnings()) {
                LogRegistry.getInstance().warn(this.getClass(), "Sorter not informed of a change in model. Try to reinitialize Indexes");
            }
            this.initializeIndexes();
        }
    }

    private void sort(int column) {
        if (!this.model.isFlipped()) {
            this.checkModel();
            this.compares = 0;
            FastQSort fastsort = new FastQSort();
            Class columnClass = String.class;
            List formulas = this.model.getRowFormulas(column);
            if (formulas.size() > 0) {
                columnClass = ((FormulaExpression)formulas.get(0)).getResultClassForSort();
            }
            try {
                this.indexes = fastsort.sort(formulas, (Comparator)new TableColumnComparator(columnClass, column - 1, this._isAscending));
            }
            catch (Exception e) {
                // empty catch block
            }
            this._listType.setSortIndexes(this.indexes);
            this._listType.getDOM().fireDOMChanged(DOMChangeEvent.DOM_SORTED((ListType)this._listType, (int[])this.indexes));
        }
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        if (this.isFlipped()) {
            return this.model.getValueAt(aRow, this.indexes[aColumn] + 1);
        }
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        if (this.isFlipped()) {
            if (this.indexes.length > aColumn) {
                this.model.setValueAt(aValue, aRow, this.indexes[aColumn] + 1);
            }
        } else if (this.indexes.length > aRow) {
            this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
        }
    }

    private void sortByColumn(int column, boolean isAscending) {
        this._isAscending = isAscending;
        this.lastSortingColumn = column;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(column));
        this.sort(column);
        super.tableChanged(new TableModelEvent(this));
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        this._table = table;
        this._table.setColumnSelectionAllowed(false);
        this._listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = TableSorter.this._table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = TableSorter.this._table.convertColumnIndexToModel(viewColumn);
                TableColumn tc = columnModel.getColumn(viewColumn);
                if (tc != null) {
                    SortingHeader sortingHeader = (SortingHeader)tc.getHeaderRenderer();
                    int sortSequence = sortingHeader.getSortSequence(viewColumn);
                    if (e.getClickCount() == 1 && column != -1) {
                        boolean ascending = sortSequence == SortingHeader.ASCENDING;
                        sorter.sortByColumn(column, ascending);
                    }
                }
            }
        };
        JTableHeader th = this._table.getTableHeader();
        th.addMouseListener(this._listMouseListener);
    }

    public int getOriginalRowIndex(int index) {
        return this.indexes[index];
    }

    public int getOriginalRowIndexPos(int index) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != index) continue;
            return i;
        }
        return -1;
    }

    public void domChanged(DOMChangeEvent event) {
        if (event.isTemporary()) {
            return;
        }
        if (!(event.isCancelled() || event.isAboutToSave() || event.isAboutToValidate() || event.isSorted() || event.isFinishedBinding())) {
            Object source = event.getSource();
            if (source == null || !(source instanceof Type)) {
                return;
            }
            Type type = (Type)event.getSource();
            if (type.getParentList() == this._listType) {
                if (event.isAddingNode()) {
                    this.reallocateIndexes(-1);
                    if (this.model.isCellEditableEnabled()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                boolean success;
                                int row = TableSorter.this.getRowCount() - 1;
                                int firstEditableColumn = TableSorter.this.getFirstEditableColumn(row);
                                if (firstEditableColumn >= 0 && (success = TableSorter.this._table.editCellAt(row, firstEditableColumn, null))) {
                                    boolean toggle = false;
                                    boolean extend = false;
                                }
                            }
                        });
                    }
                } else if (event.isRemovingNode() && event.getIndex() != -1) {
                    this.reallocateIndexes(event.getIndex());
                } else if (event.isSwappingNode()) {
                    int from = event.getMovedFromIndex();
                    int to = event.getMovedToIndex();
                    this.model.swapFormula(from, to);
                }
            }
        } else if (event.isFinishedBinding() && event.getSource() == this.getListType()) {
            this.initializeIndexes();
        }
    }

    private int getFirstEditableColumn(int row) {
        int firstEditableColumn = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isCellEditable(row, i)) continue;
            firstEditableColumn = i;
            break;
        }
        return firstEditableColumn;
    }

    private void reallocateIndexes(int index) {
        if (index == -1) {
            int newSize = this._listType.getList().size();
            if (newSize != 0) {
                int[] newIndexes = new int[newSize];
                if (newIndexes.length >= this.indexes.length) {
                    for (int i = 0; i < this.indexes.length; ++i) {
                        newIndexes[i] = this.indexes[i];
                    }
                }
                newIndexes[newSize - 1] = newSize - 1;
                this.indexes = newIndexes;
            }
        } else {
            int newSize = this._listType.getList().size();
            int[] newIndexes = new int[newSize];
            int counter = 0;
            for (int i = 0; i < this.indexes.length; ++i) {
                int currentIndex = this.indexes[i];
                if (currentIndex == index) continue;
                if (currentIndex > index) {
                    // empty if block
                }
                newIndexes[counter] = --currentIndex;
                ++counter;
            }
            this.indexes = newIndexes;
        }
    }

    public int[] getSortIndexes() {
        return this.indexes;
    }

    public void release() {
        if (this._listType != null && this._listType.getDOM() != null) {
            this._listType.getDOM().removeDOMChangeListener((DOMChangeListener)this);
        }
        this.sortingColumns = null;
        this._listType = null;
        if (this._table != null) {
            this._table.getTableHeader().removeMouseListener(this._listMouseListener);
            this._table = null;
            this._listMouseListener = null;
        }
        super.release();
    }

    public ListType getListType() {
        return this._listType;
    }

    public boolean isFlipped() {
        return this.model.isFlipped();
    }
}

