/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TablePacker {
    public static final int VISIBLE_ROWS = 0;
    public static final int ALL_ROWS = 1;
    public static final int NO_ROWS = 2;
    private int rowsIncluded = 0;
    private boolean distributeExtraArea = true;
    private int _minWidth = -1;

    public TablePacker(int rowsIncluded, boolean distributeExtraArea, int minWidth) {
        this.rowsIncluded = rowsIncluded;
        this.distributeExtraArea = distributeExtraArea;
        this._minWidth = minWidth;
    }

    private int preferredWidth(JTable table, int col) {
        TableColumn tableColumn = table.getColumnModel().getColumn(col);
        int width = (int)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
        if (table.getRowCount() != 0) {
            int from = 0;
            int to = 0;
            if (this.rowsIncluded == 0) {
                Rectangle rect = table.getVisibleRect();
                from = table.rowAtPoint(rect.getLocation());
                to = table.rowAtPoint(new Point((int)rect.getMaxX(), (int)rect.getMaxY())) + 1;
                if (to == 0 && table.getRowCount() > 0) {
                    to = 1;
                }
            } else if (this.rowsIncluded == 1) {
                from = 0;
                to = table.getRowCount();
            } else {
                to = this.rowsIncluded;
                if (to > table.getRowCount()) {
                    to = table.getRowCount();
                }
            }
            for (int row = from; row < to; ++row) {
                int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
        }
        return width + table.getIntercellSpacing().width;
    }

    public void pack(JTable table, boolean useAlternateAlgorithm, boolean checkShowing) {
        int extra;
        if (table.getColumnCount() == 0) {
            return;
        }
        int[] width = new int[table.getColumnCount()];
        int total = 0;
        for (int col = 0; col < width.length; ++col) {
            width[col] = this.preferredWidth(table, col);
            total += width[col];
        }
        int visibleWidth = table.getVisibleRect().width;
        double toDistribWidth = visibleWidth;
        if (table.getParent() != null) {
            toDistribWidth = table.getParent().getSize().width;
        }
        if ((double)visibleWidth < toDistribWidth) {
            visibleWidth = (int)toDistribWidth;
        }
        if (visibleWidth == 0 && !table.isShowing()) {
            visibleWidth = total;
            toDistribWidth = total;
        }
        if ((extra = visibleWidth - total) > 0) {
            if (this.distributeExtraArea) {
                int bonus = extra / table.getColumnCount();
                int i = 0;
                while (i < width.length) {
                    int n = i++;
                    width[n] = width[n] + bonus;
                }
                extra -= bonus * table.getColumnCount();
            }
            int n = width.length - 1;
            width[n] = width[n] + extra;
        }
        TableColumnModel columnModel = table.getColumnModel();
        if (useAlternateAlgorithm) {
            for (int col = 0; col < width.length; ++col) {
                TableColumn tableColumn = columnModel.getColumn(col);
                table.getTableHeader().setResizingColumn(tableColumn);
                if (this._minWidth != -1) {
                    width[col] = Math.max(width[col], this._minWidth);
                }
                tableColumn.setWidth(width[col]);
            }
        } else {
            TableColumn tableColumn;
            int col;
            double calcOveralWidth = 0.0;
            for (col = 0; col < width.length; ++col) {
                tableColumn = columnModel.getColumn(col);
                width[col] = this.alternate(table.getTableHeader(), tableColumn, 5, true);
                calcOveralWidth += (double)width[col];
            }
            for (col = 0; col < width.length; ++col) {
                tableColumn = columnModel.getColumn(col);
                table.getTableHeader().setResizingColumn(tableColumn);
                tableColumn.setWidth(width[col]);
            }
        }
    }

    public int alternate(JTableHeader header, TableColumn tableColumn, int margin, boolean withHeader) {
        if (tableColumn == null) {
            return 0;
        }
        int col = header.getColumnModel().getColumnIndex(tableColumn.getIdentifier());
        JTable table = header.getTable();
        int marginSpace = 2 * margin + table.getIntercellSpacing().width;
        int rowCount = table.getRowCount();
        int width = (int)header.getDefaultRenderer().getTableCellRendererComponent(table, tableColumn.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, tableColumn.getHeaderValue(), false, false, 0, 0);
        if ((width = Math.max(width, comp.getPreferredSize().width)) == 0 && withHeader) {
            if (tableColumn.getHeaderValue() instanceof String) {
                width = comp.getFontMetrics(comp.getFont()).stringWidth((String)tableColumn.getHeaderValue()) + marginSpace;
            }
        } else {
            width += marginSpace;
        }
        for (int row = 0; row < rowCount; ++row) {
            int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth() + marginSpace;
            width = Math.max(width, preferedWidth);
        }
        header.setResizingColumn(tableColumn);
        if (this._minWidth != -1) {
            width = Math.max(width, this._minWidth);
        }
        return width;
    }
}

