/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.core.dom.DOMHelper;
import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.core.util.undo.JAXFrontUndoManager;
import com.jaxfront.core.util.undo.JAXFrontUndoableEdit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.apache.xerces.xni.parser.XMLParseException;
import org.xml.sax.SAXException;

public class Macroplayer
extends JPanel
implements UndoableEditListener,
ListSelectionListener {
    private JPanel _controlPanel;
    private JPanel _stepPanel;
    private JList _stepList;
    private Vector _macroEdits = new Vector();
    private JAXFrontUndoManager _undoManager;
    private boolean _recording;
    private AbstractAction _loadAction;
    private AbstractAction _saveAction;
    private AbstractAction _recordAction;
    private Document _saveDom;
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);
    private AbstractAction _undoAction;
    private AbstractAction _redoAction;
    private AbstractAction _undoAllAction;
    private AbstractAction _redoAllAction;
    private JTextField _currentPosTF = null;
    private AbstractAction _recClearAction;

    public Macroplayer(Document dom) {
        this._saveDom = dom;
        this._undoManager = new JAXFrontUndoManager(dom);
        dom.getUndoManager().addUndoableEditListener((UndoableEditListener)this);
        this.build();
    }

    public void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getStepPanel(), "Center");
        this.add((Component)this.getControlPanel(), "South");
    }

    private JPanel getControlPanel() {
        if (this._controlPanel == null) {
            this._controlPanel = new JPanel();
            this._controlPanel.add(this.getCurrentPosTF());
            this._controlPanel.add(new JButton(this.getLoadAction()));
            this._controlPanel.add(new JButton(this.getSaveAction()));
            this._controlPanel.add(new JButton(this.getClearRecordsAction()));
            this._controlPanel.add(new JButton(this.getRecordAction()));
            this._controlPanel.add(new JButton(this.getUndoAction()));
            this._controlPanel.add(new JButton(this.getRedoAction()));
            this._controlPanel.add(new JButton(this.getUndoAllAction()));
            this._controlPanel.add(new JButton(this.getRedoAllAction()));
            this.getLoadAction().setEnabled(true);
            this.getRecordAction().setEnabled(true);
        }
        return this._controlPanel;
    }

    private JPanel getStepPanel() {
        if (this._stepPanel == null) {
            this._stepPanel = new JPanel(new BorderLayout());
            this._stepPanel.add((Component)new JScrollPane(this.getStepList()), "Center");
        }
        return this._stepPanel;
    }

    private JList getStepList() {
        if (this._stepList == null) {
            this._stepList = new JList();
            this._stepList.setModel(new DefaultListModel());
            this._stepList.addListSelectionListener(this);
        }
        return this._stepList;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.getContentPane().add(new Macroplayer(null));
        f.setSize(400, 200);
        f.setVisible(true);
    }

    public Action getLoadAction() {
        if (this._loadAction == null) {
            this._loadAction = new AbstractAction("load Macro"){

                public void actionPerformed(ActionEvent e) {
                    FileSelector fs = new FileSelector("load Macro");
                    fs.showOpenDialog((Component)Macroplayer.this.getControlPanel());
                    if (fs.getSelectedFile() != null) {
                        try {
                            Macroplayer.this._undoManager.createFromSerialize(DOMHelper.createDocument((File)fs.getSelectedFile()));
                            Macroplayer.this.fillStepList(Macroplayer.this._undoManager.getEditSteps());
                            Macroplayer.this.updateComponentStates();
                        }
                        catch (XMLParseException e1) {
                            e1.printStackTrace();
                        }
                        catch (SAXException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        Macroplayer.this.getCurrentPosTF().setText(Macroplayer.this._undoManager.getNextEditIndex() + "/" + Macroplayer.this._undoManager.getMaxEditIndex());
                        Macroplayer.this._undoAction.setEnabled(Macroplayer.this._undoManager.canMacroUndo());
                        Macroplayer.this._redoAction.setEnabled(Macroplayer.this._undoManager.canMacroRedo());
                    }
                }
            };
            this._loadAction.setEnabled(false);
        }
        return this._loadAction;
    }

    public Action getRecordAction() {
        if (this._recordAction == null) {
            this._recordAction = new AbstractAction("record"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._recording = !Macroplayer.this._recording;
                    Macroplayer.this.updateComponentStates();
                }
            };
            this._recordAction.setEnabled(false);
        }
        return this._recordAction;
    }

    public Action getClearRecordsAction() {
        if (this._recClearAction == null) {
            this._recClearAction = new AbstractAction("clear Records"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._undoManager.discardAllEdits();
                    Macroplayer.this._macroEdits.clear();
                    ((DefaultListModel)Macroplayer.this.getStepList().getModel()).removeAllElements();
                    Macroplayer.this.updateComponentStates();
                }
            };
            this._recClearAction.setEnabled(false);
        }
        return this._recClearAction;
    }

    public Action getSaveAction() {
        if (this._saveAction == null) {
            this._saveAction = new AbstractAction("save Macro"){

                public void actionPerformed(ActionEvent e) {
                    FileSelector fs = new FileSelector("save Macro");
                    fs.showSaveDialog((Component)Macroplayer.this.getControlPanel());
                    if (fs.getSelectedFile() != null) {
                        try {
                            Macroplayer.this._saveDom.getUndoManager().serializeUndoManager(fs.getSelectedFile(), (List)Macroplayer.this._macroEdits);
                        }
                        catch (XMLParseException e1) {
                            e1.printStackTrace();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    }
                }
            };
            this._saveAction.setEnabled(false);
        }
        return this._saveAction;
    }

    private void updateComponentStates() {
        int selectedIndex = this.getStepList().getSelectedIndex();
        String tfText = this._undoManager.getNextEditIndex() + "/" + this._undoManager.getMaxEditIndex();
        if (this._recording) {
            tfText = "r!" + tfText;
        }
        this.getCurrentPosTF().setText(tfText);
        if (this.getStepList().getSelectedIndex() != selectedIndex) {
            this.getStepList().setSelectedIndex(this._undoManager.getNextEditIndex());
        }
        this._undoAction.setEnabled(this._undoManager.canMacroUndo());
        this._redoAction.setEnabled(this._undoManager.canMacroRedo());
        this._undoAllAction.setEnabled(this._undoManager.canMacroUndo());
        this._redoAllAction.setEnabled(this._undoManager.canMacroRedo());
        this.getClearRecordsAction().setEnabled(this._macroEdits.size() > 0);
        this.getSaveAction().setEnabled(this._macroEdits.size() > 0);
    }

    public Action getUndoAction() {
        if (this._undoAction == null) {
            this._undoAction = new AbstractAction("undo"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._recording = false;
                    if (Macroplayer.this._undoManager.canMacroUndo()) {
                        Macroplayer.this._undoManager.macroUndo();
                        Macroplayer.this.updateComponentStates();
                    }
                }
            };
            this._undoAction.setEnabled(false);
        }
        return this._undoAction;
    }

    public Action getRedoAction() {
        if (this._redoAction == null) {
            this._redoAction = new AbstractAction("redo"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._recording = false;
                    if (Macroplayer.this._undoManager.canMacroRedo()) {
                        Macroplayer.this._undoManager.macroRedo();
                        Macroplayer.this.updateComponentStates();
                    }
                }
            };
            this._redoAction.setEnabled(false);
        }
        return this._redoAction;
    }

    public Action getUndoAllAction() {
        if (this._undoAllAction == null) {
            this._undoAllAction = new AbstractAction("undoAll"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._recording = false;
                    while (Macroplayer.this._undoManager.canMacroUndo()) {
                        Macroplayer.this._undoManager.macroUndo();
                    }
                    Macroplayer.this.updateComponentStates();
                }
            };
            this._undoAllAction.setEnabled(false);
        }
        return this._undoAllAction;
    }

    public Action getRedoAllAction() {
        if (this._redoAllAction == null) {
            this._redoAllAction = new AbstractAction("redoAll"){

                public void actionPerformed(ActionEvent e) {
                    Macroplayer.this._recording = false;
                    while (Macroplayer.this._undoManager.canMacroRedo()) {
                        Macroplayer.this._undoManager.macroRedo();
                    }
                    Macroplayer.this.updateComponentStates();
                }
            };
            this._redoAllAction.setEnabled(false);
        }
        return this._redoAllAction;
    }

    public JTextField getCurrentPosTF() {
        if (this._currentPosTF == null) {
            this._currentPosTF = new JTextField(8);
        }
        return this._currentPosTF;
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        if (this._recording) {
            if (e.getEdit() instanceof JAXFrontUndoableEdit) {
                StringWriter aSw = new StringWriter();
                PrintWriter aPw = new PrintWriter(aSw);
                ((JAXFrontUndoableEdit)e.getEdit()).serialize(aPw);
                ((DefaultListModel)this.getStepList().getModel()).addElement(((JAXFrontUndoableEdit)e.getEdit()).getInfo());
                this._macroEdits.add(e.getEdit());
                this._undoManager.addMacroEdit(e.getEdit());
            }
            this.updateComponentStates();
        }
    }

    private void fillStepList(List edits) {
        for (int l = 0; l < edits.size(); ++l) {
            ((DefaultListModel)this.getStepList().getModel()).addElement(((JAXFrontUndoableEdit)edits.get(l)).getInfo());
        }
    }

    public void valueChanged(ListSelectionEvent e) {
    }
}

