/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.tools;

import com.jaxfront.swing.ui.tools.BubbleHelpSingleton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class ComponentTitledBorder
implements Border,
MouseListener,
MouseMotionListener,
SwingConstants {
    int offset = 5;
    Vector components;
    Hashtable componentsRect;
    JComponent container;
    Border border;

    public ComponentTitledBorder(JComponent container, Border border) {
        this.container = container;
        this.border = border;
        container.addMouseListener(this);
        container.addMouseMotionListener(this);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets borderInsets = this.border.getBorderInsets(c);
        Insets insets = this.getBorderInsets(c);
        int temp = (insets.top - borderInsets.top) / 2;
        int paintOffset = this.offset;
        this.border.paintBorder(c, g, x, y + temp, width, height - temp);
        for (int i = 0; i < this.getComponents().size(); ++i) {
            Component aComp = (Component)this.getComponents().get(i);
            Dimension size = aComp.getPreferredSize();
            Rectangle rect = new Rectangle(paintOffset, 0, size.width, size.height);
            this.getComponentsRect().put(aComp, rect);
            SwingUtilities.paintComponent(g, aComp, (Container)c, rect);
            paintOffset = (int)((double)paintOffset + size.getWidth());
        }
    }

    public Insets getBorderInsets(Component c) {
        Dimension size = null;
        Insets insets = this.border.getBorderInsets(c);
        for (int i = 0; i < this.getComponents().size(); ++i) {
            Component aComp = (Component)this.getComponents().get(i);
            size = aComp.getPreferredSize();
            insets.top = Math.max(insets.top, size.height);
        }
        return insets;
    }

    private void dispatchEvent(MouseEvent me) {
        int cummulOffset = 0;
        for (int c = 0; c < this.components.size(); ++c) {
            Component comp = (Component)this.components.get(c);
            Rectangle aRect = (Rectangle)this.getComponentsRect().get(comp);
            if (aRect == null) continue;
            if (aRect.contains(me.getX(), me.getY())) {
                BubbleHelpSingleton.getInstance().defuse();
                Point pt = me.getPoint();
                Point mousept = (Point)pt.clone();
                SwingUtilities.convertPointToScreen(mousept, this.container);
                BubbleHelpSingleton.getInstance().armBubble(mousept.x - this.offset, mousept.y, comp);
                pt.translate(-this.offset - cummulOffset, 0);
                comp.setBounds(aRect);
                comp.dispatchEvent(new MouseEvent(comp, me.getID(), me.getWhen(), me.getModifiers(), pt.x, pt.y, me.getClickCount(), me.isPopupTrigger(), me.getButton()));
                if (!comp.isValid()) {
                    this.container.repaint();
                }
                return;
            }
            cummulOffset += aRect.width;
        }
    }

    public void mouseClicked(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseExited(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mousePressed(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public void mouseReleased(MouseEvent me) {
        this.dispatchEvent(me);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JPanel proxyPanel = new JPanel();
        proxyPanel.add(new JLabel("Proxy Host: "));
        proxyPanel.add(new JTextField("proxy.xyz.com"));
        proxyPanel.add(new JLabel("  Proxy Port"));
        proxyPanel.add(new JTextField("8080"));
        final JCheckBox checkBox = new JCheckBox("Use Proxy", true);
        checkBox.setFocusPainted(false);
        checkBox.setToolTipText("test");
        ComponentTitledBorder componentBorder = new ComponentTitledBorder(proxyPanel, BorderFactory.createEtchedBorder());
        componentBorder.addComponent(checkBox);
        JButton b1 = new JButton("test");
        b1.setToolTipText("test1");
        JButton b2 = new JButton("test2");
        b2.setToolTipText("test2");
        JButton b3 = new JButton("test3");
        b3.setToolTipText("test3");
        componentBorder.addComponent(b1);
        componentBorder.addComponent(b2);
        componentBorder.addComponent(b3);
        checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enable = checkBox.isSelected();
                Component[] comp = proxyPanel.getComponents();
                for (int i = 0; i < comp.length; ++i) {
                    comp[i].setEnabled(enable);
                }
            }
        });
        proxyPanel.setBorder(componentBorder);
        JFrame frame = new JFrame("ComponentTitledBorder - santhosh@in.fiorano.com");
        Container contents = frame.getContentPane();
        contents.setLayout(new FlowLayout());
        contents.add(proxyPanel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void addComponent(Component comp) {
        this.getComponents().add(comp);
    }

    private Vector getComponents() {
        if (this.components == null) {
            this.components = new Vector();
        }
        return this.components;
    }

    private Hashtable getComponentsRect() {
        if (this.componentsRect == null) {
            this.componentsRect = new Hashtable(4);
        }
        return this.componentsRect;
    }

    public void mouseDragged(MouseEvent e) {
        this.dispatchEvent(e);
    }

    public void mouseMoved(MouseEvent e) {
        this.dispatchEvent(e);
    }
}

