/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.rtf;

import com.jaxfront.swing.ui.rtf.JEditorComboStyledEditor;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;

public class StyledText {
    private Vector _clipText;
    private Vector _clipAttr;
    private JTextPane _jEditorComboPane;

    public StyledText(JEditorComboStyledEditor src, JTextPane jEditorComboPane) throws BadLocationException {
        this._jEditorComboPane = jEditorComboPane;
        this._clipText = new Vector(0);
        this._clipAttr = new Vector(0);
        Document Zdoc = this._jEditorComboPane.getDocument();
        int selStart = this._jEditorComboPane.getSelectionStart();
        int selEnd = this._jEditorComboPane.getSelectionEnd();
        ElementIterator eli = new ElementIterator(Zdoc);
        Element elem = eli.first();
        while (elem != null) {
            int eStart = elem.getStartOffset();
            int eEnd = elem.getEndOffset();
            if (elem.getName().equalsIgnoreCase("content") && eEnd >= selStart && eStart <= selEnd) {
                this._clipAttr.addElement(elem.getAttributes());
                if (eStart < selStart) {
                    if (eEnd > selEnd) {
                        this._clipText.addElement(this._jEditorComboPane.getText(selStart, selEnd - selStart));
                    } else {
                        this._clipText.addElement(this._jEditorComboPane.getText(selStart, eEnd - selStart));
                    }
                } else if (eEnd > selEnd) {
                    this._clipText.addElement(this._jEditorComboPane.getText(eStart, selEnd - eStart));
                } else {
                    this._clipText.addElement(this._jEditorComboPane.getText(eStart, eEnd - eStart));
                }
            }
            elem = eli.next();
        }
    }

    public void insert(Document doc, int insertPos) throws BadLocationException, IOException {
        int contentSize = this.size();
        for (int i = 0; i < contentSize; ++i) {
            String text = this.getCharactersAt(i);
            doc.insertString(insertPos, text, this.getCharacterAttributes(i));
            insertPos += text.length();
        }
    }

    public int size() {
        return this._clipText.size();
    }

    public AttributeSet getCharacterAttributes(int chunkNo) {
        return (AttributeSet)this._clipAttr.elementAt(chunkNo);
    }

    public String getCharactersAt(int chunkNo) {
        return (String)this._clipText.elementAt(chunkNo);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        for (int i = 0; i < this._clipText.size(); ++i) {
            text.append((String)this._clipText.elementAt(i));
        }
        return text.toString();
    }

    public void add(String text, AttributeSet ca) {
        this._clipText.addElement(text);
        this._clipAttr.addElement(ca);
    }

    public void clear() {
        this._clipText.clear();
        this._clipAttr.clear();
    }
}

