/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.focus;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.SwingUtilities;

public class ManualFocusPolicy
extends FocusTraversalPolicy
implements Serializable {
    private Component _lastFocusable = null;
    private HashMap firstComponents = new HashMap();
    private HashMap forwardMap = new HashMap();
    private HashMap backwardMap = new HashMap();

    public void setFirstComponent(Container focusCycleRoot, Component firstComponent) {
        this.firstComponents.put(focusCycleRoot, firstComponent);
    }

    public void setNextFocusableComponent(Component left, Component right) {
        this.forwardMap.put(left, right);
        this.backwardMap.put(right, left);
    }

    public void unsetNextFocusableComponent(Component left, Component right) {
        this.forwardMap.remove(left);
        this.backwardMap.remove(right);
    }

    public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.forwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        Component lastComp = this.getLastComponent(focusCycleRoot);
        if (hardCoded == lastComp) {
            // empty if block
        }
        return hardCoded;
    }

    public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
        Component hardCoded = aComponent;
        HashSet<Component> sanity = new HashSet<Component>();
        do {
            Component prevHardCoded = hardCoded;
            if ((hardCoded = (Component)this.backwardMap.get(hardCoded)) == null) {
                return null;
            }
            if (sanity.contains(hardCoded)) {
                return null;
            }
            sanity.add(hardCoded);
        } while (!this.accept(hardCoded));
        return hardCoded;
    }

    public Component getFirstComponent(Container focusCycleRoot) {
        Object obj = this.firstComponents.get(focusCycleRoot);
        if (obj != null) {
            return (Component)obj;
        }
        return null;
    }

    public Component getLastComponent(Container focusCycleRoot) {
        if (this._lastFocusable == null) {
            this._lastFocusable = this.getFirstComponent(focusCycleRoot);
            while (this.forwardMap.get(this._lastFocusable) != null) {
                this._lastFocusable = (Component)this.forwardMap.get(this._lastFocusable);
            }
        }
        return this._lastFocusable;
    }

    public Component getDefaultComponent(Container focusCycleRoot) {
        return this.getFirstComponent(focusCycleRoot);
    }

    private boolean accept(Component aComponent) {
        if (!(aComponent.isVisible() && aComponent.isDisplayable() && aComponent.isFocusable() && aComponent.isEnabled())) {
            return false;
        }
        if (!(aComponent instanceof Window)) {
            for (Container enableTest = aComponent.getParent(); enableTest != null; enableTest = enableTest.getParent()) {
                if (!enableTest.isEnabled() && !enableTest.isLightweight()) {
                    return false;
                }
                if (enableTest instanceof Window) break;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    class FocusRequester
    implements Runnable {
        public FocusRequester() {
            try {
                SwingUtilities.invokeLater(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void run() {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().upFocusCycle();
        }
    }
}

