/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.log.LogRegistry;
import com.jaxfront.core.schema.SchemaCreationException;
import com.jaxfront.core.schema.ValidationException;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LastFile;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.URLHelper;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.core.xui.NLS;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.ChooserTab;
import com.jaxfront.swing.ui.editor.FileNameChooserModern;
import com.jaxfront.swing.ui.editor.ResourceChooser;
import com.jaxfront.swing.ui.layout.ListLayout;
import com.jaxfront.swing.ui.tools.Dialog;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TemplateFileChooser
extends JDialog
implements ActionListener,
ResourceChooser {
    private JTabbedPane _tabPane;
    private ChooserTab _chooserTab;
    private JButton _okButton;
    private JButton _cancelButton;
    private boolean _isCancelled = true;
    private boolean _useRemoteUpdate = false;

    public TemplateFileChooser(Frame owner, boolean useRemoteUpdate) {
        super(owner);
        this._useRemoteUpdate = useRemoteUpdate;
        this.init();
        int x = owner.getLocation().x;
        int y = owner.getLocation().y;
        int width = (owner.getSize().width - this.getSize().width) / 2;
        int height = (owner.getSize().height - this.getSize().height) / 2;
        this.setLocation(x + width, y + height);
        this.setModal(true);
        this.setResizable(true);
    }

    /*
     * Unable to fully structure code
     */
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._okButton) {
            this._isCancelled = false;
            try {
                if (this.getSelectedChooserTab() == null) ** GOTO lbl13
                this.getSelectedChooserTab().load();
            }
            catch (SchemaCreationException sce) {
                Dialog.showErrorDialog(this, sce.getMessage());
                this._isCancelled = true;
                return;
            }
        } else if (e.getSource() == this._cancelButton) {
            this._isCancelled = true;
        }
lbl13:
        // 5 sources

        this.dispose();
    }

    public String getRootName() {
        return this.getSelectedChooserTab().getSelectedRootName();
    }

    private ChooserTab getSelectedChooserTab() {
        if (this._tabPane != null) {
            return (ChooserTab)this._tabPane.getSelectedComponent();
        }
        return this._chooserTab;
    }

    public URL getXmlURL() {
        if (this.getSelectedChooserTab().getXMLChooser() != null) {
            return this.getSelectedChooserTab().getXMLChooser().getURL();
        }
        return null;
    }

    public URL getXsdURL() {
        return this.getSelectedChooserTab().getXSDChooser().getURL();
    }

    public URL getXuiURL() {
        if (this.getSelectedChooserTab().getXUIChooser() != null) {
            return this.getSelectedChooserTab().getXUIChooser().getURL();
        }
        return null;
    }

    private String formatUrl(String url) {
        return url;
    }

    public void setXmlURL(URL xmlURL) {
        if (this.getSelectedChooserTab().getXMLChooser() != null) {
            if (xmlURL != null) {
                this.getSelectedChooserTab().getXMLChooser().setSelectedItem(xmlURL.toExternalForm());
            } else {
                this.getSelectedChooserTab().getXMLChooser().setSelectedItem("");
            }
        }
    }

    public void setXsdURL(URL xsdURL) {
        this.getSelectedChooserTab().getXSDChooser().setSelectedItem(xsdURL.toExternalForm());
    }

    public void setXuiURL(URL xuiURL) {
        if (this.getSelectedChooserTab().getXUIChooser() != null) {
            if (xuiURL != null) {
                this.getSelectedChooserTab().getXUIChooser().setSelectedItem(xuiURL.toExternalForm());
            } else {
                this.getSelectedChooserTab().getXUIChooser().setSelectedItem("");
            }
        }
    }

    private void init() {
        Container container = this.getContentPane();
        FormLayout containerLayout = new FormLayout("10,f:p:g,10", "10,f:p:g,15,f:p,10");
        container.setLayout(containerLayout);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new ListLayout());
        centerPanel.setBorder(null);
        Vector<String> xsdFiles = new Vector<String>();
        Vector<String> xmlFiles = new Vector<String>();
        Vector<String> xuiFiles = new Vector<String>();
        Vector<String> rootNames = new Vector<String>();
        Vector lastFiles = JAXFrontProperties.getInstance().getLastFiles();
        Iterator iterator = lastFiles.iterator();
        while (iterator.hasNext()) {
            String element;
            LastFile lastFile = (LastFile)iterator.next();
            if (lastFile.getXsdURL() != null && !xsdFiles.contains(element = this.formatUrl(lastFile.getXsdURL().toExternalForm()))) {
                xsdFiles.addElement(element);
            }
            if (lastFile.getXmlURL() != null && !xmlFiles.contains(element = this.formatUrl(lastFile.getXmlURL().toExternalForm()))) {
                xmlFiles.addElement(element);
            }
            if (lastFile.getXuiURL() != null && !xuiFiles.contains(element = this.formatUrl(lastFile.getXuiURL().toExternalForm()))) {
                xuiFiles.addElement(element);
            }
            if (lastFile.getRootName() == null || rootNames.contains(element = lastFile.getRootName())) continue;
            rootNames.addElement(element);
        }
        this._tabPane = new JTabbedPane();
        centerPanel.add(this._tabPane);
        this.initFileNameChooserTab(lastFiles, xsdFiles, xmlFiles, xuiFiles, rootNames);
        this.initFileNameJAXFormChooserTab(lastFiles, xsdFiles, xmlFiles, xuiFiles, rootNames);
        this._okButton = new JButton(GUIComponentNLS.getInstance().getNLSText("button_open", "Open"));
        this._okButton.addActionListener(this);
        this._okButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this._okButton);
        this._okButton.setPreferredSize(new Dimension(90, (int)this._okButton.getPreferredSize().getHeight()));
        this._okButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    TemplateFileChooser.this._okButton.doClick();
                }
            }
        });
        this._cancelButton = new JButton(GUIComponentNLS.getInstance().getNLSText("button_cancel", "Cancel"));
        this._cancelButton.setPreferredSize(new Dimension(90, (int)this._cancelButton.getPreferredSize().getHeight()));
        this._cancelButton.addActionListener(this);
        this._cancelButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    TemplateFileChooser.this._cancelButton.doClick();
                }
            }
        });
        FormLayout buttonLayout = new FormLayout("p:g,10,p,3", "f:p");
        JPanel buttonPanel = new JPanel(buttonLayout);
        buttonPanel.setBorder(null);
        buttonPanel.add((Component)this._okButton, "1,1,r,f");
        buttonPanel.add((Component)this._cancelButton, "3,1,r,f");
        this.getContentPane().add((Component)centerPanel, "2,2");
        this.getContentPane().add((Component)buttonPanel, "2,4,f,c");
        this.setTitle(GUIComponentNLS.getInstance().getNLSText("dialog_fileselection", "File Selection"));
        this.pack();
    }

    private void initFileNameChooserTab(Vector lastFiles, Vector xsdFiles, Vector xmlFiles, Vector xuiFiles, Vector rootNames) {
        this._chooserTab = new ChooserTab(this._useRemoteUpdate, lastFiles, new FileNameChooserModern("XML Schema (*.xsd)", null, xsdFiles, "xsd", false, false), new FileNameChooserModern("XML Instance (*.xml)", null, xmlFiles, "xml", true, false), new FileNameChooserModern("XUI (*.xui)", null, xuiFiles, "xui", true, false), rootNames, false);
        this._chooserTab.setPreferredSize(new Dimension(580, this._chooserTab.getPreferredSize().height));
        this._chooserTab.setBorder(null);
        if (this._tabPane != null) {
            this._tabPane.addTab(GUIComponentNLS.getInstance().getNLSText("tabs_file", "File"), this._chooserTab);
        }
    }

    private void initFileNameJAXFormChooserTab(Vector lastFiles, Vector xsdFiles, Vector xmlFiles, Vector xuiFiles, Vector rootNames) {
        ChooserTab chooserTab = new ChooserTab(this._useRemoteUpdate, lastFiles, new FileNameChooserModern("JAXForm (*.jax)", null, xsdFiles, "jax", false, false), null, null, rootNames, true);
        chooserTab.setPreferredSize(new Dimension(480, this._chooserTab.getPreferredSize().height));
        chooserTab.setBorder(null);
        chooserTab.setLoadAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        if (this._tabPane != null) {
            this._tabPane.addTab(GUIComponentNLS.getInstance().getNLSText("tabs_jaxform", "JAXForm"), chooserTab);
        }
    }

    public boolean isCancelled() {
        return this._isCancelled;
    }

    public void save(URL url, Document dom) {
        try {
            String fileName = url.getFile();
            if (System.getProperty("os.name").startsWith("Windows")) {
                fileName = TextTools.replace((String)fileName, (String)"%20", (String)" ");
            }
            dom.saveAs(new File(fileName));
            this.setXuiURL(url);
        }
        catch (ValidationException ex) {
            LogRegistry.getInstance().error(this.getClass(), ex.getMessage());
        }
        catch (Exception e) {
            Dialog.showErrorDialog(e.getMessage());
        }
    }

    public void show() {
        this.repaint();
        this._isCancelled = true;
        super.show();
    }

    public void saveNLS(Document uiDOM, URL url, NLS nls, String rootName) {
        try {
            if (JAXFrontProperties.getInstance().useEmbeddedNLS()) {
                NLS.storeEmbeddedNLS((Document)uiDOM, (NLS)nls);
            } else {
                File nlsFile;
                NLS.removeStoredEmbeddedNLS((Document)uiDOM);
                String language = JAXFrontProperties.getInstance().getLanguage();
                URL nlsURL = URLHelper.createNLSURL((URL)url, (String)language);
                if (nlsURL != null) {
                    String nlsLocation = nlsURL.getPath();
                    nlsFile = new File(nlsLocation);
                } else {
                    String nlsLocation = URLHelper.createNLSFilePathLocation((URL)url, (String)language);
                    nlsFile = new File(nlsLocation);
                }
                nls.storeAsSortedNLS(nlsFile, rootName);
            }
        }
        catch (IOException e) {
            Dialog.showErrorDialog(this, "Error while storing NLS-File:" + e.getMessage());
            LogRegistry.getInstance().error(this.getClass(), (Exception)e);
            LogRegistry.getInstance().warn(this.getClass(), "Error while storing NLS-File:" + e.getMessage());
        }
    }

    public URL saveAsChooser(URL xsdURL, URL xuiURL, AbstractEditorPanel editor) {
        File file;
        File savedFile = null;
        FileSelector selector = new FileSelector(GUIComponentNLS.getInstance().getNLSText("dialog_save", "Save"));
        selector.setCurrentFileFilter("xui", ".xui", false);
        File directory = null;
        if (xuiURL == null) {
            file = new File(xsdURL.getFile());
            if (file != null && file.exists()) {
                directory = file.getParentFile();
            }
        } else {
            file = new File(xuiURL.getFile());
            if (file != null && file.exists()) {
                directory = file;
            }
        }
        if (directory != null) {
            selector.setRootDir(directory);
        }
        selector.showSaveDialog((Component)editor);
        if (selector.getSelectedFile() != null) {
            savedFile = selector.getSelectedFile();
            URL url = null;
            try {
                editor.getDOM().saveAs(savedFile);
                url = savedFile.toURL();
            }
            catch (ValidationException e) {
                LogRegistry.getInstance().error(this.getClass(), e.getMessage());
            }
            catch (IOException e) {
                Dialog.showErrorDialog(e.getMessage());
            }
            return url;
        }
        return null;
    }

    public String getTitle(boolean xuiHasChanged) {
        String title = "XUI-Editor " + Document.getXUIVersionNo();
        title = title + " [" + URLHelper.getFileName((URL)this.getXsdURL());
        String ending = "";
        if (xuiHasChanged) {
            ending = "*";
        }
        if (this.getXmlURL() != null) {
            title = title + ", " + URLHelper.getFileName((URL)this.getXmlURL());
        }
        title = this.getXuiURL() != null ? title + ", " + URLHelper.getFileName((URL)this.getXuiURL()) + ending + "]" : title + ", new" + ending + "]";
        return title;
    }
}

