/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TreeNode;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.LicenseChecker;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.swing.ui.editor.AbstractEditorPanel;
import com.jaxfront.swing.ui.editor.NavigationTree;
import com.jaxfront.swing.ui.wrapper.JAXJSplitPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.ImageObserver;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class EditorPanel
extends AbstractEditorPanel
implements WindowListener,
TreeModelListener,
TreeSelectionListener,
ImageObserver {
    private static Image _imageIcon;
    private static final String _image = "H4sIAAAAAAAAAKWS/TvTCQDAv5thG9XMqlVWFG4zxFFHuGzlZWde+47ydmwj5d1DRndhEXosqon0SvKavKQSdbGLSiecIcK8DcOY9y3GXfcv3Oe3z4+f5/nYUWzNzP1vAYeAbiKwtLrYNfz3wMTXvvEv6/J1gUjQM9q9Il2ZX55fXF2UrctmF2YmxMIN+YZ4STw2M9o71js5NykUC9c31jsFHbJ16bBoeHltaVm63DHUPjg5KFmW8Ee6ZhdnRfNTozOj0xLR+OzYzMJ09whf+k06Mj0s35SvydZEElH7UPvWfwD/Ay0ZDAIARED/u3xvApS2GrM7FlCWGrzCKIIe/D4bHkip8Kz88uTCJ3Egjss9bdnv1zQW3Toa2iCQ1MU8cnIuv1b/7Q/ow013uDOeppyAV3a4kpBOTM1MQJIvZcFhHki8ExQNp3HTwFSAnFVEOURXwCFwSnQd2m6GAhzxEqFKV6PgGe5QOiQHVChzaCEoUOLphdfiISogbEe8UvubWpCRTGx7S6YrbdOb2EnH0FBlE3N6CDq0n05DnusClQeXCRxB233Z+VvO8CQmLFsVM8bZcyJy2M2MKXGyqUkgk+HlLtWkH30f8wyuZwWeyU5JX7WKLrHz+wlTmUwg5fISgTyCZYqGujXaYStcTYdcKDU8fTWEuJhGcnG1SYpW/0ZLN2+ZREONc3RMqpIFlOu2cjFVTfMOu5iXZsAtfheMBhhZZA3J0yasOsWQiVrKL001ti80JDWeyoARI943i+vduB9S2qEZTXhYKDI8eF/DvVoWJRejGKZlX0RCWAQIh0qpELcqdK2C/Y03By/+5d+SU6FPRbu7jWJ2zHJuKztmGz24sx7tXgA6s7XVknFTeHMbkU5DNgr7bPh+LtujdK9mzwUN7g8cTYWqo2H6LB1jhQwfR0tZ+CtyQXk+iqWIM8aZBoBK2mbumWSG9w0qxEOf7xJnwKGlOmVB1D+HqTgyBFEOVNRWk7pi2kMY4mJSD9eQbnn2oQvlHWYAqQIGOMcwzzS74Qy7tRyPSxFqPaeJftk9Vz7X5TeZlb5Sz8RqTuneiFL99yd/DkFtl1ddX7RvPMNlxS+DRv5AiyTLA/suu+zvvnJpEwRJMSHeikz07BETXTadnx4YJUe5DBpRWB7qcZRExMBdIt+2MM9H/zZb2VHnTxL4C9BxquCgbA/GDQm+1/TM2RxnWoHsQCH2sG4kwDGvwTP3Bg31NsM00lwb0xneifcs4WBscf6klatPGTExPr2IgFJ2DfsVx5rwOoetauTG5F0NyvNvbU1R5GmLtvuB2DzbMpWn9tTSYxWJW09L2pApISXMoyZAXF8nYgbdfx7CwyJMhVwsCkw6VcIu2oePJcXXJ1d/KhD1h7e2lLe8ZtUEoTjVUayURyePrEwY8pMDGo/XfPRQDGkuisnmAcYNBejnVizr562v7XR3Pg70LtxVjBiutMBJgncA3I/+0RrK9pSpztAIh1svNwt2GnWBHqHPNdqMV55ZbAN7+7v9Ug1eoJ6ldVZbqN4NdSrVuyZe/Rp119bDJkHIx3je5FWsDXkFndxlV7YAM+uNWAyVjlCYg2q0VlNhyZ40u80Xvr8NGtimE0oqoFfjHObMv0Sd8IlF7jPtDfcxbpbJpu0Ymj425ezX7C6Itfhs0Ncnk3Mt1ucvwiLQta2Xy2PqdwuUPD0f3KQq1euOTCkP9R+5s8AP1mIbHSj8PSCBMkukQs6ZWHuujDMi8/YPEEdiTepy5n/um8x0hR6gaaMSjoneVm4hVDYggK9XLgDdTjouf3MYDlj8A5j79RFKBQAA";

    public EditorPanel(Type type, Window frame) {
        super(type, frame);
        if (frame != null) {
            frame.addWindowListener(this);
        }
    }

    protected JComponent buildPanel() {
        if (this.getDOM().getGlobalDefinition().isShowingTree() && (this._type.isRepresentedAsTreeNode() || this._type.isRepresentedAsTab() || this._type.getXUIDefinition().getStyle().isRepresentedAsHeader())) {
            if (!this.getDOM().getGlobalDefinition().isShowingEditorPanel()) {
                this.setCenterComponent(this._navigationContainer);
            } else {
                this._splitPane = this.getDOM().getDividerLocation() == 0.999f ? new JAXJSplitPane(1, this._navigationContainer, null) : new JAXJSplitPane(1, this._navigationContainer, this._workspace);
                this._splitPane.setFocusable(false);
                if (this.isTopLevelEditor()) {
                    this._splitPane.setSize(this.getDOM().getScreenSize());
                } else {
                    this._splitPane.setSize(200, 200);
                }
                if (this.getDOM().getDividerLocation() > 1.0f) {
                    this._splitPane.setDividerLocation((int)this.getDOM().getDividerLocation());
                } else {
                    this._splitPane.setDividerLocation(this.getDOM().getDividerLocation());
                }
                this.setCenterComponent(this._splitPane);
                this._splitPane.setDividerSize(5);
            }
        } else {
            this.setCenterComponent(this._workspace);
        }
        if (this.getSelectedNode() == null) {
            this.selectRootNode();
        }
        return this.getCenterComponent();
    }

    public void removeWorkspace() {
        this.remove(this.getCenterComponent());
        this.setCenterComponent(this._tree);
        this.add((Component)this.getCenterComponent(), "Center");
        this.updateUI();
    }

    protected JComponent makeNavigationPanel() {
        if (this._tree == null) {
            Vector<Type> treeNodes = new Vector<Type>();
            if (this.isTopLevelEditor()) {
                treeNodes.addAll(this._type.getDOM().getTreeRoot());
            } else {
                treeNodes.add(this._type);
            }
            this._tree = new NavigationTree(this, treeNodes);
            ToolTipManager.sharedInstance().registerComponent(this._tree);
            this._tree.putClientProperty("JTree.lineStyle", "Angled");
            this._tree.addTreeSelectionListener(this);
            if (this.getDOM().getGlobalDefinition().getTreeSelection() != null) {
                this.selectNode(this.getDOM().getGlobalDefinition().getTreeSelection());
            }
            JScrollPane scrollPane = new JScrollPane(this._tree);
            int width = (int)this.getDOM().getScreenSize().getWidth() - this.getLastDividerLocation();
            scrollPane.setPreferredSize(new Dimension(width, this.getDOM().getScreenSize().height));
            scrollPane.setFocusable(false);
            scrollPane.getViewport().setFocusable(false);
            this._navigationContainer = scrollPane;
        }
        return this._tree;
    }

    public void release() {
        if (this._holder != null) {
            this._holder.removeWindowListener(this);
        }
        super.release();
    }

    public void treeNodesChanged(TreeModelEvent e) {
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this._tree.repaint();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this._tree.repaint();
    }

    public void valueChanged(TreeSelectionEvent e) {
        if (!this._isOnlyHighLightMode && !this.getNavigationTree().isMultiSelectOperation()) {
            this._selectedNode = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
            TreeNode treeNode = (TreeNode)this._selectedNode;
            if (treeNode.getType() != null) {
                String helpText = treeNode.getType().getXUIDefinition().getStyle().getHelpText();
                if (helpText != null) {
                    this.fireHelpEvent(treeNode.getType(), helpText);
                }
                this._workspace.visualize(treeNode);
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.release();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.hasNoLicense()) {
            g.drawImage(EditorPanel.getEmbbededImage(), g.getClipBounds().width - 338, g.getClipBounds().height - 105, this);
        }
    }

    public static Image getEmbbededImage() {
        if (_imageIcon == null) {
            try {
                _imageIcon = new ImageIcon(TextTools.decodeBase64Ziped((String)_image)).getImage();
            }
            catch (Throwable ex) {
                _imageIcon = JAXFrontProperties.getImageIcon((String)"").getImage();
            }
        }
        return _imageIcon;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    private boolean hasNoLicense() {
        return LicenseChecker.getInstance().hasCommunityLicense() || !LicenseChecker.getInstance().hasValidLicense();
    }

    public Visualizer visualize(Type type, boolean forceRepaint) {
        return this.getWorkspace().visualize(type, forceRepaint);
    }

    public void removeTreeNodes(List nodesToRemove) {
        this.getNavigationTree().setSelectionPath(null);
        if (nodesToRemove != null) {
            for (int n = nodesToRemove.size() - 1; n >= 0; --n) {
                this.getTreeModel().removeNodeFromParent((DefaultMutableTreeNode)nodesToRemove.get(n));
            }
        }
    }

    public void updateTreeUI() {
        this._tree.updateUI();
        this._tree.repaint();
    }
}

