/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.editor;

import com.jaxfront.core.dom.Document;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.io.BrowserControl;
import com.jaxfront.swing.ui.tools.FontTools;
import com.jaxfront.swing.ui.tools.HeaderPanel;
import com.jaxfront.swing.ui.tools.HyperTextLabel;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AboutDialog
extends JDialog
implements MouseListener {
    private String _imageIcon;
    private String _title;
    private String _link;

    public AboutDialog(String imageIcon) {
        this(imageIcon, GUIComponentNLS.getInstance().getNLSText("dialog_aboutJaxfront", "About JAXFront"), "http://www.jaxfront.com");
    }

    public AboutDialog(String imageIcon, String title, String link) {
        this._title = title;
        this._link = link;
        this._imageIcon = imageIcon;
        this.init();
    }

    public void center() {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setLocation(x, y);
    }

    private JPanel getTextPanel() {
        FormLayout layout = new FormLayout("20,f:p,20", "111,f:p,f:p,10,f:p,10,f:p,10,f:p,20,f:p,f:p,10,f:p,20,f:p,f:p,10,f:p,10,f:p,10,f:p,10,f:p,20");
        JPanel holder = new JPanel(layout);
        JLabel title1 = new JLabel("Version Info");
        title1.setFont(FontTools.getBoldFont(11.0f));
        if (this._imageIcon == null) {
            this._imageIcon = "com/jaxfront/core/images/files/jaxfront.gif";
        }
        JLabel imageLabel = new JLabel(JAXFrontProperties.getImageIcon((String)this._imageIcon));
        imageLabel.setToolTipText("http://www.jaxfront.com");
        imageLabel.addMouseListener(this);
        HeaderPanel sep1 = new HeaderPanel("");
        JLabel jaxfrontVersion = new JLabel("Version: " + Document.getXUIVersionNo());
        jaxfrontVersion.setFont(FontTools.getBoldFont(11.0f));
        JLabel buildVersion = new JLabel("Build  : " + Document.getBuildVersion());
        JLabel javaVersion = new JLabel("JRE    : " + System.getProperty("java.version"));
        JLabel title2 = new JLabel("License Agreement");
        title2.setFont(FontTools.getBoldFont(11.0f));
        HeaderPanel sep2 = new HeaderPanel("");
        JTextArea licence = new JTextArea();
        Font font = new Font("sansserif", 0, 10);
        licence.setFont(font);
        licence.setLineWrap(true);
        licence.setWrapStyleWord(true);
        licence.setText(JAXFrontProperties.getLicenceText());
        licence.setEditable(false);
        licence.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(licence);
        scrollPane.setPreferredSize(new Dimension(70, 100));
        JLabel title3 = new JLabel("Copyrights");
        title3.setFont(FontTools.getBoldFont(11.0f));
        HeaderPanel sep3 = new HeaderPanel("");
        JLabel copyright = new JLabel("(c) 2001-2010. All Rights Reserved. xcentric technology & consulting GmbH");
        JLabel copyrightXUI = new JLabel("JAXFront is a trademark of xcentric technology & consulting GmbH, Switzerland");
        JLabel copyrightJava = new JLabel("Java and all java-based trademarks and logos are trademarks of Sun Microsystems, Inc.");
        HyperTextLabel jaxfrontLink = new HyperTextLabel(this._link, true);
        holder.add((Component)imageLabel, "2,1,1,1,right,bottom");
        holder.add((Component)title1, "2,2");
        holder.add((Component)sep1, "2,3");
        holder.add((Component)jaxfrontVersion, "2,5");
        holder.add((Component)buildVersion, "2,7");
        holder.add((Component)javaVersion, "2,9");
        holder.add((Component)title2, "2,11");
        holder.add((Component)sep2, "2,12");
        holder.add((Component)scrollPane, "2,14");
        holder.add((Component)title3, "2,16");
        holder.add((Component)sep3, "2,17");
        holder.add((Component)copyright, "2,19");
        holder.add((Component)copyrightXUI, "2,21");
        holder.add((Component)copyrightJava, "2,23");
        holder.add((Component)jaxfrontLink, "2,25");
        return holder;
    }

    private void init() {
        this.setModal(true);
        ImageIcon iconWhite = JAXFrontProperties.getImageIcon((String)"com/jaxfront/core/images/files/xcentric_16x16.gif");
        this.setTitle(this._title);
        Container container = this.getContentPane();
        container.add(this.getTextPanel());
        this.setSize(500, 700);
        this.setResizable(false);
        this.pack();
    }

    protected JComponent initializeWorkspace() {
        return null;
    }

    public void mouseClicked(MouseEvent e) {
        BrowserControl.displayURL((String)this._link);
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

