/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.Type;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JTime
extends JPanel {
    private JTextField _textFieldHours;
    private JTextField _textFieldMinutes;
    private JTextField _textFieldSeconds;
    private JLabel _labelHours;
    private JLabel _labelMinutes;
    private JLabel _labelSeconds;
    private String _hours = "00";
    private String _minutes = "00";
    private String _seconds = "00";
    private String _time = "";
    private boolean _useErrorSound = false;
    private Type _model;
    public Action nextFocusAction = new AbstractAction("Move Focus Forwards"){

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource().equals(JTime.this._textFieldHours)) {
                ((Component)evt.getSource()).transferFocus();
            } else if (evt.getSource().equals(JTime.this._textFieldMinutes)) {
                ((Component)evt.getSource()).transferFocus();
            } else if (evt.getSource().equals(JTime.this._textFieldSeconds)) {
                ((Component)evt.getSource()).transferFocus();
            }
        }
    };

    public JTime(boolean useErrorSound, Type model) {
        this._model = model;
        this.initView();
        this._useErrorSound = useErrorSound;
    }

    protected void initView() {
        this.setLayout(new BorderLayout());
        this._textFieldHours = new JTextField(this._hours);
        this._textFieldMinutes = new JTextField(this._minutes);
        this._textFieldSeconds = new JTextField(this._seconds);
        this._textFieldHours.setDocument(new TimeFieldDocument("h"));
        this._textFieldMinutes.setDocument(new TimeFieldDocument("m"));
        this._textFieldSeconds.setDocument(new TimeFieldDocument("s"));
        this._labelHours = new JLabel("hh ");
        this._labelMinutes = new JLabel("mm ");
        this._labelSeconds = new JLabel("ss ");
        this.add(this.getPanelTime());
    }

    private JPanel getPanelTime() {
        FontMetrics metrics = this._textFieldHours.getFontMetrics(this._textFieldHours.getFont());
        int width = metrics.stringWidth(this._hours);
        String colSpec = (width += 12) + "px," + "pref," + width + "px," + "pref," + width + "px";
        String rowSpec = "pref";
        JPanel panelTime = new JPanel(new FormLayout(colSpec, rowSpec));
        String timeFormat = this._model.getXUIDefinition().getStyle().getTimeFormat();
        if (timeFormat.length() > 0) {
            StringTokenizer st = new StringTokenizer(timeFormat, ":");
            String[] timeArray = new String[st.countTokens()];
            int counter = 0;
            while (st.hasMoreElements()) {
                timeArray[counter] = st.nextToken();
                ++counter;
            }
            KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
            for (int i = 0; i < timeArray.length; ++i) {
                if (timeArray[i].toLowerCase().equals("hh")) {
                    panelTime.add((Component)this._textFieldHours, i * 2 + 1 + ",1,F,C");
                    panelTime.add((Component)this._labelHours, i * 2 + 1 + 1 + ",1,F,C");
                    this._textFieldHours.addFocusListener(new SimpleTypeTimeViewListener());
                    this._textFieldHours.getInputMap(0).put(enter, this.nextFocusAction.getValue("Name"));
                    this._textFieldHours.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
                }
                if (timeArray[i].toLowerCase().equals("mm")) {
                    panelTime.add((Component)this._textFieldMinutes, i * 2 + 1 + ",1,F,C");
                    panelTime.add((Component)this._labelMinutes, i * 2 + 1 + 1 + ",1,F,C");
                    this._textFieldMinutes.addFocusListener(new SimpleTypeTimeViewListener());
                    this._textFieldMinutes.getInputMap(0).put(enter, this.nextFocusAction.getValue("Name"));
                    this._textFieldMinutes.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
                }
                if (!timeArray[i].toLowerCase().equals("ss")) continue;
                panelTime.add((Component)this._textFieldSeconds, i * 2 + 1 + ",1,F,C");
                panelTime.add((Component)this._labelSeconds, i * 2 + 1 + 1 + ",1,F,C");
                this._textFieldSeconds.addFocusListener(new SimpleTypeTimeViewListener());
                this._textFieldSeconds.getInputMap(0).put(enter, this.nextFocusAction.getValue("Name"));
                this._textFieldSeconds.getActionMap().put(this.nextFocusAction.getValue("Name"), this.nextFocusAction);
            }
            return panelTime;
        }
        return null;
    }

    private void splitToSeparateTimeFormats(String timeValue) {
        if (timeValue != null && timeValue.length() > 0) {
            StringTokenizer stk = new StringTokenizer(timeValue, ":");
            if (stk.hasMoreElements()) {
                this._hours = stk.nextToken();
            }
            if (stk.hasMoreElements()) {
                this._minutes = stk.nextToken();
            }
            if (stk.hasMoreElements()) {
                this._seconds = stk.nextToken();
            }
        }
    }

    private String getTimeFormat() {
        this._hours = this._textFieldHours.getText();
        this._minutes = this._textFieldMinutes.getText();
        this._seconds = this._textFieldSeconds.getText();
        if (this._hours.length() < 1) {
            this._hours = "00";
        }
        if (this._minutes.length() < 1) {
            this._minutes = "00";
        }
        if (this._seconds.length() < 1) {
            this._seconds = "00";
        }
        if (this._hours.length() == 1) {
            this._hours = "0" + this._hours;
        }
        if (this._minutes.length() == 1) {
            this._minutes = "0" + this._minutes;
        }
        if (this._seconds.length() == 1) {
            this._seconds = "0" + this._seconds;
        }
        this._time = "";
        this._time = this._time + this._hours;
        this._time = this._time + ":";
        this._time = this._time + this._minutes;
        this._time = this._time + ":";
        this._time = this._time + this._seconds;
        return this._time;
    }

    public String getHours() {
        return this._hours;
    }

    public String getMinutes() {
        return this._minutes;
    }

    public String getSeconds() {
        return this._seconds;
    }

    public String getTime() {
        return this.getTimeFormat();
    }

    public void setTime(String time) {
        this.splitToSeparateTimeFormats(time);
        this.setTextfieldHours();
        this.setTextfieldMinutes();
        this.setTextfieldSeconds();
    }

    private void setTextfieldHours() {
        this._textFieldHours.setText(this._hours);
    }

    private void setTextfieldMinutes() {
        this._textFieldMinutes.setText(this._minutes);
    }

    private void setTextfieldSeconds() {
        this._textFieldSeconds.setText(this._seconds);
    }

    public void setBackground(Color color) {
        if (this._textFieldHours != null && this._textFieldMinutes != null && this._textFieldSeconds != null && color != null) {
            this._textFieldHours.setBackground(color);
            this._textFieldMinutes.setBackground(color);
            this._textFieldSeconds.setBackground(color);
        }
    }

    public void setFont(Font font) {
    }

    public void setForeground(Color fg) {
    }

    public void setEnabled(boolean enabled) {
        if (this._textFieldHours != null) {
            this._textFieldHours.setEnabled(enabled);
            this._textFieldMinutes.setEnabled(enabled);
            this._textFieldSeconds.setEnabled(enabled);
            this._labelHours.setEnabled(enabled);
            this._labelMinutes.setEnabled(enabled);
            this._labelSeconds.setEnabled(enabled);
        }
    }

    class SimpleTypeTimeViewListener
    implements FocusListener {
        SimpleTypeTimeViewListener() {
        }

        public void focusLost(FocusEvent e) {
            if (e.getSource() == JTime.this._textFieldHours && !e.isTemporary()) {
                JTime.this.firePropertyChange("time", null, null);
            } else if (e.getSource() == JTime.this._textFieldMinutes && !e.isTemporary()) {
                JTime.this.firePropertyChange("time", null, null);
            } else if (e.getSource() == JTime.this._textFieldSeconds && !e.isTemporary()) {
                JTime.this.firePropertyChange("time", null, null);
            }
        }

        public void focusGained(FocusEvent e) {
            if (e.getSource() == JTime.this._textFieldHours) {
                JTime.this._textFieldHours.selectAll();
            }
            if (e.getSource() == JTime.this._textFieldMinutes) {
                JTime.this._textFieldMinutes.selectAll();
            }
            if (e.getSource() == JTime.this._textFieldSeconds) {
                JTime.this._textFieldSeconds.selectAll();
            }
        }
    }

    class TimeFieldDocument
    extends PlainDocument {
        private String whichField = "";

        public TimeFieldDocument(String h) {
            this.whichField = h;
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            try {
                if (this.getLength() + s.length() <= 2) {
                    Integer.parseInt(s);
                    super.insertString(offset, s, attributeSet);
                }
                if (offset == 1 && this.whichField.equals("h")) {
                    JTime.this._textFieldHours.transferFocus();
                } else if (offset == 1 && this.whichField.equals("m")) {
                    JTime.this._textFieldMinutes.transferFocus();
                } else if (offset == 1 && this.whichField.equals("s")) {
                    JTime.this._textFieldSeconds.transferFocus();
                }
            }
            catch (Exception ex) {
                if (JTime.this._useErrorSound) {
                    Toolkit.getDefaultToolkit().beep();
                }
                return;
            }
        }
    }
}

