/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JDayChooser
extends JPanel
implements ActionListener {
    private JButton[] _days;
    private JButton _selectedDay = null;
    private int _day;
    private Color _oldDayBackground;
    private String[] _dayNames;
    private Calendar _calendar;
    private Calendar _today;
    private Locale _locale = Locale.getDefault();
    private boolean _initialized = false;

    public JDayChooser() {
        this._days = new JButton[49];
        Calendar calendar = Calendar.getInstance(this._locale);
        this._today = (Calendar)calendar.clone();
        this.setLayout(new GridLayout(7, 7));
        for (int y = 0; y < 7; ++y) {
            for (int x = 0; x < 7; ++x) {
                int index = x + 7 * y;
                if (y == 0) {
                    this._days[index] = new JButton(){

                        public void addMouseListener(MouseListener l) {
                        }
                    };
                    this._days[index].setBackground(new Color(200, 200, 255));
                } else {
                    this._days[index] = new JButton("x");
                    this._days[index].addActionListener(this);
                }
                this._days[index].setMargin(new Insets(0, 0, 0, 0));
                this._days[index].setFocusPainted(false);
                this.add(this._days[index]);
            }
        }
        this.init();
        this._initialized = true;
    }

    public void actionPerformed(ActionEvent e) {
        JButton button = (JButton)e.getSource();
        int day = new Integer(button.getText());
        this.setDay(day, true);
    }

    protected void drawDays() {
        int i;
        Calendar tmpCalendar = (Calendar)this._calendar.clone();
        int firstDayOfWeek = tmpCalendar.getFirstDayOfWeek();
        tmpCalendar.set(5, 1);
        int firstDay = tmpCalendar.get(7) - firstDayOfWeek;
        if (firstDay < 0) {
            firstDay += 7;
        }
        for (i = 0; i < firstDay; ++i) {
            this._days[i + 7].setVisible(false);
            this._days[i + 7].setText("");
        }
        tmpCalendar.add(2, 1);
        Date firstDayInNextMonth = tmpCalendar.getTime();
        tmpCalendar.add(2, -1);
        Date day = tmpCalendar.getTime();
        int n = 0;
        Color foreground = this.getForeground();
        while (day.before(firstDayInNextMonth)) {
            this._days[i + n + 7].setText(Integer.toString(n + 1));
            this._days[i + n + 7].setVisible(true);
            if (tmpCalendar.get(6) == this._today.get(6) && tmpCalendar.get(1) == this._today.get(1)) {
                this._days[i + n + 7].setForeground(Color.blue);
            } else {
                this._days[i + n + 7].setForeground(foreground);
            }
            if (n + 1 == this._day) {
                this._days[i + n + 7].setBackground(Color.gray);
                this._selectedDay = this._days[i + n + 7];
            } else {
                this._days[i + n + 7].setBackground(this._oldDayBackground);
            }
            ++n;
            tmpCalendar.add(5, 1);
            day = tmpCalendar.getTime();
        }
        for (int k = n + i + 7; k < 49; ++k) {
            this._days[k].setVisible(false);
            this._days[k].setText("");
        }
    }

    public int getDay() {
        return this._day;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getName() {
        return "JDayChooser";
    }

    protected void init() {
        this._calendar = Calendar.getInstance(this._locale);
        int firstDayOfWeek = this._calendar.getFirstDayOfWeek();
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this._locale);
        this._dayNames = dateFormatSymbols.getShortWeekdays();
        int day = firstDayOfWeek;
        for (int i = 0; i < 7; ++i) {
            this._days[i].setText(this._dayNames[day]);
            if (day == 1) {
                this._days[i].setForeground(Color.red);
            } else {
                this._days[i].setForeground(Color.blue);
            }
            if (day < 7) {
                ++day;
                continue;
            }
            day -= 6;
        }
        this._oldDayBackground = new JButton().getBackground();
        this.drawDays();
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JDayChooser");
        frame.getContentPane().add(new JDayChooser());
        frame.pack();
        frame.setVisible(true);
    }

    public void setCalendar(Calendar c) {
        this._calendar = c;
        this.drawDays();
    }

    public void setDay(int d, boolean firePropertyChangeEvent) {
        if (d > 0) {
            Calendar tmpCalendar = (Calendar)this._calendar.clone();
            tmpCalendar.set(5, 1);
            tmpCalendar.add(2, 1);
            tmpCalendar.add(5, -1);
            int maxDaysInMonth = tmpCalendar.get(5);
            if (d > maxDaysInMonth) {
                d = maxDaysInMonth;
            }
            int oldDay = this._day;
            this._day = d;
            if (this._selectedDay != null) {
                this._selectedDay.setBackground(this._oldDayBackground);
                this._selectedDay.repaint();
            }
            for (int i = 7; i < 49; ++i) {
                if (!this._days[i].getText().equals(Integer.toString(this._day))) continue;
                this._selectedDay = this._days[i];
                this._selectedDay.setBackground(Color.gray);
                break;
            }
            if (firePropertyChangeEvent) {
                this.firePropertyChange("day", 0, this._day);
            }
        }
    }

    public void setFont(Font font) {
        if (this._days != null) {
            for (int i = 0; i < 49; ++i) {
                this._days[i].setFont(font);
            }
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this._days != null) {
            for (int i = 7; i < 49; ++i) {
                this._days[i].setForeground(fg);
            }
            this.drawDays();
        }
    }

    public void setLocale(Locale l) {
        if (!this._initialized) {
            super.setLocale(l);
        } else {
            this._locale = l;
            this.init();
        }
    }

    public void setMonth(int month) {
        this._calendar.set(2, month);
        this.setDay(this._day, false);
        this.drawDays();
    }

    public void setYear(int year) {
        this._calendar.set(1, year);
        this.drawDays();
    }
}

