/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.GUITools;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.wrapper.JAXJSpinner;
import com.toedter.calendar.JDateChooser;
import java.awt.Color;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class DateBean
extends AbstractSimpleTypeView {
    private String _mask;

    public DateBean(Type type) {
        this((SimpleType)type, null);
    }

    public DateBean(SimpleType type, Type context) {
        this(type, context, null);
    }

    public DateBean(SimpleType type, Type context, String mask) {
        this();
        this._mask = mask;
        this.setModel((Type)type);
    }

    public DateBean() {
    }

    public DateBean(String mask) {
        this._mask = mask;
    }

    protected JComponent createEditorComponent() {
        if (this._mask != null) {
            this.setEditorField((JComponent)new JDateChooser(this._mask, false));
        } else {
            this.setEditorField((JComponent)new JDateChooser());
        }
        this.setFont(FontFactory.getTextFieldFontDefinition().createFont());
        this.getEditorField().addPropertyChangeListener(this);
        JAXJSpinner.releaseMouse(((JDateChooser)this.getEditorField()).getSpinner());
        this.setFirstFocusableComponent(this.getEditorField());
        this.getEditorField().addFocusListener(this);
        return this.getEditorField();
    }

    public String getText() {
        return GUITools.convertToISODate(((JDateChooser)this._editorComponent).getDate());
    }

    public void populateView() {
        JDateChooser calendarPopUp = (JDateChooser)this._editorComponent;
        if (calendarPopUp != null) {
            String value = "";
            if (((SimpleType)this._model).getValue() != null) {
                value = ((SimpleType)this._model).getValue();
            }
            calendarPopUp.setDate(GUITools.createDateFromIso(value));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.getEditorComponent())) {
            if (evt.getNewValue() != null) {
                this.populateModel();
            }
        } else if (evt.getPropertyName().equals("propertyChange")) {
            this.populateView();
        }
    }

    public void release() {
        super.release();
    }

    public void setEditable(boolean editable) {
        if (this.getEditorField() != null) {
            ((JDateChooser)this.getEditorField()).setEnabled(editable);
        } else {
            super.setEditable(editable);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        JDateChooser chooser = (JDateChooser)this.getEditorField();
        if (chooser != null) {
            JComponent editor = chooser.getSpinner().getEditor();
            for (int i = 0; i < editor.getComponentCount(); ++i) {
                if (!(editor.getComponent(i) instanceof JTextComponent)) continue;
                editor.getComponent(i).setBackground(color);
            }
        }
    }

    public void setFont(Font font) {
        JDateChooser chooser = (JDateChooser)this.getEditorField();
        if (chooser != null) {
            JComponent editor = chooser.getSpinner().getEditor();
            for (int i = 0; i < editor.getComponentCount(); ++i) {
                if (!(editor.getComponent(i) instanceof JTextComponent)) continue;
                editor.getComponent(i).setFont(font);
            }
        }
    }
}

