package retypar.converter.helper;

import retypar.retypar;



/**
 * Keeps the characteristics of an ASCII sign and checks usefulness for a given image area.
 * @author Jens Heuser
 */
public class Letter {

    public char name;

    /**
     * The sign as an int array of colors.<br>
     * Values are calculated in {@link retypar.converter.helper.FontRenderer#calcValues}
     */
    private int[] value = new int[retypar.fontSize * retypar.fontSize];


    /**
     * The index of {@link Letter#value} where the next color value has to be inserted.<br>
     * Values are calculated in {@link retypar.converter.helper.FontRenderer#calcValues}
     */
    private int index = 0;


    public Letter(char name){
        this.name = name;
    }


    /**
     * <code>value</code> is added to {@link Letter#value} at index {@link Letter#index}.
     * @param value Color of a pixel, see {@link java.awt.image.BufferedImage#getRGB(int, int)}.
     */
    public void addValue(int value) {
        this.value[index] = value;
        index++;
    }


    /**
     * Checks for usefulness of the given image area.<br>
     * Returns a value representing the difference of the sign's characteristics and the image area. Currently only colors are looked at.
     * @param block The int array of the target image area to be examined.
     * @return The difference of the sign's graphical representation and the image area.
     */
    public int fits(int[] block){
        int diff = 0;
        int x;

        for (int i = 0; i < (retypar.fontSize * retypar.fontSize); i++){
            if(block[i] > value[i]) diff += (block[i] - value[i]);
                else diff += (value[i] - block[i]);
        }

        return diff;
    }


    public String toString(){
        return ""+name;
    }
}