package retypar.converter;

import java.io.File;
import java.awt.*;
import java.awt.image.BufferedImage;
import retypar.converter.helper.*;

/**
 * retypar algorithm "M-Rules".<BR>
 * Returns ASCII and Images, features progress monitoring.
 * @author Jens Heuser
 * @see retypar.converter.Converter
 */
public class MRules implements Converter {

    ImageProcessor imP;



    public String worksWith() {
        return "0.9.2";
    }


    public String getDescription() {
        return "The first conversion algorithm of retypar. Produces many 'M's...\n";
    }


    public String getAuthor() {
        return "Jens Heuser";
    }


    public String getWebsite() {
        return "http://www.retypar.de.vu";
    }


    public String toString() {
        return "M-Rules";
    }


    public String getShortName(){
        return "mr";
    }


    public String broughtPackage(){
        return "";
    }


    public boolean usesThreshold() {
        return false;
    }


    public int getMinThreshold() {
        return 0;
    }


    public int getMaxThreshold() {
        return 0;
    }


    public int getInitThreshold(){
        return 0;
    }

    public int getThresholdStep(){
        return 1;
    }


    public boolean monitorsProgess() {
        return true;
    }


    public boolean returnsASCII(){
        return true;
    }


    public boolean returnsImage(){
        return true;
    }


    public Color[][] getColors(){
        return imP.colors;
    }


    public String[] getASCII(){
        return imP.txtVerMono;
    }


    public void prepare(Image img,
                        boolean uppercase,
                        boolean lowercase,
                        boolean numbers,
                        boolean special,
                        boolean colored,
                        Color bgColor,
                        int scale,
                        int threshold) {

        imP = new ImageProcessor();
        imP.init(img, uppercase, lowercase, numbers, special, colored, bgColor, scale, imP.RENDER_MRULES, threshold);
    }


    public BufferedImage getImage() {
        imP.run();
        return imP.convertImage();
    }


    public int getProgress(){
        return (int)imP.progress;
    }


    public void stop(){
        imP.stop = true;
    }


    public String getErrors() {
        return null;
    }
}
