/*
 * Decompiled with CFR 0.152.
 */
package thirdParty;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ImagePreviewPanel
extends JPanel
implements PropertyChangeListener {
    private int width;
    private int height;
    private ImageIcon icon;
    private Image image;
    private static final int ACCSIZE = 155;
    private Color bg;

    public ImagePreviewPanel() {
        this.setPreferredSize(new Dimension(155, -1));
        this.bg = this.getBackground();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("SelectedFileChangedProperty")) {
            File file = (File)propertyChangeEvent.getNewValue();
            if (file == null) {
                return;
            }
            String string2 = file.getAbsolutePath();
            if (string2 != null && string2.toLowerCase().endsWith(".jpg") || string2.toLowerCase().endsWith(".jpeg") || string2.toLowerCase().endsWith(".gif") || string2.toLowerCase().endsWith(".png")) {
                this.icon = new ImageIcon(string2);
                this.image = this.icon.getImage();
                this.scaleImage();
                this.repaint();
            }
        }
    }

    private void scaleImage() {
        this.width = this.image.getWidth(this);
        this.height = this.image.getHeight(this);
        double d = 1.0;
        if (this.width >= this.height) {
            d = 150.0 / (double)this.width;
            this.width = 150;
            this.height = (int)((double)this.height * d);
        } else if (this.getHeight() > 150) {
            d = 150.0 / (double)this.height;
            this.height = 150;
            this.width = (int)((double)this.width * d);
        } else {
            d = (double)this.getHeight() / (double)this.height;
            this.height = this.getHeight();
            this.width = (int)((double)this.width * d);
        }
        this.image = this.image.getScaledInstance(this.width, this.height, 1);
    }

    public void paintComponent(Graphics graphics) {
        graphics.setColor(this.bg);
        graphics.fillRect(0, 0, 155, this.getHeight());
        graphics.drawImage(this.image, this.getWidth() / 2 - this.width / 2 + 5, this.getHeight() / 2 - this.height / 2, this);
    }
}

