/*
 * Decompiled with CFR 0.152.
 */
package primitives;

import export.ExportInterface;
import geom.GeometricDistances;
import geom.MapCoordinates;
import globals.Globals;
import graphic.GraphicsInterface;
import java.io.IOException;
import java.util.Vector;
import primitives.GraphicPrimitive;

public final class PrimitiveConnection
extends GraphicPrimitive {
    static final int N_POINTS = 3;
    private int x1;
    private int y1;
    private int xa1;
    private int ya1;
    private int ni;
    private double nn;

    public int getControlPointNumber() {
        return 3;
    }

    public PrimitiveConnection(String f, int size) {
        this.initPrimitive(-1, f, size);
    }

    public PrimitiveConnection(int x, int y, int layer, String f, int size) {
        this.initPrimitive(-1, f, size);
        this.virtualPoint[0].x = x;
        this.virtualPoint[0].y = y;
        this.virtualPoint[this.getNameVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getNameVirtualPointNumber()].y = y + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].x = x + 5;
        this.virtualPoint[this.getValueVirtualPointNumber()].y = y + 10;
        this.setLayer(layer);
    }

    public void draw(GraphicsInterface g, MapCoordinates coordSys, Vector layerV) {
        if (!this.selectLayer(g, layerV)) {
            return;
        }
        this.drawText(g, coordSys, layerV, -1);
        if (this.changed) {
            this.changed = false;
            this.x1 = this.virtualPoint[0].x;
            this.y1 = this.virtualPoint[0].y;
            this.nn = Math.abs(coordSys.mapXr(0.0, 0.0) - coordSys.mapXr(10.0, 10.0)) * Globals.diameterConnection / 10.0;
            if (this.nn < 2.0) {
                this.nn = (int)(Math.abs(coordSys.mapXr(0.0, 0.0) - coordSys.mapXr(20.0, 20.0)) * Globals.diameterConnection / 12.0);
            }
            this.xa1 = (int)Math.round((double)coordSys.mapX(this.x1, this.y1) - this.nn / 2.0);
            this.ya1 = (int)Math.round((double)coordSys.mapY(this.x1, this.y1) - this.nn / 2.0);
            this.ni = (int)Math.round(this.nn);
            if (this.ni == 0) {
                this.ni = 1;
            }
        }
        if (!g.hitClip(this.xa1, this.ya1, this.ni, this.ni)) {
            return;
        }
        if (this.ni >= 1) {
            g.fillOval(this.xa1, this.ya1, this.ni, this.ni);
        } else {
            g.fillRect(this.xa1, this.ya1, this.ni, this.ni);
        }
    }

    public void parseTokens(String[] tokens, int N) throws IOException {
        this.changed = true;
        if (tokens[0].equals("SA")) {
            if (N < 3) {
                IOException E = new IOException("bad arguments on SA");
                throw E;
            }
            int x1 = this.virtualPoint[0].x = Integer.parseInt(tokens[1]);
            int y1 = this.virtualPoint[0].y = Integer.parseInt(tokens[2]);
            this.virtualPoint[this.getNameVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getNameVirtualPointNumber()].y = y1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].x = x1 + 5;
            this.virtualPoint[this.getValueVirtualPointNumber()].y = y1 + 10;
            if (N > 3) {
                this.parseLayer(tokens[3]);
            }
        } else {
            IOException E = new IOException("Invalid primitive: programming error?");
            throw E;
        }
    }

    public int getDistanceToPoint(int px, int py) {
        if (this.checkText(px, py)) {
            return 0;
        }
        return GeometricDistances.pointToPoint(this.virtualPoint[0].x, this.virtualPoint[0].y, px, py) - 1;
    }

    public String toString(boolean extensions) {
        String s = "SA " + this.virtualPoint[0].x + " " + this.virtualPoint[0].y + " " + this.getLayer() + "\n";
        s = s + this.saveText(extensions);
        return s;
    }

    public void export(ExportInterface exp, MapCoordinates cs) throws IOException {
        this.exportText(exp, cs, -1);
        exp.exportConnection(cs.mapX(this.virtualPoint[0].x, this.virtualPoint[0].y), cs.mapY(this.virtualPoint[0].x, this.virtualPoint[0].y), this.getLayer(), Globals.diameterConnection * cs.getXMagnitude());
    }

    public int getNameVirtualPointNumber() {
        return 1;
    }

    public int getValueVirtualPointNumber() {
        return 2;
    }
}

