/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.fidocadj;

import globals.Globals;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.fidocadj.FidoFrame;

class OpenFile
implements Runnable {
    private FidoFrame parent;

    OpenFile() {
    }

    public void setParam(FidoFrame tparent) {
        this.parent = tparent;
    }

    public void run() {
        String din;
        String fin;
        if (Globals.useNativeFileDialogs) {
            FileDialog fd = new FileDialog((Frame)this.parent, Globals.messages.getString("Open"));
            fd.setDirectory(this.parent.openFileDirectory);
            fd.setFilenameFilter(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase(OpenFile.this.parent.getLocale()).endsWith(".fcd");
                }
            });
            fd.setVisible(true);
            fin = fd.getFile();
            din = fd.getDirectory();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setCurrentDirectory(new File(this.parent.openFileDirectory));
            fc.setDialogTitle(Globals.messages.getString("Open"));
            fc.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".fcd") || f.isDirectory();
                }

                public String getDescription() {
                    return "FidoCadJ (.fcd)";
                }
            });
            if (fc.showOpenDialog(this.parent) != 0) {
                return;
            }
            fin = fc.getSelectedFile().getName();
            din = fc.getSelectedFile().getParentFile().getPath();
        }
        if (fin != null) {
            int selection;
            File f = new File(Globals.createCompleteFileName(din, fin));
            if (!Globals.checkExtension(fin, "fcd") && (selection = f.exists() ? JOptionPane.showConfirmDialog(null, Globals.messages.getString("Warning_extension"), Globals.messages.getString("Warning"), 0, 2) : 0) == 0) {
                fin = Globals.adjustExtension(fin, "fcd");
            }
            try {
                FidoFrame popFrame;
                if (this.parent.CC.getUndoActions().getModified() || !this.parent.CC.P.isEmpty()) {
                    popFrame = new FidoFrame(this.parent.runsAsApplication, this.parent.getLocale());
                    popFrame.init();
                    popFrame.setBounds(this.parent.getX() + 20, this.parent.getY() + 20, popFrame.getWidth(), popFrame.getHeight());
                    popFrame.loadLibraries();
                    popFrame.setVisible(true);
                } else {
                    popFrame = this.parent;
                }
                popFrame.CC.getParserActions().openFileName = Globals.createCompleteFileName(din, fin);
                if (this.parent.runsAsApplication) {
                    this.parent.prefs.put("OPEN_DIR", din);
                }
                popFrame.openFileDirectory = din;
                popFrame.openFile();
                popFrame.CC.getUndoActions().saveUndoState();
                popFrame.CC.getUndoActions().setModified(false);
            }
            catch (IOException fnfex) {
                JOptionPane.showMessageDialog(this.parent, Globals.messages.getString("Open_error") + fnfex);
            }
        }
    }
}

