/*
 * Decompiled with CFR 0.152.
 */
package export;

import export.ExportInterface;
import globals.Globals;
import graphic.DimensionG;
import graphic.PointDouble;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import layers.LayerDesc;
import primitives.MacroDesc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportEagle
implements ExportInterface {
    private final FileWriter fstream;
    private BufferedWriter out;
    private DimensionG dim;
    private int oldtextsize;
    private String macroList = "";
    private String junctionList = "";
    static final double text_stretch = 0.73;
    static final String EagleFidoLib = "FidoCadJLIB";
    static final String ExportFormatString = "####.####";
    static double res = 0.05;

    public int cLe(double l) {
        return (int)l;
    }

    public ExportEagle(File f) throws IOException {
        this.fstream = new FileWriter(f);
    }

    @Override
    public void exportStart(DimensionG totalSize, Vector<LayerDesc> la, int grid) throws IOException {
        this.dim = totalSize;
        this.out = new BufferedWriter(this.fstream);
        this.oldtextsize = -1;
        this.macroList = "";
        this.junctionList = "";
        this.out.write("# Created by FidoCadJ 0.24.4 by Davide Bucci\n");
        this.out.write("Set Wire_Bend 2; \n");
        this.out.write("Grid inch " + this.een((double)grid * res) + ";\n");
        this.out.write("Change font fixed;\n");
        this.out.write("Set auto_junction off;\n");
    }

    @Override
    public void exportEnd() throws IOException {
        this.out.write(this.macroList);
        this.out.write(this.junctionList);
        this.out.write("Window Fit; \n");
        this.out.close();
    }

    @Override
    public void exportAdvText(int x, int y, int sizex, int sizey, String fontname, boolean isBold, boolean isMirrored, boolean isItalic, int orientation, int layer, String text) throws IOException {
        String mirror = "";
        if (isMirrored) {
            mirror = "M";
        }
        if (this.oldtextsize != sizey) {
            this.out.write("Change size " + (double)sizey * res * 0.73 + "\n");
        }
        this.oldtextsize = sizey;
        this.out.write("Text " + text + " " + mirror + "R" + -orientation + " (" + this.een((double)x * res) + " " + this.een((double)(this.dim.height - y) * res) + ");\n");
    }

    @Override
    public void exportBezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.out.write("# B\u00e9zier export not implemented yet\n");
    }

    @Override
    public void exportConnection(int x, int y, int layer, double size) throws IOException {
        this.junctionList = this.junctionList + "Junction (" + this.een((double)x * res) + " " + this.een((double)(this.dim.height - y) * res) + ");\n";
    }

    @Override
    public void exportLine(double x1, double y1, double x2, double y2, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        this.out.write("Net (" + this.een(x1 * res) + " " + this.een(((double)this.dim.height - y1) * res) + ") (" + this.een(x2 * res) + " " + this.een(((double)this.dim.height - y2) * res) + ");\n");
    }

    @Override
    public boolean exportMacro(int x, int y, boolean isMirrored, int orientation, String macroName, String macroDesc, String tname, int xn, int yn, String value, int xv, int yv, String font, int fontSize, Map<String, MacroDesc> m) throws IOException {
        String mirror = "";
        if (isMirrored) {
            mirror = "M";
        }
        HashMap<String, String> subst = new HashMap<String, String>();
        subst.put(" ", "_");
        String name = Globals.substituteBizarreChars(tname, subst);
        this.macroList = this.macroList + "Add " + macroName + "@" + EagleFidoLib + " " + name + " " + mirror + "R" + -orientation + " (" + this.een((double)x * res) + " " + this.een((double)(this.dim.height - y) * res) + ");\n";
        this.macroList = this.macroList + "Value " + name + " " + value + ";\n";
        return true;
    }

    @Override
    public void exportOval(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        String fill_pattern = "";
        this.out.write("# Circle export not fully implemented\n");
        this.out.write("Circle (" + this.een((double)x1 * res) + " " + this.een((double)(this.dim.height - y1) * res) + ") (" + this.een((double)(x2 - x1) * res) + " " + this.een((double)(y2 - y1) * res) + ");");
    }

    @Override
    public void exportPCBLine(int x1, int y1, int x2, int y2, int width, int layer) throws IOException {
        this.out.write("# PCBLine export not implemented yet\n");
    }

    @Override
    public void exportPCBPad(int x, int y, int style, int six, int siy, int indiam, int layer, boolean onlyHole) throws IOException {
        if (!onlyHole) {
            switch (style) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
        }
        this.out.write("# PCBpad export not implemented yet\n");
    }

    @Override
    public void exportPolygon(PointDouble[] vertices, int nVertices, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        String fill_pattern = "";
        this.out.write("# Polygon export not implemented yet\n");
    }

    @Override
    public void exportRectangle(int x1, int y1, int x2, int y2, boolean isFilled, int layer, int dashStyle, double strokeWidth) throws IOException {
        this.out.write("Layer 94;\n");
        if (isFilled) {
            this.out.write("Rect (" + this.een((double)x1 * res) + " " + this.een((double)(this.dim.height - y1) * res) + ") (" + this.een((double)x2 * res) + " " + this.een((double)(this.dim.height - y2) * res) + ");\n");
        } else {
            this.out.write("Set Wire_Bend 0;\n");
            this.out.write("Wire (" + this.een((double)x1 * res) + " " + this.een((double)(this.dim.height - y1) * res) + ") (" + this.een((double)x2 * res) + " " + this.een((double)(this.dim.height - y2) * res) + ");\n");
            this.out.write("Wire (" + this.een((double)x2 * res) + " " + this.een((double)(this.dim.height - y2) * res) + ") (" + this.een((double)x1 * res) + " " + this.een((double)(this.dim.height - y1) * res) + ");\n");
            this.out.write("Set Wire_Bend 2;\n");
        }
        this.out.write("Layer 91;\n");
    }

    @Override
    public boolean exportCurve(PointDouble[] vertices, int nVertices, boolean isFilled, boolean isClosed, int layer, boolean arrowStart, boolean arrowEnd, int arrowStyle, int arrowLength, int arrowHalfWidth, int dashStyle, double strokeWidth) throws IOException {
        return false;
    }

    @Override
    public void exportArrow(double x, double y, double xc, double yc, double l, double h, int style) throws IOException {
    }

    private String een(double n) {
        DecimalFormatSymbols separators = new DecimalFormatSymbols();
        separators.setDecimalSeparator('.');
        DecimalFormat exportFormat = new DecimalFormat(ExportFormatString, separators);
        return exportFormat.format(n);
    }
}

